/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.FetchParameterUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.util.StringUtils;
import java.sql.Date;
import java.util.HashMap;
import java.util.Set;

public class CMBank {
    private static final HashMap<Integer, CMBank> CACHE = new HashMap();
    private static final String BTD = "BTD";
    private static final String CAMT_XXX_CFONB120_STM = "camt.xxx.cfonb120.stm";
    private static final String CAMT_XXX_CFONB120_STM_EUR = "camt.xxx.cfonb120.stm.eur";
    private static StatementFormat GERMAN_DEFAULT_STATEMENT_FORMAT = StatementFormat.CAMT053;
    private static final StatementFormat FRENCH_DEFAULT_STATEMENT_FORMAT = StatementFormat.CAMT053;
    private static final StatementFormat[] STATEMENT_FORMATS = new StatementFormat[]{StatementFormat.MT940, StatementFormat.CAMT053, StatementFormat.CFONB120};
    private static final AdviceFormat[] ADVICE_FORMATS = new AdviceFormat[]{AdviceFormat.MT942, AdviceFormat.CAMT052};
    private CmBank data;
    private final boolean isFrenchBank;

    public static synchronized CMBank get(BankSettings bank) {
        CMBank toReturn = CACHE.get(bank.getBankId());
        if (toReturn == null) {
            toReturn = new CMBank(bank);
            if (toReturn.data != null && toReturn.data.getId() != null) {
                CACHE.put(bank.getBankId(), toReturn);
            }
        } else {
            CmBank data = CmBank.get(bank);
            if (data != null) {
                toReturn.data = data;
            }
        }
        return toReturn;
    }

    public static void setGermanDefaultStatementFormat(StatementFormat newFormat) {
        GERMAN_DEFAULT_STATEMENT_FORMAT = newFormat;
    }

    private CMBank(BankSettings bank) {
        this.isFrenchBank = bank.isFrenchBank();
        this.data = CmBank.get(bank);
        if (this.data == null) {
            this.data = new CmBank();
            this.data.setBank(bank);
            StatementFormat sf = this.getDefaultStatementFormat();
            this.data.setStatementFetchType(this.getDefaultFetchType(sf));
            this.data.setStatementFormat(sf.name());
            this.data.setStatementsActivated(true);
            AdviceFormat af = this.getDefaultAdviceFormat(sf);
            this.data.setAdviceActivated(af != null);
            if (af != null) {
                this.data.setAdviceFetchType(this.getDefaultFetchType(af));
                this.data.setAdviceFormat(af.name());
            }
            this.data.setCumulativeAdviceProvision(false);
            this.data.setMultidaysAdviceRepeated(false);
            this.data.setCreditAdviceActivated(true);
            this.data.setCreditAdviceFetchType(this.getDefaultCreditAdviceFetchType());
            this.data.setVbCalculationWithCreditAdvices(true);
        }
    }

    public boolean isStatementFetchActivated() {
        return this.data.isStatementsActivated();
    }

    public void setStatementFetchActivated(boolean statementsActivated) {
        this.data.setStatementsActivated(statementsActivated);
    }

    public StatementFormat getStatementFormat() {
        return StatementFormat.valueOf(this.data.getStatementFormat());
    }

    public void setStatementFormat(StatementFormat format) {
        this.data.setStatementFormat(format.name());
    }

    public String getStatementFetchType() {
        return BankUtils.getProperFetchType(this.isEbics30OrNewer(), this.data.getStatementFetchType(), this.data.getBank().getCountryCode());
    }

    public void setStatementFetchType(String fetchType) {
        this.data.setStatementFetchType(fetchType);
    }

    public boolean isAdviceFetchActivated() {
        return this.data.isAdviceActivated();
    }

    public void setAdviceFetchActivated(boolean advicesActivated) {
        this.data.setAdviceActivated(advicesActivated);
    }

    public AdviceFormat getAdviceFormat() {
        if (this.data.getAdviceFormat() == null) {
            return null;
        }
        return AdviceFormat.valueOf(this.data.getAdviceFormat());
    }

    public void setAdviceFormat(AdviceFormat format) {
        this.data.setAdviceFormat(format.name());
    }

    public String getAdviceFetchType() {
        return BankUtils.getProperFetchType(this.isEbics30OrNewer(), this.data.getAdviceFetchType(), this.data.getBank().getCountryCode());
    }

    public void setAdviceFetchType(String fetchType) {
        this.data.setAdviceFetchType(fetchType);
    }

    public boolean getMultidaysAdviceRepeated() {
        return this.data.isMultidaysAdviceRepeated();
    }

    public void setMultidaysAdviceRepeated(boolean multidaysAdviceRepeated) {
        this.data.setMultidaysAdviceRepeated(multidaysAdviceRepeated);
    }

    public boolean getCumulativeAdviceProvision() {
        return this.data.isCumulativeAdviceProvision();
    }

    public void setCumulativeAdviceProvision(boolean cumulativeAdviceProvision) {
        this.data.setCumulativeAdviceProvision(cumulativeAdviceProvision);
    }

    public boolean vbCalculationWithCreditAdvices() {
        return this.data.vbCalculationWithCreditAdvices();
    }

    public void setVbCalculationWithCreditAdvices(boolean vbCalculationWithCreditAdvices) {
        this.data.setVbCalculationWithCreditAdvices(vbCalculationWithCreditAdvices);
    }

    public boolean vbCalculationWithPendingAdvices() {
        return this.data.vbCalculationWithPendingAdvices();
    }

    public void setVbCalculationWithPendingAdvices(boolean vbCalculationWithPendingAdvices) {
        this.data.setVbCalculationWithPendingAdvices(vbCalculationWithPendingAdvices);
    }

    public boolean isCreditAdviceFetchActivated() {
        return this.data.isCreditAdviceActivated();
    }

    public void setCreditAdviceFetchActivated(boolean isCreditAdviceActivated) {
        this.data.setCreditAdviceActivated(isCreditAdviceActivated);
    }

    public String getCreditAdviceFetchType() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.data.getCreditAdviceFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.data.getBank().getCountryCode());
        }
        return this.getDefaultCreditAdviceFetchType();
    }

    public void setCreditAdviceFetchType(String fetchType) {
        this.data.setCreditAdviceFetchType(fetchType);
    }

    public boolean isC54FetchActivated() {
        return this.data.isC54Activated();
    }

    public void setC54FetchActivated(boolean bkiActivated) {
        this.data.setC54Activated(bkiActivated);
    }

    public String getC54FetchType() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.data.getC54FetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.data.getBank().getCountryCode());
        }
        return this.getDefaultC54FetchType();
    }

    public void setC54FetchType(String fetchType) {
        this.data.setC54FetchType(fetchType);
    }

    public boolean isBkaFetchActivated() {
        return this.data.isBkaActivated();
    }

    public void setBkaFetchActivated(boolean bkaActivated) {
        this.data.setBkaActivated(bkaActivated);
    }

    public String getBkaFetchType() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.data.getBkaFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.data.getBank().getCountryCode());
        }
        return this.getDefaultBkaFetchType();
    }

    public void setBkaFetchType(String fetchType) {
        this.data.setBkaFetchType(fetchType);
    }

    public boolean isBkiFetchActivated() {
        return this.data.isBkiActivated();
    }

    public void setBkiFetchActivated(boolean bkiActivated) {
        this.data.setBkiActivated(bkiActivated);
    }

    public String getBkiFetchType() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.data.getBkiFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.data.getBank().getCountryCode());
        }
        return this.getDefaultBkiFetchType();
    }

    public void setBkiFetchType(String fetchType) {
        this.data.setBkiFetchType(fetchType);
    }

    public String getDefaultCreditAdviceFetchType() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.camt054CreditAdvice, this.isEbics30OrNewer(), this.getBank().getCountryCode());
    }

    public String getDefaultC54FetchType() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.camt054, this.isEbics30OrNewer(), this.getBank().getCountryCode());
    }

    public String getDefaultBkaFetchType() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.pdfStatement, this.isEbics30OrNewer(), this.getBank().getCountryCode());
    }

    public String getDefaultBkiFetchType() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.otherPdfDocument, this.isEbics30OrNewer(), this.getBank().getCountryCode());
    }

    public YYMMDD getLastStaFetchDate() {
        return this.getYYMMDDFromDate(this.data.getLastStaFetch());
    }

    public void setLastStaFetchDate(YYMMDD lastFetch) {
        this.data.setLastStaFetch(this.getDateFromYYMMDD(lastFetch));
    }

    public YYMMDD getLastVmkFetchDate() {
        return this.getYYMMDDFromDate(this.data.getLastVmkFetch());
    }

    public void setLastVmkFetchDate(YYMMDD lastFetch) {
        this.data.setLastVmkFetch(this.getDateFromYYMMDD(lastFetch));
    }

    public YYMMDD getLastCreditAdviceFetchDate() {
        return this.getYYMMDDFromDate(this.data.getLastCreditAdviceFetch());
    }

    public void setLastCreditAdviceFetchDate(YYMMDD lastFetch) {
        this.data.setLastCreditAdviceFetch(this.getDateFromYYMMDD(lastFetch));
    }

    public YYMMDD getLastC54FetchDate() {
        return this.getYYMMDDFromDate(this.data.getLastC54Fetch());
    }

    public void setLastC54FetchDate(YYMMDD lastFetch) {
        this.data.setLastC54Fetch(this.getDateFromYYMMDD(lastFetch));
    }

    public YYMMDD getLastBkaFetchDate() {
        return this.getYYMMDDFromDate(this.data.getLastBkaFetch());
    }

    public void setLastBkaFetchDate(YYMMDD lastFetch) {
        this.data.setLastBkaFetch(this.getDateFromYYMMDD(lastFetch));
    }

    public YYMMDD getLastBkiFetchDate() {
        return this.getYYMMDDFromDate(this.data.getLastBkiFetch());
    }

    public void setLastBkiFetchDate(YYMMDD lastFetch) {
        this.data.setLastBkiFetch(this.getDateFromYYMMDD(lastFetch));
    }

    private YYMMDD getYYMMDDFromDate(Date date) {
        return date != null ? new YYMMDD(date.getTime()) : null;
    }

    private Date getDateFromYYMMDD(YYMMDD yymmdd) {
        return yymmdd != null ? new Date(yymmdd.getTime()) : null;
    }

    public CmBank.FetchMode getStaFetchMode() {
        return this.data.getStaFetchMode();
    }

    public void setStaFetchMode(CmBank.FetchMode fetchMode) {
        this.data.setStaFetchMode(fetchMode);
    }

    public CmBank.FetchMode getVmkFetchMode() {
        return this.data.getVmkFetchMode();
    }

    public void setVmkFetchMode(CmBank.FetchMode fetchMode) {
        this.data.setVmkFetchMode(fetchMode);
    }

    public CmBank.FetchMode getCreditAdviceFetchMode() {
        return this.data.getCreditAdviceFetchMode();
    }

    public void setCreditAdviceFetchMode(CmBank.FetchMode fetchMode) {
        this.data.setCreditAdviceFetchMode(fetchMode);
    }

    public CmBank.FetchMode getC54FetchMode() {
        return this.data.getC54FetchMode();
    }

    public void setC54FetchMode(CmBank.FetchMode fetchMode) {
        this.data.setC54FetchMode(fetchMode);
    }

    public CmBank.FetchMode getBkaFetchMode() {
        return this.data.getBkaFetchMode();
    }

    public void setBkaFetchMode(CmBank.FetchMode fetchMode) {
        this.data.setBkaFetchMode(fetchMode);
    }

    public CmBank.FetchMode getBkiFetchMode() {
        return this.data.getBkiFetchMode();
    }

    public void setBkiFetchMode(CmBank.FetchMode fetchMode) {
        this.data.setBkiFetchMode(fetchMode);
    }

    public boolean hasStatementFetchPermission(BankUser user) {
        return Util.hasFetchPermission(user, this.getStatementFetchType());
    }

    public boolean hasAdviceFetchPermission(BankUser user) {
        return Util.hasFetchPermission(user, this.getAdviceFetchType());
    }

    public boolean hasCreditAdviceFetchPermission(BankUser user) {
        return Util.hasFetchPermission(user, this.getCreditAdviceFetchType());
    }

    public boolean hasBkaFetchPermission(BankUser user) {
        return Util.hasFetchPermission(user, this.getBkaFetchType());
    }

    public boolean hasBkiFetchPermission(BankUser user) {
        return Util.hasFetchPermission(user, this.getBkiFetchType());
    }

    public boolean hasC54FetchPermission(BankUser user) {
        return Util.hasFetchPermission(user, this.getC54FetchType());
    }

    public StatementFormat[] getSupportedStatementFormats() {
        return STATEMENT_FORMATS;
    }

    public AdviceFormat[] getSupportedAdviceFormats() {
        return ADVICE_FORMATS;
    }

    public StatementFormat getDefaultStatementFormat() {
        if (this.isFrenchBank) {
            return FRENCH_DEFAULT_STATEMENT_FORMAT;
        }
        if (this.permissionExists(FetchParameterUtil.StatementType.camt053Statement)) {
            return StatementFormat.CAMT053;
        }
        if (this.permissionExists(FetchParameterUtil.StatementType.mt940Statement)) {
            return StatementFormat.MT940;
        }
        if (this.permissionExists(FetchParameterUtil.StatementType.cfonb120Statement)) {
            return StatementFormat.CFONB120;
        }
        return GERMAN_DEFAULT_STATEMENT_FORMAT;
    }

    private boolean permissionExists(FetchParameterUtil.StatementType statementType) {
        String defaultFetchType = FetchParameterUtil.getDefaultFetchParameter(statementType, this.isEbics30OrNewer(), this.getBank().getCountryCode());
        if (this.isEbics30OrNewer()) {
            return UserPermission.hasUserPermission(this.getBank(), OrderType.TransferType.FETCH, BTD, defaultFetchType);
        }
        return UserPermission.hasUserPermission(this.getBank(), OrderType.TransferType.FETCH, defaultFetchType, null);
    }

    public AdviceFormat getDefaultAdviceFormat(StatementFormat statementFormat) {
        switch (statementFormat.ordinal()) {
            case 2: {
                return AdviceFormat.CAMT052;
            }
            case 0: {
                return AdviceFormat.MT942;
            }
        }
        return null;
    }

    public CmStatement.Type getStatementType() {
        if (this.data.getStatementFormat() == null) {
            return CmStatement.Type.CAMT053;
        }
        switch (StatementFormat.valueOf(this.data.getStatementFormat()).ordinal()) {
            case 0: {
                return CmStatement.Type.MT940;
            }
            case 1: {
                return CmStatement.Type.CFONB120;
            }
        }
        return CmStatement.Type.CAMT053;
    }

    public CmStatement.Type getAdviceType() {
        if (this.data.getAdviceFormat() == null) {
            return CmStatement.Type.CAMT052;
        }
        if (AdviceFormat.valueOf(this.data.getAdviceFormat()) == AdviceFormat.CAMT052) {
            return CmStatement.Type.CAMT052;
        }
        return CmStatement.Type.MT942;
    }

    public Set<CmStatement.Type> getAdviceTypesForVBCalculation() {
        return this.vbCalculationWithCreditAdvices() ? CmStatement.AdviceTypes : CmStatement.AdviceTypesWithoutCreditAdvices;
    }

    public String getDefaultFetchType(StatementFormat format) {
        return FetchParameterUtil.getDefaultFetchParameter(CMBank.getStatementType(format), this.isEbics30OrNewer(), this.getBank().getCountryCode());
    }

    public static FetchParameterUtil.StatementType getStatementType(StatementFormat format) {
        switch (format.ordinal()) {
            case 2: {
                return FetchParameterUtil.StatementType.camt053Statement;
            }
            case 0: {
                return FetchParameterUtil.StatementType.mt940Statement;
            }
            case 1: {
                return FetchParameterUtil.StatementType.cfonb120Statement;
            }
        }
        return null;
    }

    public String getDefaultFetchType(AdviceFormat format) {
        return FetchParameterUtil.getDefaultFetchParameter(CMBank.getStatementType(format), this.isEbics30OrNewer(), this.getBank().getCountryCode());
    }

    public static FetchParameterUtil.StatementType getStatementType(AdviceFormat format) {
        switch (format.ordinal()) {
            case 1: {
                return FetchParameterUtil.StatementType.camt052Advice;
            }
            case 0: {
                return FetchParameterUtil.StatementType.mt942Advice;
            }
        }
        return null;
    }

    public void save() {
        if (this.data.getId() == null) {
            DB.save(this.data);
        } else {
            DB.update(this.data);
        }
    }

    public boolean tryNextStatementFetchParameters() {
        if (this.isFrenchBank && StatementFormat.CFONB120.equals((Object)this.getStatementFormat())) {
            if (CAMT_XXX_CFONB120_STM.equals(this.getStatementFetchType())) {
                this.setStatementFetchType(CAMT_XXX_CFONB120_STM_EUR);
                return true;
            }
            this.setStatementFormat(StatementFormat.CAMT053);
            this.setStatementFetchType(FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.camt053Statement, this.isEbics30OrNewer(), this.getBank().getCountryCode()));
            return true;
        }
        if (StatementFormat.CAMT053.equals((Object)this.getStatementFormat())) {
            this.setStatementFormat(StatementFormat.MT940);
            this.setStatementFetchType(FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.mt940Statement, this.isEbics30OrNewer(), this.getBank().getCountryCode()));
            return true;
        }
        return false;
    }

    public boolean tryNextAdviceFetchParameters() {
        if (AdviceFormat.CAMT052.equals((Object)this.getAdviceFormat())) {
            this.setAdviceFormat(AdviceFormat.MT942);
            this.setAdviceFetchType(FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.mt942Advice, this.isEbics30OrNewer(), this.getBank().getCountryCode()));
            return true;
        }
        return false;
    }

    private boolean isEbics30OrNewer() {
        return BankUtils.isProtocolH005OrNewer(this.data.getBank().getProtocolVersion());
    }

    public BankSettings getBank() {
        return this.data.getBank();
    }

    public static enum StatementFormat {
        MT940,
        CFONB120,
        CAMT053;

    }

    public static enum AdviceFormat {
        MT942,
        CAMT052;

    }
}

