/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;

public class CMAccount {
    private final Account account;
    private final Date periodStartDate;
    private final Date periodEndDate;
    private CmStatement newestStatement;
    private CmStatement newestAdvice;
    private BigDecimal freeLiquidity;
    private CmBalance vbToday;
    private CmBalance vbTomorrow;
    private CmBalance vbAfterTomorrow;
    private final boolean valueBalanceWithAdvice;
    private final boolean relateFreeLiquidityToValueBalance;

    public CMAccount(Account account, User user) {
        this(account, null, null, user);
    }

    public CMAccount(Account account, Date periodStartDate, Date periodEndDate, User user) {
        this.account = account;
        this.periodStartDate = periodStartDate;
        this.periodEndDate = periodEndDate;
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
        this.valueBalanceWithAdvice = store.getBoolean(CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO);
        this.relateFreeLiquidityToValueBalance = store.getBoolean(CmPreferenceConstants.RELATE_FREE_LIQUIDITY_TO_VALUE_BALANCE);
    }

    public String getDisplayName() {
        return Account.getDefaultDisplayName(this.account);
    }

    public Account getAccount() {
        return this.account;
    }

    public CmStatement getNewestAdvice() {
        if (this.newestAdvice == null) {
            this.newestAdvice = CmStatement.findNewestAdvice(this.account, this.periodEndDate);
        }
        return this.newestAdvice;
    }

    public CmStatement getNewestStatement() {
        if (this.newestStatement == null) {
            this.newestStatement = CmStatement.findNewestStatement(this.account, this.periodEndDate);
        }
        return this.newestStatement;
    }

    public BigDecimal getFreeLiquidity() {
        if (this.freeLiquidity == null) {
            if (this.relateFreeLiquidityToValueBalance) {
                CmBalance cmBalance = this.getVbToday();
                if (cmBalance != null) {
                    BigDecimal tmp = this.valueBalanceWithAdvice ? cmBalance.getValueBalanceWithAdvice() : cmBalance.getValueBalance();
                    this.addToFreeLiquidity(tmp);
                }
            } else {
                if (this.newestStatement == null) {
                    this.newestStatement = CmStatement.findNewestStatement(this.account, this.periodEndDate);
                }
                if (this.newestStatement != null) {
                    BigDecimal tmp = this.newestStatement.getClosingBalance();
                    this.addToFreeLiquidity(tmp);
                }
            }
        }
        return this.freeLiquidity;
    }

    private void addToFreeLiquidity(BigDecimal start) {
        if (start != null && (this.account.getInvestmentAmount() != null || this.account.getCreditLimit() != null)) {
            if (this.account.getCreditLimit() != null) {
                start = start.add(this.account.getCreditLimit());
            }
            if (this.account.getInvestmentAmount() != null) {
                start = start.add(this.account.getInvestmentAmount());
            }
            this.freeLiquidity = start;
        }
    }

    public int hashCode() {
        return ((Object)this.account).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMAccount other = (CMAccount)obj;
        return ((Object)this.account).equals(other.account);
    }

    public CmBalance getVbToday() {
        if (this.vbToday == null) {
            this.vbToday = CmBalance.getForDate(this.account, this.periodEndDate);
        }
        return this.vbToday;
    }

    public CmBalance getVbTomorrow() {
        if (this.vbTomorrow == null) {
            this.vbTomorrow = CmBalance.getForDate(this.account, this.getDayAfterPeriodEndDate(1));
        }
        return this.vbTomorrow;
    }

    public CmBalance getVbAfterTomorrow() {
        if (this.vbAfterTomorrow == null) {
            this.vbAfterTomorrow = CmBalance.getForDate(this.account, this.getDayAfterPeriodEndDate(2));
        }
        return this.vbAfterTomorrow;
    }

    public Date getPeriodStartDate() {
        return this.periodStartDate;
    }

    public Date getPeriodEndDate() {
        return this.periodEndDate;
    }

    private Date getDayAfterPeriodEndDate(int numberOfDays) {
        Calendar cal = Calendar.getInstance();
        if (this.periodEndDate != null) {
            cal.setTimeInMillis(this.periodEndDate.getTime());
        }
        cal.add(5, numberOfDays);
        return new Date(cal.getTimeInMillis());
    }
}

