/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.format.cfonb120.CFONB120Block01;
import de.businesslogics.format.cfonb120.CFONB120Block04;
import de.businesslogics.format.cfonb120.CFONB120Block05;
import de.businesslogics.format.cfonb120.CFONB120Block07;
import de.businesslogics.format.cfonb120.CFONB120Block08;
import de.businesslogics.format.cfonb120.CFONB120Block09;
import de.businesslogics.format.cfonb120.CFONB120Booking;
import de.businesslogics.format.cfonb120.CFONB120Listener;
import de.businesslogics.format.cfonb120.CFONB120Parser;
import de.businesslogics.format.cfonb120.CFONB120Statement;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class CFONB120Processing
extends CMProcessingDb
implements CFONB120Listener {
    protected static final String DIR_NAME = "cfonb120";
    private BigDecimal currentBalance;
    private CFONB120Statement statement;
    private CFONB120Booking booking;
    private boolean foundHeaderBlock = false;
    private OutputStreamWriter out;

    public CFONB120Processing(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(bank, reporter, DIR_NAME, logger, encrypt, preferences);
    }

    @Override
    protected Account findOrCreateAccount() {
        return null;
    }

    @Override
    public void process(InputStream in) throws Exception {
        new CFONB120Parser(this).parse(in);
    }

    @Override
    public void handleBlock01(CFONB120Block01 block) throws IOException {
        this.foundHeaderBlock = true;
        this.out = new OutputStreamWriter(this.getTempOutputStream());
        this.out.write(block.getContent());
        this.statement = new CFONB120Statement(block);
        this.booking = null;
    }

    @Override
    public void handleBlock04(CFONB120Block04 block) throws IOException {
        if (!this.foundHeaderBlock) {
            throw new IOException("Block04 appeared without Block01");
        }
        this.out.write(block.getContent());
        if (this.booking != null) {
            this.statement.getBookings().add(this.booking);
        }
        this.booking = new CFONB120Booking(block);
    }

    @Override
    public void handleBlock05(CFONB120Block05 block) throws IOException {
        if (!this.foundHeaderBlock) {
            throw new IOException("Block05 appeared without Block01");
        }
        this.out.write(block.getContent());
        if (this.booking != null) {
            this.booking.addBlock(block);
        }
    }

    @Override
    public void handleBlock07(CFONB120Block07 block) throws IOException {
        String uniqueId;
        CmStatement c;
        if (!this.foundHeaderBlock) {
            throw new IOException("Block07 appeared without Block01");
        }
        this.out.write(block.getContent());
        this.out.flush();
        SystemUtils.close(this.out);
        this.foundHeaderBlock = false;
        if (this.booking != null) {
            this.statement.getBookings().add(this.booking);
        }
        this.statement.setTrailer(block);
        this.latestAccount = CFONB120Processing.findOrCreateFrenchAccount(this.bank, block.getBankCode(), block.getBranchCode(), block.getAccountNumber(), block.getCurrencyCode());
        if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
            return;
        }
        block.getAccountIdentifier();
        if (this.existingFile == null) {
            String accountDirName = block.getBankCode() + "_" + block.getBranchCode() + "_" + block.getAccountNumber() + "_" + block.getCurrencyCode();
            this.createAccountDir(accountDirName);
        }
        if ((c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId = CMProcessingDb.getUniqueStatementId(block.getDate(), null, "_CFONB120"))) == null) {
            if (this.existingFile == null) {
                this.createAccountDir(block.getAccountIdentifier());
                this.createTargetFile(this.accountDir, uniqueId.substring(0, 6));
            }
            this.statement.parseContent();
            this.createStatement(uniqueId, this.statement);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createAccountDir(block.getAccountIdentifier());
                this.createTargetFile(this.accountDir, uniqueId.substring(0, 6));
            }
            this.updateStatement(c, this.statement);
        }
    }

    @Override
    public void handleBlock08(CFONB120Block08 block) {
    }

    @Override
    public void handleBlock09(CFONB120Block09 block) {
    }

    private CmStatement createStatement(String uniqueId, CFONB120Statement statementData) {
        statementData.parseContent();
        CmStatement s = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.CFONB120, this.latestAccount);
        this.setStatementData(s, statementData);
        DB.save(s);
        this.processBookings(s, statementData);
        this.reporter.newStatement(s, null);
        return s;
    }

    private void updateStatement(CmStatement s, CFONB120Statement statementData) {
        statementData.parseContent();
        this.setStatementData(s, statementData);
        DB.update(s);
        this.processBookings(s, statementData);
        this.reporter.newStatement(s, null);
    }

    private void setStatementData(CmStatement s, CFONB120Statement statementData) {
        this.setFile(s);
        s.setOpeningBalance(this.statement.getOpeningBalance());
        s.setOpeningDate(new Date(this.statement.getOpeningDate().getTime()));
        s.setClosingBalance(this.statement.getBalance());
        s.setClosingDate(new Date(this.statement.getDate().getTime()));
        s.setCreationDate(new Timestamp(s.getClosingDate().getTime()));
        s.setCurrency(this.statement.getCurrency());
    }

    private void processBookings(CmStatement s, CFONB120Statement statementData) {
        int pos = 0;
        this.currentBalance = s.getOpeningBalance();
        if (this.currentBalance == null) {
            this.currentBalance = BigDecimal.ZERO;
        }
        BookingStatistics statistics = new BookingStatistics();
        for (CFONB120Booking booking : statementData.getBookings()) {
            CmBooking b = this.findOrCreateBooking(s, pos++, booking);
            statistics.addBooking(b.getAmount());
        }
        CFONB120Processing.deleteHigherPositionedBookings(s, null, pos);
        CFONB120Processing.storeStatistics(s, null, statistics);
    }

    private CmBooking findOrCreateBooking(CmStatement s, int pos, CFONB120Booking booking) {
        CmBooking b = CMProcessingDb.findBooking(s, null, pos);
        if (b == null) {
            b = new CmBooking();
            b.setPos(pos);
        }
        this.setBookingData(b, s, booking);
        if (b.getId() == null) {
            DB.save(b);
        } else {
            DB.update(b);
        }
        return b;
    }

    private void setBookingData(CmBooking b, CmStatement s, CFONB120Booking booking) {
        b.setAccount(this.latestAccount);
        b.setAmount(booking.getAmount());
        b.setCurrency(s.getCurrency());
        if (this.currentBalance != null) {
            this.currentBalance = this.currentBalance.add(b.getAmount());
            b.setBalance(this.currentBalance);
        }
        if (booking.getValueDate() != null) {
            b.setValueDate(new Date(booking.getValueDate().getTime()));
        }
        if (booking.getBookingDate() != null) {
            b.setBookingDate(new Date(booking.getBookingDate().getTime()));
        } else {
            b.setBookingDate(s.getClosingDate());
        }
        List<String> purposeLines = booking.getPurposeLines();
        if (purposeLines != null && purposeLines.size() > 0) {
            String[] purposeArray = purposeLines.toArray(new String[0]);
            b.setPurposeOverview(StringUtils.shorten(purposeArray[0], 140));
            b.setPurpose(StringUtils.shorten(StringUtils.getStringFromStringArray(purposeArray, "\n"), 400));
        }
        b.setTransactionCode(booking.getTransactionCode());
        b.setInterbankTransactionCode(booking.getInterbankTransactionCode());
        b.setRejectionCauseCode(booking.getRejectionCauseCode());
        String entryNumber = booking.getEntryNumber();
        if ("0000000".equals(entryNumber)) {
            entryNumber = null;
        }
        b.setEntryNumber(entryNumber);
        b.setExemption(this.convertToBoolean(booking.getExemption()));
        b.setUnavailabiltyRating(this.convertToBoolean(booking.getUnavailabiltyRating()));
        b.setCollective(false);
        b.setStatement(s);
    }

    private Boolean convertToBoolean(String s) {
        if ("1".equals(s)) {
            return Boolean.TRUE;
        }
        if ("0".equals(s)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

