/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.BundesbankOrderTypes;
import de.businesslogics.banking.mt940.api.BaseDtaProcessing;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.CmReporterApi;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.format.dta.BundesbankEMZSwiftItem;
import de.businesslogics.format.dta.BundesbankPackedSwiftExtractor;
import de.businesslogics.format.dta.BundesbankSwiftExtractor;
import de.businesslogics.format.dta.BundesbankSwiftItem;
import de.businesslogics.format.dta.BundesbankSwiftListener;
import de.businesslogics.format.dta.BundesbankSwiftPaymentItem;
import de.businesslogics.format.dta.BundesbankSwiftWriter;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.SLF;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class BundesbankSwiftProcessingApi
extends BaseDtaProcessing
implements BundesbankSwiftListener {
    private static final String[] STEP2_COMPRESSED_ORDER_TYPES = new String[]{"YCS", "QE7"};
    private BundesbankSwiftWriter dtaw;
    private final List<BundesbankSwiftItem> items = new ArrayList<BundesbankSwiftItem>();
    private final List<StatementBookingReportHandler> reportHandlers;

    public static OutputStream getStep2Extractor(DTAUSExtractor.DTAUSListener listener, String orderType, boolean isBankFile) {
        if (StringUtils.isContainedInArray(orderType, STEP2_COMPRESSED_ORDER_TYPES)) {
            return new BundesbankPackedSwiftExtractor(listener);
        }
        return new BundesbankSwiftExtractor(listener, SLF.SLF_4_UNCOMPRESSED);
    }

    public BundesbankSwiftProcessingApi(BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(logger, encrypt, preferences);
        this.reportHandlers = reportHandlers;
    }

    public BundesbankSwiftProcessingApi(BankSettings bank, CmReporter reporter, String orderType, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(bank, reporter, orderType, logger, encrypt, preferences);
        this.reportHandlers = reportHandlers;
    }

    @Override
    protected OutputStream getExtractor() {
        boolean isBankFile = true;
        if (BundesbankOrderTypes.isValidStep2OrderType(this.orderType)) {
            return BundesbankSwiftProcessingApi.getStep2Extractor(this, this.orderType, isBankFile);
        }
        return new BundesbankSwiftExtractor(this, SLF.SLF_6_UNCOMPRESSED);
    }

    @Override
    public void startLogicalFile(DTAUSLogicalFile logicalFile) {
        this.dtaw = null;
        this.items.clear();
        if (this.existingFile == null) {
            try {
                this.dtaw = new BundesbankSwiftWriter(this.getTempOutputStream());
                this.dtaw.startLogicalFile(logicalFile);
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
    }

    @Override
    public void handleItem(DTAUSItem i) {
    }

    @Override
    public void handleSwiftItem(BundesbankSwiftItem item) {
        this.items.add(item);
        if (this.dtaw != null) {
            try {
                this.dtaw.write(item);
            }
            catch (Exception e) {
                this.logger.logError("Exception", e);
            }
        }
    }

    @Override
    public void consumeError(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    @Override
    public void handleWarning(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public void endLogicalFile(DTAUSLogicalFile logicalFile) {
        if (this.dtaw != null) {
            try {
                this.dtaw.closeLogicalFile();
                this.dtaw.close();
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
        this.processLogicalFile(logicalFile);
    }

    @Override
    protected String getReferenceNumber(DTAUSLogicalFile lf) {
        return String.valueOf(lf.getFileNumber());
    }

    private BookingStatistics calculateStatistics(List<BundesbankSwiftItem> items) {
        BookingStatistics statistics = new BookingStatistics();
        for (BundesbankSwiftItem item : items) {
            BundesbankSwiftItem i;
            if (item instanceof BundesbankSwiftPaymentItem) {
                i = (BundesbankSwiftPaymentItem)item;
                if ("D".equals(((BundesbankSwiftPaymentItem)i).getCreditDebitFlag())) {
                    statistics.addBooking(((BundesbankSwiftPaymentItem)i).getAmount().negate());
                    continue;
                }
                statistics.addBooking(((BundesbankSwiftPaymentItem)i).getAmount());
                continue;
            }
            if (!(item instanceof BundesbankEMZSwiftItem)) continue;
            i = (BundesbankEMZSwiftItem)item;
            statistics.addBooking(((BundesbankEMZSwiftItem)i).getAmount().negate());
        }
        return statistics;
    }

    @Override
    protected void processBookings(CmStatement s, DTAUSLogicalFile lf) {
        boolean isCreditFile = lf.isCredit();
        List<CmBooking> possibleParentBookings = CMProcessingDb.findParentBookings(s, s.getReference1(), this.preferences, this.logger);
        CmBooking parentBooking = null;
        ArrayList<CmBooking> parentBookings = null;
        BookingStatistics statistics = this.calculateStatistics(this.items);
        statistics.storeStatistics(s);
        if (possibleParentBookings != null && (parentBooking = CMProcessingDb.findParentBooking(possibleParentBookings, s.getTotalSum(), s.getCreationDate(), this.preferences)) == null) {
            parentBookings = new ArrayList<CmBooking>();
        }
        int pos = 0;
        for (BundesbankSwiftItem i : this.items) {
            CmBooking b;
            if ((b = BundesbankSwiftProcessingApi.findBooking(s, null, ++pos)) == null) {
                b = new CmBooking();
                b.setPos(pos);
            }
            b.setCollective(false);
            b.setAccount(this.latestAccount);
            b.setStatement(s);
            b.setBookingDate(new Date(s.getCreationDate().getTime()));
            BigDecimal amount = null;
            if (i instanceof BundesbankSwiftPaymentItem) {
                String tmp;
                item = (BundesbankSwiftPaymentItem)i;
                boolean isDebit = "D".equals(((BundesbankSwiftPaymentItem)item).getCreditDebitFlag());
                if (isDebit) {
                    amount = ((BundesbankSwiftPaymentItem)item).getAmount().negate();
                    b.setLocalParty(StringUtils.getStringFromStringArray(((BundesbankSwiftPaymentItem)item).getLocalParty(), "\n"));
                    b.setLocalPartyBankCode(((BundesbankSwiftPaymentItem)item).getLocalPartyBankCode());
                    b.setLocalPartyAccountNumber(((BundesbankSwiftPaymentItem)item).getLocalPartyAccountNumber());
                    b.setCounterParty(StringUtils.getStringFromStringArray(((BundesbankSwiftPaymentItem)item).getCounterParty(), "\n"));
                    b.setCounterPartyBankCode(((BundesbankSwiftPaymentItem)item).getCounterPartyBankCode());
                    b.setCounterPartyAccountNumber(((BundesbankSwiftPaymentItem)item).getCounterPartyAccountNumber());
                } else {
                    amount = ((BundesbankSwiftPaymentItem)item).getAmount();
                    b.setLocalParty(StringUtils.getStringFromStringArray(((BundesbankSwiftPaymentItem)item).getCounterParty(), "\n"));
                    b.setLocalPartyBankCode(((BundesbankSwiftPaymentItem)item).getCounterPartyBankCode());
                    b.setLocalPartyAccountNumber(((BundesbankSwiftPaymentItem)item).getCounterPartyAccountNumber());
                    b.setCounterParty(StringUtils.getStringFromStringArray(((BundesbankSwiftPaymentItem)item).getLocalParty(), "\n"));
                    b.setCounterPartyBankCode(((BundesbankSwiftPaymentItem)item).getLocalPartyBankCode());
                    b.setCounterPartyAccountNumber(((BundesbankSwiftPaymentItem)item).getLocalPartyAccountNumber());
                }
                b.setPurpose(StringUtils.getStringFromStringArray(((BundesbankSwiftPaymentItem)item).getPurpose(), "\n"));
                b.setPurposeOverview(b.getFirstLine(b.getPurpose()));
                this.setOriginalAmount(b, ((BundesbankSwiftPaymentItem)item).getOriginalAmount(), ((BundesbankSwiftPaymentItem)item).getOriginalCurrency(), isDebit);
                this.setSettlementAmount(b, ((BundesbankSwiftPaymentItem)item).getSettlementAmount(), ((BundesbankSwiftPaymentItem)item).getSettlementCurrency(), isDebit);
                if (((BundesbankSwiftPaymentItem)item).getExchangeRateDate() != null && ((BundesbankSwiftPaymentItem)item).getExchangeRate() != null) {
                    b.setExchangeRateDate(new Date(((BundesbankSwiftPaymentItem)item).getExchangeRateDate().getTime()));
                    b.setExchangeRate(((BundesbankSwiftPaymentItem)item).getExchangeRate());
                }
                b.setFeeType(((BundesbankSwiftPaymentItem)item).getFeeType());
                if (((BundesbankSwiftPaymentItem)item).getSenderToReceiverInformation() != null && !(tmp = StringUtils.getStringFromStringArray(((BundesbankSwiftPaymentItem)item).getSenderToReceiverInformation(), "\n")).equals(b.getPurpose())) {
                    b.setAdditionalInformation(tmp);
                }
            } else if (i instanceof BundesbankEMZSwiftItem) {
                item = (BundesbankEMZSwiftItem)i;
                amount = ((BundesbankEMZSwiftItem)item).getAmount().negate();
                b.setLocalParty(StringUtils.getStringFromStringArray(((BundesbankEMZSwiftItem)item).getLocalParty(), "\n"));
                b.setLocalPartyBankCode(((BundesbankEMZSwiftItem)item).getLocalPartyBankCode());
                b.setLocalPartyAccountNumber(((BundesbankEMZSwiftItem)item).getLocalPartyAccountNumber());
                b.setCounterParty(StringUtils.getStringFromStringArray(((BundesbankEMZSwiftItem)item).getCounterParty(), "\n"));
                b.setCounterPartyBankCode(((BundesbankEMZSwiftItem)item).getCounterPartyBIC());
                b.setCounterPartyAccountNumber(((BundesbankEMZSwiftItem)item).getCounterPartyAccountNumber());
                b.setPurpose(StringUtils.getStringFromStringArray(((BundesbankEMZSwiftItem)item).getPurpose(), "\n"));
                b.setPurposeOverview(b.getFirstLine(b.getPurpose()));
                this.setOriginalAmount(b, ((BundesbankEMZSwiftItem)item).getOriginalAmount(), ((BundesbankEMZSwiftItem)item).getOriginalCurrency(), true);
                b.setFeeType(((BundesbankEMZSwiftItem)item).getFeeType());
            }
            b.setAmount(amount);
            b.setCurrency(EURO);
            b.setDebit(!isCreditFile);
            if (parentBooking != null) {
                b.setParentBooking(parentBooking);
            } else if (parentBookings != null) {
                CmBooking parentBookingForSingle = CMProcessingDb.findParentBooking(possibleParentBookings, b.getAmount(), s.getCreationDate(), this.preferences);
                if (parentBookingForSingle != null) {
                    b.setParentBooking(parentBookingForSingle);
                    parentBookings.add(parentBookingForSingle);
                } else {
                    b.setParentBooking(null);
                }
            } else {
                b.setParentBooking(null);
            }
            if (b.getId() == null) {
                DB.save(b);
                continue;
            }
            DB.update(b);
        }
        if (parentBooking != null) {
            parentBooking.setCollective(true);
            DB.update(parentBooking);
        } else if (parentBookings != null) {
            for (CmBooking booking : parentBookings) {
                booking.setCollective(true);
                DB.update(booking);
            }
        }
        BundesbankSwiftProcessingApi.deleteHigherPositionedBookings(s, null, pos);
    }

    private void setOriginalAmount(CmBooking b, BigDecimal amount, Currency currency, boolean isDebit) {
        if (amount != null && currency != null) {
            b.setOriginalAmount(isDebit ? amount.negate() : amount);
            b.setOriginalCurrency(currency.getCurrencyCode());
        }
    }

    private void setSettlementAmount(CmBooking b, BigDecimal amount, Currency currency, boolean isDebit) {
        if (amount != null && currency != null) {
            b.setSettlementAmount(isDebit ? amount.negate() : amount);
            b.setSettlementCurrency(currency.getCurrencyCode());
        }
    }

    @Override
    protected CmReporter getReporter(String orderType) {
        return new CmReporterApi(CmReporter.Mode.FETCH_DTI, orderType, this.logger, this.encrypt, this.preferences.getUser(), this.reportHandlers);
    }
}

