/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.DTIProcessingApi;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.format.dta.BundesbankDtaExtractor;
import de.businesslogics.format.dta.BundesbankDtaToDTAUSConverter;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.SLF;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class BundesbankDtaProcessingApi
extends DTIProcessingApi {
    public BundesbankDtaProcessingApi(BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(logger, encrypt, preferences, reportHandlers);
    }

    public BundesbankDtaProcessingApi(BankSettings bank, CmReporter reporter, String orderType, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(bank, reporter, orderType, logger, encrypt, preferences, reportHandlers);
    }

    @Override
    protected OutputStream getExtractor() {
        return new BundesbankDtaExtractor(this, SLF.SLF_4_UNCOMPRESSED);
    }

    @Override
    protected String getReferenceNumber(DTAUSLogicalFile lf) {
        return String.valueOf(lf.getFileNumber());
    }

    @Override
    protected void convertFiles() {
        BundesbankDtaToDTAUSConverter converter = new BundesbankDtaToDTAUSConverter();
        if (this.targetFileMap != null && this.targetFileMap.keySet().size() > 0) {
            for (File ebcdicFile : this.targetFileMap.keySet()) {
                File dtausFile = new File(ebcdicFile.getParentFile(), ebcdicFile.getName() + ".CONVERTED");
                try {
                    InputStream ebcdicStream = this.encrypt.openInputStream(ebcdicFile);
                    OutputStream dtausStream = this.encrypt.openOutputStream(dtausFile);
                    converter.convertToDTAUS(true, ebcdicStream, dtausStream);
                }
                catch (Exception e) {
                    this.logger.logError("Exception while converting " + ebcdicFile.getAbsolutePath() + " to DTAUS", e);
                }
            }
        }
    }
}

