/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.banking.mt940.api.CMBank;
import io.ebean.Expr;
import io.ebean.Expression;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BookingSQLBuilder {
    private Expression expr;
    private Expression dti;
    private Map<Timestamp, Set<Account>> accounts;
    private Set<CMAccount> cmBankAccounts;
    private Set<Account> dtiAccounts;
    private Set<CmStatement> statements;
    private Set<CmStatement> advicesWithIgnoreOlderPages;
    private Set<CmPage> pages;
    private Set<CmBooking> bookings;
    private Date periodStartDate;
    private Date periodEndDate;
    private boolean singleBookingsOnly = false;
    private boolean showAlsoOldAdvices = false;

    @Deprecated
    public Expression getExpression() {
        return this.getExpression(true);
    }

    public Expression getExpression(boolean withoutFilter) {
        Expression expression;
        if (this.expr == null) {
            this.getCmAccountExpression();
            this.getDTIAccountExpression();
            this.getStmtExpression();
            this.getPageExpression();
            this.getBookingExpression();
        }
        if ((expression = this.expr) != null) {
            if (this.singleBookingsOnly) {
                expression = Expr.and((Expression)expression, (Expression)Expr.eq((String)"collective", (Object)false));
                if (this.dti != null) {
                    expression = Expr.or((Expression)expression, (Expression)this.dti);
                }
            } else if (withoutFilter) {
                Expression batchedTransactionFile = Expr.not((Expression)Expr.in((String)"statement.type", (Object[])new Object[]{CmStatement.Type.CAMT053, CmStatement.Type.CAMT052, CmStatement.Type.CAMT054Advice}));
                Expression firstLevelBookings = Expr.or((Expression)Expr.isNull((String)"parentBooking"), (Expression)batchedTransactionFile);
                expression = Expr.and((Expression)expression, (Expression)firstLevelBookings);
            }
        }
        return expression;
    }

    public void clearSelection() {
        this.expr = null;
        this.dti = null;
        this.accounts = null;
        this.cmBankAccounts = null;
        this.dtiAccounts = null;
        this.statements = null;
        this.advicesWithIgnoreOlderPages = null;
        this.pages = null;
        this.bookings = null;
        this.periodStartDate = null;
        this.periodEndDate = null;
    }

    public void addCMAccount(CMAccount cm) {
        this.expr = null;
        this.dti = null;
        if (this.periodStartDate != null && !this.periodStartDate.equals(cm.getPeriodStartDate())) {
            throw new RuntimeException("The start date for account" + cm.getDisplayName() + "was different than excpected.");
        }
        if (this.periodEndDate != null && !this.periodEndDate.equals(cm.getPeriodEndDate())) {
            throw new RuntimeException("The end date for account" + cm.getDisplayName() + "was different than excpected.");
        }
        this.periodStartDate = cm.getPeriodStartDate();
        this.periodEndDate = cm.getPeriodEndDate();
        CMBank cmBank = CMBank.get(cm.getAccount().getBank());
        if (cm.getNewestAdvice() != null && (cmBank.getCumulativeAdviceProvision() || cmBank.getMultidaysAdviceRepeated())) {
            if (this.cmBankAccounts == null) {
                this.cmBankAccounts = new HashSet<CMAccount>();
            }
            this.cmBankAccounts.add(cm);
            return;
        }
        if (this.accounts == null) {
            this.accounts = new HashMap<Timestamp, Set<Account>>();
        }
        Timestamp newest = cm.getNewestStatement() == null ? null : cm.getNewestStatement().getCreationDate();
        Set accs = this.accounts.computeIfAbsent(newest, k -> new HashSet());
        accs.add(cm.getAccount());
    }

    public void addDTIAccount(Account a) {
        this.expr = null;
        this.dti = null;
        if (this.dtiAccounts == null) {
            this.dtiAccounts = new HashSet<Account>();
        }
        this.dtiAccounts.add(a);
    }

    public void addCmStatement(CmStatement stmt) {
        CMBank cmBank;
        this.expr = null;
        this.dti = null;
        if (stmt.isAdvice() && (cmBank = CMBank.get(stmt.getAccount().getBank())).getCumulativeAdviceProvision()) {
            if (this.advicesWithIgnoreOlderPages == null) {
                this.advicesWithIgnoreOlderPages = new HashSet<CmStatement>();
            }
            this.advicesWithIgnoreOlderPages.add(stmt);
            return;
        }
        if (this.statements == null) {
            this.statements = new HashSet<CmStatement>();
        }
        this.statements.add(stmt);
    }

    public void addCmPage(CmPage page) {
        this.expr = null;
        this.dti = null;
        if (this.pages == null) {
            this.pages = new HashSet<CmPage>();
        }
        this.pages.add(page);
    }

    public void addCmBooking(CmBooking booking) {
        this.expr = null;
        this.dti = null;
        if (this.bookings == null) {
            this.bookings = new HashSet<CmBooking>();
        }
        this.bookings.add(booking);
    }

    public boolean isSingleBookingsOnly() {
        return this.singleBookingsOnly;
    }

    public void setSingleBookingsOnly(boolean singleBookingsOnly) {
        this.expr = null;
        this.dti = null;
        this.singleBookingsOnly = singleBookingsOnly;
    }

    public boolean isShowAlsoOldAdvices() {
        return this.showAlsoOldAdvices;
    }

    public void setShowAlsoOldAdvices(boolean showAlsoOldAdvices) {
        this.expr = null;
        this.dti = null;
        this.showAlsoOldAdvices = showAlsoOldAdvices;
    }

    private void getCmAccountExpression() {
        Expression filter = null;
        if (this.accounts != null) {
            for (Timestamp date : this.accounts.keySet()) {
                Set<Account> accs = this.accounts.get(date);
                Expression acc = Expr.in((String)"account", accs);
                Expression stmt = Expr.in((String)"statement.type", CmStatement.StatementTypes);
                Expression advice = Expr.in((String)"statement.type", CmStatement.AdviceTypes);
                if (!this.showAlsoOldAdvices && date != null) {
                    advice = Expr.and((Expression)advice, (Expression)Expr.gt((String)"statement.creationDate", (Object)date));
                }
                filter = this.smartOr(filter, Expr.and((Expression)acc, (Expression)Expr.or((Expression)stmt, (Expression)advice)));
            }
        }
        if (this.cmBankAccounts != null) {
            for (CMAccount cm : this.cmBankAccounts) {
                CMBank cmBank;
                Expression acc = Expr.eq((String)"account", (Object)cm.getAccount());
                Expression stmt = Expr.in((String)"statement.type", CmStatement.StatementTypes);
                Expression advice = Expr.in((String)"statement.type", CmStatement.AdviceTypes);
                if (!this.showAlsoOldAdvices && cm.getNewestStatement() != null) {
                    advice = Expr.and((Expression)advice, (Expression)Expr.gt((String)"bookingDate", (Object)cm.getNewestStatement().getClosingDate()));
                }
                if ((cmBank = CMBank.get(cm.getAccount().getBank())).getCumulativeAdviceProvision()) {
                    advice = Expr.and((Expression)advice, (Expression)this.ignoreOlderPages());
                    if (cm.getNewestAdvice() != null) {
                        advice = Expr.and((Expression)advice, (Expression)Expr.eq((String)"statement", (Object)cm.getNewestAdvice()));
                    }
                }
                if (!this.showAlsoOldAdvices && cmBank.getMultidaysAdviceRepeated() && cm.getNewestAdvice() != null) {
                    CmStatement newestAdvice = cm.getNewestAdvice();
                    Calendar c = Calendar.getInstance();
                    c.setTime(newestAdvice.getCreationDate());
                    Calendar day = Calendar.getInstance();
                    day.clear();
                    day.set(c.get(1), c.get(2), c.get(5));
                    Expression multiFilter = Expr.or((Expression)Expr.ge((String)"statement.creationDate", (Object)day.getTime()), (Expression)Expr.raw((String)"bookingDate <= statement.creationDate"));
                    advice = Expr.and((Expression)advice, (Expression)multiFilter);
                }
                filter = this.smartOr(filter, Expr.and((Expression)acc, (Expression)Expr.or((Expression)stmt, (Expression)advice)));
            }
        }
        if (this.periodStartDate != null) {
            filter = Expr.and(filter, (Expression)Expr.ge((String)"bookingDate", (Object)this.periodStartDate));
        }
        if (this.periodEndDate != null) {
            filter = Expr.and((Expression)filter, (Expression)Expr.le((String)"bookingDate", (Object)this.periodEndDate));
        }
        this.expr = this.smartOr(this.expr, filter);
        Set<Account> allAccounts = this.getAllAccounts();
        if (allAccounts != null && !allAccounts.isEmpty()) {
            this.dti = this.smartOr(this.dti, Expr.in((String)"parentBooking.account", allAccounts));
        }
    }

    private void getDTIAccountExpression() {
        if (this.dtiAccounts != null && !this.dtiAccounts.isEmpty()) {
            Expression filter = Expr.in((String)"statement.type", CmStatement.DtiTypes);
            filter = Expr.and((Expression)Expr.in((String)"account", this.dtiAccounts), (Expression)filter);
            this.expr = this.smartOr(this.expr, filter);
        }
    }

    private void getStmtExpression() {
        if (this.statements != null && !this.statements.isEmpty()) {
            this.expr = this.smartOr(this.expr, Expr.in((String)"statement", this.statements));
            this.dti = this.smartOr(this.dti, Expr.in((String)"parentBooking.statement", this.statements));
        }
        if (this.advicesWithIgnoreOlderPages != null && !this.advicesWithIgnoreOlderPages.isEmpty()) {
            this.expr = this.smartOr(this.expr, Expr.in((String)"statement", this.advicesWithIgnoreOlderPages));
            this.expr = Expr.and((Expression)this.expr, (Expression)this.ignoreOlderPages());
            this.dti = this.smartOr(this.dti, Expr.in((String)"parentBooking.statement", this.advicesWithIgnoreOlderPages));
        }
    }

    private void getPageExpression() {
        if (this.pages != null && !this.pages.isEmpty()) {
            this.expr = this.smartOr(this.expr, Expr.in((String)"page", this.pages));
            this.dti = this.smartOr(this.dti, Expr.in((String)"parentBooking.page", this.pages));
        }
    }

    private void getBookingExpression() {
        if (this.bookings != null && !this.bookings.isEmpty()) {
            this.expr = this.smartOr(this.expr, Expr.in((String)"parentBooking", this.bookings));
        }
    }

    private Set<Account> getAllAccounts() {
        HashSet<Account> result = new HashSet<Account>();
        if (this.accounts != null) {
            for (Set set : this.accounts.values()) {
                result.addAll(set);
            }
        }
        if (this.cmBankAccounts != null) {
            for (CMAccount cMAccount : this.cmBankAccounts) {
                result.add(cMAccount.getAccount());
            }
        }
        return result;
    }

    private Expression ignoreOlderPages() {
        return Expr.or((Expression)Expr.isNull((String)"page"), (Expression)Expr.eq((String)"page.old", (Object)false));
    }

    private Expression smartOr(Expression exp1, Expression exp2) {
        if (exp1 == null) {
            return exp2;
        }
        if (exp2 == null) {
            return exp1;
        }
        return Expr.or((Expression)exp1, (Expression)exp2);
    }
}

