/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.database.vo.CmBookingFilter;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Locale;

public class BookingFilterDescription {
    public static String getDescription(CmBookingFilter filter, int filteredCount, int totalCount, Locale locale) {
        boolean displayShortDescription = false;
        if (displayShortDescription) {
            return BookingFilterDescription.getShortDescription(filteredCount, totalCount, locale);
        }
        return BookingFilterDescription.getLongDescription(filter, filteredCount, totalCount, locale);
    }

    private static String getShortDescription(int filteredCount, int totalCount, Locale locale) {
        StringBuffer sb = new StringBuffer();
        sb.append(Messages.getString(locale, "BookingFilter.filterResult", new Object[0]));
        sb.append(" ");
        sb.append(filteredCount);
        sb.append("/");
        sb.append(totalCount);
        sb.append(" ");
        sb.append(Messages.getString(locale, "BookingFilter.bookingsFound", new Object[0]));
        return sb.toString();
    }

    private static String getLongDescription(CmBookingFilter filter, int filteredCount, int totalCount, Locale locale) {
        StringBuffer sb = new StringBuffer();
        sb.append(filteredCount);
        sb.append("/");
        sb.append(totalCount);
        sb.append(" ");
        sb.append(Messages.getString(locale, "BookingFilter.bookingsFoundWith", new Object[0]));
        sb.append(BookingFilterDescription.getFilterDescription(filter, locale));
        return sb.toString();
    }

    public static String getFilterDescription(CmBookingFilter filter, Locale locale) {
        return BookingFilterDescription.getFilterDescription(null, filter, locale);
    }

    public static String getFilterDescription(Integer year, CmBookingFilter filter, Locale locale) {
        StringBuffer sb = new StringBuffer();
        boolean addPrefix = false;
        if (year != null) {
            sb.append(BankingApiMessages.getString(locale, "Filter.statementYear", year.toString()));
            addPrefix = true;
        }
        if (filter != null) {
            addPrefix = BookingFilterDescription.addDateDescription(sb, addPrefix, BankingApiMessages.getString(locale, "GeneralMessages.bookingDate2", new Object[0]), filter.getBookingDateComparator(), filter.getBookingDateFrom(), filter.getBookingDateTo(), locale);
            addPrefix = BookingFilterDescription.addDateDescription(sb, addPrefix, BankingApiMessages.getString(locale, "GeneralMessages.valueDate", new Object[0]), filter.getValueDateComparator(), filter.getValueDateFrom(), filter.getValueDateTo(), locale);
            addPrefix = BookingFilterDescription.addTextDescription(sb, addPrefix, filter.getTextComparator(), filter.getText(), locale);
            addPrefix = BookingFilterDescription.addAmountDescription(sb, addPrefix, filter.getAmountComparator(), filter.getAmountFrom(), filter.getAmountTo(), locale);
            if (filter.getBookingDirection() != null) {
                switch (filter.getBookingDirection()) {
                    case INCOMING: {
                        addPrefix = BookingFilterDescription.addPrefix(sb, addPrefix);
                        sb.append(' ');
                        sb.append(Messages.getString(locale, "BookingFilter.bookingDirection.incoming", new Object[0]));
                        break;
                    }
                    case OUTGOING: {
                        addPrefix = BookingFilterDescription.addPrefix(sb, addPrefix);
                        sb.append(' ');
                        sb.append(Messages.getString(locale, "BookingFilter.bookingDirection.outgoing", new Object[0]));
                        break;
                    }
                }
            }
            if (filter.getBookingType() != null && filter.getBookingType() != CmBookingFilter.BookingType.ALL) {
                addPrefix = BookingFilterDescription.addPrefix(sb, addPrefix);
                BookingFilterDescription.addBookingTypeDescription(sb, filter.getBookingType(), filter.getBookingTypeText(), locale);
            }
        }
        return sb.toString();
    }

    private static void addBookingTypeDescription(StringBuffer sb, CmBookingFilter.BookingType bookingType, String bookingTypeText, Locale locale) {
        sb.append(" ");
        if (!CmBookingFilter.isBookingTypeWithTextField(bookingType)) {
            sb.append(GeneralMessages.getInstance((Locale)locale).TYPE);
            sb.append(":\u00a0");
            sb.append(EclipseFreeHelper.getBookingTypeText(bookingType, locale));
        } else if (bookingTypeText != null && bookingTypeText.length() > 0) {
            sb.append(EclipseFreeHelper.getBookingTypeText(bookingType, locale));
            sb.append(":\u00a0");
            sb.append(bookingTypeText);
        }
    }

    private static boolean addAmountDescription(StringBuffer sb, boolean addPrefix, FilterComparator.Amount amountComparator, BigDecimal amount1, BigDecimal amount2, Locale locale) {
        if (amountComparator == FilterComparator.Amount.BETWEEN && amount1 != null && amount2 != null) {
            addPrefix = BookingFilterDescription.addPrefix(sb, addPrefix);
            BookingFilterDescription.addAmountDescription(sb, amount1, amount2, locale);
        } else if (amountComparator != null && amountComparator != FilterComparator.Amount.BETWEEN && amount1 != null) {
            addPrefix = BookingFilterDescription.addPrefix(sb, addPrefix);
            BookingFilterDescription.addAmountDescription(sb, amountComparator.getVisual(), amount1, locale);
        }
        return addPrefix;
    }

    private static boolean addTextDescription(StringBuffer sb, boolean addPrefix, FilterComparator.Text textComparator, String text, Locale locale) {
        if (text != null && text.length() > 0) {
            addPrefix = BookingFilterDescription.addPrefix(sb, addPrefix);
            sb.append(' ');
            if (textComparator == FilterComparator.Text.STARTS_WITH) {
                sb.append(BankingApiMessages.getString(locale, "Filter.text.startswith", text));
            } else if (textComparator == FilterComparator.Text.ENDS_WITH) {
                sb.append(BankingApiMessages.getString(locale, "Filter.text.endswith", text));
            } else if (textComparator == FilterComparator.Text.CONTAINS_NOT) {
                sb.append(BankingApiMessages.getString(locale, "Filter.text.containsnot", text));
            } else {
                sb.append(BankingApiMessages.getString(locale, "Filter.text.contains", text));
            }
        }
        return addPrefix;
    }

    private static boolean addDateDescription(StringBuffer sb, boolean addPrefix, String dateName, FilterComparator.Date dateComparator, Date date1, Date date2, Locale locale) {
        if (dateComparator == FilterComparator.Date.BETWEEN && date1 != null && date2 != null) {
            addPrefix = BookingFilterDescription.addPrefix(sb, addPrefix);
            BookingFilterDescription.addBetweenDateDescription(sb, dateName, DateFormat.getDateInstance().format(date1), DateFormat.getDateInstance().format(date2), locale);
        } else if (dateComparator != null && date1 != null) {
            addPrefix = BookingFilterDescription.addPrefix(sb, addPrefix);
            BookingFilterDescription.addDateDescription(sb, dateName, (String)(switch (dateComparator) {
                case FilterComparator.Date.LESS -> "\u00a0" + BankingApiMessages.getString(locale, "GeneralMessages.to", new Object[0]);
                case FilterComparator.Date.GREATER -> "\u00a0" + BankingApiMessages.getString(locale, "Filter.dateComparator.newerThan", new Object[0]);
                default -> "";
            }), DateFormat.getDateInstance().format(date1));
        }
        return addPrefix;
    }

    private static boolean addPrefix(StringBuffer sb, boolean addPrefix) {
        if (addPrefix) {
            sb.append(",");
        }
        return true;
    }

    private static void addDateDescription(StringBuffer sb, String dateName, String comparator, String date) {
        sb.append(" ");
        sb.append(dateName);
        sb.append(comparator);
        sb.append("\u00a0");
        sb.append(date);
    }

    private static void addBetweenDateDescription(StringBuffer sb, String dateName, String date1, String date2, Locale locale) {
        sb.append(" ");
        sb.append(dateName);
        sb.append("\u00a0");
        sb.append(BankingApiMessages.getString(locale, "GeneralMessages.from", new Object[0]));
        sb.append("\u00a0");
        sb.append(date1);
        sb.append("\u00a0");
        sb.append(BankingApiMessages.getString(locale, "GeneralMessages.to", new Object[0]));
        sb.append("\u00a0");
        sb.append(date2);
    }

    private static void addAmountDescription(StringBuffer sb, String comparator, BigDecimal amount, Locale locale) {
        sb.append(" ");
        sb.append(BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]));
        sb.append("\u00a0");
        sb.append(comparator);
        sb.append("\u00a0");
        sb.append(PaymentUtils.formatBigDecimal(amount, locale, 2));
    }

    private static void addAmountDescription(StringBuffer sb, BigDecimal amount1, BigDecimal amount2, Locale locale) {
        sb.append(" ");
        sb.append(BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]));
        sb.append("\u00a0");
        sb.append(BankingApiMessages.getString(locale, "GeneralMessages.from", new Object[0]));
        sb.append("\u00a0");
        sb.append(PaymentUtils.formatBigDecimal(amount1, locale, 2));
        sb.append("\u00a0");
        sb.append(BankingApiMessages.getString(locale, "GeneralMessages.to", new Object[0]));
        sb.append("\u00a0");
        sb.append(PaymentUtils.formatBigDecimal(amount2, locale, 2));
    }
}

