/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.PreScheduler;
import de.businesslogics.bcs.core.YYMMDD;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

public class BkaPreScheduler
implements PreScheduler {
    @Override
    public Set<String> getOrderOrFileTypes(Scheduler s) {
        CMBank cmBank = CMBank.get(s.getBank());
        HashSet<String> result = new HashSet<String>();
        if (cmBank.isBkaFetchActivated()) {
            result.add(cmBank.getBkaFetchType());
        }
        return result;
    }

    @Override
    public YYMMDD getFromDate(Scheduler s) {
        CMBank cmBank = CMBank.get(s.getBank());
        if (CmBank.FetchMode.NEW.equals((Object)cmBank.getBkaFetchMode())) {
            return null;
        }
        if (cmBank.getLastBkaFetchDate() != null) {
            return new YYMMDD(cmBank.getLastBkaFetchDate().getTime());
        }
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, s.getLoginUser(), s.getBank().getTenant());
        Calendar c = Calendar.getInstance();
        c.add(5, -store.getInt(CmPreferenceConstants.HISTORY_TIME_RANGE));
        return new YYMMDD(c.getTimeInMillis());
    }

    @Override
    public YYMMDD getToDate(Scheduler s) {
        return null;
    }

    @Override
    public void setLastFetchDate(Scheduler s, YYMMDD date) {
        CMBank cmBank = CMBank.get(s.getBank());
        cmBank.setLastBkaFetchDate(date);
        cmBank.save();
    }
}

