/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import io.ebean.Transaction;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseDtaProcessing
extends CMProcessingDb
implements Processing {
    private static final int BLOCK_SIZE = 61440;
    protected Exception exception;
    private String blz;
    private String accountNumber;
    protected Map<File, CmStatement> targetFileMap = new HashMap<File, CmStatement>();
    protected String orderType;
    private CmStatement.Type statementType;

    protected BaseDtaProcessing(BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(logger, encrypt, preferences);
        this.setNamePrefix(WorkspaceFileSystem.DTI_DIRECTORY.toString());
    }

    protected BaseDtaProcessing(BankSettings bank, CmReporter reporter, String orderType, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(logger, encrypt, preferences);
        this.setNamePrefix(WorkspaceFileSystem.DTI_DIRECTORY.toString());
        this.statementType = CmStatement.Type.valueOf(orderType);
        this.initialize(bank, reporter, orderType);
    }

    private void initialize(BankSettings bank, CmReporter reporter, String orderType) {
        this.bank = bank;
        this.reporter = reporter;
        this.orderType = orderType;
        this.accountParentDir = new File(WorkspaceFileSystem.DTI_DIRECTORY, bank.getUniqueKey());
        this.accountParentDir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPostProcessing(Fetch item) throws Exception {
        InputStream in = null;
        try (Transaction t = DB.beginTransaction();){
            this.statementType = this.getStatementType(item);
            this.initialize(item.getBank(), this.getReporter(this.statementType.name()), this.statementType.name());
            in = this.encrypt.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));
            this.process(in);
            t.commit();
        }
        catch (Throwable throwable) {
            Util.closeStream(in);
            throw throwable;
        }
        Util.closeStream(in);
        this.reporter.finishProcessing(this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES));
    }

    private CmStatement.Type getStatementType(Fetch item) throws Exception {
        String orderType;
        String btf = item.getFileType();
        if (btf != null) {
            if ("DCT:BIL:URG_gtbbksw".equals(btf)) {
                return CmStatement.Type.YG2;
            }
            if ("REP:BIL:URG_wabbksw".equals(btf)) {
                return CmStatement.Type.YWA;
            }
        }
        if ("YG2".equals(orderType = item.getOrderType())) {
            return CmStatement.Type.YG2;
        }
        if ("YWA".equals(orderType)) {
            return CmStatement.Type.YWA;
        }
        if ("DTI".equals(orderType)) {
            return CmStatement.Type.DTI;
        }
        throw new Exception("Could not determine statementType from btf <" + btf + "> and orderType <" + orderType + ">");
    }

    protected abstract CmReporter getReporter(String var1);

    protected final String getUniqueFileName(Date creationDate, String number, String format) {
        return ((SimpleDateFormat)YYMMDD.get()).format(creationDate) + "." + number + "." + format;
    }

    public static String getOrderTypeFromFileName(String fileName) {
        int separatorPosition = fileName.lastIndexOf(".");
        if (separatorPosition > 0 && fileName.length() > separatorPosition + 3) {
            return fileName.substring(separatorPosition + 1);
        }
        return null;
    }

    @Override
    protected Account findOrCreateAccount() {
        return BaseDtaProcessing.findOrCreateGermanAccount(this.bank, this.blz, this.accountNumber, "EUR");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(InputStream in) throws Exception {
        if (in == null) {
            return;
        }
        OutputStream out = null;
        try {
            int read;
            out = this.getExtractor();
            byte[] buffer = new byte[61440];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            Util.closeStream(out);
        }
        if (this.existingFile == null) {
            this.convertFiles();
        }
    }

    protected abstract OutputStream getExtractor();

    protected void processLogicalFile(DTAUSLogicalFile logicalFile) {
        this.blz = String.valueOf(logicalFile.getOrigBankcode());
        this.accountNumber = String.valueOf(logicalFile.getOrigAccount());
        this.accountIdentifier = this.blz + "_" + this.accountNumber;
        try {
            this.latestAccount = this.findOrCreateAccount();
            if (this.existingFile == null) {
                this.createAccountDir(this.accountIdentifier);
                this.targetFile = new File(this.accountDir, this.getTargetFileName(logicalFile));
            }
            CmStatement s = this.processStatement(logicalFile);
            if (this.targetFile != null && this.targetFile.exists()) {
                this.targetFileMap.put(this.targetFile, s);
            }
        }
        catch (Exception e) {
            this.logger.logError("Exception in BaseDtaProcessing ", e);
        }
    }

    protected CmStatement processStatement(DTAUSLogicalFile logicalFile) {
        String dbFileName = this.getDbFileName();
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, dbFileName);
        if (c == null) {
            if (this.targetFile != null) {
                this.createTargetFile();
            }
            c = this.createStatement(dbFileName, this.statementType, logicalFile);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.targetFile != null) {
                this.createTargetFile();
            }
            this.updateStatement(c, logicalFile);
        }
        return c;
    }

    private CmStatement createStatement(String dbFileName, CmStatement.Type type, DTAUSLogicalFile logicalFile) {
        CmStatement c = CMProcessingDb.createStatement(dbFileName, type, this.latestAccount);
        this.setStatementData(c, logicalFile);
        DB.save(c);
        this.processBookings(c, logicalFile);
        this.reporter.newStatement(c, null);
        return c;
    }

    private void updateStatement(CmStatement c, DTAUSLogicalFile logicalFile) {
        this.setStatementData(c, logicalFile);
        DB.update(c);
        this.processBookings(c, logicalFile);
        this.reporter.newStatement(c, null);
    }

    protected abstract void processBookings(CmStatement var1, DTAUSLogicalFile var2);

    private void setStatementData(CmStatement s, DTAUSLogicalFile lf) {
        this.setFile(s);
        s.setReference1(this.getReferenceNumber(lf));
        s.setCurrency(Currency.getInstance("EUR"));
        Date creationDate = null;
        try {
            creationDate = lf.getCreation();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (creationDate != null) {
            s.setCreationDate(new Timestamp(creationDate.getTime()));
        }
    }

    private String getTargetFileName(DTAUSLogicalFile logicalFile) throws ParseException {
        Date creationDate = logicalFile.getCreation();
        String refNumber = this.getReferenceNumber(logicalFile);
        if ("0".equals(refNumber)) {
            return this.getUniqueFileName(creationDate, this.getMD5Hash(), this.orderType);
        }
        return this.getUniqueFileName(creationDate, refNumber, this.orderType);
    }

    protected abstract String getReferenceNumber(DTAUSLogicalFile var1);

    protected void convertFiles() {
    }
}

