/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.BankDeleteNotifier;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.CmDeleter;
import de.businesslogics.util.IProgressMonitorWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public class BankDelete
implements BankDeleteNotifier {
    @Override
    public String[] checkDataToBeDeleted(BankSettings bank, Locale locale) {
        return this.getMessage(DB.find(CmStatement.class).where().eq("account.bank", (Object)bank).findCount(), locale);
    }

    private String[] getMessage(int accountCount, Locale locale) {
        if (accountCount > 0) {
            return new String[]{MessageFormat.format(Messages.getString(locale, "BankDelete.hint", new Object[0]), accountCount)};
        }
        return null;
    }

    @Override
    public String[] checkDataToBeDeleted(BankSettings[] banks, Locale locale) {
        ArrayList b = new ArrayList();
        Collections.addAll(b, banks);
        return this.getMessage(DB.find(CmStatement.class).where().in("account.bank", b).findCount(), locale);
    }

    @Override
    public void deleteBank(BankSettings bank, IProgressMonitorWrapper monitor) {
        CmDeleter.deleteBank(bank, monitor);
    }
}

