/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Locale;
import java.util.Map;

public class BalancesCsvExport
extends AbstractCsvExport<CmBalance> {
    private final Map<Date, BigDecimal> bookingBalanceMap;
    private final Account account;
    private final Currency currency;
    private final Locale locale;

    public BalancesCsvExport(Map<Date, BigDecimal> bookingBalanceMap, Account account, Currency currency, Locale locale) {
        this.bookingBalanceMap = bookingBalanceMap;
        this.account = account;
        this.currency = currency;
        this.locale = locale;
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        this.addCell(writer, this.account.getName());
        this.addCell(writer, this.currency.toString());
        this.startNewLine(writer);
        this.addCell(writer, GeneralMessages.getInstance((Locale)this.locale).DATE);
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.valueBalance", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.valueBalanceWithAdvice", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.bookingBalance", new Object[0]));
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, CmBalance b) throws IOException {
        this.addCell(writer, this.formatDate(b.getVauleDate(), this.locale));
        this.addCell(writer, this.formatAmount(b.getValueBalance(), this.currency, this.locale), true);
        if (b.getValueBalance().compareTo(b.getValueBalanceWithAdvice()) != 0) {
            this.addCell(writer, this.formatAmount(b.getValueBalanceWithAdvice(), this.currency, this.locale), true);
        } else {
            this.addCell(writer, null);
        }
        this.addCell(writer, this.formatAmount(this.bookingBalanceMap.get(b.getVauleDate()), this.currency, this.locale), true);
        return true;
    }
}

