/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class BalanceSumHandler {
    private final HashMap<Currency, BigDecimal> bookingBalances = new HashMap();
    private final HashMap<Currency, BigDecimal> vbBalances = new HashMap();
    private final List<Currency> currencies = new ArrayList<Currency>();
    private final Locale locale;

    public BalanceSumHandler(List<CMAccount> accounts, boolean balancesWithAdvices, Locale locale) {
        this.locale = locale;
        HashSet<Currency> currencySet = new HashSet<Currency>();
        for (CMAccount account : accounts) {
            BigDecimal vbToday;
            CmStatement newest = account.getNewestStatement();
            if (newest == null) continue;
            BigDecimal accountBalance = EclipseFreeHelper.getClosingBalance(newest);
            Currency accountCurrency = newest.getCurrency();
            if (accountCurrency == null || accountBalance == null) continue;
            currencySet.add(accountCurrency);
            BigDecimal b = this.bookingBalances.get(accountCurrency);
            if (b == null) {
                this.bookingBalances.put(accountCurrency, accountBalance);
            } else {
                this.bookingBalances.put(accountCurrency, b.add(accountBalance));
            }
            if ((vbToday = EclipseFreeHelper.getBalance(account.getVbToday(), balancesWithAdvices)) == null) continue;
            b = this.vbBalances.get(accountCurrency);
            if (b == null) {
                this.vbBalances.put(accountCurrency, vbToday);
                continue;
            }
            this.vbBalances.put(accountCurrency, b.add(vbToday));
        }
        this.currencies.addAll(currencySet);
        Collections.sort(this.currencies, new Comparator<Currency>(this){

            @Override
            public int compare(Currency c1, Currency c2) {
                if (c1 == null) {
                    return c2 == null ? 0 : -1;
                }
                if (c2 == null) {
                    return 1;
                }
                return c1.toString().compareTo(c2.toString());
            }
        });
    }

    public List<Currency> getCurrencies() {
        return this.currencies;
    }

    public String getBookingBalanceString(Currency c) {
        return PaymentUtils.formatAmount(this.bookingBalances.get(c), c, this.locale);
    }

    public String getVbBalanceString(Currency c) {
        return PaymentUtils.formatAmount(this.vbBalances.get(c), c, this.locale);
    }

    public BigDecimal getBookingBalanceAmount(Currency c) {
        return this.bookingBalances.get(c);
    }

    public BigDecimal getVbBalanceAmount(Currency c) {
        return this.vbBalances.get(c);
    }
}

