/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.mt940.api.ValueBalancesDataProvider;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class BalanceListsCsvExport
extends AbstractCsvExport<ValueBalancesDataProvider.Data> {
    private final Date startDate;
    private final int dateCount;
    private final boolean valueBalances;
    private final boolean balancesWithAdvices;
    private final Locale locale;

    public BalanceListsCsvExport(Date startDate, int dateCount, boolean valueBalances, boolean balancesWithAdvices, Locale locale) {
        this.startDate = startDate;
        this.dateCount = dateCount;
        this.valueBalances = valueBalances;
        this.balancesWithAdvices = balancesWithAdvices;
        this.locale = locale;
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.standardName", new Object[0]));
        for (int i = 0; i < this.dateCount; ++i) {
            this.addCell(writer, this.formatDate(BalanceListsCsvExport.addToDate(this.startDate, i), this.locale));
        }
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, ValueBalancesDataProvider.Data d) throws IOException {
        String currency;
        if (!(d.account != null || d.currency != null && d.currency.length() != 0 || d.onlyOneSum)) {
            return true;
        }
        String string = d.currency != null ? d.currency : (currency = d.account != null ? d.account.getCurrency() : null);
        if (d.account != null) {
            this.addCell(writer, d.account.getName() + " (" + currency + ")");
        } else if (d.onlyOneSum) {
            if (d.creditLimit) {
                this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.sumCreditLimits", new Object[0]));
            } else if (d.freeLiquidity) {
                this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.freeLiquiditySum", new Object[0]));
            } else {
                this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.sum", new Object[0]));
            }
        } else if (d.currency != null && d.currency.length() > 0) {
            if (d.creditLimit) {
                this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.sumInCurrencyCreditLimit", d.currency));
            } else if (d.freeLiquidity) {
                this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.freeLiquiditySumInCurrency", d.currency));
            } else {
                this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.sumInCurrency", d.currency));
            }
        }
        this.addCell(writer, Account.getCmDisplayName(d.account));
        for (int i = 0; i < this.dateCount; ++i) {
            if (d.balances.length < i || d.balances[i] == null) continue;
            this.addCell(writer, this.formatAmount(EclipseFreeHelper.getBalance(d.balances[i], this.valueBalances, this.balancesWithAdvices), Currency.getInstance(currency), this.locale), true);
        }
        return true;
    }

    private static Date addToDate(Date start, int dayCount) {
        Calendar c = Calendar.getInstance();
        c.setTime(start);
        c.add(5, dayCount);
        return c.getTime();
    }
}

