/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.ProgressMonitorDummy;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.AutomaticExporter;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class AutomaticExporterApi
extends AutomaticExporter {
    public AutomaticExporterApi(Collection<AutomaticExport> exports, List<CmStatement> statements, List<CmPage> pages, String name, BLLogger logger, EncryptData enrcypt, User user) {
        super(exports, statements, pages, name, logger, enrcypt, new DatabasePreferenceStore(Preference.ApplicationId.CM, user));
    }

    @Override
    public void doExport(boolean setUser) {
        if (!(this.exports.isEmpty() || this.statements.isEmpty() && this.pages.isEmpty())) {
            this.work(ProgressMonitorDummy.getInstance());
        }
    }

    @Override
    protected void showMessageDialog(int fileCount, File lastFile) {
    }

    @Override
    protected void handleErrors() {
        for (Exception e : this.exceptions) {
            this.logger.logError(e.getMessage(), e);
        }
    }

    public static String getFileTypeText(AutomaticExport.Type type, Locale locale) {
        switch (type) {
            case STATEMENT: {
                return GeneralMessages.getInstance((Locale)locale).ACCOUNT_STATEMENTS;
            }
            case ADVICE: {
                return GeneralMessages.getInstance((Locale)locale).ADVICES;
            }
            case BATCHED_TRANSACTION_FILE: {
                return GeneralMessages.getInstance((Locale)locale).BATCHED_TRANSACTION_FILES;
            }
        }
        return GeneralMessages.getInstance((Locale)locale).ACCOUNT_STATEMENTS;
    }
}

