/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.ExportFile;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.CmPrinter;
import de.businesslogics.banking.mt940.api.CmCleanUp;
import de.businesslogics.banking.mt940.api.Converter;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.mt940.api.MT940Processing;
import de.businesslogics.banking.mt940.api.StatementExporter;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.task.Substitution;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.IProgressMonitorWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AutomaticExporter {
    protected Collection<AutomaticExport> exports;
    protected List<CmStatement> statements;
    protected List<CmPage> pages;
    protected String name;
    protected final BLLogger logger;
    protected final EncryptData enrcypt;
    protected final DatabasePreferenceStore store;
    protected final Locale locale;
    protected List<Exception> exceptions = new ArrayList<Exception>();
    private final boolean convertEbcdicToAscii;
    private final String fixedBaseDir;

    public static Substitution getExample(String exportName) {
        Substitution s = new Substitution();
        s.addPlaceHolder("EXPORTNAME", exportName);
        s.addPlaceHolder("BANK", "Business-Logics Testbank");
        s.addPlaceHolder("ACCOUNTNAME", "Testkonto");
        s.addPlaceHolder("ACCOUNT", "47260121_8729160400");
        s.addPlaceHolder("BANKCODE", "47260121");
        s.addPlaceHolder("ACCNUMBER", "8729160400");
        s.addPlaceHolder("CURRENCY", "EUR");
        s.addPlaceHolder("STATEMENT", "1");
        s.addDatePlaceHolder("STATEMENTDATE", new Date());
        s.addPlaceHolder("FORMAT", "MT940");
        s.addDatePlaceHolder("NOW", new Date());
        s.addPlaceHolder("ACCOUNTGROUP", "EUR-Konten");
        return s;
    }

    private static File getTargetFile(AutomaticExport export, CmStatement stmt, File baseDir) {
        Date lastModifiedDate;
        String cmIdentifier;
        File f = null;
        if (stmt.getFile() == null) {
            List<CmPage> pages = CmPage.findByStatement(stmt, true);
            if (!pages.isEmpty()) {
                f = WorkspaceFileSystem.getFile(pages.get(0).getFile());
            }
        } else {
            f = WorkspaceFileSystem.getFile(stmt.getFile());
        }
        if (f != null) {
            File dir = null;
            dir = AutomaticExport.Type.BATCHED_TRANSACTION_FILE.equals((Object)export.getType()) ? f.getParentFile() : f.getParentFile().getParentFile();
            cmIdentifier = dir.getName();
            lastModifiedDate = new Date(f.lastModified());
        } else {
            cmIdentifier = stmt.getAccount().getIban();
            lastModifiedDate = new Date(stmt.getCreationDate().getTime());
        }
        Substitution s = new Substitution(lastModifiedDate);
        s.addPlaceHolder("EXPORTNAME", MT940Processing.transform(export.getName()));
        s.addPlaceHolder("BANK", MT940Processing.transform(stmt.getAccount().getBank().getDisplayName()));
        s.addPlaceHolder("ACCOUNTNAME", MT940Processing.transform(stmt.getAccount().getName()));
        s.addPlaceHolder("ACCOUNT", MT940Processing.transform(cmIdentifier));
        s.addPlaceHolder("BANKCODE", MT940Processing.transform(stmt.getAccount().getGermanBankCode()));
        if (cmIdentifier.indexOf(95) >= 0) {
            s.addPlaceHolder("ACCNUMBER", MT940Processing.transform(cmIdentifier.substring(cmIdentifier.indexOf(95))));
        } else {
            s.addPlaceHolder("ACCNUMBER", MT940Processing.transform(cmIdentifier));
        }
        s.addPlaceHolder("CURRENCY", stmt.getCurrencyCode());
        s.addPlaceHolder("STATEMENT", MT940Processing.transform(String.valueOf(stmt.getStatementNumber())));
        s.addDatePlaceHolder("STATEMENTDATE", stmt.getClosingDate());
        s.addPlaceHolder("FORMAT", stmt.getType().name());
        s.addDatePlaceHolder("NOW", new Date());
        CmFolder folder = stmt.getAccount().getFolder();
        String folderName = folder != null ? MT940Processing.transform(folder.getName()) : "";
        s.addPlaceHolder("ACCOUNTGROUP", folderName);
        return new File(baseDir, s.substitute(export.getPattern()));
    }

    private static File getTargetFile(AutomaticExport export, CmPage page, File baseDir) {
        File dir = WorkspaceFileSystem.getFile(page.getFile()).getParentFile().getParentFile();
        String dirName = dir.getName();
        Substitution s = new Substitution(new Date(dir.lastModified()));
        s.addPlaceHolder("EXPORTNAME", MT940Processing.transform(export.getName()));
        s.addPlaceHolder("BANK", MT940Processing.transform(page.getStatement().getAccount().getBank().getDisplayName()));
        s.addPlaceHolder("ACCOUNTNAME", MT940Processing.transform(page.getStatement().getAccount().getName()));
        s.addPlaceHolder("ACCOUNT", MT940Processing.transform(dirName));
        s.addPlaceHolder("BANKCODE", MT940Processing.transform(page.getStatement().getAccount().getGermanBankCode()));
        if (dirName.indexOf(95) >= 0) {
            s.addPlaceHolder("ACCNUMBER", MT940Processing.transform(dirName.substring(dirName.indexOf(95))));
        } else {
            s.addPlaceHolder("ACCNUMBER", MT940Processing.transform(dirName));
        }
        s.addPlaceHolder("CURRENCY", page.getCurrencyCode());
        s.addPlaceHolder("STATEMENT", MT940Processing.transform(String.valueOf(page.getStatement().getStatementNumber())));
        s.addDatePlaceHolder("STATEMENTDATE", page.getClosingDate());
        s.addDatePlaceHolder("NOW", new Date());
        CmFolder folder = page.getStatement().getAccount().getFolder();
        String folderName = folder != null ? MT940Processing.transform(folder.getName()) : "";
        s.addPlaceHolder("ACCOUNTGROUP", folderName);
        return new File(baseDir, s.substitute(export.getPattern()));
    }

    public AutomaticExporter(Collection<AutomaticExport> exports, List<CmStatement> statements, List<CmPage> pages, String name, BLLogger logger, EncryptData enrcypt, DatabasePreferenceStore store) {
        this.exports = exports;
        this.statements = statements;
        this.pages = pages;
        this.name = name;
        this.logger = logger;
        this.enrcypt = enrcypt;
        this.store = store;
        this.convertEbcdicToAscii = store.getBoolean(CmPreferenceConstants.CONVERT_EBCDIC_TO_ASCII);
        this.locale = EclipseFreeHelper.getAutomaticExportLanguage(store);
        this.fixedBaseDir = WorkspaceFileSystem.AUT_EXPORT_BASE_PATH;
    }

    public abstract void doExport(boolean var1);

    public ReturnStatus work(IProgressMonitorWrapper progressMonitor) {
        HashMap<File, Map> sorted = new HashMap<File, Map>();
        for (AutomaticExport export : this.exports) {
            Tuple tuple;
            Map map;
            File target;
            AutomaticExport.Type exportFileType = export.getType();
            boolean isStatementExport = AutomaticExport.Type.STATEMENT.equals((Object)exportFileType);
            boolean isAdviceExport = AutomaticExport.Type.ADVICE.equals((Object)exportFileType);
            boolean isBatchedTransactionFileExport = AutomaticExport.Type.BATCHED_TRANSACTION_FILE.equals((Object)exportFileType);
            File baseDir = this.fixedBaseDir != null ? new File(this.fixedBaseDir, export.getTenant().getId().toString()) : new File(export.getDirectory());
            for (CmStatement statement : this.statements) {
                if (!((isStatementExport && statement.isStatement() || isAdviceExport && statement.isAdvice() || isBatchedTransactionFileExport && statement.isDtiFile()) && this.shouldAccountBeExported(export, statement.getAccount()))) continue;
                target = AutomaticExporter.getTargetFile(export, statement, baseDir);
                map = sorted.computeIfAbsent(target, k -> new HashMap());
                tuple = map.computeIfAbsent(export, k -> new Tuple());
                tuple.statements.add(statement);
            }
            for (CmPage page : this.pages) {
                if (!((isStatementExport && page.getStatement().isStatement() || isAdviceExport && page.getStatement().isAdvice() || isBatchedTransactionFileExport && page.getStatement().isDtiFile()) && this.shouldAccountBeExported(export, page.getStatement().getAccount()))) continue;
                target = AutomaticExporter.getTargetFile(export, page, baseDir);
                map = sorted.computeIfAbsent(target, k -> new HashMap());
                tuple = map.computeIfAbsent(export, k -> new Tuple());
                tuple.pages.add(page);
            }
        }
        if (sorted.isEmpty()) {
            return ReturnStatus.OK;
        }
        if (progressMonitor != null) {
            progressMonitor.beginTask(this.name, sorted.size() * 1000);
        }
        File lastFile = null;
        for (File targetFile : sorted.keySet()) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return ReturnStatus.CANCEL;
            }
            if (progressMonitor != null) {
                progressMonitor.subTask(targetFile.getName());
            }
            targetFile.getParentFile().mkdirs();
            File zipTargetFile = null;
            Set set = ((Map)sorted.get(targetFile)).entrySet();
            IProgressMonitorWrapper sub = null;
            if (progressMonitor != null) {
                sub = progressMonitor.newSubMonitor(1000);
                sub.beginTask("", set.size());
            }
            for (Map.Entry entry : set) {
                AutomaticExport export = (AutomaticExport)entry.getKey();
                Conversion conversion = export.getConversion();
                if (conversion != null) {
                    try {
                        boolean fileExists = targetFile.exists();
                        this.doCsvExport(conversion, targetFile, ((Tuple)entry.getValue()).statements, ((Tuple)entry.getValue()).pages);
                        exportFile = AutomaticExporter.fileForPath(targetFile, !fileExists);
                        exportFile.addAccounts(((Tuple)entry.getValue()).statements, ((Tuple)entry.getValue()).pages);
                        exportFile.addExport(export);
                    }
                    catch (Exception io) {
                        this.exceptions.add(io);
                    }
                } else if (export.isConvertToPdf()) {
                    try {
                        boolean fileExists = targetFile.exists();
                        this.doPDFExport(targetFile, ((Tuple)entry.getValue()).statements, ((Tuple)entry.getValue()).pages);
                        exportFile = AutomaticExporter.fileForPath(targetFile, !fileExists);
                        exportFile.addAccounts(((Tuple)entry.getValue()).statements, ((Tuple)entry.getValue()).pages);
                        exportFile.addExport(export);
                    }
                    catch (Exception io) {
                        this.exceptions.add(io);
                    }
                } else {
                    ExportFile exportFile;
                    ArrayList<File> mt94xFiles = new ArrayList<File>();
                    ArrayList<File> cfonb120Files = new ArrayList<File>();
                    ArrayList<File> otherFiles = new ArrayList<File>();
                    Tuple mt94xTuple = new Tuple();
                    Tuple cfonb120Tuple = new Tuple();
                    Tuple otherTuple = new Tuple();
                    boolean append = true;
                    boolean batchedTransactionFiles = false;
                    for (CmStatement stmt : ((Tuple)entry.getValue()).statements) {
                        batchedTransactionFiles = stmt.isDtiFile();
                        if (stmt.isMT94xFormat()) {
                            this.add(mt94xFiles, stmt);
                            mt94xTuple.statements.add(stmt);
                            continue;
                        }
                        if (stmt.isCFONB120Format()) {
                            this.add(cfonb120Files, stmt);
                            cfonb120Tuple.statements.add(stmt);
                            continue;
                        }
                        this.add(otherFiles, stmt);
                        otherTuple.statements.add(stmt);
                    }
                    for (CmPage page : ((Tuple)entry.getValue()).pages) {
                        CmStatement s = page.getStatement();
                        batchedTransactionFiles = s.isDtiFile();
                        if (s.isMT94xFormat()) {
                            mt94xFiles.add(WorkspaceFileSystem.getFile(page.getFile()));
                            mt94xTuple.pages.add(page);
                            continue;
                        }
                        otherFiles.add(WorkspaceFileSystem.getFile(page.getFile()));
                        otherTuple.pages.add(page);
                    }
                    if (!otherFiles.isEmpty()) {
                        zipTargetFile = this.ensureZIPFile(targetFile);
                        try {
                            boolean fileExists = zipTargetFile.exists();
                            StatementExporter.doZipExport(this.enrcypt, zipTargetFile, true, otherFiles, batchedTransactionFiles, this.convertEbcdicToAscii, this.logger);
                            exportFile = AutomaticExporter.fileForPath(zipTargetFile, !fileExists);
                            exportFile.addAccounts(otherTuple.statements, otherTuple.pages);
                            exportFile.addExport(export);
                        }
                        catch (IOException io) {
                            this.exceptions.add(io);
                        }
                    }
                    if (!mt94xFiles.isEmpty()) {
                        try {
                            boolean fileExists = targetFile.exists();
                            StatementExporter.doExport(this.enrcypt, targetFile, true, mt94xFiles, this.logger);
                            exportFile = AutomaticExporter.fileForPath(targetFile, !fileExists);
                            exportFile.addAccounts(mt94xTuple.statements, mt94xTuple.pages);
                            exportFile.addExport(export);
                        }
                        catch (IOException io) {
                            this.exceptions.add(io);
                        }
                    }
                    if (!cfonb120Files.isEmpty()) {
                        try {
                            boolean fileExists = targetFile.exists();
                            StatementExporter.doExport(this.enrcypt, targetFile, true, cfonb120Files, this.logger);
                            exportFile = AutomaticExporter.fileForPath(targetFile, !fileExists);
                            exportFile.addAccounts(cfonb120Tuple.statements, cfonb120Tuple.pages);
                            exportFile.addExport(export);
                        }
                        catch (IOException io) {
                            this.exceptions.add(io);
                        }
                    }
                }
                if (sub == null) continue;
                sub.worked(1);
            }
            if (sub != null) {
                sub.done();
            }
            lastFile = zipTargetFile != null ? zipTargetFile : targetFile;
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
        if (this.exceptions.isEmpty()) {
            this.showMessageDialog(sorted.size(), lastFile);
            return ReturnStatus.OK;
        }
        this.handleErrors();
        return ReturnStatus.OK;
    }

    private boolean shouldAccountBeExported(AutomaticExport export, Account account) {
        boolean anyAccounts;
        boolean anyFolders = export.getFolders() != null && export.getFolders().size() > 0;
        boolean bl = anyAccounts = export.getAccounts() != null && export.getAccounts().size() > 0;
        if (!anyFolders && !anyAccounts) {
            return true;
        }
        if (anyFolders) {
            if (account.getFolder() != null && export.getFolders().contains(account.getFolder())) {
                return true;
            }
            if (anyAccounts) {
                return export.getAccounts().contains(account);
            }
            return false;
        }
        return export.getAccounts().contains(account);
    }

    private static ExportFile fileForPath(File file, boolean deleteOldVO) {
        WorkspaceFile workspaceFile = null;
        ExportFile toReturn = (ExportFile)DB.find(ExportFile.class).where().eq("workspaceFile.path", (Object)file.getAbsolutePath()).setMaxRows(1).findOne();
        if (deleteOldVO && toReturn != null) {
            workspaceFile = toReturn.getWorkspaceFile();
            CmCleanUp.deleteDBOnly(toReturn);
            toReturn = null;
        }
        if (toReturn == null) {
            toReturn = new ExportFile();
            if (workspaceFile != null) {
                toReturn.setWorkspaceFile(workspaceFile);
                toReturn.getWorkspaceFile().setSize(file.length());
                DB.save(toReturn.getWorkspaceFile());
            } else {
                toReturn.setWorkspaceFile(WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.ABSOLUTE_FILE, file, file.length(), null, null));
            }
        } else {
            toReturn.getWorkspaceFile().setSize(file.length());
            DB.save(toReturn.getWorkspaceFile());
        }
        toReturn.setLastUpdate(new Timestamp(System.currentTimeMillis()));
        toReturn.save();
        return toReturn;
    }

    protected abstract void showMessageDialog(int var1, File var2);

    protected abstract void handleErrors();

    protected CmPrinter getPrinter(File dest, boolean printBookings, Boolean printGrandTotalAmount) throws PDFException, IOException {
        boolean withLogo = Util.printLogo(this.store.getUser());
        return new CmPrinter(dest, this.store, printBookings, printGrandTotalAmount, withLogo, this.locale);
    }

    private void add(List<File> files, CmStatement stmt) {
        if (stmt.getFile() == null) {
            for (CmPage page : CmPage.findByStatement(stmt, false)) {
                files.add(WorkspaceFileSystem.getFile(page.getFile()));
            }
        } else {
            files.add(WorkspaceFileSystem.getFile(stmt.getFile()));
        }
    }

    private void doCsvExport(Conversion conversion, File exportFile, List<CmStatement> statements, List<CmPage> pages) throws FileNotFoundException {
        try (Converter c = new Converter(conversion, exportFile, true, this.store, this.locale);){
            if (statements != null) {
                for (CmStatement stmt : statements) {
                    c.convert(stmt);
                }
            }
            if (pages != null) {
                for (CmPage page : pages) {
                    c.convert(page);
                }
            }
        }
    }

    private void doPDFExport(File exportFile, List<CmStatement> statements, List<CmPage> pages) throws PDFException, IOException {
        File existingPdf = null;
        File newPdf = null;
        if (exportFile.exists()) {
            existingPdf = File.createTempFile(exportFile.getName(), null, exportFile.getParentFile());
            existingPdf.delete();
            exportFile.renameTo(existingPdf);
            newPdf = File.createTempFile(exportFile.getName(), null, exportFile.getParentFile());
        }
        CmPrinter printer = this.getPrinter(newPdf == null ? exportFile : newPdf, true, null);
        printer.print(null, null, statements, pages, null, null, null);
        printer.close();
        if (existingPdf != null) {
            PDFCreator.getInstance().concatPDFs(existingPdf, newPdf, exportFile, true);
        }
    }

    private File ensureZIPFile(File in) {
        String name = in.getName();
        if (name.endsWith("ZIP") || name.endsWith("zip")) {
            return in;
        }
        if (name.endsWith("STA") || name.endsWith("sta") || name.endsWith("CSV") || name.endsWith("csv")) {
            return new File(in.getParentFile(), name.substring(0, name.length() - 3) + "zip");
        }
        return new File(in.getParentFile(), name + ".zip");
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    private static class Tuple {
        List<CmStatement> statements = new ArrayList<CmStatement>();
        List<CmPage> pages = new ArrayList<CmPage>();

        private Tuple() {
        }
    }

    public static enum ReturnStatus {
        OK,
        CANCEL;

    }
}

