/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.transfer.api.AlternativePreScheduler;
import de.businesslogics.bcs.core.YYMMDD;
import java.util.HashSet;
import java.util.Set;

public class AdvicePreScheduler
implements AlternativePreScheduler {
    @Override
    public Set<String> getOrderOrFileTypes(Scheduler s) {
        CMBank cmBank = CMBank.get(s.getBank());
        HashSet<String> result = new HashSet<String>();
        if (cmBank.isAdviceFetchActivated()) {
            result.add(cmBank.getAdviceFetchType());
        }
        if (cmBank.isCreditAdviceFetchActivated()) {
            result.add(cmBank.getCreditAdviceFetchType());
        }
        return result;
    }

    @Override
    public YYMMDD getFromDate(Scheduler s) {
        CMBank cmBank = CMBank.get(s.getBank());
        if (CmBank.FetchMode.NEW.equals((Object)cmBank.getVmkFetchMode())) {
            return null;
        }
        if (cmBank.getLastVmkFetchDate() != null) {
            return new YYMMDD(cmBank.getLastVmkFetchDate().getTime());
        }
        return new YYMMDD();
    }

    @Override
    public YYMMDD getToDate(Scheduler s) {
        return null;
    }

    @Override
    public void setLastFetchDate(Scheduler s, YYMMDD date) {
        CMBank cmBank = CMBank.get(s.getBank());
        cmBank.setLastVmkFetchDate(date);
        cmBank.save();
    }

    @Override
    public String getAlternativeOrderFileType(Scheduler scheduler, String orderOrFileType) {
        boolean tryNext;
        CMBank cmBank = CMBank.get(scheduler.getBank());
        if (cmBank.getAdviceFetchType().equals(orderOrFileType) && (tryNext = cmBank.tryNextAdviceFetchParameters())) {
            return cmBank.getAdviceFetchType();
        }
        return null;
    }

    @Override
    public void saveNewOrderOrFileType(Scheduler scheduler, String oldOrderOrFileType, String newOrderOrFileType) {
        CMBank cmBank = CMBank.get(scheduler.getBank());
        cmBank.tryNextAdviceFetchParameters();
        cmBank.save();
    }
}

