/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.io.CountingFilterInputStream;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.util.HexTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;

public class StreamHandler {
    private DigestOutputStream digestOutputStream;
    private DigestInputStream digestInputStream;
    private CountingFilterOutputStream countingOutputStream;
    private CountingFilterInputStream countingInputStream;
    private String md5Hash;

    public InputStream createExistingFileInputStream(File in, EncryptData encrypt) throws IOException {
        this.md5Hash = null;
        InputStream inStream = encrypt.openInputStream(in);
        this.digestInputStream = new DigestInputStream(inStream, this.getMD5MessageDigest());
        this.countingInputStream = new CountingFilterInputStream(this.digestInputStream);
        return this.countingInputStream;
    }

    public OutputStream createTempFileOutputStream(File tempFile, EncryptData encrypt) throws IOException {
        this.md5Hash = null;
        OutputStream out = encrypt.openOutputStream(tempFile);
        this.digestOutputStream = new DigestOutputStream(out, this.getMD5MessageDigest());
        this.countingOutputStream = new CountingFilterOutputStream(this.digestOutputStream);
        return this.countingOutputStream;
    }

    private MessageDigest getMD5MessageDigest() throws IOException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (GeneralSecurityException ge) {
            throw new IOException(ge);
        }
    }

    public long getFileSize() {
        if (this.countingOutputStream != null) {
            return this.countingOutputStream.getWritten();
        }
        if (this.countingInputStream != null) {
            return this.countingInputStream.getCountRead();
        }
        return 0L;
    }

    public String getMD5Hash() {
        if (this.md5Hash == null) {
            if (this.digestOutputStream != null) {
                this.md5Hash = HexTool.toHex(this.digestOutputStream.getMessageDigest().digest());
            } else if (this.digestInputStream != null) {
                this.md5Hash = HexTool.toHex(this.digestInputStream.getMessageDigest().digest());
            }
        }
        return this.md5Hash;
    }
}

