/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.PaymentExchangeRate;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class PrintBaseAction {
    public static final Color GREY = new Color(200, 200, 200);
    public static final BLFont F = BLFont.FONT_NORMAL;
    public static final BLFont BF = BLFont.FONT_BOLD;
    public static final String SPACES = "   ";
    public static final String NBSP = "\u00a0";
    public static final String NEWLINE = "\n";
    public static final String SLASH = "/";
    public static final char UNDERSCORE = '_';
    private static final Currency EUR = Currency.getInstance("EUR");
    private static final String BY_ACCOUNTS = "BY_ACCOUNTS";
    private static final String BY_BANKS = "BY_BANKS";
    private static final String BY_CURRENCIES = "BY_CURRENCIES";

    public static void addCell(BLTable<?> t, String text, BLFont f) throws PDFException {
        PrintBaseAction.addCell(t, text, f, 0, null, null);
    }

    public static void addCell(BLTable<?> t, String text, BLFont f, Color color) throws PDFException {
        PrintBaseAction.addCell(t, text, f, 0, color, null);
    }

    public static void addCell(BLTable<?> t, String text, BLFont f, int colspan) throws PDFException {
        PrintBaseAction.addCell(t, text, f, colspan, null, null);
    }

    public static void addCell(BLTable<?> t, String text, BLFont f, int colspan, Color color) throws PDFException {
        PrintBaseAction.addCell(t, text, f, colspan, color, null);
    }

    public static void addCell(BLTable<?> t, String text, BLFont f, int colspan, Alignment horizontalAlignment) throws PDFException {
        PrintBaseAction.addCell(t, text, f, colspan, null, horizontalAlignment);
    }

    private static void addCell(BLTable<?> t, String text, BLFont f, int colspan, Color color, Alignment horizontalAlignment) throws PDFException {
        t.addCell(text, f, colspan, horizontalAlignment, null, color, BLBorder.NO_BORDER);
    }

    public static void addSumCell(BLTable<?> t, BigDecimal amount, Currency currency, Locale locale) throws PDFException {
        PrintBaseAction.addCell(t, PaymentUtils.formatAmount(amount, currency, locale), BF, 1, Alignment.ALIGN_RIGHT);
    }

    public static void addBookingTable(BLDocument document, List<CmBooking> bookingsToPrint, Locale locale, DatabasePreferenceStore store) throws PDFException {
        document.addHeadline(Messages.getString(locale, "BookingOverviewPrintAction.title", new Object[0]), BF, null, 6.0f);
        int countColumns = 6;
        Map<Currency, BigDecimal> currencyAmountMap = PrintBaseAction.createCurrencyAmountMap();
        boolean groupByAccounts = BY_ACCOUNTS.equals(store.getString(CmPreferenceConstants.PRINT_BOOKING_OVERVIEW_GROUPING));
        if (groupByAccounts) {
            Map<Account, List<CmBooking>> accountBookingsMap = PrintBaseAction.createAccountBookingsMap();
            for (CmBooking booking : bookingsToPrint) {
                Account account = booking.getAccount();
                if (accountBookingsMap.containsKey(account)) {
                    accountBookingsMap.get(account).add(booking);
                } else {
                    ArrayList<CmBooking> bookings = new ArrayList<CmBooking>();
                    bookings.add(booking);
                    accountBookingsMap.put(account, bookings);
                }
                PrintBaseAction.addToCurrencyAmountMap(currencyAmountMap, booking);
            }
            BLTable<?> table = null;
            int countAccounts = accountBookingsMap.size();
            for (Account account : accountBookingsMap.keySet()) {
                PaymentExchangeRate rate;
                PrintBaseAction.printAccountInfo(document, account, locale, countColumns);
                table = PDFCreator.getInstance().createTable(countColumns);
                table.setBorder(BLBorder.NO_BORDER);
                table.setWidth(100.0f);
                table.setWidths(new int[]{10, 10, 20, 23, 17, 17});
                PrintBaseAction.printHeaderCellsForBookingTable(table, groupByAccounts, locale);
                BigDecimal sumAccount = BigDecimal.ZERO;
                for (CmBooking booking : accountBookingsMap.get(account)) {
                    PrintBaseAction.printBookingData(table, booking, groupByAccounts, locale);
                    sumAccount = sumAccount.add(booking.getAmount());
                }
                document.addTable(table);
                Currency currency = Currency.getInstance(account.getCurrency());
                String currencyCode = currency.getCurrencyCode();
                String labelText = BankingApiMessages.getString(locale, "GeneralMessages.sum", new Object[0]) + " (" + currencyCode + ")";
                PrintBaseAction.printSumLine(table, groupByAccounts, locale, labelText, sumAccount, currency);
                if (!currency.equals(EUR) && (rate = PaymentExchangeRate.findExchangeRate(currency.getCurrencyCode())).getExchangeRate() != null) {
                    PrintBaseAction.printSumLine(table, groupByAccounts, locale, Messages.getString(locale, "PrintOverviewAction.sumEur", new Object[0]), rate.convertToEURO(sumAccount), EUR);
                    if (countAccounts == 1) {
                        PrintBaseAction.addCell(table, MessageFormat.format(Messages.getString(locale, "PrintOverviewAction.convert.hint", new Object[0]), PaymentExchangeRate.getLatestExchangeRateDate()), F, countColumns);
                    }
                }
                PrintBaseAction.addCell(table, NBSP, F, countColumns);
            }
            if (countAccounts > 1) {
                PrintBaseAction.addCell(table, Messages.getString(locale, "PrintOverviewAction.sumOverAllAccounts", new Object[0]), BF, countColumns);
                BigDecimal totalSum = BigDecimal.ZERO;
                boolean printTotalSumBlock = false;
                int countCurrencies = currencyAmountMap.size();
                for (Currency currency : currencyAmountMap.keySet()) {
                    PaymentExchangeRate rate;
                    BigDecimal amount = currencyAmountMap.get(currency);
                    String currencyCode = currency.getCurrencyCode();
                    String labelText = BankingApiMessages.getString(locale, "GeneralMessages.sum", new Object[0]) + " (" + currencyCode + ")";
                    PrintBaseAction.printSumLine(table, groupByAccounts, locale, labelText, amount, currency);
                    if (countCurrencies <= 1 && EUR.equals(currency)) continue;
                    printTotalSumBlock = true;
                    if (currency.equals(EUR)) {
                        rate = new PaymentExchangeRate();
                        rate.setExchangeRate(BigDecimal.ONE);
                    } else {
                        rate = PaymentExchangeRate.findExchangeRate(currencyCode);
                    }
                    if (rate.getExchangeRate() == null) {
                        totalSum = null;
                    }
                    if (totalSum == null || rate.getExchangeRate() == null) continue;
                    totalSum = totalSum.add(rate.convertToEURO(amount));
                }
                if (printTotalSumBlock && totalSum != null) {
                    String labelText = countCurrencies > 1 ? Messages.getString(locale, "PrintOverviewAction.convert.sum", new Object[0]) : Messages.getString(locale, "PrintOverviewAction.sumEur", new Object[0]);
                    PrintBaseAction.printSumLine(table, groupByAccounts, locale, labelText, totalSum, EUR);
                    PrintBaseAction.addCell(table, MessageFormat.format(Messages.getString(locale, "PrintOverviewAction.convert.hint", new Object[0]), PaymentExchangeRate.getLatestExchangeRateDate()), F, countColumns);
                }
            }
        } else {
            BLTable<?> t = PDFCreator.getInstance().createTable(countColumns);
            t.setBorder(BLBorder.NO_BORDER);
            t.setWidth(100.0f);
            t.setWidths(new int[]{20, 10, 10, 20, 23, 17});
            PrintBaseAction.printHeaderCellsForBookingTable(t, groupByAccounts, locale);
            for (CmBooking booking : bookingsToPrint) {
                PrintBaseAction.printBookingData(t, booking, groupByAccounts, locale);
                PrintBaseAction.addToCurrencyAmountMap(currencyAmountMap, booking);
            }
            BigDecimal totalSum = BigDecimal.ZERO;
            boolean printTotalSumBlock = false;
            for (Currency currency : currencyAmountMap.keySet()) {
                Object labelText;
                BigDecimal amount = currencyAmountMap.get(currency);
                if (currencyAmountMap.size() == 1 && EUR.equals(currency)) {
                    labelText = BankingApiMessages.getString(locale, "GeneralMessages.sum", new Object[0]);
                } else {
                    PaymentExchangeRate rate;
                    String currencyCode = currency.getCurrencyCode();
                    labelText = BankingApiMessages.getString(locale, "GeneralMessages.sum", new Object[0]) + " (" + currencyCode + ")";
                    printTotalSumBlock = true;
                    if (currency.equals(EUR)) {
                        rate = new PaymentExchangeRate();
                        rate.setExchangeRate(BigDecimal.ONE);
                    } else {
                        rate = PaymentExchangeRate.findExchangeRate(currencyCode);
                    }
                    if (rate.getExchangeRate() == null) {
                        totalSum = null;
                    }
                    if (totalSum != null && rate.getExchangeRate() != null) {
                        totalSum = totalSum.add(rate.convertToEURO(amount));
                    }
                }
                PrintBaseAction.printSumLine(t, groupByAccounts, locale, (String)labelText, amount, currency);
            }
            if (printTotalSumBlock && totalSum != null) {
                PrintBaseAction.printSumLine(t, groupByAccounts, locale, Messages.getString(locale, "PrintOverviewAction.sumEur", new Object[0]), totalSum, EUR);
                PrintBaseAction.addCell(t, MessageFormat.format(Messages.getString(locale, "PrintOverviewAction.convert.hint", new Object[0]), PaymentExchangeRate.getLatestExchangeRateDate()), F, countColumns);
            }
            document.addTable(t);
        }
    }

    private static void printAccountInfo(BLDocument document, Account account, Locale locale, int countColumns) throws PDFException {
        StringBuilder sb = new StringBuilder(GeneralMessages.getInstance((Locale)locale).ACCOUNT);
        sb.append(": ");
        sb.append(account.getName());
        sb.append(" (");
        sb.append(account.getBank().getDisplayName());
        sb.append(")");
        document.addHeadline(sb.toString(), BLFont.FONT_BOLD, null, countColumns);
    }

    private static void printSumLine(BLTable<?> t, boolean groupByAccounts, Locale locale, String labelText, BigDecimal sum, Currency currency) throws PDFException {
        if (groupByAccounts) {
            PrintBaseAction.addCell(t, labelText, BF, 4);
            PrintBaseAction.addCell(t, PaymentUtils.formatAmount(sum, currency, locale), BF, 1, Alignment.ALIGN_RIGHT);
            PrintBaseAction.addCell(t, NBSP, BF, 1);
        } else {
            PrintBaseAction.addCell(t, labelText, BF, 5);
            PrintBaseAction.addCell(t, PaymentUtils.formatAmount(sum, currency, locale), BF, 1, Alignment.ALIGN_RIGHT);
        }
    }

    private static void addToCurrencyAmountMap(Map<Currency, BigDecimal> currencyAmountMap, CmBooking booking) {
        Currency currency = booking.getCurrency();
        BigDecimal amount = booking.getAmount();
        if (currencyAmountMap.containsKey(currency)) {
            BigDecimal oldAmount = currencyAmountMap.get(currency);
            currencyAmountMap.put(currency, oldAmount.add(amount));
        } else {
            currencyAmountMap.put(currency, amount);
        }
    }

    private static void printHeaderCellsForBookingTable(BLTable<?> t, boolean groupByAccounts, Locale locale) throws PDFException {
        if (!groupByAccounts) {
            PrintBaseAction.addCell(t, GeneralMessages.getInstance((Locale)locale).ACCOUNT, BF);
        }
        PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.booking", new Object[0]), BF);
        PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.value", new Object[0]), BF);
        PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.counterParty", new Object[0]), BF);
        PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), BF);
        PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
        if (groupByAccounts) {
            PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.currentBalance", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
        }
    }

    private static void printBookingData(BLTable<?> t, CmBooking booking, boolean groupByAccounts, Locale locale) throws PDFException {
        if (!groupByAccounts) {
            PrintBaseAction.addCell(t, booking.getAccount().getName(), F);
        }
        if (booking.getBookingDate() != null) {
            PrintBaseAction.addCell(t, DateFormat.getDateInstance(2, locale).format(booking.getBookingDate()), F);
        } else {
            PrintBaseAction.addCell(t, "", F);
        }
        if (booking.getValueDate() != null) {
            PrintBaseAction.addCell(t, DateFormat.getDateInstance(2, locale).format(booking.getValueDate()), F);
        } else {
            PrintBaseAction.addCell(t, "", F);
        }
        PrintBaseAction.addCell(t, booking.getCounterOrLocalParty(), F);
        PrintBaseAction.addCell(t, booking.getPurposeOverview(), F);
        PrintBaseAction.addCell(t, PaymentUtils.formatAmount(booking.getAmount(), booking.getCurrency(), locale), F, 1, Alignment.ALIGN_RIGHT);
        if (groupByAccounts) {
            PrintBaseAction.addCell(t, PaymentUtils.formatAmount(booking.getBalance(), booking.getCurrency(), locale), F, 1, Alignment.ALIGN_RIGHT);
        }
    }

    private static Map<Account, List<CmBooking>> createAccountBookingsMap() {
        return new TreeMap<Account, List<CmBooking>>(new Comparator<Account>(){

            @Override
            public int compare(Account o1, Account o2) {
                if (o1 == null || o1.getName() == null) {
                    return o2 == null || o2.getName() == null ? 0 : 1;
                }
                if (o2 == null || o2.getName() == null) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private static Map<Currency, BigDecimal> createCurrencyAmountMap() {
        return new TreeMap<Currency, BigDecimal>(new Comparator<Currency>(){

            @Override
            public int compare(Currency o1, Currency o2) {
                if (o1 == null || o1.getCurrencyCode() == null) {
                    return o2 == null || o2.getCurrencyCode() == null ? 0 : 1;
                }
                if (o2 == null || o2.getCurrencyCode() == null) {
                    return -1;
                }
                return o1.getCurrencyCode().compareTo(o2.getCurrencyCode());
            }
        });
    }

    public static void addAccountTable(BLDocument document, List<CMAccount> accountsToPrint, String accountGroupName, Locale locale, DatabasePreferenceStore store) throws PDFException {
        boolean balancesWithAdvices = store.getBoolean(CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO);
        String grouping = store.getString(CmPreferenceConstants.PRINT_ACCOUNT_OVERVIEW_GROUPING);
        boolean printTitle = store.getBoolean(CmPreferenceConstants.PRINT_OVERVIEW_TITLE);
        Map<BankSettings, List<AccountData>> bankAccountsMap = null;
        HashMap<BankSettings, Map<Currency, AmountCollector>> bankCollectorsMap = null;
        Map<Currency, List<AccountData>> currencyAccountsMap = null;
        HashMap<Currency, Map<Currency, AmountCollector>> currencyCollectorsMap = null;
        ArrayList<AccountData> accounts = null;
        Map<Currency, AmountCollector> collectors = PrintBaseAction.createAmountCollectorMap();
        if (BY_BANKS.equals(grouping)) {
            bankAccountsMap = PrintBaseAction.createBankAccountsMap();
            bankCollectorsMap = new HashMap<BankSettings, Map<Currency, AmountCollector>>();
        } else if (BY_CURRENCIES.equals(grouping)) {
            currencyAccountsMap = PrintBaseAction.createCurrencyAccountsMap();
            currencyCollectorsMap = new HashMap<Currency, Map<Currency, AmountCollector>>();
        } else {
            accounts = new ArrayList<AccountData>();
        }
        if (printTitle) {
            String date = DateFormat.getDateInstance(2, locale).format(new java.util.Date());
            String titleString = accountGroupName != null ? Messages.getString(locale, "PrintOverviewAction.titleWithGroupName", date, accountGroupName) : Messages.getString(locale, "PrintOverviewAction.title", date);
            document.addHeadline(titleString, BLFont.FONT_LARGE_BOLD, null, 6.0f);
        }
        BLTable<?> table = PDFCreator.getInstance().createTable(6);
        table.setBorder(BLBorder.NO_BORDER);
        table.setWidth(100.0f);
        PrintMode printMode = PrintBaseAction.getPrintMode(store);
        if (PrintMode.STANDARD_NAME.equals((Object)printMode)) {
            table.setWidths(new int[]{22, 20, 10, 16, 16, 16});
        } else {
            table.setWidths(new int[]{22, 10, 17, 17, 17, 17});
        }
        PrintBaseAction.printHeaderCells(printMode, table, locale);
        for (CMAccount account : accountsToPrint) {
            BankSettings bank = account.getAccount().getBank();
            CmStatement newestStatement = account.getNewestStatement();
            if (newestStatement != null && newestStatement.getClosingDate() != null) {
                Currency currency = newestStatement.getCurrency();
                BigDecimal balance = EclipseFreeHelper.getBalance(account.getAccount(), newestStatement);
                BigDecimal bigDecimal = EclipseFreeHelper.getBalance(account.getVbToday(), balancesWithAdvices);
                BigDecimal tomorrow = EclipseFreeHelper.getBalance(account.getVbTomorrow(), balancesWithAdvices);
                BigDecimal afterTomorrow = EclipseFreeHelper.getBalance(account.getVbAfterTomorrow(), balancesWithAdvices);
                BigDecimal openingBalance = newestStatement.getOpeningBalance();
                BigDecimal sumDebit = newestStatement.getSumDebit();
                BigDecimal sumCredit = newestStatement.getSumCredit();
                BigDecimal creditLimit = account.getAccount().getCreditLimit();
                BigDecimal freeLiquidity = account.getFreeLiquidity();
                PrintBaseAction.addAmounts(currency, balance, bigDecimal, tomorrow, afterTomorrow, openingBalance, sumDebit, sumCredit, creditLimit, freeLiquidity, collectors, bank, bankCollectorsMap, currencyCollectorsMap);
                PrintBaseAction.addAccountData(new AccountData(account.getDisplayName(), newestStatement.getClosingDate(), currency, balance, bigDecimal, tomorrow, afterTomorrow, openingBalance, sumDebit, sumCredit, creditLimit, freeLiquidity, Account.getCmDisplayName(account.getAccount()), locale), accounts, bank, bankAccountsMap, currency, currencyAccountsMap);
                continue;
            }
            Currency accountCurrency = null;
            if (currencyAccountsMap != null && account.getAccount().getCurrency() != null) {
                try {
                    accountCurrency = Currency.getInstance(account.getAccount().getCurrency());
                }
                catch (Exception balance) {
                    // empty catch block
                }
            }
            PrintBaseAction.addAccountData(new AccountData(account.getDisplayName(), Account.getCmDisplayName(account.getAccount())), accounts, bank, bankAccountsMap, accountCurrency, currencyAccountsMap);
        }
        if (accounts != null) {
            for (AccountData accountData : accounts) {
                PrintBaseAction.printAccountData(printMode, table, accountData);
            }
            if (!collectors.isEmpty() && accountsToPrint.size() > 1) {
                PrintBaseAction.printSumBlock(printMode, table, locale, collectors, true, grouping, true);
            }
        } else if (bankAccountsMap != null) {
            boolean printTotalSumBlock = !collectors.isEmpty() && bankCollectorsMap.size() > 1;
            boolean isFirstBank = true;
            for (BankSettings bank : bankAccountsMap.keySet()) {
                if (isFirstBank) {
                    isFirstBank = false;
                } else {
                    PrintBaseAction.addCell(table, NBSP, F, 6);
                }
                PrintBaseAction.addCell(table, bank.getDisplayName(), BF, 1);
                PrintBaseAction.addCell(table, NBSP, F, 5);
                List<AccountData> bankAccounts = bankAccountsMap.get(bank);
                for (AccountData accountData : bankAccounts) {
                    PrintBaseAction.printAccountData(printMode, table, accountData);
                }
                Map bankCollectors = (Map)bankCollectorsMap.get(bank);
                if (bankCollectors.isEmpty() || bankAccounts.size() < 1) continue;
                PrintBaseAction.printSumBlock(printMode, table, locale, bankCollectors, false, grouping, !printTotalSumBlock);
            }
            if (printTotalSumBlock) {
                PrintBaseAction.printSumBlock(printMode, table, locale, collectors, true, grouping, printTotalSumBlock);
            }
        } else if (currencyAccountsMap != null) {
            boolean printTotalSumBlock = !collectors.isEmpty() && currencyCollectorsMap.size() > 1;
            boolean isFirstCurrency = true;
            for (Currency currency : currencyAccountsMap.keySet()) {
                if (isFirstCurrency) {
                    isFirstCurrency = false;
                } else {
                    PrintBaseAction.addCell(table, NBSP, F, 6);
                }
                String text = MessageFormat.format(Messages.getString(locale, "PrintOverviewAction.currencyAccounts", new Object[0]), currency.getCurrencyCode());
                PrintBaseAction.addCell(table, text, BF, 1);
                PrintBaseAction.addCell(table, NBSP, F, 5);
                List<AccountData> currencyAccounts = currencyAccountsMap.get(currency);
                for (AccountData accountData : currencyAccounts) {
                    PrintBaseAction.printAccountData(printMode, table, accountData);
                }
                Map map = (Map)currencyCollectorsMap.get(currency);
                if (map == null || map.isEmpty() || currencyAccounts.size() < 1) continue;
                PrintBaseAction.printSumBlock(printMode, table, locale, map, false, grouping, !printTotalSumBlock);
            }
            if (printTotalSumBlock) {
                PrintBaseAction.printSumBlock(printMode, table, locale, collectors, true, grouping, true);
            }
        }
        document.addTable(table);
    }

    private static Map<BankSettings, List<AccountData>> createBankAccountsMap() {
        return new TreeMap<BankSettings, List<AccountData>>(new Comparator<BankSettings>(){

            @Override
            public int compare(BankSettings o1, BankSettings o2) {
                if (o1 == null || o1.getDisplayName() == null) {
                    return o2 == null || o2.getDisplayName() == null ? 0 : 1;
                }
                if (o2 == null || o2.getDisplayName() == null) {
                    return -1;
                }
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
    }

    private static Map<Currency, List<AccountData>> createCurrencyAccountsMap() {
        return new TreeMap<Currency, List<AccountData>>(new Comparator<Currency>(){

            @Override
            public int compare(Currency o1, Currency o2) {
                if (o1 == null || o1.getCurrencyCode() == null) {
                    return o2 == null || o2.getCurrencyCode() == null ? 0 : 1;
                }
                if (o2 == null || o2.getCurrencyCode() == null) {
                    return -1;
                }
                return o1.getCurrencyCode().compareTo(o2.getCurrencyCode());
            }
        });
    }

    private static Map<Currency, AmountCollector> createAmountCollectorMap() {
        return new TreeMap<Currency, AmountCollector>(new Comparator<Currency>(){

            @Override
            public int compare(Currency o1, Currency o2) {
                if (o1 == null || o1.getCurrencyCode() == null) {
                    return o2 == null || o2.getCurrencyCode() == null ? 0 : 1;
                }
                if (o2 == null || o2.getCurrencyCode() == null) {
                    return -1;
                }
                return o1.getCurrencyCode().compareTo(o2.getCurrencyCode());
            }
        });
    }

    private static void addAccountData(AccountData accountData, List<AccountData> accounts, BankSettings bank, Map<BankSettings, List<AccountData>> bankAccountsMap, Currency currency, Map<Currency, List<AccountData>> currencyAccountsMap) {
        if (accounts != null) {
            accounts.add(accountData);
        } else if (bankAccountsMap != null) {
            List<AccountData> bankAccounts = bankAccountsMap.get(bank);
            if (bankAccounts == null) {
                bankAccounts = new ArrayList<AccountData>();
                bankAccountsMap.put(bank, bankAccounts);
            }
            bankAccounts.add(accountData);
        } else if (currency != null && currencyAccountsMap != null) {
            List<AccountData> currencyAccounts = currencyAccountsMap.get(currency);
            if (currencyAccounts == null) {
                currencyAccounts = new ArrayList<AccountData>();
                currencyAccountsMap.put(currency, currencyAccounts);
            }
            currencyAccounts.add(accountData);
        }
    }

    private static void addAmounts(Currency currency, BigDecimal balance, BigDecimal today, BigDecimal tomorrow, BigDecimal afterTomorrow, BigDecimal openingBalance, BigDecimal sumDebit, BigDecimal sumCredit, BigDecimal creditLimit, BigDecimal freeLiquidity, Map<Currency, AmountCollector> collectors, BankSettings bank, Map<BankSettings, Map<Currency, AmountCollector>> bankCollectorsMap, Map<Currency, Map<Currency, AmountCollector>> currencyCollectorsMap) {
        AmountCollector totalAmountCollector = collectors.get(currency);
        if (totalAmountCollector == null) {
            totalAmountCollector = new AmountCollector();
            collectors.put(currency, totalAmountCollector);
        }
        totalAmountCollector.addBalance(balance);
        totalAmountCollector.addValueBalanceToday(today);
        totalAmountCollector.addValueBalanceTomorrow(tomorrow);
        totalAmountCollector.addValueBalanceAfterTomorrow(afterTomorrow);
        totalAmountCollector.addOpeningBalance(openingBalance);
        totalAmountCollector.addSumDebit(sumDebit);
        totalAmountCollector.addSumCredit(sumCredit);
        totalAmountCollector.addCreditLimit(creditLimit);
        totalAmountCollector.addFreeLiquidity(freeLiquidity);
        AmountCollector amountCollector = null;
        if (bankCollectorsMap != null) {
            Map<Currency, AmountCollector> bankCollectors = bankCollectorsMap.get(bank);
            if (bankCollectors == null) {
                bankCollectors = PrintBaseAction.createAmountCollectorMap();
                amountCollector = new AmountCollector();
                bankCollectors.put(currency, amountCollector);
                bankCollectorsMap.put(bank, bankCollectors);
            } else {
                amountCollector = bankCollectors.get(currency);
                if (amountCollector == null) {
                    amountCollector = new AmountCollector();
                    bankCollectors.put(currency, amountCollector);
                }
            }
        } else if (currencyCollectorsMap != null) {
            Map<Currency, AmountCollector> currencyCollectors = currencyCollectorsMap.get(currency);
            if (currencyCollectors == null) {
                currencyCollectors = PrintBaseAction.createAmountCollectorMap();
                amountCollector = new AmountCollector();
                currencyCollectors.put(currency, amountCollector);
                currencyCollectorsMap.put(currency, currencyCollectors);
            } else {
                amountCollector = currencyCollectors.get(currency);
                if (amountCollector == null) {
                    amountCollector = new AmountCollector();
                    currencyCollectors.put(currency, amountCollector);
                }
            }
        }
        if (amountCollector != null) {
            amountCollector.addBalance(balance);
            amountCollector.addValueBalanceToday(today);
            amountCollector.addValueBalanceTomorrow(tomorrow);
            amountCollector.addValueBalanceAfterTomorrow(afterTomorrow);
        }
    }

    private static final PrintMode getPrintMode(DatabasePreferenceStore store) {
        if (store.getBoolean(CmPreferenceConstants.DISPLAY_COLUMNS_WITH_CREDIT_DEBIT_SUMS)) {
            return PrintMode.CREDIT_DEBIT_SUMS;
        }
        if (store.getBoolean(CmPreferenceConstants.DISPLAY_COLUMNS_WITH_CREDIT_LIMIT)) {
            return PrintMode.CREDIT_LIMIT;
        }
        if (store.getBoolean(CmPreferenceConstants.DISPLAY_COLUMN_STANDARD_ACCOUNT_NAME)) {
            return PrintMode.STANDARD_NAME;
        }
        return PrintMode.VALUE_BALANCES;
    }

    private static void printHeaderCells(PrintMode printMode, BLTable<?> t, Locale locale) throws PDFException {
        PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.account", new Object[0]), BF);
        if (PrintMode.STANDARD_NAME.equals((Object)printMode)) {
            PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.standardName", new Object[0]), BF);
            PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.statementDate", new Object[0]), BF);
            PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.bookingBalance", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
            PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.valueBalance.today", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
            PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.valueBalance.tomorrow", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
        } else {
            PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.statementDate", new Object[0]), BF);
            if (PrintMode.CREDIT_DEBIT_SUMS.equals((Object)printMode)) {
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.openingBalance", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.sumDebits", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.sumCredits", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.bookingBalance", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
            } else if (PrintMode.CREDIT_LIMIT.equals((Object)printMode)) {
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.bookingBalance", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.creditLimit", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.freeLiquidity", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.valueBalance.today", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
            } else {
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.bookingBalance", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.valueBalance.today", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.valueBalance.tomorrow", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
                PrintBaseAction.addCell(t, BankingApiMessages.getString(locale, "GeneralMessages.valueBalance.dayAfterTomorrow", new Object[0]), BF, 1, Alignment.ALIGN_RIGHT);
            }
        }
        t.setHeaderRows(1);
    }

    private static void printAccountData(PrintMode printMode, BLTable<?> table, AccountData accountData) throws PDFException {
        PrintBaseAction.addCell(table, accountData.displayName, F);
        if (PrintMode.STANDARD_NAME.equals((Object)printMode)) {
            PrintBaseAction.addCell(table, accountData.standardAccountName, F);
            if (accountData.closingDate != null) {
                PrintBaseAction.addCell(table, accountData.closingDate, F);
                if (accountData.balance != null) {
                    PrintBaseAction.addCell(table, accountData.balance, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.today, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.tomorrow, F, 1, Alignment.ALIGN_RIGHT);
                } else {
                    PrintBaseAction.addCell(table, NBSP, F, 3);
                }
            } else {
                PrintBaseAction.addCell(table, NBSP, F, 4);
            }
        } else if (accountData.closingDate != null) {
            PrintBaseAction.addCell(table, accountData.closingDate, F);
            if (accountData.balance != null) {
                if (PrintMode.CREDIT_DEBIT_SUMS.equals((Object)printMode)) {
                    PrintBaseAction.addCell(table, accountData.openingBalance, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.sumDebit, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.sumCredit, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.balance, F, 1, Alignment.ALIGN_RIGHT);
                } else if (PrintMode.CREDIT_LIMIT.equals((Object)printMode)) {
                    PrintBaseAction.addCell(table, accountData.balance, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.creditLimit, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.freeLiquidity, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.today, F, 1, Alignment.ALIGN_RIGHT);
                } else {
                    PrintBaseAction.addCell(table, accountData.balance, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.today, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.tomorrow, F, 1, Alignment.ALIGN_RIGHT);
                    PrintBaseAction.addCell(table, accountData.afterTomorrow, F, 1, Alignment.ALIGN_RIGHT);
                }
            } else {
                PrintBaseAction.addCell(table, NBSP, F, 4);
            }
        } else {
            PrintBaseAction.addCell(table, NBSP, F, 5);
        }
    }

    private static void printSumBlock(PrintMode printMode, BLTable<?> t, Locale locale, Map<Currency, AmountCollector> collectors, boolean isFinalBlock, String grouping, boolean printConversionHint) throws PDFException {
        boolean groupByBanks;
        int countCurrencies = collectors.keySet().size();
        if (isFinalBlock) {
            PrintBaseAction.addCell(t, NBSP, F, 6);
        }
        AmountCollector totalConverted = null;
        if (countCurrencies > 1) {
            totalConverted = new AmountCollector();
        }
        if ((groupByBanks = BY_BANKS.equals(grouping)) && isFinalBlock) {
            PrintBaseAction.addCell(t, Messages.getString(locale, "PrintOverviewAction.sumsOverAllBanks", new Object[0]), BF);
            PrintBaseAction.addCell(t, NBSP, F, 5);
        }
        boolean printLine = true;
        boolean groupByCurrencies = BY_CURRENCIES.equals(grouping);
        if (groupByCurrencies && isFinalBlock) {
            printLine = false;
        }
        boolean useGrouping = groupByBanks || groupByCurrencies;
        for (Currency curr : collectors.keySet()) {
            PaymentExchangeRate rate;
            AmountCollector amountCollector = collectors.get(curr);
            if (countCurrencies == 1 && !EUR.equals(curr) && useGrouping) {
                totalConverted = new AmountCollector();
            }
            if (printLine) {
                String txt = countCurrencies > 1 ? " (" + curr.getCurrencyCode() + ")" : "";
                String text = BankingApiMessages.getString(locale, "GeneralMessages.sum", new Object[0]) + txt;
                PrintBaseAction.printSumLine(printMode, t, locale, amountCollector, text, curr, null);
            }
            if (curr.equals(EUR)) {
                rate = new PaymentExchangeRate();
                rate.setExchangeRate(BigDecimal.ONE);
            } else {
                rate = PaymentExchangeRate.findExchangeRate(curr.getCurrencyCode());
            }
            if (rate.getExchangeRate() == null) {
                totalConverted = null;
            }
            if (totalConverted == null || rate.getExchangeRate() == null) continue;
            totalConverted.addBalance(rate.convertToEURO(amountCollector.getBalance()));
            totalConverted.addValueBalanceToday(rate.convertToEURO(amountCollector.getValueBalanceToday()));
            totalConverted.addValueBalanceTomorrow(rate.convertToEURO(amountCollector.getValueBalanceTomorrow()));
            totalConverted.addValueBalanceAfterTomorrow(rate.convertToEURO(amountCollector.getValueBalanceAfterTomorrow()));
            totalConverted.addOpeningBalance(rate.convertToEURO(amountCollector.getOpeningBalance()));
            totalConverted.addSumDebit(rate.convertToEURO(amountCollector.getSumDebit()));
            totalConverted.addSumCredit(rate.convertToEURO(amountCollector.getSumCredit()));
            totalConverted.addCreditLimit(rate.convertToEURO(amountCollector.getCreditLimit()));
            totalConverted.addFreeLiquidity(rate.convertToEURO(amountCollector.getFreeLiquidity()));
        }
        if (totalConverted != null) {
            String text = !isFinalBlock && (groupByCurrencies || groupByBanks && countCurrencies == 1) ? Messages.getString(locale, "PrintOverviewAction.sumEur", new Object[0]) : Messages.getString(locale, "PrintOverviewAction.convert.sum", new Object[0]);
            String conversionHint = printConversionHint ? Messages.getString(locale, "PrintOverviewAction.convert.hint", new Object[0]) : null;
            PrintBaseAction.printSumLine(printMode, t, locale, totalConverted, text, EUR, conversionHint);
        }
    }

    private static void printSumLine(PrintMode printMode, BLTable<?> t, Locale locale, AmountCollector amountCollector, String text, Currency currency, String conversionHint) throws PDFException {
        if (conversionHint != null) {
            PrintBaseAction.addCell(t, text, BF, 2);
        } else {
            PrintBaseAction.addCell(t, text, BF, 1);
            PrintBaseAction.addCell(t, NBSP, F, 1);
        }
        if (PrintMode.CREDIT_DEBIT_SUMS.equals((Object)printMode)) {
            PrintBaseAction.addSumCell(t, amountCollector.getOpeningBalance(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getSumDebit(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getSumCredit(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getBalance(), currency, locale);
        } else if (PrintMode.CREDIT_LIMIT.equals((Object)printMode)) {
            PrintBaseAction.addSumCell(t, amountCollector.getBalance(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getCreditLimit(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getFreeLiquidity(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getValueBalanceToday(), currency, locale);
        } else if (PrintMode.STANDARD_NAME.equals((Object)printMode)) {
            PrintBaseAction.addCell(t, NBSP, F, 1);
            PrintBaseAction.addSumCell(t, amountCollector.getBalance(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getValueBalanceToday(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getValueBalanceTomorrow(), currency, locale);
        } else {
            PrintBaseAction.addSumCell(t, amountCollector.getBalance(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getValueBalanceToday(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getValueBalanceTomorrow(), currency, locale);
            PrintBaseAction.addSumCell(t, amountCollector.getValueBalanceAfterTomorrow(), currency, locale);
        }
        if (conversionHint != null) {
            PrintBaseAction.addCell(t, MessageFormat.format(conversionHint, PaymentExchangeRate.getLatestExchangeRateDate()), F, 6);
        }
    }

    private static enum PrintMode {
        VALUE_BALANCES,
        CREDIT_LIMIT,
        CREDIT_DEBIT_SUMS,
        STANDARD_NAME;

    }

    private static final class AccountData {
        String displayName;
        String closingDate;
        String balance;
        String today;
        String tomorrow;
        String afterTomorrow;
        String openingBalance;
        String sumDebit;
        String sumCredit;
        String creditLimit;
        String freeLiquidity;
        String standardAccountName;

        AccountData(String displayName, String standardAccountName) {
            this.displayName = displayName;
            this.standardAccountName = standardAccountName;
        }

        AccountData(String displayName, Date closingDate, String standardAccountName, Locale locale) {
            this.displayName = displayName;
            this.closingDate = DateFormat.getDateInstance(2, locale).format(closingDate);
            this.standardAccountName = standardAccountName;
        }

        AccountData(String displayName, Date closingDate, Currency currency, BigDecimal balance, BigDecimal today, BigDecimal tomorrow, BigDecimal afterTomorrow, BigDecimal openingBalance, BigDecimal sumDebit, BigDecimal sumCredit, BigDecimal creditLimit, BigDecimal freeLiquidity, String standardAccountName, Locale locale) {
            this.displayName = displayName;
            this.closingDate = DateFormat.getDateInstance(2, locale).format(closingDate);
            this.balance = PaymentUtils.formatAmount(balance, currency, locale);
            this.today = PaymentUtils.formatAmount(today, currency, locale);
            this.tomorrow = PaymentUtils.formatAmount(tomorrow, currency, locale);
            this.afterTomorrow = PaymentUtils.formatAmount(afterTomorrow, currency, locale);
            this.openingBalance = PaymentUtils.formatAmount(openingBalance, currency, locale);
            this.sumDebit = PaymentUtils.formatAmount(sumDebit, currency, locale);
            this.sumCredit = PaymentUtils.formatAmount(sumCredit, currency, locale);
            this.creditLimit = PaymentUtils.formatAmount(creditLimit, currency, locale);
            this.freeLiquidity = PaymentUtils.formatAmount(freeLiquidity, currency, locale);
            this.standardAccountName = standardAccountName;
        }
    }

    private static final class AmountCollector {
        private BigDecimal balance = BigDecimal.ZERO;
        private BigDecimal valueBalanceToday = BigDecimal.ZERO;
        private BigDecimal valueBalanceTomorrow = BigDecimal.ZERO;
        private BigDecimal valueBalanceAfterTomorrow = BigDecimal.ZERO;
        private BigDecimal openingBalance = null;
        private BigDecimal sumDebit = null;
        private BigDecimal sumCredit = null;
        private BigDecimal creditLimit = null;
        private BigDecimal freeLiquidity = null;

        public void addBalance(BigDecimal balance) {
            this.balance = this.balance.add(balance);
        }

        public void addValueBalanceToday(BigDecimal balance) {
            if (balance != null) {
                this.valueBalanceToday = this.valueBalanceToday.add(balance);
            }
        }

        public void addValueBalanceTomorrow(BigDecimal balance) {
            if (balance != null) {
                this.valueBalanceTomorrow = this.valueBalanceTomorrow.add(balance);
            }
        }

        public void addValueBalanceAfterTomorrow(BigDecimal balance) {
            if (balance != null) {
                this.valueBalanceAfterTomorrow = this.valueBalanceAfterTomorrow.add(balance);
            }
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public BigDecimal getValueBalanceToday() {
            return this.valueBalanceToday;
        }

        public BigDecimal getValueBalanceTomorrow() {
            return this.valueBalanceTomorrow;
        }

        public BigDecimal getValueBalanceAfterTomorrow() {
            return this.valueBalanceAfterTomorrow;
        }

        public void addOpeningBalance(BigDecimal openingBalance) {
            if (openingBalance != null) {
                this.openingBalance = this.openingBalance == null ? openingBalance : this.openingBalance.add(openingBalance);
            }
        }

        public void addSumDebit(BigDecimal sumDebit) {
            if (sumDebit != null) {
                this.sumDebit = this.sumDebit == null ? sumDebit : this.sumDebit.add(sumDebit);
            }
        }

        public void addSumCredit(BigDecimal sumCredit) {
            if (sumCredit != null) {
                this.sumCredit = this.sumCredit == null ? sumCredit : this.sumCredit.add(sumCredit);
            }
        }

        public void addCreditLimit(BigDecimal creditLimit) {
            if (creditLimit != null) {
                this.creditLimit = this.creditLimit == null ? creditLimit : this.creditLimit.add(creditLimit);
            }
        }

        public void addFreeLiquidity(BigDecimal freeLiquidity) {
            if (freeLiquidity != null) {
                this.freeLiquidity = this.freeLiquidity == null ? freeLiquidity : this.freeLiquidity.add(freeLiquidity);
            }
        }

        public BigDecimal getOpeningBalance() {
            return this.openingBalance;
        }

        public BigDecimal getSumDebit() {
            return this.sumDebit;
        }

        public BigDecimal getSumCredit() {
            return this.sumCredit;
        }

        public BigDecimal getCreditLimit() {
            return this.creditLimit;
        }

        public BigDecimal getFreeLiquidity() {
            return this.freeLiquidity;
        }
    }
}

