/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.core.GeneralTexts;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmCharge;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SclDirectory;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.format.sepa.SEPAPurposeCode;
import de.businesslogics.format.swift.mt940.CMUtil;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import io.ebean.PagedList;
import io.ebean.Query;
import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class CmPrinter
implements Closeable {
    private static final int PAGING_SIZE_STATEMENTS = 100;
    private static final Color PALE_GREY = new Color(235, 235, 235);
    private static final Color GREY = new Color(200, 200, 200);
    public static final BLFont F = BLFont.FONT_NORMAL;
    public static final BLFont BF = BLFont.FONT_BOLD;
    private final BLDocument document;
    private final boolean printBookings;
    private final boolean insertSeparatorLineBetweenStatements;
    private final boolean newPageForSheet;
    private final boolean printPageInformations;
    private final boolean repeatHeaderBoxOnNewPage;
    private final boolean printAllBookingDetails;
    private final boolean printSingleBookings;
    private final boolean printOneBookingPerPage;
    private final boolean enrichDti;
    private final boolean printGrandTotalAmount;
    private final boolean printTotalAmount;
    private final boolean printAdditionalStatementInfo;
    private final boolean conversionUsePositiveDebits;
    private final boolean printAlternatingBackground;
    private final boolean printAccountOwner;
    private final CmBooking.BookingSorting bookingSorting;
    private final Locale locale;
    private final Map<Currency, AmountAndCountCollector> totalAmountMap = new LinkedHashMap<Currency, AmountAndCountCollector>();
    private boolean hasPrintedFirstStatement = false;
    private int numberOfTables = 0;
    private boolean alternatingBackgroundPosition = false;
    private final DateFormat sdf;
    private final DateFormat dateTimeFormat;
    private static final Comparator<CmStatement> STATEMENT_COMPARATOR = (o1, o2) -> {
        int compare = o1.getAccount().getBank().getBankId().compareTo(o2.getAccount().getBank().getBankId());
        if (compare != 0) {
            return compare;
        }
        compare = Account.getDefaultDisplayName(o1.getAccount()).compareTo(Account.getDefaultDisplayName(o2.getAccount()));
        if (compare != 0) {
            return compare;
        }
        compare = o1.getType().compareTo(o2.getType());
        if (compare != 0) {
            return compare;
        }
        if (o1.getOpeningDate() != null && o2.getOpeningDate() != null && (compare = o1.getOpeningDate().compareTo(o2.getOpeningDate())) != 0) {
            return compare;
        }
        if (o1.getClosingDate() != null && o2.getClosingDate() != null && (compare = o1.getClosingDate().compareTo(o2.getClosingDate())) != 0) {
            return compare;
        }
        if (o1.getStatementNumberToDisplay() != null && o2.getStatementNumberToDisplay() != null && (compare = o1.getStatementNumberToDisplay().compareTo(o2.getStatementNumberToDisplay())) != 0) {
            return compare;
        }
        if (o1.getPageNumber() != null && o2.getPageNumber() != null && (compare = o1.getPageNumber().compareTo(o2.getPageNumber())) != 0) {
            return compare;
        }
        if (o1.getUniqueId() != null && o2.getUniqueId() != null && (compare = o1.getUniqueId().compareTo(o2.getUniqueId())) != 0) {
            return compare;
        }
        return o1.getId().compareTo(o2.getId());
    };
    private static final Comparator<CmBooking> BOOKING_COMPARATOR = (o1, o2) -> {
        int compare;
        if (o1.getPage() != null && o2.getPage() != null && o1.getPage().getPageNumber() != null && o2.getPage().getPageNumber() != null && (compare = o1.getPage().getPageNumber().compareTo(o2.getPage().getPageNumber())) != 0) {
            return compare;
        }
        compare = Integer.compare(o1.getPos(), o2.getPos());
        if (compare != 0) {
            return compare;
        }
        if (o1.getBookingDate() != null && o2.getBookingDate() != null && (compare = o1.getBookingDate().compareTo(o2.getBookingDate())) != 0) {
            return compare;
        }
        if (o1.getValueDate() != null && o2.getValueDate() != null && (compare = o1.getValueDate().compareTo(o2.getValueDate())) != 0) {
            return compare;
        }
        return o1.getId().compareTo(o2.getId());
    };

    public CmPrinter(File dest, DatabasePreferenceStore store, boolean printBookings, Boolean printGrandTotalAmount, boolean withLogo, Locale locale) throws IOException, PDFException {
        this(dest, BankingApiMessages.getString(locale, "GeneralMessages.accountStatement", new Object[0]), store, printBookings, printGrandTotalAmount, withLogo, locale);
    }

    public CmPrinter(File dest, String title, DatabasePreferenceStore store, boolean printBookings, Boolean printGrandTotalAmount, boolean withLogo, Locale locale) throws IOException, PDFException {
        this(dest, title, store, printBookings, printGrandTotalAmount, withLogo, locale, false);
    }

    public CmPrinter(File dest, String title, DatabasePreferenceStore store, boolean printBookings, Boolean printGrandTotalAmount, boolean withLogo, Locale locale, boolean withAdditionalFooter) throws IOException, PDFException {
        this.locale = locale;
        this.sdf = DateFormat.getDateInstance(2, locale);
        this.dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        this.printBookings = printBookings;
        this.insertSeparatorLineBetweenStatements = store.getBoolean(CmPreferenceConstants.INSERT_SEPARATOR_BETWEEN_STATEMENTS);
        this.newPageForSheet = store.getBoolean(CmPreferenceConstants.NEW_PAGE_ON_PRINT);
        this.printPageInformations = store.getBoolean(CmPreferenceConstants.PRINT_PAGE_INFORMATIONS);
        this.repeatHeaderBoxOnNewPage = store.getBoolean(CmPreferenceConstants.REPEAT_STATEMENT_INFORMATIONS);
        this.printAllBookingDetails = store.getBoolean(CmPreferenceConstants.PRINT_ALL_BOOKING_DETAILS);
        this.printSingleBookings = store.getBoolean(CmPreferenceConstants.PRINT_SINGLE_BOOKINGS);
        this.printOneBookingPerPage = store.getBoolean(CmPreferenceConstants.PRINT_ONE_BOOKING_PER_PAGE);
        this.enrichDti = store.getBoolean(CmPreferenceConstants.ENRICH_DTI_INFORMATIONS);
        this.printGrandTotalAmount = printGrandTotalAmount == null ? store.getBoolean(CmPreferenceConstants.PRINT_TOTAL_AMOUNT) : printGrandTotalAmount.booleanValue();
        this.printTotalAmount = store.getBoolean(CmPreferenceConstants.PRINT_TOTAL_AMOUNT_PER_STATEMENT);
        this.printAdditionalStatementInfo = store.getBoolean(CmPreferenceConstants.PRINT_ADDITIONAL_STATEMENT_INFO);
        this.conversionUsePositiveDebits = store.getBoolean(CmPreferenceConstants.CONVERSION_USE_POSITIVE_DEBITS);
        this.bookingSorting = CmBooking.BookingSorting.valueOf(store.getString(CmPreferenceConstants.PRINT_BOOKING_SORTING));
        this.printAlternatingBackground = store.getBoolean(CmPreferenceConstants.PRINT_ALTERNATING_BACKGROUND);
        this.printAccountOwner = store.getBoolean(CmPreferenceConstants.PRINT_ACCOUNT_OWNER);
        FileOutputStream fout = new FileOutputStream(dest);
        this.document = Util.createBLDocument(fout, BLDocument.PageLayout.A4, title, withLogo, locale, withAdditionalFooter);
    }

    public void print(Collection<Account> accounts, Collection<Account> dtiAccounts, Collection<CmStatement> statements, Collection<CmPage> pages, Map<CmStatement, Collection<CmBooking>> bookings, Date printPeriodStartDate, Date printPeriodEndDate) throws IOException, PDFException {
        int countPages;
        int countAccounts = accounts == null ? 0 : accounts.size();
        int countDtiAccounts = dtiAccounts == null ? 0 : dtiAccounts.size();
        int countStatements = statements == null ? 0 : statements.size();
        int n = countPages = pages == null ? 0 : pages.size();
        if (countAccounts > 0 || countDtiAccounts > 0 || countStatements > 0 || countPages > 0) {
            PagedList<CmStatement> paging;
            int page;
            if (countDtiAccounts > 0) {
                for (Account a : dtiAccounts) {
                    page = 0;
                    do {
                        paging = CmStatement.findDtiFiles(a, page++, 100, false, printPeriodStartDate, printPeriodEndDate);
                        this.printStatements(paging.getList());
                    } while (paging.hasNext());
                }
            }
            if (countAccounts > 0) {
                for (Account a : accounts) {
                    page = 0;
                    do {
                        paging = CmStatement.findStatements(a, page++, 100, false, printPeriodStartDate, printPeriodEndDate);
                        this.printStatements(paging.getList());
                    } while (paging.hasNext());
                }
            }
            if (countStatements > 0) {
                this.printStatements(statements);
            }
            if (countPages > 0) {
                this.printPages(pages);
            }
            if (!this.hasPrintedFirstStatement) {
                throw new IOException("The document has no pages.");
            }
        } else {
            this.printBookings(bookings, printPeriodStartDate, printPeriodEndDate);
        }
    }

    private BLTable<?> printHeader(Account account) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(4);
        t.setWidth(100.0f);
        t.setWidths(new int[]{17, 33, 17, 33});
        if (this.printBookings) {
            t.setBackgroundColor(GREY);
        }
        t.setBorder(BLBorder.NO_BORDER);
        t.setUseDescender(true);
        CmPrinter.addGeneralHeaderLine(t, account, this.locale, this.printAccountOwner);
        ++this.numberOfTables;
        this.alternatingBackgroundPosition = false;
        return t;
    }

    private static void addGeneralHeaderLine(BLTable<?> t, Account account, Locale locale, boolean printAccountOwner) throws PDFException {
        String name = Account.getDefaultDisplayName(account);
        if (!name.equals(Account.getCmDisplayName(account))) {
            t.setDefaultColspan(4);
            t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
            t.addCell(name, BF);
            t.setDefaultColspan(1);
            t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        }
        if (printAccountOwner && account.getAccountHolder() != null && !account.getAccountHolder().isEmpty()) {
            t.setDefaultColspan(4);
            t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
            t.addCell(account.getAccountHolder(), BF);
            t.setDefaultColspan(1);
            t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        }
        t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.account", new Object[0]), BF);
        t.addCell(Account.getCmDisplayName(account), F);
        String bankName = account.getBank().getDisplayName();
        if (bankName != null && bankName.length() > 0) {
            t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.bank", new Object[0]), BF);
            t.addCell(bankName, F);
        } else {
            t.addCell("");
            t.addCell("");
        }
    }

    private void addStatementHeaderLine(BLTable<?> t, Date date, String number) throws PDFException {
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.statementDate", new Object[0]), BF);
        if (date != null) {
            t.addCell(this.sdf.format(date), F);
        } else {
            t.addCell("");
        }
        if (number != null && number.length() > 0) {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.statementNumber", new Object[0]), BF);
            t.addCell(number, F);
        } else {
            t.addCell("");
            t.addCell("");
        }
    }

    private void addAdviceHeaderLine(BLTable<?> t, java.util.Date date, String number) throws PDFException {
        t.addCell(Messages.getString(this.locale, "PrintAction.adviceDate", new Object[0]), BF);
        t.addCell(this.dateTimeFormat.format(date), F);
        if (number != null) {
            int sepPos = number.indexOf("-");
            if (sepPos > 0) {
                number = number.substring(0, sepPos);
            }
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.adviceNumber", new Object[0]), BF);
            t.addCell(number, F);
        } else {
            t.addCell("");
            t.addCell("");
        }
    }

    private void printStatements(Collection<CmStatement> statements) throws PDFException {
        ArrayList<CmStatement> sorted = new ArrayList<CmStatement>(statements);
        sorted.sort(STATEMENT_COMPARATOR);
        for (CmStatement statement : sorted) {
            this.printStatement(statement);
            this.hasPrintedFirstStatement = true;
        }
    }

    private void printStatement(CmStatement accountStatement) throws PDFException {
        List<CmPage> pages;
        int countPages;
        BLTable<?> t;
        if (this.hasPrintedFirstStatement) {
            if (this.newPageForSheet) {
                this.document.newPage();
            } else if (this.insertSeparatorLineBetweenStatements) {
                t = PDFCreator.getInstance().createTable(1);
                t.setBorderWidth(2.0f);
                t.setBorder(BLBorder.BOTTOM);
                t.setWidth(100.0f);
                t.addCell("");
                this.document.add(t);
                this.document.addNewLine();
            } else {
                this.document.addNewLine();
            }
        }
        if ((accountStatement.isAdvice() || this.printPageInformations) && (countPages = (pages = CmPage.findByStatement(accountStatement, false)).size()) > 0) {
            for (CmPage page : pages) {
                this.printPage(page);
            }
            return;
        }
        t = this.printHeader(accountStatement.getAccount());
        if (accountStatement.isDtiFile()) {
            this.addDtiData(t, accountStatement);
        } else {
            this.addStatementData(t, accountStatement);
        }
        Query<CmBooking> list = null;
        if (this.printBookings) {
            list = CmBooking.findByStatement(accountStatement, this.bookingSorting, this.printPageInformations);
        }
        if (!this.repeatHeaderBoxOnNewPage || !this.printBookings) {
            this.document.addTable(t);
        }
        if (this.printBookings) {
            this.addBookings(this.repeatHeaderBoxOnNewPage ? t : null, list);
        }
    }

    private void printPages(Collection<CmPage> pages) throws PDFException {
        for (CmPage page : pages) {
            this.printPage(page);
        }
    }

    private void printPage(CmPage page) throws PDFException {
        if (this.hasPrintedFirstStatement) {
            if (this.newPageForSheet) {
                this.document.newPage();
            } else {
                this.document.addNewLine();
            }
        }
        BLTable<?> t = this.printHeader(page.getStatement().getAccount());
        this.addStatementData(t, page);
        Query<CmBooking> list = null;
        if (this.printBookings) {
            list = CmBooking.findByPage(page, this.bookingSorting);
        }
        if (!this.repeatHeaderBoxOnNewPage || !this.printBookings) {
            this.document.addTable(t);
        }
        if (this.printBookings) {
            this.addBookings(this.repeatHeaderBoxOnNewPage ? t : null, list);
        }
        if (this.printPageInformations) {
            this.hasPrintedFirstStatement = true;
        }
    }

    private void addBookings(BLTable<?> t, Query<CmBooking> bookings) throws PDFException {
        t = this.getBookingTable(t);
        MyQueryConsumer consumer = new MyQueryConsumer(t, this);
        bookings.findEach((Consumer)consumer);
        if (consumer.exception != null) {
            throw consumer.exception;
        }
        t.setDefaultColspan(4);
        if (this.printTotalAmount) {
            for (Currency currency : consumer.totalAmountMap.keySet()) {
                AmountAndCountCollector amountAndCount = consumer.totalAmountMap.get(currency);
                this.printTotalAmountToTable(t, amountAndCount.getCount(), amountAndCount.getAmount(), currency, false);
            }
        }
        if (!consumer.hasBookings) {
            t.setHeaderRows(0);
        }
        this.document.add(t);
        consumer.addTotalsToPrinter();
    }

    private void addStatementData(BLTable<?> table, CmStatement s) throws PDFException {
        if (s.isAdvice()) {
            this.addAdviceHeaderLine(table, s.getCreationDate(), this.getTotalNumber(s));
            this.printCumulativeInfos(table, s);
        } else {
            this.addStatementHeaderLine(table, s.getClosingDate(), this.getTotalNumber(s));
            this.addStatementData(table, s.getCurrency(), s.getOpeningBalance(), s.getClosingBalance(), s.getSumCredit(), s.getSumDebit());
            if (this.printAdditionalStatementInfo && s.getAdditionalInformation() != null) {
                this.addAdditionalInformation(table, s.getAdditionalInformation());
            }
        }
    }

    private String getTotalNumber(CmStatement s) {
        String pageNumber;
        Object totalNumber = this.checkNull(s.getStatementNumberToDisplay());
        if (!s.isHasPages() && (pageNumber = this.checkNull(s.getPageNumber())).length() > 0) {
            totalNumber = (String)totalNumber + "/" + pageNumber;
        }
        return totalNumber;
    }

    private void addStatementData(BLTable<?> t, CmPage page) throws PDFException {
        CmStatement statement = page.getStatement();
        Object totalNumber = this.checkNull(statement.getStatementNumberToDisplay());
        String pageNumber = this.checkNull(page.getPageNumber());
        if (pageNumber.length() > 0) {
            totalNumber = (String)totalNumber + "/" + pageNumber;
        }
        if (statement.isAdvice()) {
            this.addAdviceHeaderLine(t, page.getCreationDate(), (String)totalNumber);
            this.printCumulativeInfos(t, page);
        } else {
            this.addStatementHeaderLine(t, page.getClosingDate(), (String)totalNumber);
            this.addStatementData(t, page.getCurrency(), page.getOpeningBalance(), page.getClosingBalance(), page.getSumCredit(), page.getSumDebit());
        }
    }

    private void addStatementData(BLTable<?> t, Currency currency, BigDecimal openingBalance, BigDecimal balance, BigDecimal sumCredit, BigDecimal sumDebit) throws PDFException {
        if (openingBalance != null) {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.openingBalance", new Object[0]), BF);
            t.addCell(PaymentUtils.formatAmount(openingBalance, currency, this.locale), F);
        } else {
            t.addCell("");
            t.addCell("");
        }
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.sumCredits", new Object[0]), BF);
        t.addCell(PaymentUtils.formatAmount(sumCredit, currency, this.locale), F);
        if (balance != null) {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.balance", new Object[0]), BF);
            t.addCell(PaymentUtils.formatAmount(balance, currency, this.locale), F);
        } else {
            t.addCell("");
            t.addCell("");
        }
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.sumDebits", new Object[0]), BF);
        if (sumDebit != null && this.conversionUsePositiveDebits) {
            sumDebit = sumDebit.abs();
        }
        t.addCell(PaymentUtils.formatAmount(sumDebit, currency, this.locale), F);
    }

    private void addAdditionalInformation(BLTable<?> t, String additionalInformation) throws PDFException {
        t.setDefaultColspan(4);
        t.addCell(additionalInformation);
        t.setDefaultColspan(1);
    }

    private void addDtiData(BLTable<?> t, CmStatement statement) throws PDFException {
        this.addDtiHeaderLine(t, statement);
        if (CmStatement.Type.CAMT054.equals((Object)statement.getType())) {
            this.printCumulativeInfos(t, statement);
        } else {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.countBookings", new Object[0]), BF);
            t.addCell(String.valueOf(statement.getCountBookings()), F);
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.sumBookings", new Object[0]), BF);
            t.addCell(PaymentUtils.formatAmount(statement.getTotalSum(), statement.getCurrency(), this.locale), F);
        }
    }

    private void addDtiHeaderLine(BLTable<?> t, CmStatement statement) throws PDFException {
        String statementInfo = EclipseFreeHelper.getDisplayText(statement, this.locale);
        if (statementInfo != null) {
            CmStatement accountStatement = null;
            if (this.enrichDti) {
                accountStatement = CmStatement.findAccountStatementForDtiFile(statement);
            }
            boolean fourColums = !this.enrichDti || accountStatement == null;
            t.setDefaultColspan(fourColums ? 4 : 2);
            String sb = statementInfo + " " + Messages.getString(this.locale, "AccountStatement.from", new Object[0]) + " " + this.sdf.format(statement.getCreationDate());
            t.addCell(sb, BF);
            if (!fourColums) {
                Date date = accountStatement.getClosingDate();
                Integer statementNumber = accountStatement.getStatementNumberToDisplay();
                if (statementNumber != null) {
                    if (date != null) {
                        t.addCell(MessageFormat.format(BankingApiMessages.getString(this.locale, "GeneralMessages.statementNumberAndDate", new Object[0]), statementNumber.toString(), this.sdf.format(date)), BF);
                    } else {
                        Timestamp creationTime = accountStatement.getCreationDate();
                        if (creationTime != null) {
                            t.addCell(MessageFormat.format(BankingApiMessages.getString(this.locale, "GeneralMessages.adviceNumberAndDate", new Object[0]), statementNumber.toString(), this.dateTimeFormat.format(creationTime)), BF);
                        } else {
                            t.addCell("");
                        }
                    }
                } else if (date != null) {
                    t.addCell(MessageFormat.format(BankingApiMessages.getString(this.locale, "AccountOverviewLabelProvider.statementFromDate", new Object[0]), this.sdf.format(date)), BF);
                } else {
                    Timestamp creationTime = accountStatement.getCreationDate();
                    if (creationTime != null) {
                        t.addCell(MessageFormat.format(BankingApiMessages.getString(this.locale, "AccountOverviewLabelProvider.adviceFromDate", new Object[0]), this.dateTimeFormat.format(date)), BF);
                    } else {
                        t.addCell("");
                    }
                }
            }
            t.setDefaultColspan(1);
            if (statement.getOriginalFilename() != null && statement.getOriginalFilename().length() > 0) {
                t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.file", new Object[0]), BF);
                t.setDefaultColspan(3);
                t.addCell(statement.getOriginalFilename(), F);
                t.setDefaultColspan(1);
            }
        }
    }

    private void addBookingBalancesHeaderLine(BLTable<?> table, CmStatement statement, Collection<CmBooking> bookingsForStatement) throws PDFException {
        if (bookingsForStatement.isEmpty()) {
            return;
        }
        ArrayList<CmBooking> bookingsSorted = new ArrayList<CmBooking>(bookingsForStatement);
        bookingsSorted.sort(BOOKING_COMPARATOR);
        CmBooking firstBooking = bookingsSorted.get(0);
        BigDecimal openingBalance = null;
        if (firstBooking.getBalance() != null && firstBooking.getAmount() != null) {
            openingBalance = firstBooking.getBalance().subtract(firstBooking.getAmount());
        }
        BigDecimal closingBalance = null;
        CmBooking lastBooking = bookingsSorted.get(bookingsSorted.size() - 1);
        if (lastBooking.getBalance() != null) {
            closingBalance = lastBooking.getBalance();
        }
        BigDecimal sumCredit = BigDecimal.ZERO;
        BigDecimal sumDebit = BigDecimal.ZERO;
        for (CmBooking booking : bookingsSorted) {
            BigDecimal amount = booking.getAmount();
            if (amount.signum() < 0) {
                sumDebit = sumDebit.add(amount);
                continue;
            }
            sumCredit = sumCredit.add(amount);
        }
        this.addStatementData(table, statement.getCurrency(), openingBalance, closingBalance, sumCredit, sumDebit);
    }

    private void printCumulativeInfos(BLTable<?> t, CmStatement accountStatement) throws PDFException {
        Currency currency = accountStatement.getCurrency();
        int countCredits = accountStatement.getCountCredit();
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.stmt.countCredits", new Object[0]), BF);
        t.addCell(String.valueOf(countCredits), F);
        if (countCredits > 0) {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.sumCredits", new Object[0]), BF);
            t.addCell(PaymentUtils.formatAmount(accountStatement.getSumCredit(), currency, this.locale), F);
        } else {
            t.addCell("");
            t.addCell("");
        }
        int countDebits = accountStatement.getCountDebit();
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.stmt.countDebits", new Object[0]), BF);
        t.addCell(String.valueOf(countDebits), F);
        if (countDebits > 0) {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.sumDebits", new Object[0]), BF);
            BigDecimal sumDebits = accountStatement.getSumDebit();
            if (sumDebits != null && this.conversionUsePositiveDebits) {
                sumDebits = sumDebits.abs();
            }
            t.addCell(PaymentUtils.formatAmount(sumDebits, currency, this.locale), F);
        } else {
            t.addCell("");
            t.addCell("");
        }
    }

    private void printCumulativeInfos(BLTable<?> t, CmPage page) throws PDFException {
        Currency currency = page.getCurrency();
        int countCredits = page.getCountCredit();
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.stmt.countCredits", new Object[0]), BF);
        t.addCell(String.valueOf(countCredits), F);
        if (countCredits > 0) {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.sumCredits", new Object[0]), BF);
            t.addCell(PaymentUtils.formatAmount(page.getSumCredit(), currency, this.locale), F);
        } else {
            t.addCell("");
            t.addCell("");
        }
        int countDebits = page.getCountDebit();
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.stmt.countDebits", new Object[0]), BF);
        t.addCell(String.valueOf(countDebits), F);
        if (countDebits > 0) {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.sumDebits", new Object[0]), BF);
            BigDecimal sumDebits = page.getSumDebit();
            if (sumDebits != null && this.conversionUsePositiveDebits) {
                sumDebits = sumDebits.abs();
            }
            t.addCell(PaymentUtils.formatAmount(sumDebits, currency, this.locale), F);
        } else {
            t.addCell("");
            t.addCell("");
        }
    }

    private void printBookings(Map<CmStatement, Collection<CmBooking>> bookings, Date printPeriodStartDate, Date printPeriodEndDate) throws PDFException {
        BLTable<?> t = null;
        HashMap<Currency, AmountAndCountCollector> totalAmountMap = new HashMap<Currency, AmountAndCountCollector>();
        boolean printTimePeriod = printPeriodStartDate != null && printPeriodEndDate != null;
        ArrayList<CmStatement> statementsSorted = new ArrayList<CmStatement>(bookings.keySet());
        statementsSorted.sort(STATEMENT_COMPARATOR);
        int statementIndex = 0;
        int countStatements = statementsSorted.size();
        for (CmStatement statement : statementsSorted) {
            AmountAndCountCollector amountAndCount;
            BLTable<?> h;
            ++statementIndex;
            Collection<CmBooking> bookingsForStatement = bookings.get(statement);
            if (!this.printOneBookingPerPage) {
                h = this.getBookingHeaderTable(statement, bookingsForStatement, printTimePeriod);
                if (!this.repeatHeaderBoxOnNewPage) {
                    this.document.addTable(h);
                }
                t = this.getBookingTable(h);
            }
            HashMap<Currency, AmountAndCountCollector> statementmountMap = new HashMap<Currency, AmountAndCountCollector>();
            for (CmBooking booking : bookingsForStatement) {
                Currency currency = booking.getCurrency();
                if (statementmountMap.containsKey(currency)) {
                    amountAndCount = (AmountAndCountCollector)statementmountMap.get(currency);
                } else {
                    amountAndCount = new AmountAndCountCollector();
                    statementmountMap.put(currency, amountAndCount);
                }
                amountAndCount.addAmount(booking.getAmount());
                amountAndCount.incrementCount();
                if (totalAmountMap.containsKey(currency)) {
                    amountAndCount = (AmountAndCountCollector)totalAmountMap.get(currency);
                } else {
                    amountAndCount = new AmountAndCountCollector();
                    totalAmountMap.put(currency, amountAndCount);
                }
                amountAndCount.addAmount(booking.getAmount());
                amountAndCount.incrementCount();
                if (this.printOneBookingPerPage) {
                    h = this.getBookingHeaderTable(statement, bookingsForStatement, printTimePeriod);
                    if (!this.repeatHeaderBoxOnNewPage) {
                        this.document.addTable(h);
                    }
                    t = this.getBookingTable(h);
                    this.addBooking(t, booking);
                    this.document.addTable(t);
                    this.document.newPage();
                    continue;
                }
                this.addBooking(t, booking);
            }
            if (t == null || this.printOneBookingPerPage) continue;
            if (this.printTotalAmount && bookings.get(statement).size() > 1) {
                t.setDefaultColspan(4);
                for (Currency curr : statementmountMap.keySet()) {
                    amountAndCount = (AmountAndCountCollector)statementmountMap.get(curr);
                    this.printTotalAmountToTable(t, amountAndCount.getCount(), amountAndCount.getAmount(), curr, true);
                }
            }
            this.document.addTable(t);
            if (statementIndex >= countStatements) continue;
            this.document.addNewLine();
        }
        if (this.printGrandTotalAmount && !this.printOneBookingPerPage && t != null && bookings.size() > 1) {
            this.document.addTable(this.createGrandTotalAmountTable(totalAmountMap));
        }
    }

    private void printTotalAmountToTable(BLTable<?> t, int count, BigDecimal sum, Currency currency, boolean forcePrint) throws PDFException {
        t.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(currency.getDefaultFractionDigits());
        nf.setMaximumFractionDigits(currency.getDefaultFractionDigits());
        if (forcePrint || count > 1) {
            t.addCell(MessageFormat.format(Messages.getString(this.locale, "PrintAction.totalAmountInfo", new Object[0]), count, currency.getCurrencyCode(), nf.format(sum.doubleValue())), BF);
        }
    }

    private BLTable<?> getBookingHeaderTable(CmStatement statement, Collection<CmBooking> bookingsForStatement, boolean printTimePeriod) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(4);
        t.setWidth(100.0f);
        t.setWidths(new int[]{17, 33, 17, 33});
        t.setBackgroundColor(GREY);
        t.setBorder(BLBorder.NO_BORDER);
        t.setUseDescender(true);
        CmPrinter.addGeneralHeaderLine(t, statement.getAccount(), this.locale, this.printAccountOwner);
        if (statement.isDtiFile()) {
            this.addDtiHeaderLine(t, statement);
        } else if (statement.isAdvice()) {
            this.addAdviceHeaderLine(t, statement.getCreationDate(), this.checkNull(statement.getStatementNumberToDisplay()));
        } else {
            this.addStatementHeaderLine(t, statement.getClosingDate(), this.checkNull(statement.getStatementNumberToDisplay()));
        }
        if (printTimePeriod) {
            this.addBookingBalancesHeaderLine(t, statement, bookingsForStatement);
        }
        this.alternatingBackgroundPosition = false;
        return t;
    }

    public static BLTable<?> getValueBalanceHeaderTable(Account account, Locale locale, User user) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(4);
        t.setWidth(100.0f);
        t.setWidths(new int[]{17, 33, 17, 33});
        t.setBackgroundColor(GREY);
        t.setBorder(BLBorder.NO_BORDER);
        t.setUseDescender(true);
        if (account.getUseVirtualBalances()) {
            t.addCell(Messages.getString(locale, "AccountPage.virtualBalances", new Object[0]), F, 4, Alignment.ALIGN_CENTER, null, GREY, BLBorder.NO_BORDER);
        }
        CmPrinter.addGeneralHeaderLine(t, account, locale, new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean(CmPreferenceConstants.PRINT_ACCOUNT_OWNER));
        CmPrinter.addBalanceLine(t, account, locale, user);
        return t;
    }

    private static void addBalanceLine(BLTable<?> t, Account a, Locale locale, User user) throws PDFException {
        if (a.getUseVirtualBalances()) {
            t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.openingDate", new Object[0]), BF);
            t.addCell(DateFormat.getDateInstance().format(a.getVirtualStartDate()), F);
            t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.openingBalance", new Object[0]), BF);
            t.addCell(PaymentUtils.formatAmount(a.getVirtualStartBalance(), Currency.getInstance(a.getCurrency()), locale), F);
        } else {
            CMAccount account = new CMAccount(a, user);
            CmStatement s = account.getNewestStatement();
            if (s != null) {
                Object msg = BankingApiMessages.getString(locale, "GeneralMessages.accountStatement", new Object[0]);
                if (s.getStatementNumberToDisplay() != null) {
                    msg = (String)msg + " " + s.getStatementNumberToDisplay();
                }
                t.addCell((String)msg, BF);
                t.addCell(DateFormat.getDateInstance().format(s.getClosingDate()), F);
                t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.bookingBalance", new Object[0]), BF);
                t.addCell(PaymentUtils.formatAmount(s.getClosingBalance(), Currency.getInstance(a.getCurrency()), locale), F);
            } else {
                t.addCell("");
                t.addCell("");
                t.addCell("");
                t.addCell("");
            }
        }
    }

    private BLTable<?> getBookingTable(BLTable<?> pageHeader) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(4);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(100.0f);
        t.setWidths(new int[]{13, 13, 50, 24});
        if (this.repeatHeaderBoxOnNewPage && pageHeader != null) {
            t.setDefaultColspan(4);
            t.addCell(pageHeader);
            t.setDefaultColspan(1);
        }
        t.addCell(Messages.getString(this.locale, "PrintAction.bookingDate", new Object[0]), BF);
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.valueDate", new Object[0]), BF);
        t.addCell(Messages.getString(this.locale, "PrintAction.bookingDetails", new Object[0]), BF);
        t.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
        t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]), BF);
        t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        t.setHeaderRows(this.repeatHeaderBoxOnNewPage ? 2 : 1);
        return t;
    }

    private void addBooking(BLTable<?> t, CmBooking b) throws PDFException {
        java.util.Date bookingDate = EclipseFreeHelper.getBookingDate(b);
        if (this.printAlternatingBackground && !this.printOneBookingPerPage) {
            if (this.alternatingBackgroundPosition) {
                t.setBackgroundColor(PALE_GREY);
            } else {
                t.setBackgroundColor(null);
            }
            boolean bl = this.alternatingBackgroundPosition = !this.alternatingBackgroundPosition;
        }
        if (bookingDate != null) {
            t.addCell(this.sdf.format(bookingDate), F);
        } else {
            t.addCell("");
        }
        java.util.Date valueDate = EclipseFreeHelper.getValueDate(b);
        if (valueDate != null) {
            t.addCell(this.sdf.format(valueDate), F);
        } else {
            t.addCell("");
        }
        t.addCell(this.createBookingDetailsTable(b, this.printAllBookingDetails));
        t.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
        t.addCell(PaymentUtils.formatAmount(b.getAmount(), b.getCurrency(), this.locale), F);
        t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        t.setBackgroundColor(null);
    }

    private BLTable<?> createTable() throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(2);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(100.0f);
        t.setWidths(new int[]{37, 63});
        return t;
    }

    private BLTable<?> createBookingDetailsTable(CmBooking b, boolean printAllDetails) throws PDFException {
        String status;
        String ownIban = b.getAccount().getIban();
        String localPartyMandateReference = b.getLocalPartyMandateReference();
        String counterPartyCreditorId = b.getCounterPartyCreditorId();
        String localPartyCreditorId = b.getLocalPartyCreditorId();
        String counterPartyMandateReference = b.getCounterPartyMandateReference();
        boolean isReversal = b.isReversal();
        boolean isDirectDebit = b.isDebit();
        String counterPartyLabel = this.getCounterPartyLabel(b.getAmount(), isDirectDebit, isReversal);
        String localPartyLabel = this.getLocalPartyLabel(counterPartyLabel);
        String ultimateCounterPartyLabel = this.getUltimateCounterPartyLabel(counterPartyLabel);
        String ultimateLocalPartyLabel = this.getUltimateLocalPartyLabel(counterPartyLabel);
        BLTable<?> t = this.createTable();
        if (b.isReversal()) {
            t.setDefaultColspan(2);
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.bookingDetails.reversal", new Object[0]), F);
            t.setDefaultColspan(1);
        }
        this.printCountTransactions(t, b.getCountTransactions());
        if (printAllDetails || b.getLocalPartyAccountNumber() == null || !b.getLocalPartyAccountNumber().equals(ownIban)) {
            this.printLine(t, localPartyLabel, b.getLocalParty());
            this.printLine(t, ultimateLocalPartyLabel, b.getUltimateLocalParty());
            this.printAccountNumber(t, b.getLocalPartyAccountNumber());
            this.printBankCode(t, b.getLocalPartyBankCode());
            this.printMandateReference(t, localPartyMandateReference);
            this.printCreditorId(t, localPartyCreditorId);
        } else {
            this.printLine(t, ultimateLocalPartyLabel, b.getUltimateLocalParty());
        }
        if (printAllDetails || b.getCounterPartyAccountNumber() == null || !b.getCounterPartyAccountNumber().equals(ownIban)) {
            this.printLine(t, counterPartyLabel, b.getCounterParty());
            this.printLine(t, ultimateCounterPartyLabel, b.getUltimateCounterParty());
            this.printAccountNumber(t, b.getCounterPartyAccountNumber());
            this.printBankCode(t, b.getCounterPartyBankCode());
            this.printCreditorId(t, counterPartyCreditorId);
            this.printMandateReference(t, counterPartyMandateReference);
        } else {
            this.printLine(t, ultimateCounterPartyLabel, b.getUltimateCounterParty());
        }
        this.printPurpose(t, b.getPurpose());
        String purposeCode = StringUtils.checkNullAndTrim(b.getPurposeCode());
        if (purposeCode.length() > 0) {
            String description = SEPAPurposeCode.getDescription(purposeCode, this.locale);
            if (description != null && description.length() > 0) {
                purposeCode = description;
            }
            this.printLine(t, Messages.getString(this.locale, "PrintAction.purposeCode", new Object[0]), purposeCode);
        }
        if (printAllDetails) {
            this.printEntryReference(t, b.getNtryRef());
            this.printMessageId(t, b.getMsgId());
            this.printPmtInfId(t, b.getPmtInfId());
            this.printEndToEndId(t, b.getEndToEndId());
            this.printInstructionId(t, b.getInstrId());
            this.printTransactionId(t, b.getTransactionId());
            this.printDtiReference(t, b.getCustomerReference(), b.getCustomerReferenceDate());
            this.printBankReference(t, b.getBankReference());
            this.printAdditionalFields(t, b);
        }
        if ((status = StringUtils.checkNullAndTrim(b.getSts())).length() > 0 && !"BOOK".equals(status)) {
            this.printLine(t, GeneralMessages.getInstance((Locale)this.locale).STATUS + ":", status);
        }
        return t;
    }

    private String getCounterPartyLabel(BigDecimal amount, boolean isDirectDebit, boolean isReversalFromCamt) {
        return this.getCounterPartyLabel(amount, isDirectDebit, isReversalFromCamt, false);
    }

    private String getCounterPartyLabel(BigDecimal amount, boolean isDirectDebit, boolean isReversal, boolean hasCollectiveGVC) {
        if (amount.signum() > 0) {
            if (isDirectDebit) {
                if (isReversal) {
                    return Messages.getString(this.locale, "PrintAction.origPayee", new Object[0]);
                }
                return GeneralMessages.getInstance((Locale)this.locale).PAYER + ":";
            }
            if (isReversal) {
                return GeneralMessages.getInstance((Locale)this.locale).ORIGINAL_RECIPIENT + ":";
            }
            return hasCollectiveGVC ? Messages.getString(this.locale, "PrintAction.recipName", new Object[0]) : Messages.getString(this.locale, "PrintAction.origName", new Object[0]);
        }
        if (isDirectDebit) {
            if (isReversal) {
                return Messages.getString(this.locale, "PrintAction.origPayer", new Object[0]);
            }
            return GeneralMessages.getInstance((Locale)this.locale).PAYEE + ":";
        }
        if (isReversal) {
            return GeneralMessages.getInstance((Locale)this.locale).ORIGINAL_ORIGINATOR + ":";
        }
        return hasCollectiveGVC ? Messages.getString(this.locale, "PrintAction.origName", new Object[0]) : Messages.getString(this.locale, "PrintAction.recipName", new Object[0]);
    }

    private String getLocalPartyLabel(String counterPartyLabel) {
        GeneralMessages m = GeneralMessages.getInstance(this.locale);
        if (Messages.getString(this.locale, "PrintAction.origName", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.recipName", new Object[0]);
        }
        if (Messages.getString(this.locale, "PrintAction.recipName", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.origName", new Object[0]);
        }
        if ((m.PAYEE + ":").equals(counterPartyLabel)) {
            return m.PAYER + ":";
        }
        if ((m.PAYER + ":").equals(counterPartyLabel)) {
            return m.PAYEE + ":";
        }
        if ((m.ORIGINAL_ORIGINATOR + ":").equals(counterPartyLabel)) {
            return m.ORIGINAL_RECIPIENT + ":";
        }
        if ((m.ORIGINAL_RECIPIENT + ":").equals(counterPartyLabel)) {
            return m.ORIGINAL_ORIGINATOR + ":";
        }
        if (Messages.getString(this.locale, "PrintAction.origPayee", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.origPayer", new Object[0]);
        }
        if (Messages.getString(this.locale, "PrintAction.origPayer", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.origPayee", new Object[0]);
        }
        return "";
    }

    private String getUltimateCounterPartyLabel(String counterPartyLabel) {
        GeneralMessages m = GeneralMessages.getInstance(this.locale);
        if (Messages.getString(this.locale, "PrintAction.origName", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultOrigName", new Object[0]);
        }
        if (Messages.getString(this.locale, "PrintAction.recipName", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultRecipName", new Object[0]);
        }
        if ((m.PAYEE + ":").equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultPayee", new Object[0]);
        }
        if ((m.PAYER + ":").equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultPayer", new Object[0]);
        }
        if ((m.ORIGINAL_ORIGINATOR + ":").equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultOrigName", new Object[0]);
        }
        if ((m.ORIGINAL_RECIPIENT + ":").equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultRecipName", new Object[0]);
        }
        if (Messages.getString(this.locale, "PrintAction.origPayee", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultPayee", new Object[0]);
        }
        if (Messages.getString(this.locale, "PrintAction.origPayer", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultPayer", new Object[0]);
        }
        return "";
    }

    private String getUltimateLocalPartyLabel(String counterPartyLabel) {
        GeneralMessages m = GeneralMessages.getInstance(this.locale);
        if (Messages.getString(this.locale, "PrintAction.origName", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultRecipName", new Object[0]);
        }
        if (Messages.getString(this.locale, "PrintAction.recipName", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultOrigName", new Object[0]);
        }
        if ((m.PAYEE + ":").equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultPayer", new Object[0]);
        }
        if ((m.PAYER + ":").equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultPayee", new Object[0]);
        }
        if ((m.ORIGINAL_ORIGINATOR + ":").equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultRecipName", new Object[0]);
        }
        if ((m.ORIGINAL_RECIPIENT + ":").equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultOrigName", new Object[0]);
        }
        if (Messages.getString(this.locale, "PrintAction.origPayee", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultPayer", new Object[0]);
        }
        if (Messages.getString(this.locale, "PrintAction.origPayer", new Object[0]).equals(counterPartyLabel)) {
            return Messages.getString(this.locale, "PrintAction.ultPayee", new Object[0]);
        }
        return "";
    }

    private boolean isDirectDebit(String mandateReference, String creditorId) {
        return mandateReference != null && mandateReference.trim().length() > 0 || creditorId != null && creditorId.trim().length() > 0;
    }

    private void printBankCode(BLTable<?> t, String bankCode) throws PDFException {
        this.printLine(t, GeneralMessages.getInstance((Locale)this.locale).BANK_CODE + ":", bankCode);
    }

    private void printAccountNumber(BLTable<?> t, String accountNumber) throws PDFException {
        this.printLine(t, Messages.getString(this.locale, "PrintAction.accountNumberWithColon", new Object[0]), IbanUtil.formatIfIBAN(accountNumber));
    }

    private void printMandateReference(BLTable<?> t, String mandateReference) throws PDFException {
        this.printLine(t, GeneralMessages.getInstance((Locale)this.locale).MANDATE_REFERENCE + ":", mandateReference);
    }

    private void printCreditorId(BLTable<?> t, String creditorId) throws PDFException {
        this.printLine(t, GeneralMessages.getInstance((Locale)this.locale).CREDITOR_ID + ":", creditorId);
    }

    private void printPurpose(BLTable<?> t, String purpose) throws PDFException {
        this.printLine(t, Messages.getString(this.locale, "PrintAction.purpose", new Object[0]), purpose);
    }

    private void printMessageId(BLTable<?> t, String messageId) throws PDFException {
        this.printLine(t, GeneralTexts.get((Locale)this.locale).MESSAGE_ID, messageId);
    }

    private void printPmtInfId(BLTable<?> t, String pmtInfId) throws PDFException {
        this.printLine(t, GeneralTexts.get((Locale)this.locale).COLLECTOR_REFERENCE, pmtInfId);
    }

    private void printEndToEndId(BLTable<?> t, String endToEndId) throws PDFException {
        this.printLine(t, Messages.getString(this.locale, "PrintAction.endToEndReference", new Object[0]), endToEndId);
    }

    private void printInstructionId(BLTable<?> t, String instructionId) throws PDFException {
        this.printLine(t, GeneralTexts.DEFAULT.TRANSACTION_REFERENCE, instructionId);
    }

    private void printTransactionId(BLTable<?> t, String transactionId) throws PDFException {
        this.printLine(t, BankingApiMessages.getString(this.locale, "GeneralMessages.transactionId", new Object[0]) + ":", transactionId);
    }

    private void printEntryReference(BLTable<?> t, String entryReference) throws PDFException {
        this.printLine(t, GeneralMessages.getInstance((Locale)this.locale).UNAMBIGUOUS_REFERENCE + ":", entryReference);
    }

    private void printCountTransactions(BLTable<?> t, Integer countTransactions) throws PDFException {
        if (countTransactions != null) {
            this.printLine(t, Messages.getString(this.locale, "BookingDetailsView.countTransactions", new Object[0]) + ":", countTransactions.toString());
        }
    }

    private void printDtiReference(BLTable<?> t, String dtiReference, Date referenceDate) throws PDFException {
        if (dtiReference != null) {
            if (referenceDate != null) {
                dtiReference = (String)dtiReference + "   (" + this.sdf.format(referenceDate) + ")";
            }
            this.printLine(t, GeneralMessages.getInstance((Locale)this.locale).REFERENCE + ":", (String)dtiReference);
        }
    }

    private void printBankReference(BLTable<?> t, String bankReference) throws PDFException {
        this.printLine(t, Messages.getString(this.locale, "PrintAction.bankReference", new Object[0]), bankReference);
    }

    private void printAdditionalFields(BLTable<?> t, CmBooking b) throws PDFException {
        Boolean rating;
        this.printLine(t, Messages.getString(this.locale, "PrintAction.additionalInformation", new Object[0]), b.getAdditionalInformation());
        this.printAdditionalAmounts(t, b);
        this.printLine(t, BankingApiMessages.getString(this.locale, "CFONB120.bnpParibasTransactionCode", new Object[0]) + ":", CMUtil.getGvcWithDescription(b.getTransactionCode(), this.locale));
        this.printLine(t, Messages.getString(this.locale, "PrintAction.bookingKey", new Object[0]), CMUtil.getBookingKeyWithDescription(b.getBookingKey(), this.locale));
        this.printLine(t, Messages.getString(this.locale, "PrintAction.bookingText", new Object[0]), b.getBookingText());
        this.printLine(t, Messages.getString(this.locale, "PrintAction.businessTransactionCode", new Object[0]), CMUtil.getGvcWithDescription(b.getGvc(), this.locale));
        this.printLine(t, Messages.getString(this.locale, "PrintAction.isoBtc", new Object[0]), CMUtil.getIsoBTC(b.getDomainCode(), b.getFamilyCode(), b.getSubFamilyCode(), b.getGvc(), this.locale));
        this.printLine(t, Messages.getString(this.locale, "PrintAction.primanota", new Object[0]), b.getPrimanota());
        this.printLine(t, Messages.getString(this.locale, "PrintAction.textKeyAppendix", new Object[0]), CMUtil.getTextKeyAppendixWithDescription(b.getTextKeyAppendix(), this.locale));
        this.printLine(t, BankingApiMessages.getString(this.locale, "CFONB120.interbankTransactionCode", new Object[0]) + ":", b.getInterbankTransactionCode());
        this.printLine(t, BankingApiMessages.getString(this.locale, "CFONB120.rejectionCauseCode", new Object[0]) + ":", CMUtil.getRejectionWithDescription(b.getRejectionCauseCode(), this.locale));
        this.printLine(t, BankingApiMessages.getString(this.locale, "CFONB120.entryNumber", new Object[0]) + ":", b.getEntryNumber());
        Boolean exemption = b.getExemption();
        if (exemption != null) {
            this.printLine(t, BankingApiMessages.getString(this.locale, "CFONB120.exemptFromCharge", new Object[0]) + ":", exemption != false ? GeneralMessages.getInstance((Locale)this.locale).Yes : GeneralMessages.getInstance((Locale)this.locale).No);
        }
        if ((rating = b.getUnavailabiltyRating()) != null) {
            this.printLine(t, BankingApiMessages.getString(this.locale, "CFONB120.unavailabilityRating", new Object[0]) + ":", rating != false ? GeneralMessages.getInstance((Locale)this.locale).Yes : GeneralMessages.getInstance((Locale)this.locale).No);
        }
    }

    private void printAdditionalAmounts(BLTable<?> t, CmBooking b) throws PDFException {
        this.printAmountLine(t, Messages.getString(this.locale, "PrintAction.originalAmount", new Object[0]), b.getOriginalAmount(), b.getOriginalCurrency());
        this.printAmountLine(t, Messages.getString(this.locale, "PrintAction.convertedAmount", new Object[0]), b.getConvertedAmount(), b.getConvertedCurrency());
        List<CmCharge> charges = b.getCharges();
        if (charges == null || charges.size() == 0) {
            this.printAmountLine(t, Messages.getString(this.locale, "PrintAction.chargesAmount", new Object[0]), b.getChargesAmount(), b.getChargesCurrency());
        } else if (charges.size() == 1) {
            this.printChargeAmountLine(t, Messages.getString(this.locale, "PrintAction.charges", new Object[0]), charges.get(0));
        } else {
            this.printAmountLine(t, Messages.getString(this.locale, "PrintAction.chargesTotal", new Object[0]), b.getChargesAmount(), b.getChargesCurrency());
            for (CmCharge charge : charges) {
                this.printChargeAmountLine(t, Messages.getString(this.locale, "PrintAction.charges", new Object[0]), charge);
            }
        }
        this.printAmountLine(t, Messages.getString(this.locale, "PrintAction.settlementAmount", new Object[0]), b.getSettlementAmount(), b.getSettlementCurrency());
        if (b.getExchangeRate() != null) {
            String s = b.getExchangeRateDate() != null ? MessageFormat.format(Messages.getString(this.locale, "PrintAction.exchangeRateAtDate", new Object[0]), b.getExchangeRateDate()) : Messages.getString(this.locale, "PrintAction.exchangeRate", new Object[0]);
            this.addLine(t, s, NumberFormat.getNumberInstance().format(b.getExchangeRate()));
        }
        this.printLine(t, Messages.getString(this.locale, "PrintAction.feeArrangement", new Object[0]), b.getFeeType());
    }

    private void printAmountLine(BLTable<?> t, String label, BigDecimal amt, Currency ccy) throws PDFException {
        if (amt != null && ccy != null) {
            this.addLine(t, label, PaymentUtils.formatAmount(amt, ccy, this.locale));
        }
    }

    private void printChargeAmountLine(BLTable<?> t, String label, CmCharge charge) {
        try {
            Currency currency = Currency.getInstance(charge.getCurrencyCode());
            StringBuilder sb = new StringBuilder(PaymentUtils.formatAmount(charge.getAmount(), currency, this.locale));
            if (charge.getBankIdentification() != null) {
                sb.append("   (");
                String bankName = SclDirectory.getBankName(charge.getBankIdentification());
                if (bankName != null) {
                    sb.append(bankName);
                } else {
                    sb.append(charge.getBankIdentification());
                }
                sb.append(")");
            }
            this.addLine(t, label, sb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printLine(BLTable<?> t, String label, String value) throws PDFException {
        if (value != null && value.trim().length() > 0) {
            this.addLine(t, label, value);
        }
    }

    private void addLine(BLTable<?> detailsTable, String label, String value) throws PDFException {
        detailsTable.addCell(label, F);
        detailsTable.addCell(this.checkNull(value), F);
    }

    private String checkNull(String s) {
        return s != null ? s : "";
    }

    private String checkNull(Integer i) {
        if (i != null) {
            return String.valueOf(i);
        }
        return "";
    }

    @Override
    public void close() throws IOException {
        if (this.printGrandTotalAmount && (this.numberOfTables > 1 || !this.printTotalAmount)) {
            try {
                this.document.addTable(this.createGrandTotalAmountTable(this.totalAmountMap));
            }
            catch (PDFException d) {
                throw new IOException(d);
            }
        }
        try {
            this.document.close();
        }
        catch (PDFException pe) {
            throw new IOException(pe);
        }
    }

    private BLTable<?> createGrandTotalAmountTable(Map<Currency, AmountAndCountCollector> totalAmountMap) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(1);
        t.setBorder(BLBorder.TOP);
        t.setWidth(100.0f);
        for (Currency curr : totalAmountMap.keySet()) {
            AmountAndCountCollector amountAndCount = totalAmountMap.get(curr);
            this.printTotalAmountToTable(t, amountAndCount.getCount(), amountAndCount.getAmount(), curr, true);
        }
        return t;
    }

    private static class MyQueryConsumer
    implements Consumer<CmBooking> {
        boolean hasBookings = false;
        final Map<Currency, AmountAndCountCollector> totalAmountMap = new HashMap<Currency, AmountAndCountCollector>();
        final BLTable<?> t;
        final CmPrinter printer;
        PDFException exception;

        public MyQueryConsumer(BLTable<?> t, CmPrinter printer) {
            this.t = t;
            this.printer = printer;
        }

        @Override
        public void accept(CmBooking booking) {
            AmountAndCountCollector amountAndCount;
            this.hasBookings = true;
            CmBooking parent = booking.getParentBooking();
            if (parent != null && ((Object)parent.getStatement()).equals(booking.getStatement())) {
                return;
            }
            Currency currency = booking.getCurrency();
            if (this.totalAmountMap.containsKey(currency)) {
                amountAndCount = this.totalAmountMap.get(currency);
            } else {
                amountAndCount = new AmountAndCountCollector();
                this.totalAmountMap.put(currency, amountAndCount);
            }
            boolean hasPrintedSingleBookings = false;
            if (this.printer.printSingleBookings && booking.isCollective()) {
                List<CmBooking> singleBookings;
                List<CmStatement.Type> statementTypes = CmBooking.findChildStatementTypes(booking);
                if (statementTypes.size() > 0) {
                    CmStatement.Type statementType = CmBooking.getPreferredChildStatementType(statementTypes, booking);
                    singleBookings = CmBooking.findSingleBookings(booking, true, statementType);
                } else {
                    singleBookings = CmBooking.findSingleBookings(booking, true);
                }
                if (singleBookings != null && singleBookings.size() > 0) {
                    hasPrintedSingleBookings = true;
                    for (CmBooking singleBooking : singleBookings) {
                        try {
                            this.printer.addBooking(this.t, singleBooking);
                        }
                        catch (PDFException e) {
                            this.exception = e;
                        }
                        amountAndCount.addAmount(singleBooking.getAmount());
                        amountAndCount.incrementCount();
                    }
                }
            }
            if (!hasPrintedSingleBookings) {
                try {
                    this.printer.addBooking(this.t, booking);
                }
                catch (PDFException e) {
                    this.exception = e;
                }
                amountAndCount.addAmount(booking.getAmount());
                amountAndCount.incrementCount();
            }
        }

        private void addTotalsToPrinter() {
            for (Map.Entry<Currency, AmountAndCountCollector> e : this.totalAmountMap.entrySet()) {
                AmountAndCountCollector existing = this.printer.totalAmountMap.get(e.getKey());
                if (existing == null) {
                    this.printer.totalAmountMap.put(e.getKey(), e.getValue());
                    continue;
                }
                existing.addAmount(e.getValue().getAmount());
                existing.addCount(e.getValue().getCount());
            }
        }
    }

    private static final class AmountAndCountCollector {
        private BigDecimal amount;
        private int count;

        private AmountAndCountCollector() {
        }

        public void addAmount(BigDecimal amount) {
            this.amount = this.amount == null ? amount : this.amount.add(amount);
        }

        public BigDecimal getAmount() {
            if (this.amount == null) {
                return BigDecimal.ZERO;
            }
            return this.amount;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void addCount(int number) {
            this.count += number;
        }

        public int getCount() {
            return this.count;
        }
    }
}

