/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940;

import de.businesslogics.util.StringUtils;

public class BundesbankOrderTypes {
    private static final String[] ORDER_TYPES = new String[]{"YG1", "YGB", "YLB", "YGD", "QG3", "QE2", "QE4", "QE6"};
    private static final String[] COMPRESSED_ORDER_TYPES = new String[]{"YCG", "YCL", "YCD", "QE1", "QE3", "QE5"};
    private static final String[] DOMESTIC_ORDER_TYPES = new String[]{"YG2", "QG4"};
    private static final String[] FOREIGN_ORDER_TYPES = new String[]{"YWA", "QWA"};
    private static final String[] STEP2_ORDER_TYPES = new String[]{"YGS", "QEB", "YCS", "QE7"};
    private static final String[] ALL_ORDER_TYPES = new String[]{"YG2", "QG4", "YWA", "QWA", "YGS", "QEB", "YCS", "QE7"};

    private BundesbankOrderTypes() {
    }

    public static final boolean isValidDtaOrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, ORDER_TYPES);
    }

    public static boolean isValidDtaCompressedOrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, COMPRESSED_ORDER_TYPES);
    }

    public static final boolean isValidDomesticOrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, DOMESTIC_ORDER_TYPES);
    }

    public static final boolean isValidForeignOrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, FOREIGN_ORDER_TYPES);
    }

    public static final boolean isValidStep2OrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, STEP2_ORDER_TYPES);
    }

    public static final boolean isValidSwiftOrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, ALL_ORDER_TYPES);
    }
}

