/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import java.math.BigDecimal;

public class BookingStatistics {
    private BigDecimal sumCredits = BigDecimal.ZERO;
    private BigDecimal sumDebits = BigDecimal.ZERO;
    private int countCredits = 0;
    private BigDecimal smallestCredit;
    private BigDecimal highestCredit;
    private int countDebits = 0;
    private BigDecimal smallestDebit;
    private BigDecimal highestDebit;

    public BookingStatistics() {
        this.countCredits = 0;
        this.countDebits = 0;
        this.sumCredits = BigDecimal.ZERO;
        this.sumDebits = BigDecimal.ZERO;
        this.smallestCredit = null;
        this.highestCredit = null;
        this.smallestDebit = null;
        this.highestDebit = null;
    }

    private BookingStatistics(CmStatement statement) {
        this.countCredits = statement.getCountCredit();
        this.countDebits = statement.getCountDebit();
        this.sumCredits = statement.getSumCredit();
        this.sumDebits = statement.getSumDebit();
        this.smallestCredit = statement.getMinCredit();
        this.highestCredit = statement.getMaxCredit();
        this.smallestDebit = statement.getMinDebit();
        this.highestDebit = statement.getMaxDebit();
    }

    private BookingStatistics(CmPage page) {
        this.countCredits = page.getCountCredit();
        this.countDebits = page.getCountDebit();
        this.sumCredits = page.getSumCredit();
        this.sumDebits = page.getSumDebit();
        this.smallestCredit = page.getMinCredit();
        this.highestCredit = page.getMaxCredit();
        this.smallestDebit = page.getMinDebit();
        this.highestDebit = page.getMaxDebit();
    }

    public void addBooking(BigDecimal amount) {
        if (amount.signum() > 0) {
            ++this.countCredits;
            this.sumCredits = this.sumCredits.add(amount);
            if (this.countCredits > 1) {
                this.smallestCredit = this.smallestCredit.min(amount);
                this.highestCredit = this.highestCredit.max(amount);
            } else {
                this.smallestCredit = amount;
                this.highestCredit = amount;
            }
        } else {
            ++this.countDebits;
            this.sumDebits = this.sumDebits.add(amount);
            if (this.countDebits > 1) {
                this.smallestDebit = this.smallestDebit.max(amount);
                this.highestDebit = this.highestDebit.min(amount);
            } else {
                this.smallestDebit = amount;
                this.highestDebit = amount;
            }
        }
    }

    public void addStatement(CmStatement statement) {
        this.addStatistics(new BookingStatistics(statement));
    }

    public void addPage(CmPage page) {
        this.addStatistics(new BookingStatistics(page));
    }

    private void addStatistics(BookingStatistics other) {
        BigDecimal otherHighestDebit;
        BigDecimal otherSmallestDebit;
        BigDecimal otherHighestCredit;
        BigDecimal otherSmallestCredit;
        BigDecimal otherSumDebits;
        this.countCredits += other.getCountCredits();
        this.countDebits += other.getCountDebits();
        BigDecimal otherSumCredits = other.getSumCredits();
        if (otherSumCredits != null) {
            this.sumCredits = this.sumCredits != null ? this.sumCredits.add(otherSumCredits) : otherSumCredits;
        }
        if ((otherSumDebits = other.getSumDebits()) != null) {
            this.sumDebits = this.sumDebits != null ? this.sumDebits.add(otherSumDebits) : otherSumDebits;
        }
        if ((otherSmallestCredit = other.getSmallestCredit()) != null) {
            this.smallestCredit = this.smallestCredit != null ? this.smallestCredit.min(otherSmallestCredit) : otherSmallestCredit;
        }
        if ((otherHighestCredit = other.getHighestCredit()) != null) {
            this.highestCredit = this.highestCredit != null ? this.highestCredit.max(otherHighestCredit) : otherHighestCredit;
        }
        if ((otherSmallestDebit = other.getSmallestDebit()) != null) {
            this.smallestDebit = this.smallestDebit != null ? this.smallestDebit.max(otherSmallestDebit) : otherSmallestDebit;
        }
        if ((otherHighestDebit = other.getHighestDebit()) != null) {
            this.highestDebit = this.highestDebit != null ? this.highestDebit.min(otherHighestDebit) : otherHighestDebit;
        }
    }

    public BigDecimal getSumCredits() {
        return this.sumCredits;
    }

    public BigDecimal getSumDebits() {
        return this.sumDebits;
    }

    public int getCountCredits() {
        return this.countCredits;
    }

    public BigDecimal getSmallestCredit() {
        return this.smallestCredit;
    }

    public BigDecimal getHighestCredit() {
        return this.highestCredit;
    }

    public int getCountDebits() {
        return this.countDebits;
    }

    public BigDecimal getSmallestDebit() {
        return this.smallestDebit;
    }

    public BigDecimal getHighestDebit() {
        return this.highestDebit;
    }

    public void storeStatistics(CmStatement s) {
        s.setCountCredit(this.getCountCredits());
        s.setCountDebit(this.getCountDebits());
        s.setSumCredit(this.getSumCredits());
        s.setSumDebit(this.getSumDebits());
        s.setMinCredit(this.getSmallestCredit());
        s.setMinDebit(this.getSmallestDebit());
        s.setMaxCredit(this.getHighestCredit());
        s.setMaxDebit(this.getHighestDebit());
        DB.update(s);
    }

    public void storeStatistics(CmPage p) {
        p.setCountCredit(this.getCountCredits());
        p.setCountDebit(this.getCountDebits());
        p.setSumCredit(this.getSumCredits());
        p.setSumDebit(this.getSumDebits());
        p.setMinCredit(this.getSmallestCredit());
        p.setMinDebit(this.getSmallestDebit());
        p.setMaxCredit(this.getHighestCredit());
        p.setMaxDebit(this.getHighestDebit());
        DB.update(p);
    }
}

