/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt101.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;

public final class MT101RecipientData
extends RecipientData {
    private String name2;
    private String street;
    private String town;
    private String intermediaryBankCode;
    private String feeType;
    private String[] purposeArray;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.MT101;
    }

    @Override
    protected void loadRecipientInfo() throws IOException {
        Properties properties = this.loadRecipientInfoProperties();
        this.name2 = properties.getProperty(PropertiesKeys.NAME2.getKey());
        this.street = properties.getProperty(PropertiesKeys.STREET.getKey());
        this.town = properties.getProperty(PropertiesKeys.TOWN.getKey());
        this.intermediaryBankCode = properties.getProperty(PropertiesKeys.INTERMEDIARY_BANK_CODE.getKey());
        this.feeType = properties.getProperty(PropertiesKeys.FEE_TYPE.getKey());
    }

    @Override
    protected void buildRecipientInfo() throws IOException {
        Properties properties = new Properties();
        this.setProperty(properties, PropertiesKeys.NAME2, this.name2);
        this.setProperty(properties, PropertiesKeys.STREET, this.street);
        this.setProperty(properties, PropertiesKeys.TOWN, this.town);
        this.setProperty(properties, PropertiesKeys.INTERMEDIARY_BANK_CODE, this.intermediaryBankCode);
        this.setProperty(properties, PropertiesKeys.FEE_TYPE, this.feeType);
        this.setRecipientInfoProperties(properties);
        this.storePurposeArray();
    }

    @Override
    protected boolean hasFourEyesChange(PaymentRecipient originalVo) {
        if (this.hasGeneralChanges(originalVo)) {
            return true;
        }
        try {
            MT101RecipientData original = new MT101RecipientData();
            original.setPaymentRecipient(originalVo);
            if (StringUtils.valuesDiffer(this.name2, original.getName2())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.street, original.getStreet())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.town, original.getTown())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.intermediaryBankCode, original.getIntermediaryBankCode())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.feeType, original.getFeeType())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void csvExport(Writer writer, User user, Locale locale, char columnSeparator, boolean withHeader, String lineSeparator) throws IOException {
        if (withHeader) {
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.format", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.displayName", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.name", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.address1", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.address2", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.address3", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.accountNumberIban", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.blzBic", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, GeneralMessages.getInstance((Locale)locale).INTERMEDIARY_INSTITUTION, false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.feeType", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose2", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose3", new Object[0]), false, columnSeparator, lineSeparator);
            MT101RecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose4", new Object[0]), true, columnSeparator, lineSeparator);
        }
        MT101RecipientData.writeCsvFieldToWriter(writer, PaymentType.MT101.name(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getDisplayName(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getName(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getName2(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getStreet(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getTown(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getAccountNumber(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getBankCode(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getIntermediaryBankCode(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getFeeType(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getPurpose1(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getPurpose2(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getPurpose3(), false, columnSeparator, lineSeparator);
        MT101RecipientData.writeCsvFieldToWriter(writer, this.getPurpose4(), true, columnSeparator, lineSeparator);
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getIntermediaryBankCode() {
        return this.intermediaryBankCode;
    }

    public void setIntermediaryBankCode(String intermediaryBankCode) {
        this.intermediaryBankCode = intermediaryBankCode;
    }

    public String getFeeType() {
        if (this.feeType == null) {
            return "SHA";
        }
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getPurpose1() {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        return this.purposeArray[0];
    }

    public void setPurpose1(String purpose1) {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        this.purposeArray[0] = purpose1;
    }

    public String getPurpose2() {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        return this.purposeArray[1];
    }

    public void setPurpose2(String purpose2) {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        this.purposeArray[1] = purpose2;
    }

    public String getPurpose3() {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        return this.purposeArray[2];
    }

    public void setPurpose3(String purpose3) {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        this.purposeArray[2] = purpose3;
    }

    public String getPurpose4() {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        return this.purposeArray[3];
    }

    public void setPurpose4(String purpose4) {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        this.purposeArray[3] = purpose4;
    }

    private void storePurposeArray() {
        if (this.purposeArray == null) {
            return;
        }
        StringBuilder purposeBuilder = new StringBuilder();
        for (int i = 0; i < this.purposeArray.length; ++i) {
            if (i > 0) {
                purposeBuilder.append('\n');
            }
            if (this.purposeArray[i] == null) continue;
            purposeBuilder.append(this.purposeArray[i]);
        }
        this.getPaymentRecipient().setPurpose(purposeBuilder.toString());
    }

    private void loadPurposeArray() {
        this.purposeArray = new String[4];
        if (this.getPaymentRecipient().getPurpose() != null) {
            String[] splittedPurpose = this.getPaymentRecipient().getPurpose().split("\\r|\\n|\\r\\n");
            for (int i = 0; i < Math.min(splittedPurpose.length, this.purposeArray.length); ++i) {
                this.purposeArray[i] = splittedPurpose[i];
            }
        }
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    private static enum PropertiesKeys {
        NAME2("name2"),
        STREET("street"),
        TOWN("town"),
        INTERMEDIARY_BANK_CODE("intermediaryBankCode"),
        FEE_TYPE("feeType");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

