/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt101.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.mt101.api.MT101ApiMessages;
import de.businesslogics.banking.payments.api.BankingPaymentPrinter;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.PaymentUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MT101PaymentPrinter
extends BankingPaymentPrinter {
    public MT101PaymentPrinter(Locale locale) {
        super(locale);
    }

    public void printPayment(BLDocument document, Send send, MT101PaymentData payment, String reference) throws PDFException {
        int i;
        BLTable<?> t = PDFCreator.getInstance().createTable(4);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(100.0f);
        t.setWidths(new int[]{17, 33, 17, 33});
        String headerText = MT101ApiMessages.getString(this.locale, "printer.mt101payment", new Object[0]);
        this.printHeaderLine(t, headerText);
        if (send != null) {
            this.printOrderInfo(t, send, reference);
        }
        t.setDefaultColspan(2);
        t.addCell(this.getTextOriginatorData(true), BOLD_FONT);
        t.addCell(this.getTextRecipientData(true), BOLD_FONT);
        t.setDefaultColspan(1);
        String textName = this.getTextName();
        t.addCell(textName, FONT);
        t.addCell(payment.getOriginatorName(), FONT);
        t.addCell(textName, FONT);
        t.addCell(payment.getRecipientName(), FONT);
        String textIban = this.getTextAccountNumber();
        t.addCell(textIban, FONT);
        if (IbanUtil.checkIban(payment.getOriginatorAccount())) {
            t.addCell(IbanUtil.formatIBAN(payment.getOriginatorAccount()), FONT);
        } else {
            t.addCell(payment.getOriginatorAccount(), FONT);
        }
        t.addCell(textIban, FONT);
        if (IbanUtil.checkIban(payment.getRecipientAccount())) {
            t.addCell(IbanUtil.formatIBAN(payment.getRecipientAccount()), FONT);
        } else {
            t.addCell(payment.getRecipientAccount(), FONT);
        }
        t.addCell(this.getTextBic(), FONT);
        t.addCell(payment.getOriginatorBic(), FONT);
        t.addCell(this.getTextBlz(), FONT);
        t.addCell(payment.getRecipientBankCode(), FONT);
        List<String> oData = this.getOriginatorData(payment);
        List<String> rData = this.getRecipientData(payment);
        boolean originatorHasMoreLines = false;
        int max = oData.size();
        if (rData.size() < max) {
            max = rData.size();
            originatorHasMoreLines = true;
        }
        for (i = 0; i < max; i += 2) {
            t.addCell(oData.get(i));
            t.addCell(oData.get(i + 1));
            t.addCell(rData.get(i));
            t.addCell(rData.get(i + 1));
        }
        if (originatorHasMoreLines) {
            while (i < oData.size()) {
                t.addCell(oData.get(i));
                t.addCell(oData.get(i + 1));
                this.addEmptyCells(t, 2);
                i += 2;
            }
        } else {
            while (i < rData.size()) {
                this.addEmptyCells(t, 2);
                t.addCell(rData.get(i));
                t.addCell(rData.get(i + 1));
                i += 2;
            }
        }
        t.setDefaultColspan(4);
        this.addEmptyCell(t);
        t.addCell(this.getTextPaymentData(), BOLD_FONT);
        t.setDefaultColspan(1);
        t.addCell(this.getTextAmount(), FONT);
        t.addCell(PaymentUtils.formatAmount(payment.getAmount(), payment.getCurrency(), this.locale), FONT);
        t.addCell(this.getTextExecutionDate(true), FONT);
        Date d = null;
        try {
            d = payment.getExecutionDateAsDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.printDate(t, d);
        t.addCell(this.getTextCurrency());
        t.addCell(payment.getCurrency().getCurrencyCode());
        boolean pruposeLeft = false;
        if (payment.getFeeType() != null && !payment.getFeeType().isEmpty()) {
            t.addCell(this.getTextFeeType(), FONT);
            t.addCell(payment.getFeeType(), FONT);
            pruposeLeft = true;
        }
        t.addCell(this.getTextReference(), FONT);
        t.addCell(payment.getTransactionReference(), FONT);
        if (!pruposeLeft) {
            this.addEmptyCells(t, 2);
        }
        t.addCell(this.getTextPurpose(), FONT);
        t.addCell(payment.getPurpose(), FONT);
        this.addEmptyCells(t, 2);
        t.addCell("", FONT);
        t.addCell(payment.getPurpose2(), FONT);
        this.addEmptyCells(t, 2);
        t.addCell("", FONT);
        t.addCell(payment.getPurpose3(), FONT);
        this.addEmptyCells(t, 2);
        t.addCell("", FONT);
        t.addCell(payment.getPurpose4(), FONT);
        document.addTable(t);
    }

    private List<String> getRecipientData(MT101PaymentData payment) {
        boolean townPresent;
        ArrayList<String> list = new ArrayList<String>();
        if (payment == null) {
            return list;
        }
        String intermediary = payment.getIntermediaryBankCode();
        if (intermediary != null && intermediary.trim().length() > 0) {
            list.add(this.getTextIntermediaryInstitution());
            list.add(payment.getIntermediaryBankCode());
        }
        boolean name2Present = payment.getRecipientName2() != null && !payment.getRecipientName2().isEmpty();
        boolean streetPresent = payment.getRecipientStreet() != null && !payment.getRecipientStreet().isEmpty();
        boolean bl = townPresent = payment.getRecipientTown() != null && !payment.getRecipientTown().isEmpty();
        if (name2Present || streetPresent || townPresent) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.address", new Object[0]));
            if (name2Present) {
                list.add(payment.getRecipientName2());
                if (streetPresent || townPresent) {
                    list.add("");
                }
            }
            if (streetPresent) {
                list.add(payment.getRecipientStreet());
                if (townPresent) {
                    list.add("");
                }
            }
            if (townPresent) {
                list.add(payment.getRecipientTown());
            }
        }
        return list;
    }

    private List<String> getOriginatorData(MT101PaymentData payment) {
        boolean townPresent;
        ArrayList<String> list = new ArrayList<String>();
        if (payment == null) {
            return list;
        }
        if (payment.getSenderBic() != null && !payment.getSenderBic().isEmpty()) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.sendingInstitute", new Object[0]));
            list.add(payment.getSenderBic());
        }
        if (payment.getReceiverBic() != null && !payment.getReceiverBic().isEmpty()) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.receivingInstitute", new Object[0]));
            list.add(payment.getReceiverBic());
        }
        boolean name2Present = payment.getOriginatorName2() != null && !payment.getOriginatorName2().isEmpty();
        boolean streetPresent = payment.getOriginatorStreet() != null && !payment.getOriginatorStreet().isEmpty();
        boolean bl = townPresent = payment.getOriginatorTown() != null && !payment.getOriginatorTown().isEmpty();
        if (name2Present || streetPresent || townPresent) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.address", new Object[0]));
            if (name2Present) {
                list.add(payment.getOriginatorName2());
                if (streetPresent || townPresent) {
                    list.add("");
                }
            }
            if (streetPresent) {
                list.add(payment.getOriginatorStreet());
                if (townPresent) {
                    list.add("");
                }
            }
            if (townPresent) {
                list.add(payment.getOriginatorTown());
            }
        }
        return list;
    }
}

