/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt101.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt101.api.MT101ApiMessages;
import de.businesslogics.banking.payments.api.PaymentImportHandler;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.format.swift.mt101.MT101Extractor;
import de.businesslogics.format.swift.mt101.MT101LogicalFile;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class MT101PaymentImportHandler
extends PaymentImportHandler {
    public MT101PaymentImportHandler(BLLogger logger) {
        super(logger, Locale.getDefault());
    }

    public MT101PaymentImportHandler(BLLogger logger, Locale locale) {
        super(logger, locale);
    }

    public void readFrom(InputStream inputStream, BankSettings bankSettings, PaymentTransferType.PmtType pmtType, User user) throws IOException {
        this.accounts = this.loadAccounts(user, bankSettings, pmtType, PermissionsLoader.AccountType.IBAN_OR_NAT_ACC_NUMBER_AND_BIC);
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording(user);
        try {
            for (MT101LogicalFile mt101LogicalFile : new MT101Extractor().getLogicalFiles(inputStream)) {
                for (MT101PaymentData payment : mt101LogicalFile.getPayments()) {
                    String originatorName = payment.getOriginatorName();
                    if (originatorName == null || originatorName.trim().length() == 0) {
                        if (this.logger != null) {
                            this.logger.logWarning("Could not import payment with option 50G - originator name is missing!");
                        }
                        this.addIgnoredPayment(MT101ApiMessages.getString(this.locale, "import.nooriginator", new Object[0]));
                        continue;
                    }
                    String recipientName = payment.getRecipientName();
                    if (recipientName == null || recipientName.trim().length() == 0) {
                        if (this.logger != null) {
                            this.logger.logWarning("Could not import payment with option 59A - recipient name is missing!");
                        }
                        this.addIgnoredPayment(MT101ApiMessages.getString(this.locale, "import.norecipient", new Object[0]));
                        continue;
                    }
                    BankSettings bank = this.loadBank(payment);
                    if (bank == null) {
                        StringBuilder accountNumber = new StringBuilder();
                        if (payment.getOriginatorBic() != null && !payment.getOriginatorBic().isEmpty()) {
                            accountNumber.append(payment.getOriginatorBic()).append('/');
                        }
                        accountNumber.append(payment.getOriginatorAccount());
                        this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.unknownOriginatorAccount", accountNumber.toString()));
                        continue;
                    }
                    boolean checkPermissions = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, bank.getTenant()).getBoolean(PreferenceConstants.CHECK_PERMISSION_FOR_PAYMENT_RECORDING);
                    if (checkPermissions && bankSettings != null) {
                        String orderTypeOrBtf;
                        Account originatorAccount = IbanUtil.checkIban(payment.getOriginatorAccount()) ? Account.findAccountByIbanBic(bankSettings, payment.getOriginatorAccount(), payment.getOriginatorBic(), null) : Account.findAccountByNationalAccountNumberBic(bankSettings, payment.getOriginatorBic(), payment.getOriginatorAccount(), null);
                        String string = orderTypeOrBtf = BankUtils.isProtocolH005OrNewer(bankSettings.getProtocolVersion()) ? SendParameters.getBTF(bankSettings, pmtType) : SendParameters.getOrderType(bankSettings, pmtType);
                        if (originatorAccount == null || new PermissionsLoader(user).getAccountOrderTypes(originatorAccount, new String[]{orderTypeOrBtf}).isEmpty()) {
                            String accountNumber = payment.getOriginatorAccount();
                            this.logger.logInfo("No permission for originator account " + accountNumber + " or for order type " + orderTypeOrBtf);
                            this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.noPermissionForAccountOrOrderType", orderTypeOrBtf, accountNumber));
                            continue;
                        }
                    }
                    if (!allowRecipientRecording && PaymentRecipient.findRecipientByAccountInfo(PaymentType.MT101, recipientName, payment.getRecipientAccount(), payment.getRecipientBankCode(), bank.getTenant()) == null) {
                        this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.unknownRecipient", recipientName));
                        if (this.logger == null) continue;
                        this.logger.logWarning("Could not import payment with unknown recipient '" + recipientName + "'");
                        continue;
                    }
                    this.createPayment(bank, pmtType, payment);
                }
            }
        }
        catch (Exception e) {
            this.logger.logError("Exception during MT101 import", e);
            throw new IOException(e);
        }
    }

    protected abstract Account checkForReplaceAccount(List<Account> var1, String var2, String var3);

    protected abstract void createPayment(BankSettings var1, PaymentTransferType.PmtType var2, MT101PaymentData var3);

    private BankSettings loadBank(MT101PaymentData paymentData) {
        String accountNumber = paymentData.getOriginatorAccount();
        boolean paymentHasIban = IbanUtil.checkIban(accountNumber);
        String bic = paymentData.getOriginatorBic();
        for (Object account : this.accounts) {
            if (!(paymentHasIban ? accountNumber.equals(((Account)account).getIban()) && bic.equals(((Account)account).getBic()) : accountNumber.equals(((Account)account).getNationalAccountNumber()) && bic.equals(((Account)account).getBic()))) continue;
            return ((Account)account).getBank();
        }
        ArrayList<Account> replaceableAccounts = new ArrayList<Account>();
        for (Account account : this.accounts) {
            replaceableAccounts.add(account);
        }
        if (replaceableAccounts.size() == 0) {
            if (this.logger != null) {
                this.logger.logWarning("Could not import payment. Found no replaceable accounts");
            }
            return null;
        }
        Account replaceAccount = this.checkForReplaceAccount(replaceableAccounts, bic, accountNumber);
        if (replaceAccount != null) {
            paymentData.setOriginatorBic(replaceAccount.getBic());
            if (replaceAccount.getIban() != null && replaceAccount.getIban().length() > 0) {
                paymentData.setOriginatorAccount(replaceAccount.getIban());
            } else if (replaceAccount.getNationalAccountNumber() != null && replaceAccount.getNationalAccountNumber().length() > 0) {
                paymentData.setOriginatorAccount(replaceAccount.getNationalAccountNumber());
            }
            return replaceAccount.getBank();
        }
        return null;
    }
}

