/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt101.api;

import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PaymentConversionHandler2;
import de.businesslogics.format.swift.mt101.csv.Converter;
import de.businesslogics.format.swift.mt101.csv.Format;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;

public class MT101PaymentConversionHandler
extends PaymentConversionHandler2<Format> {
    public MT101PaymentConversionHandler(BLLogger logger, File file) {
        super(logger, file);
    }

    @Override
    public Format getDefaultFormat() {
        return Format.DEFAULT_FORMAT;
    }

    @Override
    protected Format getFormat(ConverterFormat format) {
        return new Format(format.getFormat(), format.getCountryCode());
    }

    @Override
    protected int checkXls(Format format, boolean hasHeader) {
        return Converter.checkXLS(this.file, format, hasHeader);
    }

    @Override
    protected boolean checkCSVFile(Format format, boolean hasHeader) {
        return Converter.checkCSVFile(this.file, format, hasHeader);
    }

    @Override
    protected List<ConverterFormat> getFormats(User user) {
        List<ConverterFormat> formats = ConverterFormat.findAllByType(ConverterFormat.Type.MT101, user);
        if (formats.isEmpty()) {
            ConverterFormat format = new ConverterFormat();
            format.setType(ConverterFormat.Type.MT101);
            format.setFormat(Format.DEFAULT_FORMAT.toString());
            format.setEncoding(Charset.defaultCharset().name());
            format.setFieldSeparator(";");
            format.setHasHeader(true);
            format.setTenant(user.getTenants().get(0));
            format.save();
            formats.add(format);
        }
        return formats;
    }
}

