/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt101.api;

import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.payments.api.OriginatorData;
import java.io.IOException;
import java.util.Properties;

public class MT101OriginatorData
extends OriginatorData {
    private String name2;
    private String street;
    private String town;
    private String senderBic;
    private String receiverBic;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.MT101;
    }

    @Override
    protected void loadOriginatorInfo() throws IOException {
        Properties properties = this.loadOriginatorInfoProperties();
        this.name2 = properties.getProperty(PropertiesKeys.NAME2.getKey());
        this.street = properties.getProperty(PropertiesKeys.STREET.getKey());
        this.town = properties.getProperty(PropertiesKeys.TOWN.getKey());
        this.senderBic = properties.getProperty(PropertiesKeys.SENDER_BIC.getKey());
        this.receiverBic = properties.getProperty(PropertiesKeys.RECEIVER_BIC.getKey());
    }

    @Override
    protected void buildOriginatorInfo() throws IOException {
        Properties properties = new Properties();
        this.setProperty(properties, PropertiesKeys.NAME2, this.name2);
        this.setProperty(properties, PropertiesKeys.STREET, this.street);
        this.setProperty(properties, PropertiesKeys.TOWN, this.town);
        this.setProperty(properties, PropertiesKeys.SENDER_BIC, this.senderBic);
        this.setProperty(properties, PropertiesKeys.RECEIVER_BIC, this.receiverBic);
        this.setOriginatorInfoProperties(properties);
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getSenderBic() {
        return this.senderBic;
    }

    public void setSenderBic(String senderBic) {
        this.senderBic = senderBic;
    }

    public String getReceiverBic() {
        return this.receiverBic;
    }

    public void setReceiverBic(String receiverBic) {
        this.receiverBic = receiverBic;
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    private static enum PropertiesKeys {
        NAME2("name2"),
        STREET("street"),
        TOWN("town"),
        SENDER_BIC("senderBic"),
        RECEIVER_BIC("receiverBic");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

