/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt101.api;

import de.businesslogics.banking.api.AbstractLicenseHandler;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.payments.api.AbstractBankOrder;
import de.businesslogics.banking.payments.api.BankOrderCallback;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import de.businesslogics.banking.payments.api.FileNumberHandler;
import de.businesslogics.format.swift.mt101.MT101LogicalFile;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MT101Api {
    public static final String RFT = "RFT";
    private static final String RFT_BTF = "RFT_mt101";
    public static final String[] ORDER_TYPES = new String[]{"RFT", "RFT_mt101"};
    public static final boolean DEFAULT_ONE_LOGICAL_FILE_PER_ORDER = true;
    public static final boolean DEFAULT_SAVE_ACCOUNT_CURRENCY = false;
    public static final int MIN_SENDER_REFERENCE = 1;
    public static final int MAX_SENDER_REFERENCE = 9999;

    public static PaymentTransferType.PmtType getPmtType() {
        return PaymentTransferType.PmtType.MT101_TRANSFER;
    }

    public static boolean doMergeLogicalFiles(BankSettings bank) {
        Boolean oneLogicalFilePerOrder = PaymentProperties.findForBank(bank).getMT101OneLogicalFilePerOrder();
        if (oneLogicalFilePerOrder == null) {
            oneLogicalFilePerOrder = true;
        }
        return oneLogicalFilePerOrder == false;
    }

    public static boolean doSaveAccountCurrency(BankSettings bank) {
        Boolean saveAccountCurrency = PaymentProperties.findForBank(bank).getSaveMt101AccountCurrency();
        if (saveAccountCurrency == null) {
            saveAccountCurrency = false;
        }
        return saveAccountCurrency;
    }

    public static boolean isMt101PmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.FormatType.mt101.equals((Object)pmtType.getFormatType());
    }

    public static boolean isMt101OrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, ORDER_TYPES);
    }

    public static String getSenderReference(BankUser bankUser) {
        return String.valueOf(MT101Api.getSenderReferenceAsInt(bankUser));
    }

    private static int getSenderReferenceAsInt(BankUser bankUser) {
        return MT101Api.getSenderReferenceOffset(bankUser) + MT101Api.getRelativeSenderReference(bankUser);
    }

    public static int getRelativeSenderReference(BankUser bankUser) {
        return FileNumberHandler.getNumber(bankUser, FileNumberHandler.FileNumber.MT101_SENDER_REFERENCE, 1, 9999);
    }

    public static int getSenderReferenceOffset(BankUser bankUser) {
        int orderNumberPrefix;
        if (bankUser.getOrderNumber() != null && bankUser.getOrderNumber().length() > 0) {
            orderNumberPrefix = bankUser.getOrderNumber().charAt(0);
        } else if (bankUser.getUser().getLicense() != null && bankUser.getUser().getLicense().getContent() != null) {
            String licenseOrderNumber;
            AbstractLicenseHandler licenseHandler = AbstractLicenseHandler.getInstance();
            if (licenseHandler != null) {
                try {
                    licenseOrderNumber = AbstractLicenseHandler.getInstance().getLicenseProperties(bankUser.getUser()).getProperty("ORDER_NUMBER");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                licenseOrderNumber = null;
            }
            if (licenseOrderNumber != null && licenseOrderNumber.length() > 0) {
                orderNumberPrefix = licenseOrderNumber.charAt(0);
                bankUser.setOrderNumber(licenseOrderNumber);
                bankUser.save();
            } else {
                orderNumberPrefix = 65;
            }
        } else {
            orderNumberPrefix = 65;
        }
        int letterPosition = Character.getNumericValue((char)orderNumberPrefix) - 9 + 52;
        return letterPosition * 10000;
    }

    @Deprecated
    public static <BankOrderType extends AbstractBankOrder> Map<BankOrderType, List<OpenPayment>> createBankOrder(BankUser bankUser, String orderType, Iterator<BankOrderPayment<MT101PaymentData>> paymentsIterator, BankOrderCallback<BankOrderType> bankOrderCallback) throws InvalidPasswordException, KnownFormatException, DisplayFileException, IOException {
        List list;
        HashSet logicalFiles = new HashSet();
        while (paymentsIterator.hasNext()) {
            list = new ArrayList<BankOrderPayment<MT101PaymentData>>();
            list.add(paymentsIterator.next());
            logicalFiles.add(list);
        }
        Iterator iterator = logicalFiles.iterator();
        HashMap orders = new HashMap();
        if (MT101Api.doMergeLogicalFiles(bankUser.getBank())) {
            ArrayList<List<MT101PaymentData>> mt101LogicalFiles = new ArrayList<List<MT101PaymentData>>();
            ArrayList<OpenPayment> openPayments = new ArrayList<OpenPayment>();
            while (iterator.hasNext()) {
                List bankOrderPayments = (List)iterator.next();
                ArrayList<MT101PaymentData> mt101LogicalFile = new ArrayList<MT101PaymentData>(bankOrderPayments.size());
                for (BankOrderPayment bankOrderPayment : bankOrderPayments) {
                    mt101LogicalFile.add((MT101PaymentData)bankOrderPayment.getPaymentData());
                    openPayments.add(bankOrderPayment.getOpenPayment());
                }
                mt101LogicalFiles.add(mt101LogicalFile);
            }
            BankOrderType bankOrder = MT101Api.createOrderFileFromLogicalFiles(bankUser, orderType, mt101LogicalFiles, bankOrderCallback);
            orders.put(bankOrder, openPayments);
        } else {
            while (iterator.hasNext()) {
                list = (List)iterator.next();
                ArrayList<MT101PaymentData> paymentData = new ArrayList<MT101PaymentData>(list.size());
                ArrayList<OpenPayment> openPayments = new ArrayList<OpenPayment>(list.size());
                for (BankOrderPayment p : list) {
                    paymentData.add((MT101PaymentData)p.getPaymentData());
                    openPayments.add(p.getOpenPayment());
                }
                orders.put(MT101Api.createOrderFile(bankUser, orderType, paymentData, bankOrderCallback), openPayments);
            }
        }
        return orders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <BankOrderType extends AbstractBankOrder> BankOrderType createOrderFile(BankUser bankUser, String orderType, List<MT101PaymentData> payments, BankOrderCallback<BankOrderType> bankOrderCallback) throws IOException, InvalidPasswordException, KnownFormatException, DisplayFileException {
        File orderFile;
        CountingFilterOutputStream out = null;
        BankSettings bank = bankUser.getBank();
        try {
            orderFile = AbstractBankOrder.createOrderFile(bank.getUniqueKey(), orderType, null);
            out = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(orderFile));
            MT101PaymentData firstPayment = payments.get(0);
            int senderReference = MT101Api.getSenderReferenceAsInt(bankUser);
            firstPayment.setSenderReference(String.valueOf(senderReference));
            String transactionReference = firstPayment.getTransactionReference();
            if (transactionReference == null || transactionReference.trim().length() == 0) {
                firstPayment.setTransactionReference(senderReference + "-1");
            }
            MT101LogicalFile logicalFile = new MT101LogicalFile(firstPayment);
            for (int i = 1; i < payments.size(); ++i) {
                MT101PaymentData furtherPayment = payments.get(i);
                transactionReference = furtherPayment.getTransactionReference();
                if (transactionReference == null || transactionReference.trim().length() == 0) {
                    furtherPayment.setTransactionReference(senderReference + "-" + (i + 1));
                }
                logicalFile.getPayments().add(furtherPayment);
            }
            PaymentProperties p = PaymentProperties.findForBank(bank);
            logicalFile.save(out, p.getMT101SwiftHeader(), MT101Api.doSaveAccountCurrency(bank), senderReference, senderReference);
        }
        catch (Throwable throwable) {
            SystemUtils.close(out);
            throw throwable;
        }
        SystemUtils.close(out);
        return bankOrderCallback.createBankOrder(bank, MT101Api.getPmtType(), orderType, orderFile, out.getWritten());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <BankOrderType extends AbstractBankOrder> BankOrderType createOrderFileFromLogicalFiles(BankUser bankUser, String orderType, Collection<List<MT101PaymentData>> logicalFiles, BankOrderCallback<BankOrderType> bankOrderCallback) throws IOException, InvalidPasswordException, KnownFormatException, DisplayFileException {
        File orderFile;
        CountingFilterOutputStream out = null;
        BankSettings bank = bankUser.getBank();
        try {
            orderFile = AbstractBankOrder.createOrderFile(bank.getUniqueKey(), orderType, null);
            out = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(orderFile));
            for (List<MT101PaymentData> payments : logicalFiles) {
                MT101PaymentData firstPayment = payments.get(0);
                int senderReference = MT101Api.getSenderReferenceAsInt(bankUser);
                firstPayment.setSenderReference(String.valueOf(senderReference));
                String transactionReference = firstPayment.getTransactionReference();
                if (transactionReference == null || transactionReference.trim().length() == 0) {
                    firstPayment.setTransactionReference(senderReference + "-1");
                }
                MT101LogicalFile logicalFile = new MT101LogicalFile(firstPayment);
                for (int i = 1; i < payments.size(); ++i) {
                    MT101PaymentData furtherPayment = payments.get(i);
                    transactionReference = furtherPayment.getTransactionReference();
                    if (transactionReference == null || transactionReference.trim().length() == 0) {
                        furtherPayment.setTransactionReference(senderReference + "-" + (i + 1));
                    }
                    logicalFile.getPayments().add(furtherPayment);
                }
                PaymentProperties p = PaymentProperties.findForBank(bank);
                logicalFile.save(out, p.getMT101SwiftHeader(), MT101Api.doSaveAccountCurrency(bank), senderReference, senderReference);
            }
        }
        catch (Throwable throwable) {
            SystemUtils.close(out);
            throw throwable;
        }
        SystemUtils.close(out);
        return bankOrderCallback.createBankOrder(bank, MT101Api.getPmtType(), orderType, orderFile, out.getWritten());
    }
}

