/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.dta.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;

public final class DtazvRecipientData
extends RecipientData {
    private String name2;
    private String street;
    private String town;
    private String country;
    private String bankName2;
    private String bankStreet;
    private String bankTown;
    private String bankCountry;
    private String[] purposeArray;
    private String feeType;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
        String name = properties.getProperty(RecipientData.MultiwebPropertiesKeys.NAME.name());
        if (name != null && name.length() > 35) {
            this.setName(name.substring(0, 35).trim());
            this.setName2(name.substring(35).trim());
        } else {
            this.setName(name);
        }
        this.setStreet(properties.getProperty(RecipientData.MultiwebPropertiesKeys.STREET.name()));
        this.setTown(properties.getProperty(RecipientData.MultiwebPropertiesKeys.CITY.name()));
        this.setCountry(properties.getProperty(RecipientData.MultiwebPropertiesKeys.COUNTRY_CODE.name()));
        this.setAccountNumber(properties.getProperty(RecipientData.MultiwebPropertiesKeys.IBAN.name()));
        this.setBankCode(properties.getProperty(RecipientData.MultiwebPropertiesKeys.BANKCODE.name()));
        this.setBankName(properties.getProperty(RecipientData.MultiwebPropertiesKeys.BANK_NAME.name()));
        this.setBankStreet(properties.getProperty(RecipientData.MultiwebPropertiesKeys.BANK_STREET.name()));
        this.setBankTown(properties.getProperty(RecipientData.MultiwebPropertiesKeys.BANK_CITY.name()));
        this.setBankCountry(properties.getProperty(RecipientData.MultiwebPropertiesKeys.BANK_COUNTRY_CODE.name()));
        this.setFeeType(properties.getProperty(RecipientData.MultiwebPropertiesKeys.FEE_TYPE.name()));
        String purposeString = properties.getProperty(RecipientData.MultiwebPropertiesKeys.PURPOSE.name());
        if (purposeString != null) {
            String[] multiWebPurposeArray = purposeString.split("#");
            if (multiWebPurposeArray.length > 0) {
                this.setPurpose1(multiWebPurposeArray[0]);
            }
            if (multiWebPurposeArray.length > 1) {
                this.setPurpose2(multiWebPurposeArray[1]);
            }
            if (multiWebPurposeArray.length > 2) {
                this.setPurpose3(multiWebPurposeArray[2]);
            }
            if (multiWebPurposeArray.length > 3) {
                this.setPurpose4(multiWebPurposeArray[3]);
            }
        }
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.DTAZV;
    }

    @Override
    protected void loadRecipientInfo() throws IOException {
        Properties properties = this.loadRecipientInfoProperties();
        this.name2 = properties.getProperty(PropertiesKeys.NAME2.getKey());
        this.street = properties.getProperty(PropertiesKeys.STREET.getKey());
        this.town = properties.getProperty(PropertiesKeys.TOWN.getKey());
        this.country = properties.getProperty(PropertiesKeys.COUNTRY.getKey());
        this.bankName2 = properties.getProperty(PropertiesKeys.BANK_NAME2.getKey());
        this.bankStreet = properties.getProperty(PropertiesKeys.BANK_STREET.getKey());
        this.bankTown = properties.getProperty(PropertiesKeys.BANK_TOWN.getKey());
        this.bankCountry = properties.getProperty(PropertiesKeys.BANK_COUNTRY.getKey());
        this.feeType = properties.getProperty(PropertiesKeys.FEE_TYPE.getKey());
    }

    @Override
    protected void buildRecipientInfo() throws IOException {
        Properties properties = new Properties();
        this.setProperty(properties, PropertiesKeys.NAME2, this.name2);
        this.setProperty(properties, PropertiesKeys.STREET, this.street);
        this.setProperty(properties, PropertiesKeys.TOWN, this.town);
        this.setProperty(properties, PropertiesKeys.COUNTRY, this.country);
        this.setProperty(properties, PropertiesKeys.BANK_NAME2, this.bankName2);
        this.setProperty(properties, PropertiesKeys.BANK_STREET, this.bankStreet);
        this.setProperty(properties, PropertiesKeys.BANK_TOWN, this.bankTown);
        this.setProperty(properties, PropertiesKeys.BANK_COUNTRY, this.bankCountry);
        this.setProperty(properties, PropertiesKeys.FEE_TYPE, this.feeType);
        this.setRecipientInfoProperties(properties);
        this.storePurposeArray();
    }

    @Override
    protected boolean hasFourEyesChange(PaymentRecipient originalVo) {
        if (this.hasGeneralChanges(originalVo)) {
            return true;
        }
        try {
            DtazvRecipientData original = new DtazvRecipientData();
            original.setPaymentRecipient(originalVo);
            if (StringUtils.valuesDiffer(this.name2, original.getName2())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.street, original.getStreet())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.town, original.getTown())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.country, original.getCountry())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.getPaymentRecipient().getBankName(), originalVo.getBankName())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.bankName2, original.getBankName2())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.bankStreet, original.getBankStreet())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.bankTown, original.getBankTown())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.bankCountry, original.getBankCountry())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.feeType, original.getFeeType())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void csvExport(Writer writer, User user, Locale locale, char columnSeparator, boolean withHeader, String lineSeparator) throws IOException {
        if (withHeader) {
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.displayName", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.name", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.name2", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.street", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.city", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.country", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.accountNumberIban", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.blzBic", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.recipientBank", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.name2", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.street", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.city", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.country", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.feeType", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose2", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose3", new Object[0]), false, columnSeparator, lineSeparator);
            DtazvRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose4", new Object[0]), true, columnSeparator, lineSeparator);
        }
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getDisplayName(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getName(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getName2(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getStreet(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getTown(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getCountry(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getAccountNumber(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getBankCode(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getBankName(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getBankName2(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getBankStreet(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getBankTown(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getBankCountry(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getFeeType(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getPurpose1(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getPurpose2(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getPurpose3(), false, columnSeparator, lineSeparator);
        DtazvRecipientData.writeCsvFieldToWriter(writer, this.getPurpose4(), true, columnSeparator, lineSeparator);
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getBankName2() {
        return this.bankName2;
    }

    public void setBankName2(String bankName2) {
        this.bankName2 = bankName2;
    }

    public String getBankStreet() {
        return this.bankStreet;
    }

    public void setBankStreet(String bankStreet) {
        this.bankStreet = bankStreet;
    }

    public String getBankTown() {
        return this.bankTown;
    }

    public void setBankTown(String bankTown) {
        this.bankTown = bankTown;
    }

    public String getFeeType() {
        if (this.feeType == null) {
            return "0";
        }
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getBankCountry() {
        return this.bankCountry;
    }

    public void setBankCountry(String bankCountry) {
        this.bankCountry = bankCountry;
    }

    public String getPurpose1() {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        return this.purposeArray[0];
    }

    public void setPurpose1(String purpose1) {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        this.purposeArray[0] = purpose1;
    }

    public String getPurpose2() {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        return this.purposeArray[1];
    }

    public void setPurpose2(String purpose2) {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        this.purposeArray[1] = purpose2;
    }

    public String getPurpose3() {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        return this.purposeArray[2];
    }

    public void setPurpose3(String purpose3) {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        this.purposeArray[2] = purpose3;
    }

    public String getPurpose4() {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        return this.purposeArray[3];
    }

    public void setPurpose4(String purpose4) {
        if (this.purposeArray == null) {
            this.loadPurposeArray();
        }
        this.purposeArray[3] = purpose4;
    }

    private void storePurposeArray() {
        if (this.purposeArray == null) {
            return;
        }
        StringBuilder purposeBuilder = new StringBuilder();
        for (int i = 0; i < this.purposeArray.length; ++i) {
            if (i > 0) {
                purposeBuilder.append('\n');
            }
            if (this.purposeArray[i] == null) continue;
            purposeBuilder.append(this.purposeArray[i]);
        }
        this.getPaymentRecipient().setPurpose(purposeBuilder.toString());
    }

    private void loadPurposeArray() {
        this.purposeArray = new String[4];
        if (this.getPaymentRecipient().getPurpose() != null) {
            String[] splittedPurpose = this.getPaymentRecipient().getPurpose().split("\\r|\\n|\\r\\n");
            for (int i = 0; i < Math.min(splittedPurpose.length, this.purposeArray.length); ++i) {
                this.purposeArray[i] = splittedPurpose[i];
            }
        }
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    private static enum PropertiesKeys {
        NAME2("name2"),
        STREET("street"),
        TOWN("town"),
        COUNTRY("country"),
        BANK_NAME2("bankName2"),
        BANK_STREET("bankStreet"),
        BANK_TOWN("bankTown"),
        BANK_COUNTRY("bankCountry"),
        FEE_TYPE("feeType");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

