/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.dta.api;

import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.payments.api.OriginatorData;
import java.io.IOException;
import java.util.Properties;

public final class DtazvOriginatorData
extends OriginatorData {
    private String name2;
    private String street;
    private String town;
    private String contact;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
        String name = properties.getProperty(OriginatorData.MultiwebPropertiesKeys.NAME.name());
        if (name != null && name.length() > 35) {
            this.setName(name.substring(0, 35).trim());
            this.setName2(name.substring(35));
        } else {
            this.setName(name);
        }
        this.setStreet(properties.getProperty(OriginatorData.MultiwebPropertiesKeys.STREET.name()));
        this.setTown(properties.getProperty(OriginatorData.MultiwebPropertiesKeys.CITY.name()));
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.DTAZV;
    }

    @Override
    protected void loadOriginatorInfo() throws IOException {
        Properties properties = this.loadOriginatorInfoProperties();
        this.name2 = properties.getProperty(PropertiesKeys.NAME2.getKey());
        this.street = properties.getProperty(PropertiesKeys.STREET.getKey());
        this.town = properties.getProperty(PropertiesKeys.TOWN.getKey());
        this.contact = properties.getProperty(PropertiesKeys.CONTACT.getKey());
    }

    @Override
    protected void buildOriginatorInfo() throws IOException {
        Properties properties = new Properties();
        this.setProperty(properties, PropertiesKeys.NAME2, this.name2);
        this.setProperty(properties, PropertiesKeys.STREET, this.street);
        this.setProperty(properties, PropertiesKeys.TOWN, this.town);
        this.setProperty(properties, PropertiesKeys.CONTACT, this.contact);
        this.setOriginatorInfoProperties(properties);
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    private static enum PropertiesKeys {
        NAME2("name2"),
        STREET("street"),
        TOWN("town"),
        CONTACT("contact");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

