/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.dta.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.payments.api.PaymentImportHandler;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.format.dta.DTAReader;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class DtazvImportHandler
extends PaymentImportHandler {
    public DtazvImportHandler(BLLogger logger) {
        super(logger, Locale.getDefault());
    }

    public DtazvImportHandler(BLLogger logger, Locale locale) {
        super(logger, locale);
    }

    public void readFrom(InputStream inputStream, BankSettings bankSettings, PaymentTransferType.PmtType pmtType, User user) throws IOException {
        DTAZVPayment payment;
        this.accounts = this.loadAccounts(user, bankSettings, pmtType, PermissionsLoader.AccountType.GERMAN);
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording(user);
        DTAReader reader = new DTAReader(inputStream);
        while ((payment = DTAZVPayment.readFrom(reader)) != null) {
            ArrayList<DTAZVTransaction> transactions = new ArrayList<DTAZVTransaction>(payment.getTransactions());
            for (DTAZVTransaction transaction : transactions) {
                payment.getTransactions().clear();
                payment.getTransactions().add(transaction);
                BankSettings bank = this.getBank(transaction, this.accounts);
                if (bank == null) {
                    this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.unknownOriginatorAccount", payment.getBlz() + "/" + transaction.getAccount()));
                    this.logger.logInfo("Did not find originator account " + payment.getBlz() + "/" + transaction.getAccount() + ", payment is ignored in DTAZV import!");
                    continue;
                }
                boolean checkPermissions = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, bank.getTenant()).getBoolean(PreferenceConstants.CHECK_PERMISSION_FOR_PAYMENT_RECORDING);
                if (!allowRecipientRecording) {
                    if (DtazvApi.isChequePaymentType(Byte.toString(transaction.getPaymentType())) && !DtazvApi.chequeRecipientExists(transaction.getRecipient(), bank.getTenant())) {
                        this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.unknownRecipient", transaction.getRecipient()));
                        this.logger.logInfo("Ignored DTAZV payment as the recipient " + transaction.getRecipient() + "is unknown!");
                        continue;
                    }
                    if (!DtazvApi.recipientExists(transaction.getRecipient(), this.getIban(transaction), transaction.getBic(), bank.getTenant())) {
                        this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.unknownRecipient", transaction.getRecipient()));
                        this.logger.logInfo("Ignored DTAZV payment as the recipient " + transaction.getRecipient() + "is unknown!");
                        continue;
                    }
                }
                if (checkPermissions && bankSettings != null) {
                    String orderTypeOrBtf;
                    Account originatorAccount = Account.findGermanAccount(bankSettings, String.valueOf(transaction.getBlz()), String.valueOf(transaction.getAccount()), transaction.getAccountCurrency());
                    String string = orderTypeOrBtf = BankUtils.isProtocolH005OrNewer(bankSettings.getProtocolVersion()) ? SendParameters.getBTF(bankSettings, pmtType) : SendParameters.getOrderType(bankSettings, pmtType);
                    if (originatorAccount == null || new PermissionsLoader(user).getAccountOrderTypes(originatorAccount, new String[]{orderTypeOrBtf}).isEmpty()) {
                        this.logger.logInfo("No permission for originator account " + payment.getBlz() + "/" + transaction.getAccount() + " or for order type " + orderTypeOrBtf);
                        this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.noPermissionForAccountOrOrderType", orderTypeOrBtf, payment.getBlz() + "/" + transaction.getAccount()));
                        continue;
                    }
                }
                this.createPayment(bank, pmtType, payment);
            }
            if (payment != null) continue;
        }
    }

    protected abstract void createPayment(BankSettings var1, PaymentTransferType.PmtType var2, DTAZVPayment var3);

    protected abstract Account checkForReplaceAccount(List<Account> var1, int var2, long var3);

    protected abstract void handleException(Exception var1);

    private BankSettings getBank(DTAZVTransaction item, List<Account> accounts) {
        for (Account a : accounts) {
            if (a.getGermanAccountNumber() == null || a.getGermanAccountNumber().length() <= 0 || a.getGermanBankCode() == null || a.getGermanBankCode().length() <= 0 || Long.parseLong(a.getGermanAccountNumber()) != item.getAccount() || Integer.parseInt(a.getGermanBankCode()) != item.getBlz()) continue;
            return a.getBank();
        }
        Account replaceAccount = this.checkForReplaceAccount(accounts, item.getBlz(), item.getAccount());
        if (replaceAccount != null) {
            item.setBlz(Integer.parseInt(replaceAccount.getGermanBankCode()));
            item.setAccount(Long.parseLong(replaceAccount.getGermanAccountNumber()));
            item.setAccountCurrency(replaceAccount.getCurrency());
            return replaceAccount.getBank();
        }
        return null;
    }

    private String getIban(DTAZVTransaction transaction) {
        if (transaction == null || transaction.getIban() == null) {
            return null;
        }
        if (!transaction.getIban().isEmpty() && transaction.getIban().charAt(0) == '/') {
            return transaction.getIban().substring(1);
        }
        return transaction.getIban();
    }
}

