/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.dta.api;

import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.payments.api.AbstractBankOrder;
import de.businesslogics.banking.payments.api.BankOrderCallback;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import de.businesslogics.banking.payments.api.FileNumberHandler;
import de.businesslogics.format.dta.DTAWriter;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.format.dta.DtazvPaymentType;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.util.StringUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DtazvApi
extends de.businesslogics.format.dta.DtazvApi {
    public static final boolean DEFAULT_ONE_LOGICAL_FILE_PER_ORDER = true;
    public static final int MIN_SEQ_NUMBER = 1;
    public static final int MAX_SEQ_NUMBER = 99;
    public static final String ORDER_TYPE_ESU = "ESU";
    public static final String ORDER_TYPE_EUE = "EUE";
    public static final String ORDER_TYPE_AZV = "AZV";
    private static final String AZV_BTF = "XCT:DE_dtazv";
    public static final String[] ORDER_TYPES = new String[]{"AZV", "XCT:DE_dtazv"};
    private static final String[] ALL_ORDER_TYPES = new String[]{"AZV", "XCT:DE_dtazv"};
    public static final int MAX_LENGTH_ORIGINATOR = 35;
    public static final int MAX_LENGTH_RECIPIENT = 35;
    public static final int MAX_LENGTH_ORDER_COMMENT = 35;
    public static final int MAX_LENGTH_RECIPIENT_BANK = 35;
    public static final int MAX_LENGTH_PURPOSE = 35;
    public static final int MAX_LENGTH_INSTRUCTIONS = 25;
    public static final int MAX_LENGTH_REFERENCE = 27;
    public static final int MAX_LENGTH_CONTACT = 35;
    public static final int MAX_LENGTH_COMPANY_NUMBER = 8;
    public static final int MAX_LENGTH_CUSTOMER_NUMBER = 10;
    public static final BigDecimal MAX_AMOUNT_ESU = new BigDecimal("50000.00");
    public static final BigDecimal MAX_AMOUNT_DTAZV = new BigDecimal("99999999999999.999");
    public static final BigDecimal MAX_AMOUNT_DTAZV_MESSAGE = new BigDecimal("999999999999");

    public static boolean isGeneralAzvPaymentType(String paymentType) {
        DtazvPaymentType dtazvPaymentType = DtazvPaymentType.getForKey(paymentType);
        return dtazvPaymentType != null && dtazvPaymentType.isGeneral();
    }

    public static boolean isDtazvOrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, ALL_ORDER_TYPES);
    }

    public static boolean isDtazvPmtType(PaymentTransferType.PmtType pmtType) {
        return pmtType != null && PaymentTransferType.FormatType.dtazv.equals((Object)pmtType.getFormatType());
    }

    public static PaymentTransferType.PmtType getPmtType() {
        return PaymentTransferType.PmtType.DTAZV_TRANSFER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <BankOrderType extends AbstractBankOrder> Map<BankOrderType, List<OpenPayment>> createBankOrder(BankUser bankUser, String orderType, Iterator<BankOrderPayment<DTAZVPayment>> paymentsIterator, BankOrderCallback<BankOrderType> bankOrderCallback) throws InvalidPasswordException, KnownFormatException, DisplayFileException, IOException {
        CountingFilterOutputStream os;
        File orderFile;
        DTAZVPayment group;
        List<OpenPayment> openPayments;
        HashMap<String, DTAZVPayment> logicalFilesMap = new HashMap<String, DTAZVPayment>();
        HashMap openPaymentMap = new HashMap();
        while (paymentsIterator.hasNext()) {
            BankOrderPayment<DTAZVPayment> p = paymentsIterator.next();
            String logicalFileKey = DtazvApi.getLogicalFileKey(p.getPaymentData());
            openPayments = (ArrayList<OpenPayment>)openPaymentMap.get(logicalFileKey);
            if (openPayments != null) {
                group = (DTAZVPayment)logicalFilesMap.get(logicalFileKey);
                group.getTransactions().addAll(p.getPaymentData().getTransactions());
                openPayments.add(p.getOpenPayment());
                continue;
            }
            p.getPaymentData().setCreationDate(new Date());
            p.getPaymentData().setSequentialNumber((byte)FileNumberHandler.getNumber(bankUser, FileNumberHandler.FileNumber.DTAZV_SEQUENCE_NUMBER, 1, 99));
            logicalFilesMap.put(logicalFileKey, p.getPaymentData());
            openPayments = new ArrayList();
            openPayments.add(p.getOpenPayment());
            openPaymentMap.put(logicalFileKey, openPayments);
        }
        Boolean oneLogicalFilePerOrder = PaymentProperties.findForBank(bankUser.getBank()).getDtazvOneLogicalFilePerOrder();
        if (oneLogicalFilePerOrder == null) {
            oneLogicalFilePerOrder = true;
        }
        if (oneLogicalFilePerOrder.booleanValue() && logicalFilesMap.size() > 1) {
            HashMap<BankOrderType, ArrayList<OpenPayment>> orders = new HashMap<BankOrderType, ArrayList<OpenPayment>>();
            DTAWriter writer2 = null;
            for (String key : logicalFilesMap.keySet()) {
                CountingFilterOutputStream os2;
                File orderFile2;
                try {
                    orderFile2 = AbstractBankOrder.createOrderFile(bankUser.getBank().getUniqueKey(), orderType, null);
                    os2 = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(orderFile2));
                    writer2 = new DTAWriter(os2);
                    group = (DTAZVPayment)logicalFilesMap.get(key);
                    DtazvApi.setEarliestExecutionDateInQ8(group);
                    group.writeTo(writer2);
                }
                finally {
                    if (writer2 != null) {
                        try {
                            writer2.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                openPayments = (List)openPaymentMap.get(key);
                orders.put(bankOrderCallback.createBankOrder(bankUser.getBank(), DtazvApi.getPmtType(), orderType, orderFile2, os2.getWritten()), (ArrayList<OpenPayment>)openPayments);
            }
            return orders;
        }
        openPayments = new ArrayList<OpenPayment>();
        DTAWriter writer = null;
        try {
            orderFile = AbstractBankOrder.createOrderFile(bankUser.getBank().getUniqueKey(), orderType, null);
            os = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(orderFile));
            writer = new DTAWriter(os);
            for (String key : logicalFilesMap.keySet()) {
                group = (DTAZVPayment)logicalFilesMap.get(key);
                DtazvApi.setEarliestExecutionDateInQ8(group);
                group.writeTo(writer);
                openPayments.addAll((Collection)openPaymentMap.get(key));
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException writer2) {}
            }
        }
        HashMap<BankOrderType, ArrayList<OpenPayment>> oneFile = new HashMap<BankOrderType, ArrayList<OpenPayment>>();
        oneFile.put(bankOrderCallback.createBankOrder(bankUser.getBank(), DtazvApi.getPmtType(), orderType, orderFile, os.getWritten()), (ArrayList<OpenPayment>)openPayments);
        return oneFile;
    }

    private static String getLogicalFileKey(DTAZVPayment p) {
        int separator = 58;
        return String.valueOf(':') + p.getCustomerNumber() + ":" + p.getOriginator() + ":" + p.getOriginator2() + ":" + p.getOriginator3() + ":" + p.getOriginator4() + ":" + p.isBundesbankReport() + ":" + p.getCountryCode() + ":" + p.getCompanyCode();
    }

    private static void setEarliestExecutionDateInQ8(DTAZVPayment group) {
        Date earliestExecutionDate = null;
        for (DTAZVTransaction t : group.getTransactions()) {
            Date executionDate = t.getExecutionDate();
            if (executionDate == null || earliestExecutionDate != null && !earliestExecutionDate.after(executionDate)) continue;
            earliestExecutionDate = executionDate;
        }
        if (earliestExecutionDate != null) {
            group.setExecutionDate(earliestExecutionDate);
        }
    }

    public static boolean recipientExists(String recipient, String iban, String bic, Tenant tenant) {
        return PaymentRecipient.findRecipientByAccountInfo(PaymentType.DTAZV, recipient, iban, bic, tenant) != null;
    }

    public static boolean chequeRecipientExists(String recipient, Tenant tenant) {
        List<PaymentRecipient> recipients = PaymentRecipient.findRecipientByName(PaymentType.DTAZV, recipient, tenant);
        return recipients != null && !recipients.isEmpty();
    }

    private DtazvApi() {
    }
}

