/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.ds.api;

import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.ebics.schema.orders.HVDResponseOrderData;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;

public class DsUtil {
    private static final String[] executionDateKeywords = new String[]{"Ausfuehrung", "Faelligkeit", "Execution", "Settlement", "Ausf\u00fchrung", "FRUEHEST.AUSFUEHRUNGSTERMIN", "Requested execution date", "EARLIEST EXECUTION DATE", "Date d'ex\u00e9cution"};
    private static final SimpleDateFormat[] simpleDateFormats = new SimpleDateFormat[]{new SimpleDateFormat("dd.MM.yyyy"), new SimpleDateFormat("dd.MM.yy"), new SimpleDateFormat("dd/MM/yyyy")};

    public static String getUniqueExecutionDate(DsOpenOrder data) {
        try {
            List<String> executionsDates;
            if (data != null && data.getTicketAsString() != null && (executionsDates = DsUtil.getExecutionDates(DsOpenOrder.getTicket(data.getTicket()))) != null && executionsDates.size() == 1) {
                return executionsDates.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getUniqueExecutionDate(HVDResponseOrderData data) {
        List<String> executionsDates = DsUtil.getExecutionDates(data);
        if (executionsDates != null && executionsDates.size() == 1) {
            return executionsDates.get(0);
        }
        return null;
    }

    public static List<String> getExecutionDates(HVDResponseOrderData data) {
        if (data != null && data.getDisplayFile() != null) {
            return DsUtil.getExecutionDates(DsOpenOrder.getTicket(data.getDisplayFile().getValue()));
        }
        return null;
    }

    public static String getUniqueExecutionDate(DsOrderDetails details) {
        List<String> executionsDates = DsUtil.getExecutionDates(details);
        if (executionsDates != null && executionsDates.size() == 1) {
            return executionsDates.get(0);
        }
        return null;
    }

    public static List<String> getExecutionDates(DsOrderDetails details) {
        if (details != null && details.getTicket() != null) {
            List<String> toReturn = DsUtil.getExecutionDates(new String(details.getTicket(), StandardCharsets.UTF_8));
            if (toReturn == null) {
                toReturn = DsUtil.getExecutionDates(new String(details.getTicket(), StandardCharsets.ISO_8859_1));
            }
            return toReturn;
        }
        return null;
    }

    private static List<String> getExecutionDates(String ticket) {
        LinkedHashSet<String> dates = null;
        if (ticket != null) {
            StringTokenizer st = new StringTokenizer(ticket, "\n");
            while (st.hasMoreTokens()) {
                int posColon;
                String line = st.nextToken().trim();
                if (!DsUtil.startsWithKeyword(line) || (posColon = line.indexOf(":")) <= 0 || posColon + 1 >= line.length()) continue;
                if (dates == null) {
                    dates = new LinkedHashSet<String>();
                }
                dates.add(line.substring(posColon + 1).trim());
            }
        }
        if (dates != null) {
            return new ArrayList<String>(dates);
        }
        return null;
    }

    private static boolean startsWithKeyword(String line) {
        for (String keyWord : executionDateKeywords) {
            if (!line.startsWith(keyWord)) continue;
            return true;
        }
        return false;
    }

    public static Date getDate(String s) {
        if (s != null && s.length() > 0) {
            for (SimpleDateFormat sdf : simpleDateFormats) {
                try {
                    return sdf.parse(s);
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }
}

