/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.ds.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.util.IProgressMonitorWrapper;
import io.ebean.Transaction;
import java.util.Date;
import java.util.List;

public class DsCleanUp {
    private int signedDeleted = 0;
    private int rejectedDeleted = 0;
    private List<DsOrderDetails> signedToDelete;
    private List<DsOrderDetails> rejectedToDelete;
    private boolean findDataWasCalled = false;

    public static void delete(DsOrderDetails details) {
        if (details.getDataFile() != null) {
            WorkspaceFileSystem.delete(details.getDataFile());
        }
        DsOrderDetails.delete(details);
    }

    public void findDataToDelete(DatabasePreferenceStore store) {
        Date oldest;
        int age;
        int unit;
        this.findDataWasCalled = true;
        if (store.getBoolean(PreferenceConstants.DS_CLEAN_SIGNED)) {
            unit = store.getInt(PreferenceConstants.DS_CLEAN_SIGNED_UNIT);
            age = store.getInt(PreferenceConstants.DS_CLEAN_SIGNED_AGE);
            oldest = Util.computeFromNow(age, unit).getTime();
            this.signedToDelete = DsOrderDetails.findByAge(oldest, DsOrderDetails.Type.SIGNED);
            this.signedDeleted = this.signedToDelete.size();
        }
        if (store.getBoolean(PreferenceConstants.DS_CLEAN_REJECTED)) {
            unit = store.getInt(PreferenceConstants.DS_CLEAN_REJECTED_UNIT);
            age = store.getInt(PreferenceConstants.DS_CLEAN_REJECTED_AGE);
            oldest = Util.computeFromNow(age, unit).getTime();
            this.rejectedToDelete = DsOrderDetails.findByAge(oldest, DsOrderDetails.Type.REJECTED);
            this.rejectedDeleted = this.rejectedToDelete.size();
        }
    }

    public boolean doCleanup(DatabasePreferenceStore store, IProgressMonitorWrapper monitor) {
        if (!this.findDataWasCalled) {
            this.findDataToDelete(store);
        }
        try (Transaction t = DB.beginTransaction();){
            if (store.getBoolean(PreferenceConstants.DS_CLEAN_SIGNED)) {
                for (DsOrderDetails ds : this.signedToDelete) {
                    DsCleanUp.delete(ds);
                }
            }
            if (store.getBoolean(PreferenceConstants.DS_CLEAN_REJECTED)) {
                for (DsOrderDetails ds : this.rejectedToDelete) {
                    DsCleanUp.delete(ds);
                }
            }
            t.commit();
        }
        this.findDataWasCalled = false;
        return true;
    }

    public int getSignedDeleted() {
        return this.signedDeleted;
    }

    public int getRejectedDeleted() {
        return this.rejectedDeleted;
    }
}

