/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.ds.api;

import de.businesslogics.banking.Messages;
import de.businesslogics.banking.api.BankDeleteNotifier;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.util.IProgressMonitorWrapper;
import java.text.MessageFormat;
import java.util.Locale;

public final class BankDelete
implements BankDeleteNotifier {
    @Override
    public String[] checkDataToBeDeleted(BankSettings bank, Locale locale) {
        return this.getMessage(this.count(bank), locale);
    }

    @Override
    public String[] checkDataToBeDeleted(BankSettings[] banks, Locale locale) {
        int count = 0;
        for (BankSettings bank : banks) {
            count += this.count(bank);
        }
        return this.getMessage(count, locale);
    }

    @Override
    public void deleteBank(BankSettings bank, IProgressMonitorWrapper monitor) {
        DsOrderDetails.deleteByBank(bank);
        DsOpenOrder.deleteByBank(bank);
        WorkspaceFile.deleteByBankAndType(WorkspaceFile.Prefix.DS, bank);
    }

    private int count(BankSettings bank) {
        return DsOrderDetails.findCountByBank(bank);
    }

    private String[] getMessage(int count, Locale locale) {
        if (count == 0) {
            return null;
        }
        return new String[]{MessageFormat.format(Messages.getString(locale, "BankDelete.dsHistory", new Object[0]), count)};
    }
}

