/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.ds;

import de.businesslogics.banking.api.DSUtil;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.DsSigningInfo;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.orders.HVZOrderDetails;
import de.businesslogics.ebics.schema.orders.OrderDetails;
import de.businesslogics.ebics.schema.orders.SignerInfo;
import de.businesslogics.io.Streams;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public final class LocalDSUtil {
    public static String buildDisplayFile(DsOrderDetails dsOrderDetails, boolean displayFileName) {
        int firstLineEnd;
        if (dsOrderDetails.getTicket() == null) {
            return "";
        }
        String displayFile = new String(dsOrderDetails.getTicket(), StandardCharsets.UTF_8);
        if (displayFileName && (firstLineEnd = displayFile.indexOf(10)) > 0 && !displayFile.trim().startsWith("====")) {
            return displayFile.substring(firstLineEnd + 1);
        }
        return displayFile;
    }

    public static DsOrderDetails findOrderForInfo(BankSettings bank, String fileType, String orderType, String orderNumber, Timestamp protocolTime, String customerId) {
        String orderOrFileType = fileType != null ? fileType : orderType;
        return LocalDSUtil.findOrderForInfo(bank, orderOrFileType, orderNumber, protocolTime, customerId);
    }

    private static DsOrderDetails findOrderForInfo(BankSettings bank, String generalizedOrderType, String orderNumber, Timestamp protocolTime, String customerId) {
        List<DsOrderDetails> dsOrderDetailsList = DsOrderDetails.findByOrder(bank, generalizedOrderType, orderNumber, protocolTime, customerId);
        if (dsOrderDetailsList.size() == 0) {
            return null;
        }
        if (dsOrderDetailsList.size() == 1) {
            return dsOrderDetailsList.get(0);
        }
        DsOrderDetails result = null;
        long resultTimeDelta = Long.MAX_VALUE;
        for (DsOrderDetails dsOrderDetails : dsOrderDetailsList) {
            if (result != null && Math.abs(dsOrderDetails.getSubmissionDate().getTime() - protocolTime.getTime()) >= resultTimeDelta) continue;
            result = dsOrderDetails;
            resultTimeDelta = Math.abs(result.getSubmissionDate().getTime() - protocolTime.getTime());
        }
        return result;
    }

    public static String readFilenameFromTicket(byte[] ticket) {
        if (ticket == null || ticket.length == 0) {
            return null;
        }
        for (int i = 0; i < ticket.length; ++i) {
            if (ticket[i] != 10 || i <= 0) continue;
            byte[] firstLineBytes = Arrays.copyOfRange(ticket, 0, i - 1);
            String firstLine = DsOpenOrder.getTicket(firstLineBytes);
            if (firstLine.startsWith("====")) {
                return null;
            }
            return firstLine;
        }
        return null;
    }

    public static DsOrderDetails createDsOrder(BankSettings bank, User user, OrderDetails details, byte[] ticket, File dataFile, DsOrderDetails.Type dsType, boolean addCurrentUserAsSigner, String ipAddress) throws IOException {
        DsSigningInfo signingInfo;
        String senderName;
        DatabasePreferenceStore preferenceStore;
        String transferType = DSUtil.getGeneralizedOrderType(details);
        boolean created = false;
        DsOrderDetails dsOrderDetails = LocalDSUtil.findOrderForInfo(bank, transferType, details.getOrderID().getValue(), new Timestamp(System.currentTimeMillis()), details.getOriginatorInfo().getPartnerID().getValue());
        if (dsOrderDetails == null) {
            dsOrderDetails = new DsOrderDetails();
            dsOrderDetails.setBank(bank);
            dsOrderDetails.setPmtType(SendParameters.getPmtType(bank, transferType));
            dsOrderDetails.setFileType(transferType);
            dsOrderDetails.setOrderId(details.getOrderID().getValue());
            created = true;
        }
        if ((preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user)).getBoolean(PreferenceConstants.DS_SHOW_FILENAME)) {
            dsOrderDetails.setFilename(LocalDSUtil.readFilenameFromTicket(ticket));
        }
        dsOrderDetails.setSubmissionDate(new Timestamp(details.getOriginatorInfo().getTimestamp().getDate().getTime()));
        dsOrderDetails.setCustomerId(details.getOriginatorInfo().getPartnerID().getValue());
        if (details.getOriginatorInfo().getUserID() != null) {
            dsOrderDetails.setUserId(details.getOriginatorInfo().getUserID().getValue());
        }
        if ((senderName = LocalDSUtil.getSenderFromSendItem(dsOrderDetails)) != null) {
            dsOrderDetails.setUserName(senderName);
        } else if (details.getOriginatorInfo().getName() != null) {
            dsOrderDetails.setUserName(details.getOriginatorInfo().getName().getValue());
        } else {
            dsOrderDetails.setUserName(details.getOriginatorInfo().getUserID().getValue());
        }
        if (details.getSigningInfo() != null) {
            dsOrderDetails.setNumSigDone(details.getSigningInfo().getNumSigDone());
            dsOrderDetails.setNumSigRequired(details.getSigningInfo().getNumSigRequired());
        } else {
            dsOrderDetails.setNumSigDone(1);
            dsOrderDetails.setNumSigRequired(1);
        }
        LocalDSUtil.determineAmountFromOrder(details, dsOrderDetails);
        dsOrderDetails.setTicket(ticket);
        dsOrderDetails.setType(dsType);
        if (dsType == DsOrderDetails.Type.SIGNED) {
            dsOrderDetails.setState(DsOrderDetails.State.WAITING);
        } else {
            dsOrderDetails.setState(DsOrderDetails.State.CANCELLED);
        }
        for (SignerInfo signerInfo : details.getSigners()) {
            if (!created) {
                boolean foundSigningInfo = false;
                for (DsSigningInfo existingSigningInfo : dsOrderDetails.getSigningInfos()) {
                    if (!existingSigningInfo.getCustomerId().equals(signerInfo.getPartnerID().getValue()) || !existingSigningInfo.getUserId().equals(signerInfo.getUserID().getValue())) continue;
                    foundSigningInfo = true;
                    existingSigningInfo.setPermission(Character.valueOf(signerInfo.getPermission().getAuthorisationLevel().charAt(0)));
                    if (details.getSigners().size() == 1 && (existingSigningInfo.getUserName() == null || existingSigningInfo.getUserName().isEmpty())) {
                        existingSigningInfo.setUserName(dsOrderDetails.getUserName());
                    }
                    DB.save(existingSigningInfo);
                    break;
                }
                if (foundSigningInfo) continue;
            }
            signingInfo = new DsSigningInfo();
            signingInfo.setCustomerId(signerInfo.getPartnerID().getValue());
            signingInfo.setUserId(signerInfo.getUserID().getValue());
            if (details.getSigners().size() == 1) {
                signingInfo.setUserName(dsOrderDetails.getUserName());
            } else if (signerInfo.getName() != null) {
                signingInfo.setUserName(signerInfo.getName().getValue() + " (" + signingInfo.getCustomerId() + " / " + signingInfo.getUserId() + ")");
            }
            signingInfo.setSignDate(new Timestamp(signerInfo.getTimestamp().getDate().getTime()));
            signingInfo.setPermission(Character.valueOf(signerInfo.getPermission().getAuthorisationLevel().charAt(0)));
            dsOrderDetails.getSigningInfos().add(signingInfo);
        }
        if (addCurrentUserAsSigner) {
            signingInfo = new DsSigningInfo();
            signingInfo.setIpAddress(ipAddress);
            signingInfo.setDsOrderDetails(dsOrderDetails);
            signingInfo.setCustomerId(bank.getCustomerId());
            BankUser bankUser = BankUser.findBankUser(bank, user);
            signingInfo.setUserId(bankUser.getDefaultUser());
            signingInfo.setUserName(user.getName() + " (" + bank.getCustomerId() + " / " + bankUser.getDefaultUser() + ")");
            signingInfo.setSignDate(new Timestamp(System.currentTimeMillis()));
            Enum authLevel = null;
            List<UserPermission> userPermissions = UserPermission.findUserPermission(bankUser, OrderType.TransferType.SEND, transferType);
            if (userPermissions.isEmpty()) {
                String alternativeTransferType = null;
                if (BTFTranslator.isBTFString(transferType)) {
                    pmtType = dsOrderDetails.getPmtType();
                    alternativeTransferType = pmtType != null ? SendParameters.getOrderType(bank, pmtType) : BTFTranslator.getSendOrderTypeFromBTF(transferType);
                } else if (Util.isOrderType(transferType)) {
                    pmtType = dsOrderDetails.getPmtType();
                    alternativeTransferType = pmtType != null ? SendParameters.getBTF(bank, pmtType) : BTFTranslator.getBTFFromSendOrderType(transferType);
                }
                if (alternativeTransferType != null) {
                    userPermissions = UserPermission.findUserPermission(bankUser, OrderType.TransferType.SEND, alternativeTransferType);
                }
            }
            for (UserPermission userPermission : userPermissions) {
                if (userPermission.getAuthLevel() == null || authLevel != null && authLevel.ordinal() <= userPermission.getAuthLevel().ordinal()) continue;
                authLevel = userPermission.getAuthLevel();
            }
            if (authLevel == UserPermission.AuthorizationLevel.SINGLE) {
                signingInfo.setPermission(Character.valueOf('E'));
            } else if (authLevel == UserPermission.AuthorizationLevel.SECOND) {
                signingInfo.setPermission(Character.valueOf('B'));
            } else if (authLevel == UserPermission.AuthorizationLevel.TRANSPORT) {
                signingInfo.setPermission(Character.valueOf('T'));
            } else if (authLevel == UserPermission.AuthorizationLevel.FIRST) {
                signingInfo.setPermission(Character.valueOf('A'));
            } else {
                signingInfo.setPermission(Character.valueOf(' '));
            }
            dsOrderDetails.getSigningInfos().add(signingInfo);
            if (details.getSigningInfo() != null) {
                dsOrderDetails.setNumSigDone(dsOrderDetails.getNumSigDone() + 1);
                if (dsOrderDetails.getNumSigDone() > dsOrderDetails.getNumSigRequired()) {
                    dsOrderDetails.setNumSigRequired(dsOrderDetails.getNumSigDone());
                }
            }
        }
        if (details.getOrderDataSize() != null) {
            dsOrderDetails.setDatasize(details.getOrderDataSize().longValue());
        }
        if (dataFile != null && dataFile.exists()) {
            try (InputStream fileInputStream = Files.newInputStream(dataFile.toPath(), new OpenOption[0]);){
                LocalDSUtil.writeDataFile(LocalDSUtil.getDsDirectory(), dsOrderDetails, fileInputStream);
            }
        }
        if (details.getAdditionalOrderInfo() != null) {
            dsOrderDetails.setAdditionalOrderInfo(details.getAdditionalOrderInfo().getValue());
        }
        dsOrderDetails.save();
        return dsOrderDetails;
    }

    private static String getSenderFromSendItem(DsOrderDetails dsOrderDetails) {
        Send send = Send.findByDsOrderDetails(dsOrderDetails);
        if (send != null) {
            return send.getSender();
        }
        return null;
    }

    public static Send findByOrderDetails(BankSettings bank, OrderDetails orderDetails) {
        List sendList = null;
        Calendar start = Calendar.getInstance();
        start.setTime(new Timestamp(orderDetails.getOriginatorInfo().getTimestamp().getDate().getTime()));
        start.add(5, -30);
        Calendar end = Calendar.getInstance();
        end.setTime(new Timestamp(orderDetails.getOriginatorInfo().getTimestamp().getDate().getTime()));
        end.add(5, 1);
        sendList = orderDetails.isH004AndBelow() ? DB.find(Send.class).where().eq("bank", (Object)bank).eq("orderNumber", (Object)orderDetails.getOrderID().getValue()).eq("orderType", (Object)orderDetails.getOrderType().getValue()).between("sent", (Object)start.getTime(), (Object)end.getTime()).findList() : DB.find(Send.class).where().eq("bank", (Object)bank).eq("orderNumber", (Object)orderDetails.getOrderID().getValue()).eq("fileType", (Object)BTFTranslator.convertToString(orderDetails.getService())).between("sent", (Object)start.getTime(), (Object)end.getTime()).findList();
        if (sendList != null && sendList.size() == 1) {
            return (Send)sendList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDataFile(File dsDirectory, DsOrderDetails dsOrderDetails, InputStream dataFileInputStream) throws IOException {
        OutputStream dataFileOutputStream = null;
        try {
            File bankDsDirectory = new File(dsDirectory, dsOrderDetails.getBank().getUniqueKey());
            if (!bankDsDirectory.isDirectory()) {
                bankDsDirectory.mkdirs();
            }
            File dataFile = File.createTempFile("ds_", ".data", bankDsDirectory);
            dataFileOutputStream = Files.newOutputStream(dataFile.toPath(), new OpenOption[0]);
            long size = Streams.copy(dataFileInputStream, dataFileOutputStream);
            WorkspaceFile workspaceFile = WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.DS, dataFile, size, null, null);
            dsOrderDetails.setDataFile(workspaceFile);
            if (dsOrderDetails.getDatasize() == null) {
                dsOrderDetails.setDatasize(size);
            }
        }
        finally {
            if (dataFileOutputStream != null) {
                try {
                    dataFileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void determineAmountFromOrder(OrderDetails orderDetails, DsOrderDetails dsOrderDetails) {
        HVZOrderDetails hvz;
        if (orderDetails instanceof HVZOrderDetails && (hvz = (HVZOrderDetails)orderDetails).getTotalAmount() != null) {
            dsOrderDetails.setAmount(hvz.getTotalAmount().getValue());
            if (hvz.getCurrency() != null) {
                dsOrderDetails.setAmountCurrency(hvz.getCurrency().getValue());
            }
        }
    }

    public static File getDataFile(DsOrderDetails dsOrderDetails) {
        if (dsOrderDetails == null || dsOrderDetails.getDataFile() == null) {
            return null;
        }
        File dataFile = WorkspaceFileSystem.getFile(dsOrderDetails.getDataFile());
        if (dataFile.exists() && dataFile.isFile()) {
            return dataFile;
        }
        return null;
    }

    public static File getDataFileFromDs(Send send, BLLogger logger) {
        List<DsOrderDetails> dsOrders = DsOrderDetails.findByOrder(send.getBank(), send.getOriginalSendType(), send.getOrderNumber(), send.getSent(), send.getBank().getCustomerId());
        if (dsOrders != null) {
            int countOrders = dsOrders.size();
            if (countOrders == 1) {
                return LocalDSUtil.getDataFile(dsOrders.get(0));
            }
            if (countOrders > 1 && logger != null) {
                logger.logWarning("Found " + countOrders + " DS orders for send order to bank '" + send.getBank().getDisplayName() + "', sendType = " + send.getOriginalSendType() + " and orderNumber = " + send.getOrderNumber() + ". No data file from DS is returned!", null);
            }
        }
        return null;
    }

    public static File getDataFileFromDs(Send send) {
        return LocalDSUtil.getDataFileFromDs(send, null);
    }

    public static File getDsDirectory() {
        return WorkspaceFileSystem.DS_DIRECTORY;
    }

    public static List<DsSigningInfo> getSortedSigningInfos(DsOrderDetails dsOrderDetails) {
        List<DsSigningInfo> signingInfosList = dsOrderDetails.getSigningInfos();
        if (signingInfosList == null) {
            return new ArrayList<DsSigningInfo>();
        }
        if (signingInfosList.size() <= 1) {
            return signingInfosList;
        }
        signingInfosList.sort((o1, o2) -> {
            if (o1.getSignDate() == null) {
                if (o2.getSignDate() == null) {
                    return 0;
                }
                return 1;
            }
            return o1.getSignDate().compareTo(o2.getSignDate());
        });
        return signingInfosList;
    }

    private LocalDSUtil() {
    }
}

