/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WebAuthn;
import de.businesslogics.banking.database.vo.YubikeyHistory;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class Yubikey
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private User user;
    @Column(length=2048)
    private String publicId;
    private String description;
    private Date usedSince;
    private SecurityType securityType;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public Yubikey() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_usedSince(new Date(System.currentTimeMillis()));
        this._ebean_set_securityType(SecurityType.YUBIKEY);
    }

    public static int deleteByUser(User user) {
        Update<YubikeyHistory> history = DB.createUpdate(YubikeyHistory.class, "DELETE FROM yubikey_history WHERE user_id=:user");
        history.set("user", (Object)user.getId());
        history.execute();
        Update<Yubikey> delete = DB.createUpdate(Yubikey.class, "DELETE FROM Yubikey WHERE user=:user");
        delete.set("user", (Object)user.getId());
        return delete.execute();
    }

    public static Query<Yubikey> findForUser(User user, SecurityType ... securityType) {
        Query q = DB.find(Yubikey.class).where().eq("user", (Object)user).query();
        if (securityType != null && securityType.length > 0) {
            q = q.where().in("securityType", Arrays.asList(securityType)).query();
        }
        return q;
    }

    public static Yubikey findForIdAndUser(int id, User user) {
        return (Yubikey)DB.find(Yubikey.class).where().eq("id", (Object)id).eq("user", (Object)user).findOne();
    }

    public static boolean hasKeyOfType(User user, SecurityType ... securityType) {
        ExpressionList e = DB.find(Yubikey.class).where().eq("user", (Object)user);
        if (securityType != null && securityType.length > 0) {
            e = e.in("securityType", Arrays.asList(securityType));
        }
        return e.findCount() > 0;
    }

    public static boolean hasYubiKey(String publicId, User user) {
        return DB.find(Yubikey.class).where().eq("securityType", (Object)SecurityType.YUBIKEY).eq("user", (Object)user).eq("publicId", (Object)publicId).setMaxRows(1).findOne() != null;
    }

    public static List<Yubikey> findOathForUser(User user) {
        return DB.find(Yubikey.class).where().eq("user", (Object)user).eq("securityType", (Object)SecurityType.OATH).findList();
    }

    public static Yubikey findWebAuthnForUser(User user, String credentialId) {
        return (Yubikey)DB.find(Yubikey.class).where().eq("user", (Object)user).eq("securityType", (Object)SecurityType.WEBAUTHN).eq("publicId", (Object)credentialId).findOne();
    }

    public static boolean hasAnyKeys(User user) {
        return DB.find(Yubikey.class).where().eq("user", (Object)user).findCount() > 0;
    }

    public SecurityType getSecurityType() {
        return this._ebean_get_securityType();
    }

    public void setSecurityType(SecurityType securityType) {
        this._ebean_set_securityType(securityType);
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public void setUser(User user) {
        this._ebean_set_user(user);
    }

    public String getDescription() {
        return this._ebean_get_description();
    }

    public void setDescription(String description) {
        this._ebean_set_description(description);
    }

    public String getPublicId() {
        if (SecurityType.YUBIKEY.equals((Object)this._ebean_get_securityType())) {
            return this._ebean_get_publicId();
        }
        return null;
    }

    public void setPublicId(String publicId) {
        this._ebean_set_publicId(publicId);
        this._ebean_set_securityType(SecurityType.YUBIKEY);
    }

    public void setCredentialId(String credentialId) {
        this._ebean_set_publicId(credentialId);
        this._ebean_set_securityType(SecurityType.WEBAUTHN);
    }

    public String getCredentialId() {
        if (SecurityType.WEBAUTHN.equals((Object)this._ebean_get_securityType())) {
            return this._ebean_get_publicId();
        }
        return null;
    }

    public void setOathData(String key) {
        this._ebean_set_publicId(key);
        this._ebean_set_securityType(SecurityType.OATH);
    }

    public String getDisplayString() {
        if (SecurityType.YUBIKEY.equals((Object)this._ebean_get_securityType())) {
            return this.getPublicId();
        }
        if (SecurityType.OATH.equals((Object)this._ebean_get_securityType())) {
            return this.getOathName();
        }
        if (SecurityType.WEBAUTHN.equals((Object)this._ebean_get_securityType())) {
            return this.getCredentialId();
        }
        return "unknown";
    }

    public String getOathName() {
        if (SecurityType.OATH.equals((Object)this._ebean_get_securityType())) {
            return this._ebean_get_publicId().substring(0, this._ebean_get_publicId().indexOf(58));
        }
        return null;
    }

    public String getOathData() {
        if (SecurityType.OATH.equals((Object)this._ebean_get_securityType())) {
            return this._ebean_get_publicId();
        }
        return null;
    }

    public Date getUsedSince() {
        return this._ebean_get_usedSince();
    }

    public void setUsedSince(Date usedSince) {
        this._ebean_set_usedSince(usedSince);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        WebAuthn w = WebAuthn.findByYubikey(this);
        if (w != null) {
            DB.delete(w);
        }
        DB.delete(this);
    }

    static {
        _ebean_props = new String[]{"id", "user", "publicId", "description", "usedSince", "securityType"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(1);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_publicId() {
        this._ebean_intercept.preGetter(2);
        return this.publicId;
    }

    protected /* synthetic */ void _ebean_set_publicId(String newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_publicId(), (Object)newValue);
        this.publicId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_publicId() {
        return this.publicId;
    }

    protected /* synthetic */ void _ebean_setni_publicId(String _newValue) {
        this.publicId = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_description() {
        this._ebean_intercept.preGetter(3);
        return this.description;
    }

    protected /* synthetic */ void _ebean_set_description(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_description(), (Object)newValue);
        this.description = newValue;
    }

    protected /* synthetic */ String _ebean_getni_description() {
        return this.description;
    }

    protected /* synthetic */ void _ebean_setni_description(String _newValue) {
        this.description = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Date _ebean_get_usedSince() {
        this._ebean_intercept.preGetter(4);
        return this.usedSince;
    }

    protected /* synthetic */ void _ebean_set_usedSince(Date newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_usedSince(), (Object)newValue);
        this.usedSince = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_usedSince() {
        return this.usedSince;
    }

    protected /* synthetic */ void _ebean_setni_usedSince(Date _newValue) {
        this.usedSince = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ SecurityType _ebean_get_securityType() {
        this._ebean_intercept.preGetter(5);
        return this.securityType;
    }

    protected /* synthetic */ void _ebean_set_securityType(SecurityType newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_securityType(), (Object)newValue);
        this.securityType = newValue;
    }

    protected /* synthetic */ SecurityType _ebean_getni_securityType() {
        return this.securityType;
    }

    protected /* synthetic */ void _ebean_setni_securityType(SecurityType _newValue) {
        this.securityType = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.user;
            }
            case 2: {
                return this.publicId;
            }
            case 3: {
                return this.description;
            }
            case 4: {
                return this.usedSince;
            }
            case 5: {
                return this.securityType;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_publicId();
            }
            case 3: {
                return this._ebean_get_description();
            }
            case 4: {
                return this._ebean_get_usedSince();
            }
            case 5: {
                return this._ebean_get_securityType();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_publicId((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_description((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_usedSince((Date)o);
                return;
            }
            case 5: {
                this._ebean_setni_securityType((SecurityType)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_publicId((String)o);
                return;
            }
            case 3: {
                this._ebean_set_description((String)o);
                return;
            }
            case 4: {
                this._ebean_set_usedSince((Date)o);
                return;
            }
            case 5: {
                this._ebean_set_securityType((SecurityType)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        Yubikey yubikey = this;
        synchronized (yubikey) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Yubikey)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new Yubikey();
    }

    public static enum SecurityType {
        YUBIKEY("Yubikey"),
        OATH("Authenticator-App"),
        WEBAUTHN("WebAuthn");

        private final String displayName;

        private SecurityType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

