/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.ClusterNode;
import io.ebean.Expr;
import io.ebean.Query;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.annotation.Index;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;

@Entity
@Index(columnNames={"prefix_id", "path"})
public class WorkspaceFile
implements EntityBean {
    @Id
    private Integer id;
    private int prefixId;
    private boolean deleted;
    @Column(length=256, nullable=false)
    private String path;
    @Column(name="file_size")
    private Long size;
    @Column(length=32, name="md5hash")
    private String md5Hash;
    @Column(length=64, name="sha256hash")
    private String sha256Hash;
    @ManyToMany
    private List<ClusterNode> clusterNodes;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public WorkspaceFile() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_deleted(false);
    }

    public static WorkspaceFile findExisting(WorkspaceFile file) {
        return (WorkspaceFile)DB.find(WorkspaceFile.class).where().eq("prefixId", (Object)file.prefixId).eq("deleted", (Object)false).eq("path", (Object)file.path).setMaxRows(1).findOne();
    }

    public static List<Statistic> getFilesystemStatistic() {
        SqlQuery query = DB.sqlQuery("select prefix_id, sum(file_size) as file_size, count(*) as anzahl from workspace_file where deleted=:false group by prefix_id order by 2");
        query.setParameter("false", (Object)false);
        List list = query.findList();
        ArrayList<Statistic> toReturn = new ArrayList<Statistic>();
        Statistic total = new Statistic();
        for (SqlRow row : list) {
            Statistic s = new Statistic();
            s.numberOfFiles = row.getInteger("anzahl");
            Long size = row.getLong("file_size");
            if (size != null) {
                s.totalSize = size;
            }
            s.prefix = Prefix.values()[row.getInteger("prefix_id")];
            total.numberOfFiles += s.numberOfFiles;
            total.totalSize += s.totalSize;
            toReturn.add(s);
        }
        toReturn.add(total);
        return toReturn;
    }

    public static void deleteByBankAndType(Prefix prefix, BankSettings bank) {
        String unixPath;
        DB.update(WorkspaceFile.class).set("deleted", (Object)true).where().eq("deleted", (Object)false).eq("prefix_id", (Object)prefix.ordinal()).or(Expr.like((String)"path", (String)unixPath), Expr.like((String)"path", (String)(switch (prefix.ordinal()) {
            case 0, 1 -> {
                unixPath = "/" + bank.getBankId() + "/%";
                yield "\\" + bank.getBankId() + "\\%";
            }
            default -> {
                unixPath = "/" + bank.getUniqueKey() + "/%";
                yield "\\" + bank.getUniqueKey() + "\\%";
            }
        }))).update();
    }

    public static Query<WorkspaceFile> findFilesMissingOnNode(ClusterNode node) {
        Query allOnThisNode = DB.find(WorkspaceFile.class).select("id").where().eq("clusterNodes", (Object)node).query();
        return DB.find(WorkspaceFile.class).where().eq("deleted", (Object)false).notIn("id", allOnThisNode).query();
    }

    public static Query<WorkspaceFile> findFilesByNode(ClusterNode node) {
        if (node == null) {
            return DB.find(WorkspaceFile.class).where().eq("deleted", (Object)false).query();
        }
        return DB.find(WorkspaceFile.class).where().eq("deleted", (Object)false).in("clusterNodes", new Object[]{node}).query();
    }

    public static List<WorkspaceFile> findDeletedFiles() {
        return DB.find(WorkspaceFile.class).where().eq("deleted", (Object)true).findList();
    }

    public static List<WorkspaceFile> findFilesToDelete(ClusterNode clusterNode) {
        if (clusterNode == null || clusterNode.getBaseURL() == null) {
            return new ArrayList<WorkspaceFile>();
        }
        return DB.find(WorkspaceFile.class).where().eq("deleted", (Object)true).eq("clusterNodes.baseURL", (Object)clusterNode.getBaseURL()).findList();
    }

    public static List<WorkspaceFile> findByPrefixAndPath(Prefix prefix, String like) {
        return DB.find(WorkspaceFile.class).where().eq("prefixId", (Object)prefix.ordinal()).like("path", like).findList();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public Prefix getPrefix() {
        return Prefix.values()[this._ebean_get_prefixId()];
    }

    public void setPrefix(Prefix prefix) {
        this._ebean_set_prefixId(prefix.ordinal());
    }

    public String getPath() {
        return this._ebean_get_path();
    }

    public void setPath(String path) {
        this._ebean_set_path(path);
    }

    public Long getSize() {
        return this._ebean_get_size();
    }

    public void setSize(Long size) {
        this._ebean_set_size(size);
    }

    public String getMd5Hash() {
        return this._ebean_get_md5Hash();
    }

    public void setMd5Hash(String md5Hash) {
        this._ebean_set_md5Hash(md5Hash);
    }

    public String getSha256Hash() {
        return this._ebean_get_sha256Hash();
    }

    public void setSha256Hash(String sha256Hash) {
        this._ebean_set_sha256Hash(sha256Hash);
    }

    public List<ClusterNode> getClusterNodes() {
        return this._ebean_get_clusterNodes();
    }

    public boolean isDeleted() {
        return this._ebean_get_deleted();
    }

    public void setDeleted(boolean deleted) {
        this._ebean_set_deleted(deleted);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "prefixId", "deleted", "path", "size", "md5Hash", "sha256Hash", "clusterNodes"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ int _ebean_get_prefixId() {
        this._ebean_intercept.preGetter(1);
        return this.prefixId;
    }

    protected /* synthetic */ void _ebean_set_prefixId(int newValue) {
        this._ebean_intercept.preSetter(true, 1, this._ebean_get_prefixId(), newValue);
        this.prefixId = newValue;
    }

    protected /* synthetic */ int _ebean_getni_prefixId() {
        return this.prefixId;
    }

    protected /* synthetic */ void _ebean_setni_prefixId(int _newValue) {
        this.prefixId = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ boolean _ebean_get_deleted() {
        this._ebean_intercept.preGetter(2);
        return this.deleted;
    }

    protected /* synthetic */ void _ebean_set_deleted(boolean newValue) {
        this._ebean_intercept.preSetter(true, 2, this._ebean_get_deleted(), newValue);
        this.deleted = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_deleted() {
        return this.deleted;
    }

    protected /* synthetic */ void _ebean_setni_deleted(boolean _newValue) {
        this.deleted = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_path() {
        this._ebean_intercept.preGetter(3);
        return this.path;
    }

    protected /* synthetic */ void _ebean_set_path(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_path(), (Object)newValue);
        this.path = newValue;
    }

    protected /* synthetic */ String _ebean_getni_path() {
        return this.path;
    }

    protected /* synthetic */ void _ebean_setni_path(String _newValue) {
        this.path = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Long _ebean_get_size() {
        this._ebean_intercept.preGetter(4);
        return this.size;
    }

    protected /* synthetic */ void _ebean_set_size(Long newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_size(), (Object)newValue);
        this.size = newValue;
    }

    protected /* synthetic */ Long _ebean_getni_size() {
        return this.size;
    }

    protected /* synthetic */ void _ebean_setni_size(Long _newValue) {
        this.size = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_md5Hash() {
        this._ebean_intercept.preGetter(5);
        return this.md5Hash;
    }

    protected /* synthetic */ void _ebean_set_md5Hash(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_md5Hash(), (Object)newValue);
        this.md5Hash = newValue;
    }

    protected /* synthetic */ String _ebean_getni_md5Hash() {
        return this.md5Hash;
    }

    protected /* synthetic */ void _ebean_setni_md5Hash(String _newValue) {
        this.md5Hash = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_sha256Hash() {
        this._ebean_intercept.preGetter(6);
        return this.sha256Hash;
    }

    protected /* synthetic */ void _ebean_set_sha256Hash(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_sha256Hash(), (Object)newValue);
        this.sha256Hash = newValue;
    }

    protected /* synthetic */ String _ebean_getni_sha256Hash() {
        return this.sha256Hash;
    }

    protected /* synthetic */ void _ebean_setni_sha256Hash(String _newValue) {
        this.sha256Hash = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ List _ebean_get_clusterNodes() {
        this._ebean_intercept.preGetter(7);
        if (this.clusterNodes == null) {
            this.clusterNodes = new BeanList();
            this._ebean_intercept.initialisedMany(7);
            ((BeanCollection)this.clusterNodes).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.clusterNodes;
    }

    protected /* synthetic */ void _ebean_set_clusterNodes(List newValue) {
        this._ebean_intercept.preSetterMany(false, 7, this.clusterNodes, (Object)newValue);
        this.clusterNodes = newValue;
    }

    protected /* synthetic */ List _ebean_getni_clusterNodes() {
        return this.clusterNodes;
    }

    protected /* synthetic */ void _ebean_setni_clusterNodes(List _newValue) {
        this.clusterNodes = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.prefixId;
            }
            case 2: {
                return this.deleted;
            }
            case 3: {
                return this.path;
            }
            case 4: {
                return this.size;
            }
            case 5: {
                return this.md5Hash;
            }
            case 6: {
                return this.sha256Hash;
            }
            case 7: {
                return this.clusterNodes;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_prefixId();
            }
            case 2: {
                return this._ebean_get_deleted();
            }
            case 3: {
                return this._ebean_get_path();
            }
            case 4: {
                return this._ebean_get_size();
            }
            case 5: {
                return this._ebean_get_md5Hash();
            }
            case 6: {
                return this._ebean_get_sha256Hash();
            }
            case 7: {
                return this._ebean_get_clusterNodes();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_prefixId((Integer)o);
                return;
            }
            case 2: {
                this._ebean_setni_deleted((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_setni_path((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_size((Long)o);
                return;
            }
            case 5: {
                this._ebean_setni_md5Hash((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_sha256Hash((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_clusterNodes((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_prefixId((Integer)o);
                return;
            }
            case 2: {
                this._ebean_set_deleted((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_set_path((String)o);
                return;
            }
            case 4: {
                this._ebean_set_size((Long)o);
                return;
            }
            case 5: {
                this._ebean_set_md5Hash((String)o);
                return;
            }
            case 6: {
                this._ebean_set_sha256Hash((String)o);
                return;
            }
            case 7: {
                this._ebean_set_clusterNodes((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        WorkspaceFile workspaceFile = this;
        synchronized (workspaceFile) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((WorkspaceFile)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new WorkspaceFile();
    }

    public static class Statistic {
        public Prefix prefix;
        public int numberOfFiles;
        public long totalSize;
    }

    public static enum Prefix {
        BKA,
        BKI,
        CM,
        DTI,
        DATA_FETCHED,
        DATA_SENT,
        DS,
        NOTIFICATIONS,
        ABSOLUTE_FILE,
        TEMPORARY_FILE;

    }
}

