/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.EbeanHelper;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Expr;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class UserPermission
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankUser bankUser;
    @ManyToOne
    private OrderType orderType;
    private AuthorizationLevel authLevel;
    @Column(precision=38, scale=4)
    private BigDecimal maxAmount;
    @Column(length=3)
    private String maxAmountCurrency;
    @ManyToOne
    private AccountPermission accountPermission;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public UserPermission() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static int deleteAll(AccountPermission ap) {
        Update<UserPermission> delete = DB.createUpdate(UserPermission.class, "DELETE FROM UserPermission WHERE accountPermission=:ap");
        delete.setParameter("ap", (Object)ap.getId());
        return delete.execute();
    }

    public static int deleteAll(BankSettings bank) {
        Update<UserPermission> delete = DB.createUpdate(UserPermission.class, "DELETE FROM UserPermission WHERE bankUser IN (SELECT id FROM bankuser WHERE bank_id=:bank)");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static int deleteByUser(User user) {
        Update<UserPermission> delete = DB.createUpdate(UserPermission.class, "DELETE FROM UserPermission WHERE bankUser IN (SELECT id FROM bankuser WHERE user_id=:user)");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public static int deleteByBankUser(BankUser user) {
        Update<UserPermission> delete = DB.createUpdate(UserPermission.class, "DELETE FROM UserPermission WHERE bankUser=:user");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public static List<UserPermission> findUserPermission(BankUser bankUser, OrderType.TransferType transferType, String orderType, String fileFormat) {
        ExpressionList expressionList = DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).eq("orderType.transferType", (Object)transferType).eq("orderType.orderType", (Object)orderType);
        expressionList = fileFormat == null ? expressionList.isNull("orderType.fileFormat") : expressionList.eq("orderType.fileFormat", (Object)fileFormat);
        return expressionList.findList();
    }

    public static List<UserPermission> findUserPermission(BankUser bankUser, OrderType.TransferType transferType, String generalizedOrderType) {
        ExpressionList expressionList = DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).eq("orderType.transferType", (Object)transferType);
        expressionList = RegularExpressions.ORDER_TYPE.matches(generalizedOrderType) ? expressionList.eq("orderType.orderType", (Object)generalizedOrderType) : expressionList.eq("orderType.fileFormat", (Object)generalizedOrderType);
        return expressionList.findList();
    }

    public static boolean hasPermissionForOrderType(BankUser bankUser, OrderType.TransferType transferType, String orderType) {
        ExpressionList expressionList = DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).eq("orderType.transferType", (Object)transferType).eq("orderType.orderType", (Object)orderType);
        return expressionList.findCount() > 0;
    }

    public static boolean hasPermissionForFileFormat(BankUser bankUser, OrderType.TransferType transferType, String fileFormat) {
        ExpressionList expressionList = DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).eq("orderType.transferType", (Object)transferType).eq("orderType.fileFormat", (Object)fileFormat);
        return expressionList.findCount() > 0;
    }

    public static boolean hasUserPermission(BankSettings bank, OrderType.TransferType transferType, String orderType, String fileFormat) {
        ExpressionList expressionList = DB.find(UserPermission.class).where().eq("bankUser.bank", (Object)bank).ne("bankUser.user.securityMedium", (Object)User.SecurityMedium.DUMMY).eq("orderType.transferType", (Object)transferType).eq("orderType.orderType", (Object)orderType);
        expressionList = fileFormat == null ? expressionList.isNull("orderType.fileFormat") : expressionList.eq("orderType.fileFormat", (Object)fileFormat);
        return expressionList.findCount() > 0;
    }

    public static Query<UserPermission> findByBankUser(BankUser bankUser) {
        return DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).order("orderType.orderType,orderType.fileFormat,authLevel,maxAmount").query();
    }

    public static Query<UserPermission> findSendPermissionsForBankUser(BankUser bankUser) {
        return DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).eq("orderType.transferType", (Object)OrderType.TransferType.SEND).order("orderType.orderType,orderType.fileFormat,authLevel,maxAmount").query();
    }

    public static Query<UserPermission> findFetchPermissionsForBankUser(BankUser bankUser) {
        return DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).eq("orderType.transferType", (Object)OrderType.TransferType.FETCH).order("orderType.orderType,orderType.fileFormat,authLevel,maxAmount").query();
    }

    public static List<UserPermission> findUserPermission(BankUser bankUser, OrderType orderType, Account account, AuthorizationLevel authLevel, BigDecimal maxAmount) {
        ExpressionList expressionList = DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).eq("orderType", (Object)orderType);
        expressionList = account != null ? expressionList.eq("accountPermission.account", (Object)account) : expressionList.isNull("accountPermission");
        expressionList = authLevel != null ? expressionList.eq("authLevel", (Object)authLevel) : expressionList.isNull("authLevel");
        expressionList = maxAmount != null ? expressionList.eq("maxAmount", (Object)maxAmount) : expressionList.isNull("maxAmount");
        return expressionList.findList();
    }

    public static void deleteUnknownUserPermissions(BankUser bankUser, List<UserPermission> knownUserPermissions) {
        if (knownUserPermissions.size() <= 900) {
            Object[] exceptPermissionIds = new Integer[knownUserPermissions.size()];
            int i = 0;
            for (UserPermission userPermission : knownUserPermissions) {
                exceptPermissionIds[i++] = userPermission.getId();
            }
            List toDelete = DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).not(Expr.in((String)"id", (Object[])exceptPermissionIds)).findList();
            EbeanHelper.deleteByObject(toDelete);
        } else {
            List all = DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).findList();
            all.removeAll(knownUserPermissions);
            EbeanHelper.deleteByObject(all);
        }
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankUser getBankUser() {
        return this._ebean_get_bankUser();
    }

    public void setBankUser(BankUser bankUser) {
        this._ebean_set_bankUser(bankUser);
    }

    public OrderType getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(OrderType orderType) {
        this._ebean_set_orderType(orderType);
    }

    public AuthorizationLevel getAuthLevel() {
        return this._ebean_get_authLevel();
    }

    public void setAuthLevel(AuthorizationLevel authLevel) {
        this._ebean_set_authLevel(authLevel);
    }

    public BigDecimal getMaxAmount() {
        return this._ebean_get_maxAmount();
    }

    public void setMaxAmount(BigDecimal maxAmount) {
        this._ebean_set_maxAmount(maxAmount);
    }

    public String getMaxAmountCurrency() {
        return this._ebean_get_maxAmountCurrency();
    }

    public void setMaxAmountCurrency(String maxAmountCurrency) {
        this._ebean_set_maxAmountCurrency(maxAmountCurrency);
    }

    public AccountPermission getAccountPermission() {
        return this._ebean_get_accountPermission();
    }

    public void setAccountPermission(AccountPermission accountPermission) {
        this._ebean_set_accountPermission(accountPermission);
    }

    public void save() {
        DB.save(this);
    }

    public void delete() {
        DB.delete(this);
    }

    static {
        _ebean_props = new String[]{"id", "bankUser", "orderType", "authLevel", "maxAmount", "maxAmountCurrency", "accountPermission"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankUser _ebean_get_bankUser() {
        this._ebean_intercept.preGetter(1);
        return this.bankUser;
    }

    protected /* synthetic */ void _ebean_set_bankUser(BankUser newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bankUser(), (Object)newValue);
        this.bankUser = newValue;
    }

    protected /* synthetic */ BankUser _ebean_getni_bankUser() {
        return this.bankUser;
    }

    protected /* synthetic */ void _ebean_setni_bankUser(BankUser _newValue) {
        this.bankUser = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ OrderType _ebean_get_orderType() {
        this._ebean_intercept.preGetter(2);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(OrderType newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ OrderType _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(OrderType _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ AuthorizationLevel _ebean_get_authLevel() {
        this._ebean_intercept.preGetter(3);
        return this.authLevel;
    }

    protected /* synthetic */ void _ebean_set_authLevel(AuthorizationLevel newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_authLevel(), (Object)newValue);
        this.authLevel = newValue;
    }

    protected /* synthetic */ AuthorizationLevel _ebean_getni_authLevel() {
        return this.authLevel;
    }

    protected /* synthetic */ void _ebean_setni_authLevel(AuthorizationLevel _newValue) {
        this.authLevel = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ BigDecimal _ebean_get_maxAmount() {
        this._ebean_intercept.preGetter(4);
        return this.maxAmount;
    }

    protected /* synthetic */ void _ebean_set_maxAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_maxAmount(), (Object)newValue);
        this.maxAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_maxAmount() {
        return this.maxAmount;
    }

    protected /* synthetic */ void _ebean_setni_maxAmount(BigDecimal _newValue) {
        this.maxAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_maxAmountCurrency() {
        this._ebean_intercept.preGetter(5);
        return this.maxAmountCurrency;
    }

    protected /* synthetic */ void _ebean_set_maxAmountCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_maxAmountCurrency(), (Object)newValue);
        this.maxAmountCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_maxAmountCurrency() {
        return this.maxAmountCurrency;
    }

    protected /* synthetic */ void _ebean_setni_maxAmountCurrency(String _newValue) {
        this.maxAmountCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ AccountPermission _ebean_get_accountPermission() {
        this._ebean_intercept.preGetter(6);
        return this.accountPermission;
    }

    protected /* synthetic */ void _ebean_set_accountPermission(AccountPermission newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_accountPermission(), (Object)newValue);
        this.accountPermission = newValue;
    }

    protected /* synthetic */ AccountPermission _ebean_getni_accountPermission() {
        return this.accountPermission;
    }

    protected /* synthetic */ void _ebean_setni_accountPermission(AccountPermission _newValue) {
        this.accountPermission = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bankUser;
            }
            case 2: {
                return this.orderType;
            }
            case 3: {
                return this.authLevel;
            }
            case 4: {
                return this.maxAmount;
            }
            case 5: {
                return this.maxAmountCurrency;
            }
            case 6: {
                return this.accountPermission;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bankUser();
            }
            case 2: {
                return this._ebean_get_orderType();
            }
            case 3: {
                return this._ebean_get_authLevel();
            }
            case 4: {
                return this._ebean_get_maxAmount();
            }
            case 5: {
                return this._ebean_get_maxAmountCurrency();
            }
            case 6: {
                return this._ebean_get_accountPermission();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bankUser((BankUser)o);
                return;
            }
            case 2: {
                this._ebean_setni_orderType((OrderType)o);
                return;
            }
            case 3: {
                this._ebean_setni_authLevel((AuthorizationLevel)((Object)o));
                return;
            }
            case 4: {
                this._ebean_setni_maxAmount((BigDecimal)o);
                return;
            }
            case 5: {
                this._ebean_setni_maxAmountCurrency((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_accountPermission((AccountPermission)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bankUser((BankUser)o);
                return;
            }
            case 2: {
                this._ebean_set_orderType((OrderType)o);
                return;
            }
            case 3: {
                this._ebean_set_authLevel((AuthorizationLevel)((Object)o));
                return;
            }
            case 4: {
                this._ebean_set_maxAmount((BigDecimal)o);
                return;
            }
            case 5: {
                this._ebean_set_maxAmountCurrency((String)o);
                return;
            }
            case 6: {
                this._ebean_set_accountPermission((AccountPermission)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        UserPermission userPermission = this;
        synchronized (userPermission) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((UserPermission)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new UserPermission();
    }

    public static enum AuthorizationLevel {
        SINGLE('E'),
        FIRST('A'),
        SECOND('B'),
        TRANSPORT('T');

        private final char letter;

        private AuthorizationLevel(char c) {
            this.letter = c;
        }

        public char getLetter() {
            return this.letter;
        }
    }
}

