/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmBookingFilter;
import de.businesslogics.banking.database.vo.CmCheck;
import de.businesslogics.banking.database.vo.ExportFileFilter;
import de.businesslogics.banking.database.vo.FetchFilter;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.LoginSession;
import de.businesslogics.banking.database.vo.NotificationFilter;
import de.businesslogics.banking.database.vo.OpenIdToken;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PasswordHistory;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PdfStatementsFilter;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.UserNotification;
import de.businesslogics.banking.database.vo.Yubikey;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.annotation.SoftDelete;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.io.File;
import java.security.SecureRandom;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="loginuser")
public class User
implements EntityBean {
    private static final Date PW_RESET_DATE;
    public static int LIMIT_ERROR_COUNTER;
    public static final int LOCK_ERROR_COUNTER = 99;
    public static final int RESET_ERROR_COUNTER = -1;
    public static final int NAME_MAX_LENGTH = 255;
    @Id
    @Column(name="id", nullable=false)
    private Integer id;
    @Column(name="name", nullable=false, length=256)
    private String name;
    @Column(name="is_admin", nullable=false)
    private boolean admin;
    @Column(name="security_medium", nullable=false)
    private SecurityMedium securityMedium;
    @Column(name="enc_key", nullable=false)
    @Lob
    private byte[] encryptionKey;
    @Column(name="key_dir", length=256)
    private String keyDirectory;
    @Column(name="iccsn", length=50)
    private String iccsn;
    @Column(name="driver", length=2048)
    private String driver;
    @Column(name="alias", length=256)
    private String alias;
    @Column(name="serial_number", length=50)
    private String serialNumber;
    @Lob
    private byte[] proxyPassword;
    @Column(length=256)
    private String proxyUser;
    private String systemName;
    @ManyToOne
    private License license;
    @ManyToOne
    private License webLicense;
    private Integer errorCounter;
    private Integer errorSignCounter;
    private Timestamp lastLogin;
    private Timestamp lastLoginError;
    private Date lastPasswordChange;
    @Column(length=128)
    private String randomId;
    @Column(length=300)
    private String challenge;
    @SoftDelete
    private boolean deleted;
    private Timestamp lastDesFetch;
    @Column(length=256)
    private String givenName;
    @Column(length=256)
    private String familyName;
    @Column(length=256)
    private String email;
    @Column
    private UUID uuid;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    private List<BankUser> bankUsers;
    @ManyToMany
    @JoinTable(name="loginuser_tenant")
    private List<Tenant> tenants;
    @ManyToMany
    @JoinTable(name="loginuser_managed_tenant")
    private List<Tenant> managedTenants;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="user")
    private List<Yubikey> yubikeys;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public User() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_securityMedium(SecurityMedium.SOFTWARE);
        this._ebean_set_deleted(false);
    }

    public static String createChallenge(User user) {
        SecureRandom r = new SecureRandom();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(r.nextInt(256));
        }
        user.setChallenge(b.toString());
        DB.save(user);
        return user.getChallenge();
    }

    public static byte[] getChallenge(User user) {
        String challenge = user.getChallenge();
        if (challenge == null) {
            return null;
        }
        String[] digits = challenge.split(",");
        byte[] byteArray = new byte[digits.length];
        int pos = 0;
        for (String i : digits) {
            byteArray[pos++] = Integer.valueOf(i).byteValue();
        }
        user.setChallenge(null);
        DB.save(user);
        return byteArray;
    }

    public static User getByWebAuthMigrationUUID(String uuid) {
        return (User)DB.find(User.class).where().eq("challenge", (Object)uuid).findOne();
    }

    public static List<User> getAllByBank(BankSettings bank) {
        return DB.find(User.class).orderBy("name").where().eq("bankUsers.bank", (Object)bank).findList();
    }

    public static List<User> getLocalUsersByBank(BankSettings bank) {
        return DB.find(User.class).where().eq("securityMedium", (Object)SecurityMedium.DUMMY).eq("bankUsers.bank", (Object)bank).findList();
    }

    public static List<User> getAllLocalAdmins(Tenant ... tenants) {
        ExpressionList q = DB.find(User.class).where().eq("admin", (Object)true).eq("securityMedium", (Object)SecurityMedium.DUMMY);
        if (tenants != null && tenants.length > 0) {
            q.in("tenants", (Object[])tenants);
        }
        return q.findList();
    }

    public static List<User> getAllAdmins() {
        return DB.find(User.class).where().eq("admin", (Object)true).findList();
    }

    public static List<User> getAllTenantAdmins(Tenant forTenant) {
        return DB.find(User.class).where().eq("managedTenants", (Object)forTenant).findList();
    }

    public static int getCount() {
        return DB.find(User.class).where().findCount();
    }

    public static int getNonLocalUsers() {
        return DB.find(User.class).where().ne("securityMedium", (Object)SecurityMedium.DUMMY).findCount();
    }

    public static List<User> getAll() {
        return DB.find(User.class).where().orderBy("name").findList();
    }

    public static User getByUUID(UUID uuid) {
        return (User)DB.find(User.class).where().eq("uuid", (Object)uuid).findOne();
    }

    public static List<User> getAllForTenants(Collection<Tenant> tenants, boolean withAdmins) {
        return User.getQueryForTenants(tenants, withAdmins).findList();
    }

    public static User getByIdForTenants(int id, Collection<Tenant> tenants, boolean withAdmins) {
        return (User)User.getQueryForTenants(tenants, withAdmins).where().eq("id", (Object)id).findOne();
    }

    public static int getNonLocalUserCountForTenant(Tenant tenant, boolean withAdmins) {
        ExpressionList expr = User.getQueryForTenants(Collections.singletonList(tenant), withAdmins).where();
        expr.ne("securityMedium", (Object)SecurityMedium.DUMMY);
        return expr.findCount();
    }

    public static Query<User> getQueryForTenants(Collection<Tenant> tenants, boolean withAdmins) {
        return User.getQueryForTenants(tenants, withAdmins, null);
    }

    public static Query<User> getQueryForTenants(Collection<Tenant> tenants, boolean withAdmins, Expression filterExpression) {
        ExpressionList expr = DB.find(User.class).where().in("tenants", tenants);
        if (!withAdmins) {
            expr.eq("admin", (Object)false);
        }
        if (filterExpression != null) {
            expr.add(filterExpression);
        }
        return expr.orderBy("name").query();
    }

    public static int getNonLocalUserCountByWebLicense(License license) {
        return DB.find(User.class).where().eq("webLicense", (Object)license).ne("securityMedium", (Object)SecurityMedium.DUMMY).findCount();
    }

    public static User getUser(String name) {
        return (User)DB.find(User.class).where().ieq("name", name).findOne();
    }

    public static List<User> getBySystemName(String name) {
        return DB.find(User.class).where().ieq("systemName", name).findList();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public UUID getUUID() {
        return this._ebean_get_uuid();
    }

    public void setUUID(UUID uuid) {
        this._ebean_set_uuid(uuid);
    }

    public UUID getOrCreateUUID() {
        if (this._ebean_get_uuid() == null) {
            this._ebean_set_uuid(UUID.randomUUID());
            this.save();
        }
        return this._ebean_get_uuid();
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public String getGivenName() {
        return this._ebean_get_givenName();
    }

    public void setGivenName(String givenName) {
        this._ebean_set_givenName(givenName);
    }

    public String getFamilyName() {
        return this._ebean_get_familyName();
    }

    public void setFamilyName(String familyName) {
        this._ebean_set_familyName(familyName);
    }

    public String getEmail() {
        return this._ebean_get_email();
    }

    public void setEmail(String email) {
        this._ebean_set_email(email);
    }

    public boolean isLocalUser() {
        return SecurityMedium.DUMMY.equals((Object)this.getSecurityMedium());
    }

    public boolean isAdmin() {
        return this._ebean_get_admin();
    }

    public boolean isTenantAdmin() {
        return !this._ebean_get_managedTenants().isEmpty();
    }

    public boolean isAdminOrTenantAdmin() {
        return this._ebean_get_admin() || this.isTenantAdmin();
    }

    public void setAdmin(boolean admin) {
        this._ebean_set_admin(admin);
    }

    public boolean isToBeImported() {
        return SecurityMedium.IMPORT.equals((Object)this.getSecurityMedium());
    }

    public SecurityMedium getSecurityMedium() {
        return this._ebean_get_securityMedium();
    }

    public void setSecurityMedium(SecurityMedium securityMedium) {
        this._ebean_set_securityMedium(securityMedium);
    }

    public byte[] getEncryptionKey() {
        return this._ebean_get_encryptionKey();
    }

    public void setEncryptionKey(byte[] encryptionKey) {
        this._ebean_set_encryptionKey(encryptionKey);
    }

    public String getKeyDirectory() {
        if (this._ebean_get_keyDirectory() != null) {
            return this._ebean_get_keyDirectory().replaceAll("[\\\\/]", Matcher.quoteReplacement(File.separator));
        }
        return null;
    }

    public void setKeyDirectory(String keyDirectory) {
        this._ebean_set_keyDirectory(keyDirectory);
    }

    public byte[] getProxyPassword() {
        return this._ebean_get_proxyPassword();
    }

    public void setProxyPassword(byte[] proxyPassword) {
        this._ebean_set_proxyPassword(proxyPassword);
    }

    public String getProxyUser() {
        return this._ebean_get_proxyUser();
    }

    public void setProxyUser(String proxyUser) {
        this._ebean_set_proxyUser(proxyUser);
    }

    public String getIccsn() {
        return this._ebean_get_iccsn();
    }

    public void setIccsn(String iccsn) {
        this._ebean_set_iccsn(iccsn);
    }

    public String getDriver() {
        return this._ebean_get_driver();
    }

    public void setDriver(String driver) {
        this._ebean_set_driver(driver);
    }

    public String[] getDriverArray() {
        if (this._ebean_get_driver() == null) {
            return new String[0];
        }
        return this._ebean_get_driver().split(";");
    }

    public void addDriver(String newDriver) {
        if (this._ebean_get_driver() == null) {
            this._ebean_set_driver(newDriver);
        } else {
            User user = this;
            user._ebean_set_driver(user._ebean_get_driver() + ";" + newDriver);
        }
    }

    public String getAlias() {
        return this._ebean_get_alias();
    }

    public void setAlias(String alias) {
        this._ebean_set_alias(alias);
    }

    public String getSerialNumber() {
        return this._ebean_get_serialNumber();
    }

    public void setSerialNumber(String serialNumber) {
        this._ebean_set_serialNumber(serialNumber);
    }

    public String getSystemName() {
        return this._ebean_get_systemName();
    }

    public void setSystemName(String systemName) {
        this._ebean_set_systemName(systemName);
    }

    public void resetPassword() {
        this.setLastPasswordChange(PW_RESET_DATE);
    }

    public boolean hasResetPassword() {
        Date lastChangeDate = this.getLastPasswordChange();
        return lastChangeDate != null && lastChangeDate.equals(PW_RESET_DATE);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete(boolean removeUsername) {
        BankUser.deleteByUser(this);
        CmCheck.deleteByUser(this);
        CmBookingFilter.deleteByUser(this);
        PdfStatementsFilter.deleteByUser(this);
        Sorting.deleteByUser(this, null);
        Preference.deleteByUser(this);
        PaymentFilter.deleteByUser(this);
        SendFilter.deleteByUser(this);
        FetchFilter.deleteByUser(this);
        ExportFileFilter.deleteByUser(this);
        NotificationFilter.deleteByUser(this);
        CmBookingFilter.deleteByUser(this);
        OpenPayment.unlockPayments(this);
        PasswordHistory.deleteByUser(this);
        SimpleTextFilter.deleteByUser(this);
        OpenIdToken.deleteByUser(this);
        UserNotification.deleteForUser(this);
        this._ebean_get_tenants().clear();
        this._ebean_get_managedTenants().clear();
        DB.save(this);
        if (removeUsername) {
            this.setName("");
            this.setEmail("");
            this.setGivenName("");
            this.setFamilyName("");
            this.setProxyUser("");
        }
        DB.delete(this);
    }

    public License getLicense() {
        return this._ebean_get_license();
    }

    public void setLicense(License license) {
        this._ebean_set_license(license);
    }

    public License getWebLicense() {
        return this._ebean_get_webLicense();
    }

    public void setWebLicense(License webLicense) {
        this._ebean_set_webLicense(webLicense);
    }

    public Timestamp getLastLogin() {
        return this._ebean_get_lastLogin();
    }

    public boolean setLoginError() {
        this._ebean_set_errorCounter(this.getErrorCounter() + 1);
        this._ebean_set_lastLoginError(new Timestamp(System.currentTimeMillis()));
        this.save();
        return this._ebean_get_errorCounter() >= LIMIT_ERROR_COUNTER;
    }

    public boolean setSignatureError() {
        this._ebean_set_errorSignCounter(this.getErrorSignCounter() + 1);
        this.save();
        return this._ebean_get_errorSignCounter() >= LIMIT_ERROR_COUNTER;
    }

    public Timestamp getLastLoginError() {
        return this._ebean_get_lastLoginError();
    }

    public long getNextLoginTry() {
        return this._ebean_get_lastLoginError().getTime() + (1L << Math.min(this.getErrorCounter(), 5)) * 1000L;
    }

    public int getRemainingPasswordTries() {
        return LIMIT_ERROR_COUNTER - this.getErrorCounter();
    }

    public int getRemainingSignatureTries() {
        return LIMIT_ERROR_COUNTER - this.getErrorSignCounter();
    }

    public int getErrorCounter() {
        DB.refresh(this);
        if (this._ebean_get_errorCounter() == null || this._ebean_get_errorCounter() < 0) {
            return 0;
        }
        return this._ebean_get_errorCounter();
    }

    public int getErrorSignCounter() {
        DB.refresh(this);
        if (this._ebean_get_errorSignCounter() == null || this._ebean_get_errorSignCounter() < 0) {
            return 0;
        }
        return this._ebean_get_errorSignCounter();
    }

    public void cleanLoginError() {
        this.cleanLoginError(true);
    }

    public void cleanLoginError(boolean setLastLogin) {
        this._ebean_set_errorCounter(null);
        this._ebean_set_lastLoginError(null);
        if (setLastLogin) {
            this._ebean_set_lastLogin(new Timestamp(System.currentTimeMillis()));
        }
        this.save();
    }

    public void cleanSignatureError() {
        if (this._ebean_get_errorSignCounter() != null && this._ebean_get_errorSignCounter() != 0) {
            this._ebean_set_errorSignCounter(null);
            this.save();
        }
    }

    public void lock() {
        this._ebean_set_errorCounter(99);
        this._ebean_set_errorSignCounter(99);
        this.save();
        LoginSession.closeSessionByUserId(this._ebean_get_id().intValue());
    }

    public void resetLoginErrorCounter() {
        if (this._ebean_get_errorCounter() != null && this._ebean_get_errorCounter() > 0) {
            this._ebean_set_errorCounter(-1);
            this.save();
        }
    }

    public void resetSignatureErrorCounter() {
        if (this._ebean_get_errorSignCounter() != null && this._ebean_get_errorSignCounter() > 0) {
            this._ebean_set_errorSignCounter(-1);
            this.save();
        }
    }

    public long errorTimeout() {
        if (this._ebean_get_lastLoginError() == null || this._ebean_get_errorCounter() == null) {
            return 0L;
        }
        long start = this._ebean_get_lastLoginError().getTime();
        long end = start + (1L << this.getErrorCounter()) * 1000L;
        long now = System.currentTimeMillis();
        if (now > end) {
            return 0L;
        }
        return end - now;
    }

    public boolean isLocked() {
        DB.refresh(this);
        return this._ebean_get_errorCounter() != null && this._ebean_get_errorCounter() >= LIMIT_ERROR_COUNTER || this._ebean_get_errorSignCounter() != null && this._ebean_get_errorSignCounter() >= LIMIT_ERROR_COUNTER;
    }

    public boolean wasErrorCounterReset() {
        return this._ebean_get_errorCounter() != null && this._ebean_get_errorCounter() == -1;
    }

    public boolean wasErrorSignCounterReset() {
        return this._ebean_get_errorSignCounter() != null && this._ebean_get_errorSignCounter() == -1;
    }

    public Date getLastPasswordChange() {
        return this._ebean_get_lastPasswordChange();
    }

    public void setLastPasswordChange(Date lastPasswordChange) {
        this._ebean_set_lastPasswordChange(lastPasswordChange);
    }

    public Timestamp getLastDesFetch() {
        return this._ebean_get_lastDesFetch();
    }

    public void setLastDesFetch(Timestamp lastDesFetch) {
        this._ebean_set_lastDesFetch(lastDesFetch);
    }

    public List<Tenant> getTenants() {
        return this._ebean_get_tenants();
    }

    public void setTenants(List<Tenant> tenants) {
        this._ebean_set_tenants(tenants);
    }

    public List<Tenant> getManagedTenants() {
        return this._ebean_get_managedTenants();
    }

    public void setManagedTenants(List<Tenant> managedTenants) {
        this._ebean_set_managedTenants(managedTenants);
    }

    public String getRandomId() {
        return this._ebean_get_randomId();
    }

    public void setRandomId(String randomId) {
        this._ebean_set_randomId(randomId);
    }

    public static Expression getFilterExpression(String searchString) {
        if (searchString == null || searchString.length() == 0) {
            return null;
        }
        String like = "%" + searchString + "%";
        Expression expression = Expr.ilike((String)"name", (String)like);
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"tenants.name", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"bankUsers.defaultUser", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"bankUsers.bank.customerId", (String)like));
        return expression;
    }

    public List<Tenant> getManageableTenants() {
        if (this.isAdmin()) {
            return Tenant.getAllTenants();
        }
        return this.getManagedTenants();
    }

    public List<Tenant> getManageableTenantsSorted() {
        List<Tenant> toReturn = this.getManageableTenants();
        toReturn.sort((tenant, t1) -> tenant.getName().compareToIgnoreCase(t1.getName()));
        return toReturn;
    }

    public List<Tenant> getVisibleTenants() {
        if (this.isAdmin()) {
            return Tenant.getAllTenants();
        }
        if (this.isTenantAdmin()) {
            HashSet<Tenant> visibleTenants = new HashSet<Tenant>(this.getManagedTenants());
            visibleTenants.addAll(this.getTenants());
            return new ArrayList<Tenant>(visibleTenants);
        }
        return this.getTenants();
    }

    public List<Tenant> getVisibleTenantsSorted() {
        List<Tenant> toReturn = this.getVisibleTenants();
        toReturn.sort((tenant, t1) -> tenant.getName().compareToIgnoreCase(t1.getName()));
        return toReturn;
    }

    public String getChallenge() {
        return this._ebean_get_challenge();
    }

    public void setChallenge(String challenge) {
        this._ebean_set_challenge(challenge);
    }

    static {
        _ebean_props = new String[]{"id", "name", "admin", "securityMedium", "encryptionKey", "keyDirectory", "iccsn", "driver", "alias", "serialNumber", "proxyPassword", "proxyUser", "systemName", "license", "webLicense", "errorCounter", "errorSignCounter", "lastLogin", "lastLoginError", "lastPasswordChange", "randomId", "challenge", "deleted", "lastDesFetch", "givenName", "familyName", "email", "uuid", "bankUsers", "tenants", "managedTenants", "yubikeys"};
        LIMIT_ERROR_COUNTER = 5;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 1999);
        cal.set(2, 11);
        cal.set(5, 31);
        PW_RESET_DATE = new Date(cal.getTimeInMillis());
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ boolean _ebean_get_admin() {
        this._ebean_intercept.preGetter(2);
        return this.admin;
    }

    protected /* synthetic */ void _ebean_set_admin(boolean newValue) {
        this._ebean_intercept.preSetter(true, 2, this._ebean_get_admin(), newValue);
        this.admin = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_admin() {
        return this.admin;
    }

    protected /* synthetic */ void _ebean_setni_admin(boolean _newValue) {
        this.admin = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ SecurityMedium _ebean_get_securityMedium() {
        this._ebean_intercept.preGetter(3);
        return this.securityMedium;
    }

    protected /* synthetic */ void _ebean_set_securityMedium(SecurityMedium newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_securityMedium(), (Object)newValue);
        this.securityMedium = newValue;
    }

    protected /* synthetic */ SecurityMedium _ebean_getni_securityMedium() {
        return this.securityMedium;
    }

    protected /* synthetic */ void _ebean_setni_securityMedium(SecurityMedium _newValue) {
        this.securityMedium = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ byte[] _ebean_get_encryptionKey() {
        this._ebean_intercept.preGetter(4);
        return this.encryptionKey;
    }

    protected /* synthetic */ void _ebean_set_encryptionKey(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 4, this._ebean_get_encryptionKey(), newValue);
        this.encryptionKey = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_encryptionKey() {
        return this.encryptionKey;
    }

    protected /* synthetic */ void _ebean_setni_encryptionKey(byte[] _newValue) {
        this.encryptionKey = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_keyDirectory() {
        this._ebean_intercept.preGetter(5);
        return this.keyDirectory;
    }

    protected /* synthetic */ void _ebean_set_keyDirectory(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_keyDirectory(), (Object)newValue);
        this.keyDirectory = newValue;
    }

    protected /* synthetic */ String _ebean_getni_keyDirectory() {
        return this.keyDirectory;
    }

    protected /* synthetic */ void _ebean_setni_keyDirectory(String _newValue) {
        this.keyDirectory = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_iccsn() {
        this._ebean_intercept.preGetter(6);
        return this.iccsn;
    }

    protected /* synthetic */ void _ebean_set_iccsn(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_iccsn(), (Object)newValue);
        this.iccsn = newValue;
    }

    protected /* synthetic */ String _ebean_getni_iccsn() {
        return this.iccsn;
    }

    protected /* synthetic */ void _ebean_setni_iccsn(String _newValue) {
        this.iccsn = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_driver() {
        this._ebean_intercept.preGetter(7);
        return this.driver;
    }

    protected /* synthetic */ void _ebean_set_driver(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_driver(), (Object)newValue);
        this.driver = newValue;
    }

    protected /* synthetic */ String _ebean_getni_driver() {
        return this.driver;
    }

    protected /* synthetic */ void _ebean_setni_driver(String _newValue) {
        this.driver = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_alias() {
        this._ebean_intercept.preGetter(8);
        return this.alias;
    }

    protected /* synthetic */ void _ebean_set_alias(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_alias(), (Object)newValue);
        this.alias = newValue;
    }

    protected /* synthetic */ String _ebean_getni_alias() {
        return this.alias;
    }

    protected /* synthetic */ void _ebean_setni_alias(String _newValue) {
        this.alias = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_serialNumber() {
        this._ebean_intercept.preGetter(9);
        return this.serialNumber;
    }

    protected /* synthetic */ void _ebean_set_serialNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_serialNumber(), (Object)newValue);
        this.serialNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_serialNumber() {
        return this.serialNumber;
    }

    protected /* synthetic */ void _ebean_setni_serialNumber(String _newValue) {
        this.serialNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ byte[] _ebean_get_proxyPassword() {
        this._ebean_intercept.preGetter(10);
        return this.proxyPassword;
    }

    protected /* synthetic */ void _ebean_set_proxyPassword(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 10, this._ebean_get_proxyPassword(), newValue);
        this.proxyPassword = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_proxyPassword() {
        return this.proxyPassword;
    }

    protected /* synthetic */ void _ebean_setni_proxyPassword(byte[] _newValue) {
        this.proxyPassword = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ String _ebean_get_proxyUser() {
        this._ebean_intercept.preGetter(11);
        return this.proxyUser;
    }

    protected /* synthetic */ void _ebean_set_proxyUser(String newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_proxyUser(), (Object)newValue);
        this.proxyUser = newValue;
    }

    protected /* synthetic */ String _ebean_getni_proxyUser() {
        return this.proxyUser;
    }

    protected /* synthetic */ void _ebean_setni_proxyUser(String _newValue) {
        this.proxyUser = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_systemName() {
        this._ebean_intercept.preGetter(12);
        return this.systemName;
    }

    protected /* synthetic */ void _ebean_set_systemName(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_systemName(), (Object)newValue);
        this.systemName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_systemName() {
        return this.systemName;
    }

    protected /* synthetic */ void _ebean_setni_systemName(String _newValue) {
        this.systemName = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ License _ebean_get_license() {
        this._ebean_intercept.preGetter(13);
        return this.license;
    }

    protected /* synthetic */ void _ebean_set_license(License newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_license(), (Object)newValue);
        this.license = newValue;
    }

    protected /* synthetic */ License _ebean_getni_license() {
        return this.license;
    }

    protected /* synthetic */ void _ebean_setni_license(License _newValue) {
        this.license = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ License _ebean_get_webLicense() {
        this._ebean_intercept.preGetter(14);
        return this.webLicense;
    }

    protected /* synthetic */ void _ebean_set_webLicense(License newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_webLicense(), (Object)newValue);
        this.webLicense = newValue;
    }

    protected /* synthetic */ License _ebean_getni_webLicense() {
        return this.webLicense;
    }

    protected /* synthetic */ void _ebean_setni_webLicense(License _newValue) {
        this.webLicense = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ Integer _ebean_get_errorCounter() {
        this._ebean_intercept.preGetter(15);
        return this.errorCounter;
    }

    protected /* synthetic */ void _ebean_set_errorCounter(Integer newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_errorCounter(), (Object)newValue);
        this.errorCounter = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_errorCounter() {
        return this.errorCounter;
    }

    protected /* synthetic */ void _ebean_setni_errorCounter(Integer _newValue) {
        this.errorCounter = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ Integer _ebean_get_errorSignCounter() {
        this._ebean_intercept.preGetter(16);
        return this.errorSignCounter;
    }

    protected /* synthetic */ void _ebean_set_errorSignCounter(Integer newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_errorSignCounter(), (Object)newValue);
        this.errorSignCounter = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_errorSignCounter() {
        return this.errorSignCounter;
    }

    protected /* synthetic */ void _ebean_setni_errorSignCounter(Integer _newValue) {
        this.errorSignCounter = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ Timestamp _ebean_get_lastLogin() {
        this._ebean_intercept.preGetter(17);
        return this.lastLogin;
    }

    protected /* synthetic */ void _ebean_set_lastLogin(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_lastLogin(), (Object)newValue);
        this.lastLogin = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_lastLogin() {
        return this.lastLogin;
    }

    protected /* synthetic */ void _ebean_setni_lastLogin(Timestamp _newValue) {
        this.lastLogin = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ Timestamp _ebean_get_lastLoginError() {
        this._ebean_intercept.preGetter(18);
        return this.lastLoginError;
    }

    protected /* synthetic */ void _ebean_set_lastLoginError(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_lastLoginError(), (Object)newValue);
        this.lastLoginError = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_lastLoginError() {
        return this.lastLoginError;
    }

    protected /* synthetic */ void _ebean_setni_lastLoginError(Timestamp _newValue) {
        this.lastLoginError = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ Date _ebean_get_lastPasswordChange() {
        this._ebean_intercept.preGetter(19);
        return this.lastPasswordChange;
    }

    protected /* synthetic */ void _ebean_set_lastPasswordChange(Date newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_lastPasswordChange(), (Object)newValue);
        this.lastPasswordChange = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_lastPasswordChange() {
        return this.lastPasswordChange;
    }

    protected /* synthetic */ void _ebean_setni_lastPasswordChange(Date _newValue) {
        this.lastPasswordChange = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ String _ebean_get_randomId() {
        this._ebean_intercept.preGetter(20);
        return this.randomId;
    }

    protected /* synthetic */ void _ebean_set_randomId(String newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_randomId(), (Object)newValue);
        this.randomId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_randomId() {
        return this.randomId;
    }

    protected /* synthetic */ void _ebean_setni_randomId(String _newValue) {
        this.randomId = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ String _ebean_get_challenge() {
        this._ebean_intercept.preGetter(21);
        return this.challenge;
    }

    protected /* synthetic */ void _ebean_set_challenge(String newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_challenge(), (Object)newValue);
        this.challenge = newValue;
    }

    protected /* synthetic */ String _ebean_getni_challenge() {
        return this.challenge;
    }

    protected /* synthetic */ void _ebean_setni_challenge(String _newValue) {
        this.challenge = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ boolean _ebean_get_deleted() {
        this._ebean_intercept.preGetter(22);
        return this.deleted;
    }

    protected /* synthetic */ void _ebean_set_deleted(boolean newValue) {
        this._ebean_intercept.preSetter(true, 22, this._ebean_get_deleted(), newValue);
        this.deleted = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_deleted() {
        return this.deleted;
    }

    protected /* synthetic */ void _ebean_setni_deleted(boolean _newValue) {
        this.deleted = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ Timestamp _ebean_get_lastDesFetch() {
        this._ebean_intercept.preGetter(23);
        return this.lastDesFetch;
    }

    protected /* synthetic */ void _ebean_set_lastDesFetch(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_lastDesFetch(), (Object)newValue);
        this.lastDesFetch = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_lastDesFetch() {
        return this.lastDesFetch;
    }

    protected /* synthetic */ void _ebean_setni_lastDesFetch(Timestamp _newValue) {
        this.lastDesFetch = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ String _ebean_get_givenName() {
        this._ebean_intercept.preGetter(24);
        return this.givenName;
    }

    protected /* synthetic */ void _ebean_set_givenName(String newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_givenName(), (Object)newValue);
        this.givenName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_givenName() {
        return this.givenName;
    }

    protected /* synthetic */ void _ebean_setni_givenName(String _newValue) {
        this.givenName = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ String _ebean_get_familyName() {
        this._ebean_intercept.preGetter(25);
        return this.familyName;
    }

    protected /* synthetic */ void _ebean_set_familyName(String newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_familyName(), (Object)newValue);
        this.familyName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_familyName() {
        return this.familyName;
    }

    protected /* synthetic */ void _ebean_setni_familyName(String _newValue) {
        this.familyName = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ String _ebean_get_email() {
        this._ebean_intercept.preGetter(26);
        return this.email;
    }

    protected /* synthetic */ void _ebean_set_email(String newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_email(), (Object)newValue);
        this.email = newValue;
    }

    protected /* synthetic */ String _ebean_getni_email() {
        return this.email;
    }

    protected /* synthetic */ void _ebean_setni_email(String _newValue) {
        this.email = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    protected /* synthetic */ UUID _ebean_get_uuid() {
        this._ebean_intercept.preGetter(27);
        return this.uuid;
    }

    protected /* synthetic */ void _ebean_set_uuid(UUID newValue) {
        this._ebean_intercept.preSetter(true, 27, (Object)this._ebean_get_uuid(), (Object)newValue);
        this.uuid = newValue;
    }

    protected /* synthetic */ UUID _ebean_getni_uuid() {
        return this.uuid;
    }

    protected /* synthetic */ void _ebean_setni_uuid(UUID _newValue) {
        this.uuid = _newValue;
        this._ebean_intercept.setLoadedProperty(27);
    }

    protected /* synthetic */ List _ebean_get_bankUsers() {
        this._ebean_intercept.preGetter(28);
        if (this.bankUsers == null) {
            this.bankUsers = new BeanList();
            this._ebean_intercept.initialisedMany(28);
        }
        return this.bankUsers;
    }

    protected /* synthetic */ void _ebean_set_bankUsers(List newValue) {
        this._ebean_intercept.preSetterMany(false, 28, this.bankUsers, (Object)newValue);
        this.bankUsers = newValue;
    }

    protected /* synthetic */ List _ebean_getni_bankUsers() {
        return this.bankUsers;
    }

    protected /* synthetic */ void _ebean_setni_bankUsers(List _newValue) {
        this.bankUsers = _newValue;
        this._ebean_intercept.setLoadedProperty(28);
    }

    protected /* synthetic */ List _ebean_get_tenants() {
        this._ebean_intercept.preGetter(29);
        if (this.tenants == null) {
            this.tenants = new BeanList();
            this._ebean_intercept.initialisedMany(29);
            ((BeanCollection)this.tenants).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.tenants;
    }

    protected /* synthetic */ void _ebean_set_tenants(List newValue) {
        this._ebean_intercept.preSetterMany(false, 29, this.tenants, (Object)newValue);
        this.tenants = newValue;
    }

    protected /* synthetic */ List _ebean_getni_tenants() {
        return this.tenants;
    }

    protected /* synthetic */ void _ebean_setni_tenants(List _newValue) {
        this.tenants = _newValue;
        this._ebean_intercept.setLoadedProperty(29);
    }

    protected /* synthetic */ List _ebean_get_managedTenants() {
        this._ebean_intercept.preGetter(30);
        if (this.managedTenants == null) {
            this.managedTenants = new BeanList();
            this._ebean_intercept.initialisedMany(30);
            ((BeanCollection)this.managedTenants).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.managedTenants;
    }

    protected /* synthetic */ void _ebean_set_managedTenants(List newValue) {
        this._ebean_intercept.preSetterMany(false, 30, this.managedTenants, (Object)newValue);
        this.managedTenants = newValue;
    }

    protected /* synthetic */ List _ebean_getni_managedTenants() {
        return this.managedTenants;
    }

    protected /* synthetic */ void _ebean_setni_managedTenants(List _newValue) {
        this.managedTenants = _newValue;
        this._ebean_intercept.setLoadedProperty(30);
    }

    protected /* synthetic */ List _ebean_get_yubikeys() {
        this._ebean_intercept.preGetter(31);
        if (this.yubikeys == null) {
            this.yubikeys = new BeanList();
            this._ebean_intercept.initialisedMany(31);
        }
        return this.yubikeys;
    }

    protected /* synthetic */ void _ebean_set_yubikeys(List newValue) {
        this._ebean_intercept.preSetterMany(false, 31, this.yubikeys, (Object)newValue);
        this.yubikeys = newValue;
    }

    protected /* synthetic */ List _ebean_getni_yubikeys() {
        return this.yubikeys;
    }

    protected /* synthetic */ void _ebean_setni_yubikeys(List _newValue) {
        this.yubikeys = _newValue;
        this._ebean_intercept.setLoadedProperty(31);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.admin;
            }
            case 3: {
                return this.securityMedium;
            }
            case 4: {
                return this.encryptionKey;
            }
            case 5: {
                return this.keyDirectory;
            }
            case 6: {
                return this.iccsn;
            }
            case 7: {
                return this.driver;
            }
            case 8: {
                return this.alias;
            }
            case 9: {
                return this.serialNumber;
            }
            case 10: {
                return this.proxyPassword;
            }
            case 11: {
                return this.proxyUser;
            }
            case 12: {
                return this.systemName;
            }
            case 13: {
                return this.license;
            }
            case 14: {
                return this.webLicense;
            }
            case 15: {
                return this.errorCounter;
            }
            case 16: {
                return this.errorSignCounter;
            }
            case 17: {
                return this.lastLogin;
            }
            case 18: {
                return this.lastLoginError;
            }
            case 19: {
                return this.lastPasswordChange;
            }
            case 20: {
                return this.randomId;
            }
            case 21: {
                return this.challenge;
            }
            case 22: {
                return this.deleted;
            }
            case 23: {
                return this.lastDesFetch;
            }
            case 24: {
                return this.givenName;
            }
            case 25: {
                return this.familyName;
            }
            case 26: {
                return this.email;
            }
            case 27: {
                return this.uuid;
            }
            case 28: {
                return this.bankUsers;
            }
            case 29: {
                return this.tenants;
            }
            case 30: {
                return this.managedTenants;
            }
            case 31: {
                return this.yubikeys;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_admin();
            }
            case 3: {
                return this._ebean_get_securityMedium();
            }
            case 4: {
                return this._ebean_get_encryptionKey();
            }
            case 5: {
                return this._ebean_get_keyDirectory();
            }
            case 6: {
                return this._ebean_get_iccsn();
            }
            case 7: {
                return this._ebean_get_driver();
            }
            case 8: {
                return this._ebean_get_alias();
            }
            case 9: {
                return this._ebean_get_serialNumber();
            }
            case 10: {
                return this._ebean_get_proxyPassword();
            }
            case 11: {
                return this._ebean_get_proxyUser();
            }
            case 12: {
                return this._ebean_get_systemName();
            }
            case 13: {
                return this._ebean_get_license();
            }
            case 14: {
                return this._ebean_get_webLicense();
            }
            case 15: {
                return this._ebean_get_errorCounter();
            }
            case 16: {
                return this._ebean_get_errorSignCounter();
            }
            case 17: {
                return this._ebean_get_lastLogin();
            }
            case 18: {
                return this._ebean_get_lastLoginError();
            }
            case 19: {
                return this._ebean_get_lastPasswordChange();
            }
            case 20: {
                return this._ebean_get_randomId();
            }
            case 21: {
                return this._ebean_get_challenge();
            }
            case 22: {
                return this._ebean_get_deleted();
            }
            case 23: {
                return this._ebean_get_lastDesFetch();
            }
            case 24: {
                return this._ebean_get_givenName();
            }
            case 25: {
                return this._ebean_get_familyName();
            }
            case 26: {
                return this._ebean_get_email();
            }
            case 27: {
                return this._ebean_get_uuid();
            }
            case 28: {
                return this._ebean_get_bankUsers();
            }
            case 29: {
                return this._ebean_get_tenants();
            }
            case 30: {
                return this._ebean_get_managedTenants();
            }
            case 31: {
                return this._ebean_get_yubikeys();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_admin((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_setni_securityMedium((SecurityMedium)((Object)o));
                return;
            }
            case 4: {
                this._ebean_setni_encryptionKey((byte[])o);
                return;
            }
            case 5: {
                this._ebean_setni_keyDirectory((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_iccsn((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_driver((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_alias((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_serialNumber((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_proxyPassword((byte[])o);
                return;
            }
            case 11: {
                this._ebean_setni_proxyUser((String)o);
                return;
            }
            case 12: {
                this._ebean_setni_systemName((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_license((License)o);
                return;
            }
            case 14: {
                this._ebean_setni_webLicense((License)o);
                return;
            }
            case 15: {
                this._ebean_setni_errorCounter((Integer)o);
                return;
            }
            case 16: {
                this._ebean_setni_errorSignCounter((Integer)o);
                return;
            }
            case 17: {
                this._ebean_setni_lastLogin((Timestamp)o);
                return;
            }
            case 18: {
                this._ebean_setni_lastLoginError((Timestamp)o);
                return;
            }
            case 19: {
                this._ebean_setni_lastPasswordChange((Date)o);
                return;
            }
            case 20: {
                this._ebean_setni_randomId((String)o);
                return;
            }
            case 21: {
                this._ebean_setni_challenge((String)o);
                return;
            }
            case 22: {
                this._ebean_setni_deleted((Boolean)o);
                return;
            }
            case 23: {
                this._ebean_setni_lastDesFetch((Timestamp)o);
                return;
            }
            case 24: {
                this._ebean_setni_givenName((String)o);
                return;
            }
            case 25: {
                this._ebean_setni_familyName((String)o);
                return;
            }
            case 26: {
                this._ebean_setni_email((String)o);
                return;
            }
            case 27: {
                this._ebean_setni_uuid((UUID)o);
                return;
            }
            case 28: {
                this._ebean_setni_bankUsers((List)o);
                return;
            }
            case 29: {
                this._ebean_setni_tenants((List)o);
                return;
            }
            case 30: {
                this._ebean_setni_managedTenants((List)o);
                return;
            }
            case 31: {
                this._ebean_setni_yubikeys((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_admin((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_set_securityMedium((SecurityMedium)((Object)o));
                return;
            }
            case 4: {
                this._ebean_set_encryptionKey((byte[])o);
                return;
            }
            case 5: {
                this._ebean_set_keyDirectory((String)o);
                return;
            }
            case 6: {
                this._ebean_set_iccsn((String)o);
                return;
            }
            case 7: {
                this._ebean_set_driver((String)o);
                return;
            }
            case 8: {
                this._ebean_set_alias((String)o);
                return;
            }
            case 9: {
                this._ebean_set_serialNumber((String)o);
                return;
            }
            case 10: {
                this._ebean_set_proxyPassword((byte[])o);
                return;
            }
            case 11: {
                this._ebean_set_proxyUser((String)o);
                return;
            }
            case 12: {
                this._ebean_set_systemName((String)o);
                return;
            }
            case 13: {
                this._ebean_set_license((License)o);
                return;
            }
            case 14: {
                this._ebean_set_webLicense((License)o);
                return;
            }
            case 15: {
                this._ebean_set_errorCounter((Integer)o);
                return;
            }
            case 16: {
                this._ebean_set_errorSignCounter((Integer)o);
                return;
            }
            case 17: {
                this._ebean_set_lastLogin((Timestamp)o);
                return;
            }
            case 18: {
                this._ebean_set_lastLoginError((Timestamp)o);
                return;
            }
            case 19: {
                this._ebean_set_lastPasswordChange((Date)o);
                return;
            }
            case 20: {
                this._ebean_set_randomId((String)o);
                return;
            }
            case 21: {
                this._ebean_set_challenge((String)o);
                return;
            }
            case 22: {
                this._ebean_set_deleted((Boolean)o);
                return;
            }
            case 23: {
                this._ebean_set_lastDesFetch((Timestamp)o);
                return;
            }
            case 24: {
                this._ebean_set_givenName((String)o);
                return;
            }
            case 25: {
                this._ebean_set_familyName((String)o);
                return;
            }
            case 26: {
                this._ebean_set_email((String)o);
                return;
            }
            case 27: {
                this._ebean_set_uuid((UUID)o);
                return;
            }
            case 28: {
                this._ebean_set_bankUsers((List)o);
                return;
            }
            case 29: {
                this._ebean_set_tenants((List)o);
                return;
            }
            case 30: {
                this._ebean_set_managedTenants((List)o);
                return;
            }
            case 31: {
                this._ebean_set_yubikeys((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        User user = this;
        synchronized (user) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((User)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new User();
    }

    public static enum SecurityMedium {
        SOFTWARE,
        SMARTCARD,
        PKCS11,
        DUMMY,
        IMPORT;

    }
}

