/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import io.ebean.ExpressionList;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="pmt_urgnt_rcpnt")
public class UrgentPaymentRecipient
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankSettings bank;
    @Column(name="orgntr_acct_number", length=34)
    private String originatorAccountNumber;
    @Column(name="orgntr_bank_code", length=11)
    private String originatorBankCode;
    @Column(name="rcpnt_acct_number", length=34)
    private String recipientAccountNumber;
    @Column(name="rcpnt_bank_code", length=11)
    private String recipientBankCode;
    @Column(name="rcpnt_name", length=35)
    private String recipientName;
    @Column(name="rcpnt_tp")
    private UrgentPaymentRecipientType recipientType;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public UrgentPaymentRecipient() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static List<UrgentPaymentRecipient> findForOriginatorAccount(BankSettings bank, UrgentPaymentRecipientType recipientType, String bankCode, String accountNumber) {
        return DB.find(UrgentPaymentRecipient.class).where().eq("bank", (Object)bank).eq("recipientType", (Object)recipientType).eq("originatorBankCode", (Object)bankCode).eq("originatorAccountNumber", (Object)accountNumber).findList();
    }

    public static List<?> findIdsForBank(BankSettings bank, UrgentPaymentRecipientType recipientType) {
        return DB.find(UrgentPaymentRecipient.class).where().eq("bank", (Object)bank).eq("recipientType", (Object)recipientType).findIds();
    }

    public static UrgentPaymentRecipient findRecipient(BankSettings bank, UrgentPaymentRecipientType recipientType, String originatorBankCode, String originatorAccountNumber, String recipientBankCode, String recipientAccountNumber) {
        ExpressionList expr = DB.find(UrgentPaymentRecipient.class).where().eq("bank", (Object)bank).eq("recipientType", (Object)recipientType).eq("originatorAccountNumber", (Object)originatorAccountNumber).eq("recipientAccountNumber", (Object)recipientAccountNumber);
        expr = originatorBankCode != null ? expr.eq("originatorBankCode", (Object)originatorBankCode) : expr.isNull("originatorBankCode");
        expr = recipientBankCode != null ? expr.eq("recipientBankCode", (Object)recipientBankCode) : expr.isNull("recipientBankCode");
        return (UrgentPaymentRecipient)expr.setMaxRows(1).findOne();
    }

    public static void deleteByIds(List<?> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        for (int offset = 0; offset < ids.size(); offset += 500) {
            int toIndex = Math.min(offset + 500, ids.size());
            DB.deleteAll(UrgentPaymentRecipient.class, ids.subList(offset, toIndex));
        }
    }

    public static int deleteByBank(BankSettings bank) {
        Update<UrgentPaymentRecipient> delete = DB.createUpdate(UrgentPaymentRecipient.class, "DELETE FROM UrgentPaymentRecipient WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public String getOriginatorAccountNumber() {
        return this._ebean_get_originatorAccountNumber();
    }

    public void setOriginatorAccountNumber(String originatorAccountNumber) {
        this._ebean_set_originatorAccountNumber(originatorAccountNumber);
    }

    public String getOriginatorBankCode() {
        return this._ebean_get_originatorBankCode();
    }

    public void setOriginatorBankCode(String originatorBankCode) {
        this._ebean_set_originatorBankCode(originatorBankCode);
    }

    public String getRecipientAccountNumber() {
        return this._ebean_get_recipientAccountNumber();
    }

    public void setRecipientAccountNumber(String recipientAccountNumber) {
        this._ebean_set_recipientAccountNumber(recipientAccountNumber);
    }

    public String getRecipientBankCode() {
        return this._ebean_get_recipientBankCode();
    }

    public void setRecipientBankCode(String recipientBankCode) {
        this._ebean_set_recipientBankCode(recipientBankCode);
    }

    public String getRecipientName() {
        return this._ebean_get_recipientName();
    }

    public void setRecipientName(String recipientName) {
        this._ebean_set_recipientName(recipientName);
    }

    public String getAccountRepresentation() {
        if (this._ebean_get_recipientBankCode() == null || this._ebean_get_recipientBankCode().length() == 0) {
            return String.format("%1$s (%2$s)", this._ebean_get_recipientName(), this._ebean_get_recipientAccountNumber());
        }
        return String.format("%1$s (%2$s/%3$s)", this._ebean_get_recipientName(), this._ebean_get_recipientBankCode(), this._ebean_get_recipientAccountNumber());
    }

    public UrgentPaymentRecipientType getRecipientType() {
        return this._ebean_get_recipientType();
    }

    public void setRecipientType(UrgentPaymentRecipientType recipientType) {
        this._ebean_set_recipientType(recipientType);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "bank", "originatorAccountNumber", "originatorBankCode", "recipientAccountNumber", "recipientBankCode", "recipientName", "recipientType"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_originatorAccountNumber() {
        this._ebean_intercept.preGetter(2);
        return this.originatorAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_originatorAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_originatorAccountNumber(), (Object)newValue);
        this.originatorAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originatorAccountNumber() {
        return this.originatorAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_originatorAccountNumber(String _newValue) {
        this.originatorAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_originatorBankCode() {
        this._ebean_intercept.preGetter(3);
        return this.originatorBankCode;
    }

    protected /* synthetic */ void _ebean_set_originatorBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_originatorBankCode(), (Object)newValue);
        this.originatorBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originatorBankCode() {
        return this.originatorBankCode;
    }

    protected /* synthetic */ void _ebean_setni_originatorBankCode(String _newValue) {
        this.originatorBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_recipientAccountNumber() {
        this._ebean_intercept.preGetter(4);
        return this.recipientAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_recipientAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_recipientAccountNumber(), (Object)newValue);
        this.recipientAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipientAccountNumber() {
        return this.recipientAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_recipientAccountNumber(String _newValue) {
        this.recipientAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_recipientBankCode() {
        this._ebean_intercept.preGetter(5);
        return this.recipientBankCode;
    }

    protected /* synthetic */ void _ebean_set_recipientBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_recipientBankCode(), (Object)newValue);
        this.recipientBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipientBankCode() {
        return this.recipientBankCode;
    }

    protected /* synthetic */ void _ebean_setni_recipientBankCode(String _newValue) {
        this.recipientBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_recipientName() {
        this._ebean_intercept.preGetter(6);
        return this.recipientName;
    }

    protected /* synthetic */ void _ebean_set_recipientName(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_recipientName(), (Object)newValue);
        this.recipientName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipientName() {
        return this.recipientName;
    }

    protected /* synthetic */ void _ebean_setni_recipientName(String _newValue) {
        this.recipientName = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ UrgentPaymentRecipientType _ebean_get_recipientType() {
        this._ebean_intercept.preGetter(7);
        return this.recipientType;
    }

    protected /* synthetic */ void _ebean_set_recipientType(UrgentPaymentRecipientType newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_recipientType(), (Object)newValue);
        this.recipientType = newValue;
    }

    protected /* synthetic */ UrgentPaymentRecipientType _ebean_getni_recipientType() {
        return this.recipientType;
    }

    protected /* synthetic */ void _ebean_setni_recipientType(UrgentPaymentRecipientType _newValue) {
        this.recipientType = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.originatorAccountNumber;
            }
            case 3: {
                return this.originatorBankCode;
            }
            case 4: {
                return this.recipientAccountNumber;
            }
            case 5: {
                return this.recipientBankCode;
            }
            case 6: {
                return this.recipientName;
            }
            case 7: {
                return this.recipientType;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_originatorAccountNumber();
            }
            case 3: {
                return this._ebean_get_originatorBankCode();
            }
            case 4: {
                return this._ebean_get_recipientAccountNumber();
            }
            case 5: {
                return this._ebean_get_recipientBankCode();
            }
            case 6: {
                return this._ebean_get_recipientName();
            }
            case 7: {
                return this._ebean_get_recipientType();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_originatorAccountNumber((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_originatorBankCode((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_recipientAccountNumber((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_recipientBankCode((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_recipientName((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_recipientType((UrgentPaymentRecipientType)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_originatorAccountNumber((String)o);
                return;
            }
            case 3: {
                this._ebean_set_originatorBankCode((String)o);
                return;
            }
            case 4: {
                this._ebean_set_recipientAccountNumber((String)o);
                return;
            }
            case 5: {
                this._ebean_set_recipientBankCode((String)o);
                return;
            }
            case 6: {
                this._ebean_set_recipientName((String)o);
                return;
            }
            case 7: {
                this._ebean_set_recipientType((UrgentPaymentRecipientType)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        UrgentPaymentRecipient urgentPaymentRecipient = this;
        synchronized (urgentPaymentRecipient) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((UrgentPaymentRecipient)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new UrgentPaymentRecipient();
    }

    public static enum UrgentPaymentRecipientType {
        DTAUS,
        SEPA;

    }
}

