/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import io.ebean.annotation.SoftDelete;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;

@Entity
public class Tenant
implements EntityBean {
    private static Tenant DEFAULT_TENANT;
    @Id
    @Column(name="id", nullable=false)
    private Integer id;
    @Column(name="name", nullable=false, unique=true, length=256)
    private String name;
    @Column
    private Integer userCount;
    @Column
    private UUID uuid;
    @SoftDelete
    private boolean deleted;
    @Column
    private UUID adminsUuid;
    @ManyToMany(mappedBy="tenants", fetch=FetchType.LAZY)
    private List<User> users;
    @ManyToMany(mappedBy="managedTenants", fetch=FetchType.LAZY)
    private List<User> managingUsers;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public Tenant() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_deleted(false);
    }

    public static Tenant getDefaultTenant() {
        if (DEFAULT_TENANT == null) {
            DEFAULT_TENANT = (Tenant)DB.find(Tenant.class).order("id asc").setMaxRows(1).findOne();
        }
        return DEFAULT_TENANT;
    }

    public static Tenant getATenant() {
        return (Tenant)DB.find(Tenant.class).setMaxRows(1).findOne();
    }

    public static List<Tenant> getAllTenants() {
        return DB.find(Tenant.class).findList();
    }

    public static void ensureDefaultTenant() {
        if (DB.find(Tenant.class).findCount() < 1) {
            DEFAULT_TENANT = new Tenant();
            DEFAULT_TENANT.setName("DEFAULT");
            DEFAULT_TENANT.save();
        } else {
            DEFAULT_TENANT = (Tenant)DB.find(Tenant.class).where().eq("name", (Object)"DEFAULT").findOne();
        }
    }

    public static Query<Tenant> getQuery(User user) {
        return DB.find(Tenant.class).where().eq("managingUsers", (Object)user).query();
    }

    public static Tenant findById(int id, User user, boolean managedTenants) {
        if (user.isAdmin()) {
            return Tenant.findById(id);
        }
        if (managedTenants) {
            return Tenant.findByIdAndManagingUser(id, user);
        }
        return Tenant.findByIdAndUser(id, user);
    }

    public static Tenant findById(int id) {
        return DB.find(Tenant.class, id);
    }

    private static Tenant findByIdAndUser(int id, User user) {
        return (Tenant)DB.find(Tenant.class).where().eq("users", (Object)user).eq("id", (Object)id).findOne();
    }

    private static Tenant findByIdAndManagingUser(int id, User user) {
        return (Tenant)DB.find(Tenant.class).where().eq("managingUsers", (Object)user).eq("id", (Object)id).findOne();
    }

    public static List<Tenant> findByIds(List<Integer> ids, User user, boolean managedTenants) {
        if (user.isAdmin()) {
            return DB.find(Tenant.class).where().in("id", ids).findList();
        }
        if (managedTenants) {
            return Tenant.findByIdsAndManagingUser(ids, user);
        }
        return Tenant.findByIdsAndUser(ids, user);
    }

    public static Tenant findByUUID(UUID uuid) {
        return (Tenant)DB.find(Tenant.class).where().eq("uuid", (Object)uuid).findOne();
    }

    public static Tenant findByAdminsUUID(UUID uuid) {
        return (Tenant)DB.find(Tenant.class).where().eq("adminsUuid", (Object)uuid).findOne();
    }

    private static List<Tenant> findByIdsAndUser(List<Integer> ids, User user) {
        return DB.find(Tenant.class).where().eq("users", (Object)user).in("id", ids).findList();
    }

    private static List<Tenant> findByIdsAndManagingUser(List<Integer> ids, User user) {
        return DB.find(Tenant.class).where().eq("managingUsers", (Object)user).in("id", ids).findList();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public Integer getUserCount() {
        return this._ebean_get_userCount();
    }

    public void setUserCount(Integer userCount) {
        this._ebean_set_userCount(userCount);
    }

    public UUID getUUID() {
        return this._ebean_get_uuid();
    }

    public void setUUID(UUID uuid) {
        this._ebean_set_uuid(uuid);
    }

    public UUID getOrCreateUUID() {
        if (this._ebean_get_uuid() == null) {
            this._ebean_set_uuid(UUID.randomUUID());
            this.save();
        }
        return this._ebean_get_uuid();
    }

    public UUID getAdminsUUID() {
        return this._ebean_get_adminsUuid();
    }

    public void setAdminsUUID(UUID adminsUuid) {
        this._ebean_set_adminsUuid(adminsUuid);
    }

    public UUID getOrCreateAdminsUUID() {
        if (this._ebean_get_adminsUuid() == null) {
            this._ebean_set_adminsUuid(UUID.randomUUID());
            this.save();
        }
        return this._ebean_get_adminsUuid();
    }

    public List<User> getUsers() {
        return this._ebean_get_users();
    }

    public List<User> getManagingUsers() {
        return this._ebean_get_managingUsers();
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public boolean checkUniqueName() {
        Tenant other = (Tenant)DB.find(Tenant.class).setIncludeSoftDeletes().where().eq("name", (Object)this._ebean_get_name()).findOne();
        return other == null || other.getId().equals(this._ebean_get_id());
    }

    public static Expression getFilterExpression(String searchString) {
        if (searchString == null || searchString.length() == 0) {
            return null;
        }
        String like = "%" + searchString + "%";
        Expression expression = Expr.ilike((String)"name", (String)like);
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"users.bankUsers.bank.customerId", (String)like));
        return expression;
    }

    static {
        _ebean_props = new String[]{"id", "name", "userCount", "uuid", "deleted", "adminsUuid", "users", "managingUsers"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Integer _ebean_get_userCount() {
        this._ebean_intercept.preGetter(2);
        return this.userCount;
    }

    protected /* synthetic */ void _ebean_set_userCount(Integer newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_userCount(), (Object)newValue);
        this.userCount = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_userCount() {
        return this.userCount;
    }

    protected /* synthetic */ void _ebean_setni_userCount(Integer _newValue) {
        this.userCount = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ UUID _ebean_get_uuid() {
        this._ebean_intercept.preGetter(3);
        return this.uuid;
    }

    protected /* synthetic */ void _ebean_set_uuid(UUID newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_uuid(), (Object)newValue);
        this.uuid = newValue;
    }

    protected /* synthetic */ UUID _ebean_getni_uuid() {
        return this.uuid;
    }

    protected /* synthetic */ void _ebean_setni_uuid(UUID _newValue) {
        this.uuid = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ boolean _ebean_get_deleted() {
        this._ebean_intercept.preGetter(4);
        return this.deleted;
    }

    protected /* synthetic */ void _ebean_set_deleted(boolean newValue) {
        this._ebean_intercept.preSetter(true, 4, this._ebean_get_deleted(), newValue);
        this.deleted = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_deleted() {
        return this.deleted;
    }

    protected /* synthetic */ void _ebean_setni_deleted(boolean _newValue) {
        this.deleted = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ UUID _ebean_get_adminsUuid() {
        this._ebean_intercept.preGetter(5);
        return this.adminsUuid;
    }

    protected /* synthetic */ void _ebean_set_adminsUuid(UUID newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_adminsUuid(), (Object)newValue);
        this.adminsUuid = newValue;
    }

    protected /* synthetic */ UUID _ebean_getni_adminsUuid() {
        return this.adminsUuid;
    }

    protected /* synthetic */ void _ebean_setni_adminsUuid(UUID _newValue) {
        this.adminsUuid = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ List _ebean_get_users() {
        this._ebean_intercept.preGetter(6);
        if (this.users == null) {
            this.users = new BeanList();
            this._ebean_intercept.initialisedMany(6);
            ((BeanCollection)this.users).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.users;
    }

    protected /* synthetic */ void _ebean_set_users(List newValue) {
        this._ebean_intercept.preSetterMany(false, 6, this.users, (Object)newValue);
        this.users = newValue;
    }

    protected /* synthetic */ List _ebean_getni_users() {
        return this.users;
    }

    protected /* synthetic */ void _ebean_setni_users(List _newValue) {
        this.users = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ List _ebean_get_managingUsers() {
        this._ebean_intercept.preGetter(7);
        if (this.managingUsers == null) {
            this.managingUsers = new BeanList();
            this._ebean_intercept.initialisedMany(7);
            ((BeanCollection)this.managingUsers).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.managingUsers;
    }

    protected /* synthetic */ void _ebean_set_managingUsers(List newValue) {
        this._ebean_intercept.preSetterMany(false, 7, this.managingUsers, (Object)newValue);
        this.managingUsers = newValue;
    }

    protected /* synthetic */ List _ebean_getni_managingUsers() {
        return this.managingUsers;
    }

    protected /* synthetic */ void _ebean_setni_managingUsers(List _newValue) {
        this.managingUsers = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.userCount;
            }
            case 3: {
                return this.uuid;
            }
            case 4: {
                return this.deleted;
            }
            case 5: {
                return this.adminsUuid;
            }
            case 6: {
                return this.users;
            }
            case 7: {
                return this.managingUsers;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_userCount();
            }
            case 3: {
                return this._ebean_get_uuid();
            }
            case 4: {
                return this._ebean_get_deleted();
            }
            case 5: {
                return this._ebean_get_adminsUuid();
            }
            case 6: {
                return this._ebean_get_users();
            }
            case 7: {
                return this._ebean_get_managingUsers();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_userCount((Integer)o);
                return;
            }
            case 3: {
                this._ebean_setni_uuid((UUID)o);
                return;
            }
            case 4: {
                this._ebean_setni_deleted((Boolean)o);
                return;
            }
            case 5: {
                this._ebean_setni_adminsUuid((UUID)o);
                return;
            }
            case 6: {
                this._ebean_setni_users((List)o);
                return;
            }
            case 7: {
                this._ebean_setni_managingUsers((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_userCount((Integer)o);
                return;
            }
            case 3: {
                this._ebean_set_uuid((UUID)o);
                return;
            }
            case 4: {
                this._ebean_set_deleted((Boolean)o);
                return;
            }
            case 5: {
                this._ebean_set_adminsUuid((UUID)o);
                return;
            }
            case 6: {
                this._ebean_set_users((List)o);
                return;
            }
            case 7: {
                this._ebean_set_managingUsers((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        Tenant tenant = this;
        synchronized (tenant) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Tenant)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new Tenant();
    }
}

