/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.iban.IbanUtil;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.Update;
import io.ebean.annotation.Index;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="pmt_signed")
@Index(name="ix_pmt_signed_execution_date", columnNames={"execution_date", "account_id"})
public class SignedPayment
implements EntityBean {
    private static final String RJCT = "RJCT";
    @Id
    private Integer id;
    @ManyToOne
    private Account account;
    @ManyToOne
    private PaymentFolder folder;
    @ManyToOne(optional=false)
    private Send send;
    @ManyToOne
    private CmBooking booking;
    private Integer logicalFile;
    private Integer paymentNumber;
    @ManyToOne
    private Send callback;
    private PaymentTransferType.PmtType pmtType;
    @Column(name="is_credit")
    private Boolean credit;
    @Column(name="is_urgent")
    private Boolean urgent;
    @Column(length=70)
    private String originator;
    @Column(length=70)
    private String recipient;
    @Column(precision=38, scale=3)
    private BigDecimal amount;
    @Column(precision=38, scale=3)
    private BigDecimal salaryAmount;
    @Column(length=3)
    private String amountCurrency;
    @Column(length=140)
    private String purpose;
    private Timestamp executionDate;
    @Column(length=50)
    private String reference;
    private Boolean manualPayment;
    private Boolean salaryPayment;
    @Column(length=35)
    private String pmtInfId;
    private Send.State state;
    @Column(length=4)
    private String sts;
    @Lob
    private String statusReasonInfo;
    @Column(length=4)
    private String cnclSts;
    @Column(length=4)
    private String vopSts;
    @Lob
    private byte[] paymentData;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public SignedPayment() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static Query<SignedPayment> getDefaultQuery(User user, List<Send> selectedSendItems, boolean showAllPayments, boolean excludeSalaries, boolean onlyPaymentsWithPermission) {
        return SignedPayment.getDefaultQuery(user, selectedSendItems, null, showAllPayments, excludeSalaries, onlyPaymentsWithPermission);
    }

    public static Query<SignedPayment> getDefaultQuery(User user, List<Send> selectedSendItems, PaymentFolder folder, boolean showAllPayments, boolean excludeSalaries, boolean onlyPaymentsWithPermission) {
        List<BankSettings> banks = BankSettings.findBanksForUser(user);
        Query<SignedPayment> q = DB.find(SignedPayment.class);
        q.where().in("account.bank", banks);
        if (selectedSendItems == null) {
            if (!showAllPayments) {
                q.where().add(Expr.eq((String)"manualPayment", (Object)true));
            }
        } else {
            q.where().add(Expr.in((String)"send", selectedSendItems));
        }
        if (folder != null && folder.getId() != null) {
            q.where().eq("folder", (Object)folder);
        } else if (((Object)PaymentFolder.NULL_FOLDER).equals(folder)) {
            q.where().isNull("folder");
        }
        if (excludeSalaries) {
            q.where().add(Expr.eq((String)"salaryPayment", (Object)false));
        }
        if (onlyPaymentsWithPermission) {
            Expression accountFilter = Account.buildExpressionForAccountPermissions(user, "account");
            if (accountFilter == null) {
                return q.where(Expr.isNull((String)"account"));
            }
            q.where().add(accountFilter);
        }
        return q;
    }

    public static int removeFolderReferences(PaymentFolder folder) {
        Update<SignedPayment> update = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET folder = null WHERE folder=:folder");
        update.setParameter("folder", (Object)folder.getId());
        return update.execute();
    }

    public static Query<SignedPayment> getSignedPaymentsQuery(BankSettings bank) {
        return DB.find(SignedPayment.class).where().eq("send.bank", (Object)bank).query();
    }

    public static int findCountBySend(Send send) {
        return DB.find(SignedPayment.class).where().eq("send", (Object)send).findCount();
    }

    public static int findCountBookedBySend(Send send) {
        return DB.find(SignedPayment.class).where().eq("send", (Object)send).isNotNull("booking").findCount();
    }

    public static int setStatusCode(String statusCode, Send send) {
        Update<SignedPayment> updateStatusCode = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET sts=:param1 WHERE send_id=:param2");
        updateStatusCode.setParameter("param1", (Object)statusCode);
        updateStatusCode.setParameter("param2", (Object)send.getId());
        return updateStatusCode.execute();
    }

    public static int setStatusCode(String statusCode, Send send, String pmtInfId) {
        Update<SignedPayment> updateStatusCode = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET sts=:param1 WHERE send_id=:param2 AND pmt_inf_id=:param3");
        updateStatusCode.setParameter("param1", (Object)statusCode);
        updateStatusCode.setParameter("param2", (Object)send.getId());
        updateStatusCode.setParameter("param3", (Object)pmtInfId);
        return updateStatusCode.execute();
    }

    public static int setStatusCode(String statusCode, Send send, String pmtInfId, String endToEndId) {
        Update<SignedPayment> updateStatusCode = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET sts=:param1 WHERE send_id=:param2 AND pmt_inf_id=:param3 AND reference=:param4");
        updateStatusCode.setParameter("param1", (Object)statusCode);
        updateStatusCode.setParameter("param2", (Object)send.getId());
        updateStatusCode.setParameter("param3", (Object)pmtInfId);
        updateStatusCode.setParameter("param4", (Object)endToEndId);
        return updateStatusCode.execute();
    }

    public static int setVopStatusCode(String statusCode, Send send) {
        Update<SignedPayment> updateStatusCode = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET vopSts=:param1 WHERE send_id=:param2");
        updateStatusCode.setParameter("param1", (Object)statusCode);
        updateStatusCode.setParameter("param2", (Object)send.getId());
        return updateStatusCode.execute();
    }

    public static int setVopStatusCode(String statusCode, Send send, String pmtInfId) {
        Update<SignedPayment> updateStatusCode = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET vopSts=:param1 WHERE send_id=:param2 AND pmt_inf_id=:param3");
        updateStatusCode.setParameter("param1", (Object)statusCode);
        updateStatusCode.setParameter("param2", (Object)send.getId());
        updateStatusCode.setParameter("param3", (Object)pmtInfId);
        return updateStatusCode.execute();
    }

    public static int setVopStatusCode(String statusCode, Send send, String pmtInfId, String endToEndId) {
        Update<SignedPayment> updateStatusCode = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET vopSts=:param1 WHERE send_id=:param2 AND pmt_inf_id=:param3 AND reference=:param4");
        updateStatusCode.setParameter("param1", (Object)statusCode);
        updateStatusCode.setParameter("param2", (Object)send.getId());
        updateStatusCode.setParameter("param3", (Object)pmtInfId);
        updateStatusCode.setParameter("param4", (Object)endToEndId);
        return updateStatusCode.execute();
    }

    public static int setBookingId(CmBooking booking, Send send, String pmtInfId) {
        Update<SignedPayment> updateBookingId = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET booking_id=:param1, sts=:param2 WHERE send_id=:param3 AND account_id=:param4 AND pmt_inf_id=:param5");
        updateBookingId.setParameter("param1", (Object)booking.getId());
        if (PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)send.getPmtType())) {
            updateBookingId.setParameter("param2", (Object)"ACCP");
        } else {
            updateBookingId.setParameter("param2", (Object)"ACSC");
        }
        updateBookingId.setParameter("param3", (Object)send.getId());
        updateBookingId.setParameter("param4", (Object)booking.getAccount().getId());
        updateBookingId.setParameter("param5", (Object)pmtInfId);
        return updateBookingId.execute();
    }

    public static int setBookingId(CmBooking booking, Send send, String pmtInfId, String endToEndId) {
        Update<SignedPayment> updateBookingId = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET booking_id=:param1, sts=:param2 WHERE send_id=:param3 AND account_id=:param4 AND pmt_inf_id=:param5 AND reference=:param6");
        updateBookingId.setParameter("param1", (Object)booking.getId());
        if (PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)send.getPmtType())) {
            updateBookingId.setParameter("param2", (Object)"ACCP");
        } else {
            updateBookingId.setParameter("param2", (Object)"ACSC");
        }
        updateBookingId.setParameter("param3", (Object)send.getId());
        updateBookingId.setParameter("param4", (Object)booking.getAccount().getId());
        updateBookingId.setParameter("param5", (Object)pmtInfId);
        updateBookingId.setParameter("param6", (Object)endToEndId);
        return updateBookingId.execute();
    }

    public static int findCountLogicalFilesBySend(Send send) {
        SqlQuery query = DB.createSqlQuery("SELECT COUNT(DISTINCT pmt_inf_id) AS anzahl FROM pmt_signed WHERE send_id=:id");
        query.setParameter("id", (Object)send.getId());
        List list = query.findList();
        if (!list.isEmpty()) {
            return ((SqlRow)list.get(0)).getInteger("anzahl");
        }
        return 0;
    }

    public static int findCountByAccount(Account a) {
        return DB.find(SignedPayment.class).where().eq("account", (Object)a).findCount();
    }

    public static int findCountBySendWithCallbackFlag(Send send) {
        return DB.find(SignedPayment.class).where().eq("send", (Object)send).isNotNull("callback").findCount();
    }

    public static int setCallbackForAllPayments(Send send, Integer callbackId) {
        Update<SignedPayment> updateCallback = DB.createUpdate(SignedPayment.class, "UPDATE SignedPayment SET callback_id=:callback WHERE send_id=:send");
        updateCallback.setParameter("send", (Object)send.getId());
        updateCallback.setParameter("callback", (Object)callbackId);
        return updateCallback.execute();
    }

    public static List<SignedPayment> findCancelledByPmtInfId(BankSettings bank, String pmtInfId) {
        return DB.find(SignedPayment.class).where().eq("pmtInfId", (Object)pmtInfId).isNotNull("callback").eq("account.bank", (Object)bank).findList();
    }

    public static List<SignedPayment> findCancelledByEndToEndId(BankSettings bank, String endToEndId) {
        return DB.find(SignedPayment.class).where().eq("reference", (Object)endToEndId).isNotNull("callback").eq("account.bank", (Object)bank).findList();
    }

    public static List<SignedPayment> findBySend(Send send) {
        return DB.find(SignedPayment.class).where().eq("send", (Object)send).findList();
    }

    public static List<SignedPayment> findByPmtInfId(Send send, String pmtInfId) {
        return DB.find(SignedPayment.class).where().eq("send", (Object)send).eq("pmtInfId", (Object)pmtInfId).findList();
    }

    public static List<SignedPayment> findByEndToEndId(Send send, String pmtInfId, String endToEndId) {
        return DB.find(SignedPayment.class).where().eq("reference", (Object)endToEndId).eq("pmtInfId", (Object)pmtInfId).eq("send", (Object)send).findList();
    }

    public static Query<SignedPayment> getDefaultQuery(User user, PaymentFolder folder, boolean onlyPaymentsWithPermission, boolean excludeSalaries, boolean showAllPayments) {
        return SignedPayment.getDefaultQuery(user, null, folder, showAllPayments, excludeSalaries, onlyPaymentsWithPermission);
    }

    public static int getSignedPaymentsCount(User user, PaymentFolder folder, boolean onlyPaymentsWithPermission, boolean excludeSalaries, boolean showAllPayments) {
        return SignedPayment.getDefaultQuery(user, folder, onlyPaymentsWithPermission, excludeSalaries, showAllPayments).findCount();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public PaymentFolder getFolder() {
        return this._ebean_get_folder();
    }

    public void setFolder(PaymentFolder folder) {
        this._ebean_set_folder(folder);
    }

    public boolean isCredit() {
        if (this._ebean_get_credit() == null) {
            return false;
        }
        return this._ebean_get_credit();
    }

    public void setCredit(boolean isCredit) {
        this._ebean_set_credit(isCredit);
    }

    public boolean isUrgent() {
        if (this._ebean_get_urgent() == null) {
            return false;
        }
        return this._ebean_get_urgent();
    }

    public void setUrgent(boolean isUrgent) {
        this._ebean_set_urgent(isUrgent);
    }

    public String getOriginator() {
        return this._ebean_get_originator();
    }

    public void setOriginator(String originator) {
        this._ebean_set_originator(originator);
    }

    public String getRecipient() {
        return this._ebean_get_recipient();
    }

    public static String getRecipientWithAccountNumber(SignedPayment payment, boolean showRecipientWithAccountNumber, boolean useMandates) {
        return SignedPayment.getRecipientWithAccountNumber(payment.getRecipient(), payment.isCredit(), payment.getAccount(), showRecipientWithAccountNumber, useMandates);
    }

    public static String getRecipientWithAccountNumber(String recipientName, boolean isCredit, Account originatorAccount, boolean showRecipientWithAccountNumber, boolean useMandates) {
        if (showRecipientWithAccountNumber) {
            String accNumber;
            int n;
            List<PaymentRecipient> paymentRecipients;
            Tenant tenant = originatorAccount.getBank().getTenant();
            ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
            paymentTypes.add(PaymentType.MANDATE);
            if (isCredit || !useMandates) {
                paymentTypes.add(PaymentType.SEPA);
            }
            if ((paymentRecipients = PaymentRecipient.findRecipientByName(paymentTypes, recipientName, tenant)) != null && (n = paymentRecipients.size()) == 1 && (accNumber = paymentRecipients.get(0).getAccountNumber()) != null) {
                return recipientName + " (" + IbanUtil.formatIfIBAN(accNumber) + ")";
            }
        }
        return recipientName;
    }

    public void setRecipient(String recipient) {
        this._ebean_set_recipient(recipient);
    }

    public BigDecimal getAmount() {
        return this._ebean_get_amount();
    }

    public void setAmount(BigDecimal amount) {
        this._ebean_set_amount(amount);
    }

    public String getAmountCurrency() {
        return this._ebean_get_amountCurrency();
    }

    public void setAmountCurrency(String amountCurrency) {
        this._ebean_set_amountCurrency(amountCurrency);
    }

    public String getPurpose() {
        return this._ebean_get_purpose();
    }

    public void setPurpose(String purpose) {
        if (purpose != null && purpose.length() > 140) {
            this._ebean_set_purpose(purpose.substring(0, 140));
        } else {
            this._ebean_set_purpose(purpose);
        }
    }

    public Timestamp getExecutionDate() {
        return this._ebean_get_executionDate();
    }

    public void setExecutionDate(Timestamp executionDate) {
        this._ebean_set_executionDate(executionDate);
    }

    public byte[] getPaymentData() {
        return this._ebean_get_paymentData();
    }

    public void setPaymentData(byte[] paymentData) {
        this._ebean_set_paymentData(paymentData);
    }

    public Send getSend() {
        return this._ebean_get_send();
    }

    public void setSend(Send send) {
        this._ebean_set_send(send);
    }

    public CmBooking getBooking() {
        return this._ebean_get_booking();
    }

    public void setBooking(CmBooking booking) {
        this._ebean_set_booking(booking);
    }

    public String getReference() {
        return this._ebean_get_reference();
    }

    public void setReference(String reference) {
        this._ebean_set_reference(reference);
    }

    public boolean isManualPayment() {
        if (this._ebean_get_manualPayment() == null) {
            return false;
        }
        return this._ebean_get_manualPayment();
    }

    public void setManualPayment(boolean manualPayment) {
        this._ebean_set_manualPayment(manualPayment);
    }

    public boolean isSalaryPayment() {
        if (this._ebean_get_salaryPayment() == null) {
            return false;
        }
        return this._ebean_get_salaryPayment();
    }

    public void setSalaryPayment(boolean salaryPayment) {
        this._ebean_set_salaryPayment(salaryPayment);
    }

    public BigDecimal getSalaryAmount() {
        return this._ebean_get_salaryAmount();
    }

    public void setSalaryAmount(BigDecimal salaryAmount) {
        this._ebean_set_salaryAmount(salaryAmount);
    }

    public Integer getLogicalFile() {
        return this._ebean_get_logicalFile();
    }

    public void setLogicalFile(Integer logicalFile) {
        this._ebean_set_logicalFile(logicalFile);
    }

    public Integer getPaymentNumber() {
        return this._ebean_get_paymentNumber();
    }

    public void setPaymentNumber(Integer paymentNumber) {
        this._ebean_set_paymentNumber(paymentNumber);
    }

    public final void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public final void delete() {
        if (this._ebean_get_id() == null) {
            return;
        }
        DB.delete(this);
    }

    public Send getCallback() {
        return this._ebean_get_callback();
    }

    public void setCallback(Send callback) {
        this._ebean_set_callback(callback);
    }

    public Send.State getState() {
        if (this._ebean_get_state() == null) {
            return this.getSend().getState();
        }
        return this._ebean_get_state();
    }

    public void setState(Send.State state) {
        this._ebean_set_state(state);
    }

    public String getSts() {
        return this._ebean_get_sts();
    }

    public void setSts(String sts) {
        this._ebean_set_sts(sts);
    }

    public boolean isRejected() {
        return RJCT.equals(this._ebean_get_sts());
    }

    public String getStatusReasonInfo() {
        return this._ebean_get_statusReasonInfo();
    }

    public void setStatusReasonInfo(String statusReasonInfo) {
        this._ebean_set_statusReasonInfo(statusReasonInfo);
    }

    public String getCancellationStatus() {
        return this._ebean_get_cnclSts();
    }

    public void setCancellationSatus(String cnclSts) {
        this._ebean_set_cnclSts(cnclSts);
    }

    public String getVopSts() {
        return this._ebean_get_vopSts();
    }

    public void setVopSts(String vopSts) {
        this._ebean_set_vopSts(vopSts);
    }

    public String getPmtInfId() {
        return this._ebean_get_pmtInfId();
    }

    public void setPmtInfId(String pmtInfId) {
        this._ebean_set_pmtInfId(pmtInfId);
    }

    static {
        _ebean_props = new String[]{"id", "account", "folder", "send", "booking", "logicalFile", "paymentNumber", "callback", "pmtType", "credit", "urgent", "originator", "recipient", "amount", "salaryAmount", "amountCurrency", "purpose", "executionDate", "reference", "manualPayment", "salaryPayment", "pmtInfId", "state", "sts", "statusReasonInfo", "cnclSts", "vopSts", "paymentData"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(1);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ PaymentFolder _ebean_get_folder() {
        this._ebean_intercept.preGetter(2);
        return this.folder;
    }

    protected /* synthetic */ void _ebean_set_folder(PaymentFolder newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_folder(), (Object)newValue);
        this.folder = newValue;
    }

    protected /* synthetic */ PaymentFolder _ebean_getni_folder() {
        return this.folder;
    }

    protected /* synthetic */ void _ebean_setni_folder(PaymentFolder _newValue) {
        this.folder = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Send _ebean_get_send() {
        this._ebean_intercept.preGetter(3);
        return this.send;
    }

    protected /* synthetic */ void _ebean_set_send(Send newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_send(), (Object)newValue);
        this.send = newValue;
    }

    protected /* synthetic */ Send _ebean_getni_send() {
        return this.send;
    }

    protected /* synthetic */ void _ebean_setni_send(Send _newValue) {
        this.send = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ CmBooking _ebean_get_booking() {
        this._ebean_intercept.preGetter(4);
        return this.booking;
    }

    protected /* synthetic */ void _ebean_set_booking(CmBooking newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_booking(), (Object)newValue);
        this.booking = newValue;
    }

    protected /* synthetic */ CmBooking _ebean_getni_booking() {
        return this.booking;
    }

    protected /* synthetic */ void _ebean_setni_booking(CmBooking _newValue) {
        this.booking = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Integer _ebean_get_logicalFile() {
        this._ebean_intercept.preGetter(5);
        return this.logicalFile;
    }

    protected /* synthetic */ void _ebean_set_logicalFile(Integer newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_logicalFile(), (Object)newValue);
        this.logicalFile = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_logicalFile() {
        return this.logicalFile;
    }

    protected /* synthetic */ void _ebean_setni_logicalFile(Integer _newValue) {
        this.logicalFile = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ Integer _ebean_get_paymentNumber() {
        this._ebean_intercept.preGetter(6);
        return this.paymentNumber;
    }

    protected /* synthetic */ void _ebean_set_paymentNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_paymentNumber(), (Object)newValue);
        this.paymentNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_paymentNumber() {
        return this.paymentNumber;
    }

    protected /* synthetic */ void _ebean_setni_paymentNumber(Integer _newValue) {
        this.paymentNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ Send _ebean_get_callback() {
        this._ebean_intercept.preGetter(7);
        return this.callback;
    }

    protected /* synthetic */ void _ebean_set_callback(Send newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_callback(), (Object)newValue);
        this.callback = newValue;
    }

    protected /* synthetic */ Send _ebean_getni_callback() {
        return this.callback;
    }

    protected /* synthetic */ void _ebean_setni_callback(Send _newValue) {
        this.callback = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(8);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PaymentTransferType.PmtType newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PaymentTransferType.PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ Boolean _ebean_get_credit() {
        this._ebean_intercept.preGetter(9);
        return this.credit;
    }

    protected /* synthetic */ void _ebean_set_credit(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_credit(), (Object)newValue);
        this.credit = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_credit() {
        return this.credit;
    }

    protected /* synthetic */ void _ebean_setni_credit(Boolean _newValue) {
        this.credit = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ Boolean _ebean_get_urgent() {
        this._ebean_intercept.preGetter(10);
        return this.urgent;
    }

    protected /* synthetic */ void _ebean_set_urgent(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_urgent(), (Object)newValue);
        this.urgent = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_urgent() {
        return this.urgent;
    }

    protected /* synthetic */ void _ebean_setni_urgent(Boolean _newValue) {
        this.urgent = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ String _ebean_get_originator() {
        this._ebean_intercept.preGetter(11);
        return this.originator;
    }

    protected /* synthetic */ void _ebean_set_originator(String newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_originator(), (Object)newValue);
        this.originator = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originator() {
        return this.originator;
    }

    protected /* synthetic */ void _ebean_setni_originator(String _newValue) {
        this.originator = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_recipient() {
        this._ebean_intercept.preGetter(12);
        return this.recipient;
    }

    protected /* synthetic */ void _ebean_set_recipient(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_recipient(), (Object)newValue);
        this.recipient = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipient() {
        return this.recipient;
    }

    protected /* synthetic */ void _ebean_setni_recipient(String _newValue) {
        this.recipient = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amount() {
        this._ebean_intercept.preGetter(13);
        return this.amount;
    }

    protected /* synthetic */ void _ebean_set_amount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_amount(), (Object)newValue);
        this.amount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amount() {
        return this.amount;
    }

    protected /* synthetic */ void _ebean_setni_amount(BigDecimal _newValue) {
        this.amount = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ BigDecimal _ebean_get_salaryAmount() {
        this._ebean_intercept.preGetter(14);
        return this.salaryAmount;
    }

    protected /* synthetic */ void _ebean_set_salaryAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_salaryAmount(), (Object)newValue);
        this.salaryAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_salaryAmount() {
        return this.salaryAmount;
    }

    protected /* synthetic */ void _ebean_setni_salaryAmount(BigDecimal _newValue) {
        this.salaryAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_amountCurrency() {
        this._ebean_intercept.preGetter(15);
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_set_amountCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_amountCurrency(), (Object)newValue);
        this.amountCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_amountCurrency() {
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_setni_amountCurrency(String _newValue) {
        this.amountCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_purpose() {
        this._ebean_intercept.preGetter(16);
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_set_purpose(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_purpose(), (Object)newValue);
        this.purpose = newValue;
    }

    protected /* synthetic */ String _ebean_getni_purpose() {
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_setni_purpose(String _newValue) {
        this.purpose = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ Timestamp _ebean_get_executionDate() {
        this._ebean_intercept.preGetter(17);
        return this.executionDate;
    }

    protected /* synthetic */ void _ebean_set_executionDate(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_executionDate(), (Object)newValue);
        this.executionDate = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_executionDate() {
        return this.executionDate;
    }

    protected /* synthetic */ void _ebean_setni_executionDate(Timestamp _newValue) {
        this.executionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ String _ebean_get_reference() {
        this._ebean_intercept.preGetter(18);
        return this.reference;
    }

    protected /* synthetic */ void _ebean_set_reference(String newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_reference(), (Object)newValue);
        this.reference = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reference() {
        return this.reference;
    }

    protected /* synthetic */ void _ebean_setni_reference(String _newValue) {
        this.reference = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ Boolean _ebean_get_manualPayment() {
        this._ebean_intercept.preGetter(19);
        return this.manualPayment;
    }

    protected /* synthetic */ void _ebean_set_manualPayment(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_manualPayment(), (Object)newValue);
        this.manualPayment = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_manualPayment() {
        return this.manualPayment;
    }

    protected /* synthetic */ void _ebean_setni_manualPayment(Boolean _newValue) {
        this.manualPayment = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ Boolean _ebean_get_salaryPayment() {
        this._ebean_intercept.preGetter(20);
        return this.salaryPayment;
    }

    protected /* synthetic */ void _ebean_set_salaryPayment(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_salaryPayment(), (Object)newValue);
        this.salaryPayment = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_salaryPayment() {
        return this.salaryPayment;
    }

    protected /* synthetic */ void _ebean_setni_salaryPayment(Boolean _newValue) {
        this.salaryPayment = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ String _ebean_get_pmtInfId() {
        this._ebean_intercept.preGetter(21);
        return this.pmtInfId;
    }

    protected /* synthetic */ void _ebean_set_pmtInfId(String newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_pmtInfId(), (Object)newValue);
        this.pmtInfId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_pmtInfId() {
        return this.pmtInfId;
    }

    protected /* synthetic */ void _ebean_setni_pmtInfId(String _newValue) {
        this.pmtInfId = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ Send.State _ebean_get_state() {
        this._ebean_intercept.preGetter(22);
        return this.state;
    }

    protected /* synthetic */ void _ebean_set_state(Send.State newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
    }

    protected /* synthetic */ Send.State _ebean_getni_state() {
        return this.state;
    }

    protected /* synthetic */ void _ebean_setni_state(Send.State _newValue) {
        this.state = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ String _ebean_get_sts() {
        this._ebean_intercept.preGetter(23);
        return this.sts;
    }

    protected /* synthetic */ void _ebean_set_sts(String newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_sts(), (Object)newValue);
        this.sts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_sts() {
        return this.sts;
    }

    protected /* synthetic */ void _ebean_setni_sts(String _newValue) {
        this.sts = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ String _ebean_get_statusReasonInfo() {
        this._ebean_intercept.preGetter(24);
        return this.statusReasonInfo;
    }

    protected /* synthetic */ void _ebean_set_statusReasonInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_statusReasonInfo(), (Object)newValue);
        this.statusReasonInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_statusReasonInfo() {
        return this.statusReasonInfo;
    }

    protected /* synthetic */ void _ebean_setni_statusReasonInfo(String _newValue) {
        this.statusReasonInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ String _ebean_get_cnclSts() {
        this._ebean_intercept.preGetter(25);
        return this.cnclSts;
    }

    protected /* synthetic */ void _ebean_set_cnclSts(String newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_cnclSts(), (Object)newValue);
        this.cnclSts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_cnclSts() {
        return this.cnclSts;
    }

    protected /* synthetic */ void _ebean_setni_cnclSts(String _newValue) {
        this.cnclSts = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ String _ebean_get_vopSts() {
        this._ebean_intercept.preGetter(26);
        return this.vopSts;
    }

    protected /* synthetic */ void _ebean_set_vopSts(String newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_vopSts(), (Object)newValue);
        this.vopSts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_vopSts() {
        return this.vopSts;
    }

    protected /* synthetic */ void _ebean_setni_vopSts(String _newValue) {
        this.vopSts = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    protected /* synthetic */ byte[] _ebean_get_paymentData() {
        this._ebean_intercept.preGetter(27);
        return this.paymentData;
    }

    protected /* synthetic */ void _ebean_set_paymentData(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 27, this._ebean_get_paymentData(), newValue);
        this.paymentData = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_paymentData() {
        return this.paymentData;
    }

    protected /* synthetic */ void _ebean_setni_paymentData(byte[] _newValue) {
        this.paymentData = _newValue;
        this._ebean_intercept.setLoadedProperty(27);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.account;
            }
            case 2: {
                return this.folder;
            }
            case 3: {
                return this.send;
            }
            case 4: {
                return this.booking;
            }
            case 5: {
                return this.logicalFile;
            }
            case 6: {
                return this.paymentNumber;
            }
            case 7: {
                return this.callback;
            }
            case 8: {
                return this.pmtType;
            }
            case 9: {
                return this.credit;
            }
            case 10: {
                return this.urgent;
            }
            case 11: {
                return this.originator;
            }
            case 12: {
                return this.recipient;
            }
            case 13: {
                return this.amount;
            }
            case 14: {
                return this.salaryAmount;
            }
            case 15: {
                return this.amountCurrency;
            }
            case 16: {
                return this.purpose;
            }
            case 17: {
                return this.executionDate;
            }
            case 18: {
                return this.reference;
            }
            case 19: {
                return this.manualPayment;
            }
            case 20: {
                return this.salaryPayment;
            }
            case 21: {
                return this.pmtInfId;
            }
            case 22: {
                return this.state;
            }
            case 23: {
                return this.sts;
            }
            case 24: {
                return this.statusReasonInfo;
            }
            case 25: {
                return this.cnclSts;
            }
            case 26: {
                return this.vopSts;
            }
            case 27: {
                return this.paymentData;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_account();
            }
            case 2: {
                return this._ebean_get_folder();
            }
            case 3: {
                return this._ebean_get_send();
            }
            case 4: {
                return this._ebean_get_booking();
            }
            case 5: {
                return this._ebean_get_logicalFile();
            }
            case 6: {
                return this._ebean_get_paymentNumber();
            }
            case 7: {
                return this._ebean_get_callback();
            }
            case 8: {
                return this._ebean_get_pmtType();
            }
            case 9: {
                return this._ebean_get_credit();
            }
            case 10: {
                return this._ebean_get_urgent();
            }
            case 11: {
                return this._ebean_get_originator();
            }
            case 12: {
                return this._ebean_get_recipient();
            }
            case 13: {
                return this._ebean_get_amount();
            }
            case 14: {
                return this._ebean_get_salaryAmount();
            }
            case 15: {
                return this._ebean_get_amountCurrency();
            }
            case 16: {
                return this._ebean_get_purpose();
            }
            case 17: {
                return this._ebean_get_executionDate();
            }
            case 18: {
                return this._ebean_get_reference();
            }
            case 19: {
                return this._ebean_get_manualPayment();
            }
            case 20: {
                return this._ebean_get_salaryPayment();
            }
            case 21: {
                return this._ebean_get_pmtInfId();
            }
            case 22: {
                return this._ebean_get_state();
            }
            case 23: {
                return this._ebean_get_sts();
            }
            case 24: {
                return this._ebean_get_statusReasonInfo();
            }
            case 25: {
                return this._ebean_get_cnclSts();
            }
            case 26: {
                return this._ebean_get_vopSts();
            }
            case 27: {
                return this._ebean_get_paymentData();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 2: {
                this._ebean_setni_folder((PaymentFolder)o);
                return;
            }
            case 3: {
                this._ebean_setni_send((Send)o);
                return;
            }
            case 4: {
                this._ebean_setni_booking((CmBooking)o);
                return;
            }
            case 5: {
                this._ebean_setni_logicalFile((Integer)o);
                return;
            }
            case 6: {
                this._ebean_setni_paymentNumber((Integer)o);
                return;
            }
            case 7: {
                this._ebean_setni_callback((Send)o);
                return;
            }
            case 8: {
                this._ebean_setni_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 9: {
                this._ebean_setni_credit((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_urgent((Boolean)o);
                return;
            }
            case 11: {
                this._ebean_setni_originator((String)o);
                return;
            }
            case 12: {
                this._ebean_setni_recipient((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_amount((BigDecimal)o);
                return;
            }
            case 14: {
                this._ebean_setni_salaryAmount((BigDecimal)o);
                return;
            }
            case 15: {
                this._ebean_setni_amountCurrency((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_purpose((String)o);
                return;
            }
            case 17: {
                this._ebean_setni_executionDate((Timestamp)o);
                return;
            }
            case 18: {
                this._ebean_setni_reference((String)o);
                return;
            }
            case 19: {
                this._ebean_setni_manualPayment((Boolean)o);
                return;
            }
            case 20: {
                this._ebean_setni_salaryPayment((Boolean)o);
                return;
            }
            case 21: {
                this._ebean_setni_pmtInfId((String)o);
                return;
            }
            case 22: {
                this._ebean_setni_state((Send.State)((Object)o));
                return;
            }
            case 23: {
                this._ebean_setni_sts((String)o);
                return;
            }
            case 24: {
                this._ebean_setni_statusReasonInfo((String)o);
                return;
            }
            case 25: {
                this._ebean_setni_cnclSts((String)o);
                return;
            }
            case 26: {
                this._ebean_setni_vopSts((String)o);
                return;
            }
            case 27: {
                this._ebean_setni_paymentData((byte[])o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 2: {
                this._ebean_set_folder((PaymentFolder)o);
                return;
            }
            case 3: {
                this._ebean_set_send((Send)o);
                return;
            }
            case 4: {
                this._ebean_set_booking((CmBooking)o);
                return;
            }
            case 5: {
                this._ebean_set_logicalFile((Integer)o);
                return;
            }
            case 6: {
                this._ebean_set_paymentNumber((Integer)o);
                return;
            }
            case 7: {
                this._ebean_set_callback((Send)o);
                return;
            }
            case 8: {
                this._ebean_set_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 9: {
                this._ebean_set_credit((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_urgent((Boolean)o);
                return;
            }
            case 11: {
                this._ebean_set_originator((String)o);
                return;
            }
            case 12: {
                this._ebean_set_recipient((String)o);
                return;
            }
            case 13: {
                this._ebean_set_amount((BigDecimal)o);
                return;
            }
            case 14: {
                this._ebean_set_salaryAmount((BigDecimal)o);
                return;
            }
            case 15: {
                this._ebean_set_amountCurrency((String)o);
                return;
            }
            case 16: {
                this._ebean_set_purpose((String)o);
                return;
            }
            case 17: {
                this._ebean_set_executionDate((Timestamp)o);
                return;
            }
            case 18: {
                this._ebean_set_reference((String)o);
                return;
            }
            case 19: {
                this._ebean_set_manualPayment((Boolean)o);
                return;
            }
            case 20: {
                this._ebean_set_salaryPayment((Boolean)o);
                return;
            }
            case 21: {
                this._ebean_set_pmtInfId((String)o);
                return;
            }
            case 22: {
                this._ebean_set_state((Send.State)((Object)o));
                return;
            }
            case 23: {
                this._ebean_set_sts((String)o);
                return;
            }
            case 24: {
                this._ebean_set_statusReasonInfo((String)o);
                return;
            }
            case 25: {
                this._ebean_set_cnclSts((String)o);
                return;
            }
            case 26: {
                this._ebean_set_vopSts((String)o);
                return;
            }
            case 27: {
                this._ebean_set_paymentData((byte[])o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        SignedPayment signedPayment = this;
        synchronized (signedPayment) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((SignedPayment)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new SignedPayment();
    }
}

