/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class SendFilter
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private User user;
    @ManyToOne
    private BankSettings bank;
    @ManyToOne
    private Account account;
    private boolean sendActive;
    private boolean dsSignedActive;
    @Column(name="ds_cncl_active")
    private boolean dsCancelledActive;
    @Column(name="ds_active")
    private boolean dsOverviewActive;
    @Column(name="bank_comp", nullable=false)
    private FilterComparator.Bank bankComparator;
    @Column(name="ds_overview_signed")
    private Boolean dsOverviewSigned;
    private PaymentTransferType.PmtType pmtType;
    @Column(name="pmt_type_comp")
    private FilterComparator.PaymentType pmtTypeComparator;
    private String orderType;
    @Column(name="order_type_comp", nullable=false)
    private FilterComparator.Text orderTypeComparator;
    @Column(name="order_nr")
    private String orderNumber;
    @Column(name="order_nr_comp", nullable=false)
    private FilterComparator.Text orderNumberComparator;
    private String sender;
    @Column(name="sender_comp")
    private FilterComparator.Text senderComparator;
    private State sendState;
    private DsOrderDetails.State dsState;
    @Column(name="state_comp", nullable=false)
    private FilterComparator.SendState orderStateComparator;
    private Date fromDate;
    private Date toDate;
    @Column(name="date_comp")
    private FilterComparator.Date dateComparator;
    @Column(precision=38, scale=3)
    private BigDecimal fromAmount;
    @Column(precision=38, scale=3)
    private BigDecimal toAmount;
    @Column(name="amount_comp")
    private FilterComparator.Amount amountComparator;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public static SendFilter getFilter(User user) {
        SendFilter f = (SendFilter)DB.find(SendFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            return new SendFilter(user);
        }
        return f;
    }

    public static int deleteByUser(User user) {
        SendFilter sendFilter = (SendFilter)DB.find(SendFilter.class).where().eq("user", (Object)user).findOne();
        if (sendFilter != null) {
            DB.delete(sendFilter);
            return 1;
        }
        return 0;
    }

    public static int deleteByBank(BankSettings bank) {
        Update<SendFilter> delete = DB.createUpdate(SendFilter.class, "UPDATE SendFilter SET bank=NULL WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static int removeAccount(Account account) {
        Update<SendFilter> delete = DB.createUpdate(SendFilter.class, "UPDATE SendFilter SET account=NULL WHERE account=:account");
        delete.setParameter("account", (Object)account.getId());
        return delete.execute();
    }

    private SendFilter(User user) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_bankComparator(FilterComparator.Bank.EQUAL);
        this._ebean_set_dsOverviewSigned(null);
        this._ebean_set_pmtTypeComparator(FilterComparator.PaymentType.EQUAL);
        this._ebean_set_orderTypeComparator(FilterComparator.Text.CONTAINS);
        this._ebean_set_orderNumberComparator(FilterComparator.Text.CONTAINS);
        this._ebean_set_senderComparator(FilterComparator.Text.CONTAINS);
        this._ebean_set_orderStateComparator(FilterComparator.SendState.EQUAL);
        this._ebean_set_user(user);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public boolean isSendActive() {
        return this._ebean_get_sendActive();
    }

    public void setSendActive(boolean sendActive) {
        this._ebean_set_sendActive(sendActive);
    }

    public boolean isDsSignedActive() {
        return this._ebean_get_dsSignedActive();
    }

    public void setDsSignedActive(boolean dsSignedActive) {
        this._ebean_set_dsSignedActive(dsSignedActive);
    }

    public boolean isDsCancelledActive() {
        return this._ebean_get_dsCancelledActive();
    }

    public void setDsCancelledActive(boolean dsCancelledActive) {
        this._ebean_set_dsCancelledActive(dsCancelledActive);
    }

    public boolean isDsOverviewActive() {
        return this._ebean_get_dsOverviewActive();
    }

    public void setDsOverviewActive(boolean dsOverviewActive) {
        this._ebean_set_dsOverviewActive(dsOverviewActive);
    }

    public FilterComparator.Bank getBankComparator() {
        return this._ebean_get_bankComparator();
    }

    public void setBankComparator(FilterComparator.Bank bankComparator) {
        this._ebean_set_bankComparator(bankComparator);
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public FilterComparator.PaymentType getPmtTypeComparator() {
        return this._ebean_get_pmtTypeComparator();
    }

    public void setPmtTypeComparator(FilterComparator.PaymentType pmtTypeComparator) {
        this._ebean_set_pmtTypeComparator(pmtTypeComparator);
    }

    public void setPmtTypeComparator(int pmtTypeComparatorIndex) {
        if (pmtTypeComparatorIndex >= 0 && pmtTypeComparatorIndex < FilterComparator.PaymentType.values().length) {
            this.setPmtTypeComparator(FilterComparator.PaymentType.values()[pmtTypeComparatorIndex]);
        } else {
            this.setPmtTypeComparator(null);
        }
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(String orderType) {
        if (orderType == null || orderType.length() == 0) {
            this._ebean_set_orderType(null);
        } else {
            this._ebean_set_orderType(orderType);
        }
    }

    public FilterComparator.Text getOrderTypeComparator() {
        return this._ebean_get_orderTypeComparator();
    }

    public void setOrderTypeComparator(int orderTypeComparator) {
        if (orderTypeComparator >= 0 && orderTypeComparator < FilterComparator.Text.values().length) {
            this.setOrderTypeComparator(FilterComparator.Text.values()[orderTypeComparator]);
        } else {
            this.setOrderTypeComparator(null);
        }
    }

    public void setOrderTypeComparator(FilterComparator.Text orderTypeComparator) {
        this._ebean_set_orderTypeComparator(orderTypeComparator);
    }

    public String getOrderNumber() {
        return this._ebean_get_orderNumber();
    }

    public void setOrderNumber(String orderNumber) {
        if (orderNumber == null || orderNumber.length() == 0) {
            this._ebean_set_orderNumber(null);
        } else {
            this._ebean_set_orderNumber(orderNumber);
        }
    }

    public FilterComparator.Text getOrderNumberComparator() {
        return this._ebean_get_orderNumberComparator();
    }

    public void setOrderNumberComparator(int orderNumberComparator) {
        if (orderNumberComparator >= 0 && orderNumberComparator < FilterComparator.Text.values().length) {
            this.setOrderNumberComparator(FilterComparator.Text.values()[orderNumberComparator]);
        } else {
            this.setOrderNumberComparator(null);
        }
    }

    public void setOrderNumberComparator(FilterComparator.Text orderNumberComparator) {
        this._ebean_set_orderNumberComparator(orderNumberComparator);
    }

    public String getSender() {
        return this._ebean_get_sender();
    }

    public void setSender(String sender) {
        if (sender == null || sender.length() == 0) {
            this._ebean_set_sender(null);
        } else {
            this._ebean_set_sender(sender);
        }
    }

    public FilterComparator.Text getSenderComparator() {
        return this._ebean_get_senderComparator();
    }

    public void setSenderComparator(int senderComparator) {
        if (senderComparator >= 0 && senderComparator < FilterComparator.Text.values().length) {
            this.setSenderComparator(FilterComparator.Text.values()[senderComparator]);
        } else {
            this.setSenderComparator(null);
        }
    }

    public void setSenderComparator(FilterComparator.Text senderComparator) {
        this._ebean_set_senderComparator(senderComparator);
    }

    public State getSendState() {
        return this._ebean_get_sendState();
    }

    public Boolean getDsOverviewSigned() {
        return this._ebean_get_dsOverviewSigned();
    }

    public void setDsOverviewSigned(Boolean state) {
        this._ebean_set_dsOverviewSigned(state);
    }

    public void setSendState(State sendState) {
        this._ebean_set_sendState(sendState);
    }

    public DsOrderDetails.State getDsState() {
        return this._ebean_get_dsState();
    }

    public void setDsState(DsOrderDetails.State dsState) {
        this._ebean_set_dsState(dsState);
    }

    public FilterComparator.SendState getOrderStateComparator() {
        return this._ebean_get_orderStateComparator();
    }

    public void setOrderStateComparator(FilterComparator.SendState orderStateComparator) {
        this._ebean_set_orderStateComparator(orderStateComparator);
    }

    public Date getFromDate() {
        return this._ebean_get_fromDate();
    }

    public void setFromDate(Date fromDate) {
        this._ebean_set_fromDate(fromDate);
    }

    public Date getToDate() {
        return this._ebean_get_toDate();
    }

    public void setToDate(Date toDate) {
        this._ebean_set_toDate(toDate);
    }

    public FilterComparator.Date getDateComparator() {
        return this._ebean_get_dateComparator();
    }

    public void setDateComparator(FilterComparator.Date dateComparator) {
        this._ebean_set_dateComparator(dateComparator);
    }

    public final void setDateComparatorIndex(int i) {
        if (i >= 0 && i < FilterComparator.Date.values().length) {
            this._ebean_set_dateComparator(FilterComparator.Date.values()[i]);
        } else {
            this._ebean_set_dateComparator(null);
        }
    }

    public final int getDateComparatorIndex() {
        if (this._ebean_get_dateComparator() != null) {
            for (int i = 0; i < FilterComparator.Date.values().length; ++i) {
                if (this._ebean_get_dateComparator() != FilterComparator.Date.values()[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public BigDecimal getFromAmount() {
        return this._ebean_get_fromAmount();
    }

    public void setFromAmount(BigDecimal fromAmount) {
        this._ebean_set_fromAmount(fromAmount);
    }

    public BigDecimal getToAmount() {
        return this._ebean_get_toAmount();
    }

    public void setToAmount(BigDecimal toAmount) {
        this._ebean_set_toAmount(toAmount);
    }

    public FilterComparator.Amount getAmountComparator() {
        return this._ebean_get_amountComparator();
    }

    public void setAmountComparator(FilterComparator.Amount amountComparator) {
        this._ebean_set_amountComparator(amountComparator);
    }

    public final void setAmountComparatorIndex(int i) {
        if (i >= 0 && i < FilterComparator.Date.values().length) {
            this._ebean_set_amountComparator(FilterComparator.Amount.values()[i]);
        } else {
            this._ebean_set_amountComparator(null);
        }
    }

    public final int getAmountComparatorIndex() {
        if (this._ebean_get_amountComparator() != null) {
            for (int i = 0; i < FilterComparator.Amount.values().length; ++i) {
                if (this._ebean_get_amountComparator() != FilterComparator.Amount.values()[i]) continue;
                return i;
            }
        }
        return -1;
    }

    @Deprecated
    public final boolean isEmpty(boolean ds) {
        boolean bankEmpty = this._ebean_get_bank() == null;
        boolean accountEmpty = ds || this._ebean_get_account() == null;
        boolean pmtTypeEmpty = this._ebean_get_pmtType() == null;
        boolean orderTypeEmpty = this._ebean_get_orderType() == null;
        boolean orderNumberEmpty = this._ebean_get_orderNumber() == null;
        boolean senderEmpty = ds || this._ebean_get_sender() == null;
        boolean stateEmpty = ds && this._ebean_get_dsState() == null || !ds && this._ebean_get_sendState() == null;
        boolean dateEmpty = this._ebean_get_dateComparator() == null || this._ebean_get_fromDate() == null && this._ebean_get_toDate() == null;
        boolean fromAmountEmpty = this._ebean_get_fromAmount() == null;
        boolean toAmountEmpty = this._ebean_get_toAmount() == null;
        return bankEmpty && accountEmpty && pmtTypeEmpty && orderTypeEmpty && orderNumberEmpty && senderEmpty && stateEmpty && dateEmpty && fromAmountEmpty && toAmountEmpty;
    }

    public final boolean isEmpty(SendFilterType forType) {
        boolean stateEmpty;
        boolean accountEmpty;
        boolean bankEmpty = this._ebean_get_bank() == null;
        boolean pmtTypeEmpty = this._ebean_get_pmtType() == null;
        boolean orderTypeEmpty = this._ebean_get_orderType() == null;
        boolean orderNumberEmpty = this._ebean_get_orderNumber() == null;
        boolean dateEmpty = this._ebean_get_dateComparator() == null || this._ebean_get_fromDate() == null && this._ebean_get_toDate() == null;
        boolean fromAmountEmpty = this._ebean_get_fromAmount() == null;
        boolean toAmountEmpty = this._ebean_get_toAmount() == null;
        boolean senderEmpty = this._ebean_get_sender() == null;
        return bankEmpty && accountEmpty && pmtTypeEmpty && orderTypeEmpty && orderNumberEmpty && senderEmpty && stateEmpty && dateEmpty && fromAmountEmpty && toAmountEmpty && (switch (forType.ordinal()) {
            case 0 -> {
                accountEmpty = this._ebean_get_account() == null;
                stateEmpty = this._ebean_get_sendState() == null;
                yield true;
            }
            case 1, 2 -> {
                accountEmpty = true;
                stateEmpty = this._ebean_get_dsState() == null;
                yield true;
            }
            case 3 -> {
                accountEmpty = true;
                stateEmpty = true;
                yield this._ebean_get_dsOverviewSigned() == null;
            }
            default -> throw new RuntimeException("Unknown SendFilterType " + forType.name());
        });
    }

    public final void activateFor(SendFilterType type) {
        switch (type.ordinal()) {
            case 0: {
                this.setSendActive(true);
                break;
            }
            case 3: {
                this.setDsOverviewActive(true);
                break;
            }
            case 1: {
                this.setDsSignedActive(true);
                break;
            }
            case 2: {
                this.setDsCancelledActive(true);
            }
        }
        if (this.isSendActive()) {
            this.setSendActive(!this.isEmpty(SendFilterType.SENT_FILES));
        }
        if (this.isDsOverviewActive()) {
            this.setDsOverviewActive(!this.isEmpty(SendFilterType.DS_OVERVIEW));
        }
        if (this.isDsCancelledActive()) {
            this.setDsCancelledActive(!this.isEmpty(SendFilterType.DS_CANCELLED));
        }
        if (this.isDsSignedActive()) {
            this.setDsSignedActive(!this.isEmpty(SendFilterType.DS_SIGNED));
        }
    }

    public final void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public Expression getSendExpression() {
        return this.getExpression(SendFilterType.SENT_FILES);
    }

    public Expression getDsSignedExpression() {
        return this.getExpression(SendFilterType.DS_SIGNED);
    }

    public Expression getDsCancelledExpression() {
        return this.getExpression(SendFilterType.DS_CANCELLED);
    }

    public Expression getDsOverviewExpression() {
        return this.getExpression(SendFilterType.DS_OVERVIEW);
    }

    private Expression getExpression(SendFilterType forType) {
        Boolean dsOverviewSigned;
        Object masked;
        String orderNumber;
        String sent;
        boolean ds;
        boolean bl = ds = forType == SendFilterType.DS_OVERVIEW || forType == SendFilterType.DS_SIGNED || forType == SendFilterType.DS_CANCELLED;
        if (ds) {
            sent = "submissionDate";
            orderNumber = "orderId";
        } else {
            sent = "sent";
            orderNumber = "orderNumber";
        }
        Expression toReturn = null;
        if (this._ebean_get_dateComparator() != null && (this._ebean_get_fromDate() != null || this._ebean_get_dateComparator() == FilterComparator.Date.BETWEEN && this._ebean_get_toDate() != null)) {
            switch (this._ebean_get_dateComparator()) {
                case EQUAL: {
                    toReturn = Expr.between((String)sent, (Object)this._ebean_get_fromDate(), (Object)this.getMaximumTimestamp(this._ebean_get_fromDate()));
                    break;
                }
                case GREATER: {
                    toReturn = Expr.gt((String)sent, (Object)this._ebean_get_fromDate());
                    break;
                }
                case LESS: {
                    toReturn = Expr.lt((String)sent, (Object)this._ebean_get_fromDate());
                    break;
                }
                case BETWEEN: {
                    if (this._ebean_get_fromDate() != null && this._ebean_get_toDate() != null) {
                        if (this._ebean_get_fromDate().before(this._ebean_get_toDate())) {
                            toReturn = Expr.between((String)sent, (Object)this._ebean_get_fromDate(), (Object)this.getMaximumTimestamp(this._ebean_get_toDate()));
                            break;
                        }
                        toReturn = Expr.between((String)sent, (Object)this._ebean_get_toDate(), (Object)this.getMaximumTimestamp(this._ebean_get_fromDate()));
                        break;
                    }
                    if (this._ebean_get_fromDate() != null) {
                        toReturn = Expr.ge((String)sent, (Object)this._ebean_get_fromDate());
                        break;
                    }
                    toReturn = Expr.le((String)sent, (Object)this.getMaximumTimestamp(this._ebean_get_toDate()));
                    break;
                }
            }
        }
        if (forType != SendFilterType.DS_OVERVIEW && this._ebean_get_bank() != null) {
            toReturn = this.addFilter(toReturn, Expr.eq((String)"bank", (Object)this._ebean_get_bank()));
        }
        if (forType == SendFilterType.SENT_FILES && this._ebean_get_account() != null) {
            toReturn = this.addFilter(toReturn, Expr.eq((String)"accounts", (Object)this._ebean_get_account()));
        }
        if (this._ebean_get_pmtType() != null) {
            toReturn = FilterComparator.PaymentType.UNEQUAL.equals((Object)this._ebean_get_pmtTypeComparator()) ? this.addFilter(toReturn, Expr.ne((String)"pmtType", (Object)((Object)this._ebean_get_pmtType()))) : this.addFilter(toReturn, Expr.eq((String)"pmtType", (Object)((Object)this._ebean_get_pmtType())));
        }
        if (this._ebean_get_orderType() != null) {
            Expression orderTypeExpression;
            masked = "%" + this._ebean_get_orderType() + "%";
            if (this._ebean_get_orderTypeComparator() == FilterComparator.Text.STARTS_WITH || this._ebean_get_orderTypeComparator() == FilterComparator.Text.ENDS_WITH) {
                masked = this._ebean_get_orderType();
            }
            switch (forType.ordinal()) {
                case 0: {
                    Expression fTExpr;
                    Expression oTExpr;
                    if (this._ebean_get_orderTypeComparator() == FilterComparator.Text.STARTS_WITH) {
                        oTExpr = Expr.istartsWith((String)"orderType", (String)masked);
                        fTExpr = Expr.istartsWith((String)"fileType", (String)masked);
                    } else if (this._ebean_get_orderTypeComparator() == FilterComparator.Text.ENDS_WITH) {
                        oTExpr = Expr.iendsWith((String)"orderType", (String)masked);
                        fTExpr = Expr.iendsWith((String)"fileType", (String)masked);
                    } else {
                        oTExpr = Expr.ilike((String)"orderType", (String)masked);
                        fTExpr = Expr.ilike((String)"fileType", (String)masked);
                    }
                    Expression orderTypeExpr = Expr.and((Expression)Expr.isNotNull((String)"orderType"), (Expression)oTExpr);
                    Expression fileTypeExpr = Expr.and((Expression)Expr.isNotNull((String)"fileType"), (Expression)fTExpr);
                    if (this._ebean_get_orderTypeComparator() == FilterComparator.Text.CONTAINS_NOT) {
                        orderTypeExpression = Expr.not((Expression)Expr.or((Expression)orderTypeExpr, (Expression)fileTypeExpr));
                        break;
                    }
                    orderTypeExpression = Expr.or((Expression)orderTypeExpr, (Expression)fileTypeExpr);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    if (this._ebean_get_orderTypeComparator() == FilterComparator.Text.STARTS_WITH) {
                        orderTypeExpression = Expr.istartsWith((String)"fileType", (String)masked);
                        break;
                    }
                    if (this._ebean_get_orderTypeComparator() == FilterComparator.Text.ENDS_WITH) {
                        orderTypeExpression = Expr.iendsWith((String)"fileType", (String)masked);
                        break;
                    }
                    orderTypeExpression = Expr.ilike((String)"fileType", (String)masked);
                    if (this._ebean_get_orderTypeComparator() != FilterComparator.Text.CONTAINS_NOT) break;
                    orderTypeExpression = Expr.not((Expression)Expr.and((Expression)Expr.isNotNull((String)"fileType"), (Expression)orderTypeExpression));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown SendFilterType " + forType.name());
                }
            }
            toReturn = this.addFilter(toReturn, orderTypeExpression);
        }
        if (this._ebean_get_orderNumber() != null) {
            if (this._ebean_get_orderNumberComparator() == FilterComparator.Text.STARTS_WITH) {
                toReturn = this.addFilter(toReturn, Expr.istartsWith((String)orderNumber, (String)this._ebean_get_orderNumber()));
            } else if (this._ebean_get_orderNumberComparator() == FilterComparator.Text.ENDS_WITH) {
                toReturn = this.addFilter(toReturn, Expr.iendsWith((String)orderNumber, (String)this._ebean_get_orderNumber()));
            } else {
                masked = "%" + this._ebean_get_orderNumber() + "%";
                Expression orderNumberExpression = Expr.ilike((String)orderNumber, (String)masked);
                if (this._ebean_get_orderNumberComparator() == FilterComparator.Text.CONTAINS_NOT) {
                    orderNumberExpression = Expr.not((Expression)orderNumberExpression);
                }
                toReturn = this.addFilter(toReturn, orderNumberExpression);
            }
        }
        if (this._ebean_get_sender() != null) {
            switch (forType.ordinal()) {
                case 0: {
                    if (this._ebean_get_senderComparator() == FilterComparator.Text.STARTS_WITH) {
                        toReturn = this.addFilter(toReturn, Expr.istartsWith((String)"sender", (String)this._ebean_get_sender()));
                        break;
                    }
                    if (this._ebean_get_senderComparator() == FilterComparator.Text.ENDS_WITH) {
                        toReturn = this.addFilter(toReturn, Expr.iendsWith((String)"sender", (String)this._ebean_get_sender()));
                        break;
                    }
                    masked = "%" + this._ebean_get_sender() + "%";
                    Expression senderExpression = Expr.ilike((String)"sender", (String)masked);
                    if (this._ebean_get_senderComparator() == FilterComparator.Text.CONTAINS_NOT) {
                        senderExpression = Expr.not((Expression)senderExpression);
                    }
                    toReturn = this.addFilter(toReturn, senderExpression);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    Expression senderExpressionUserName;
                    Expression senderExpressionUserId;
                    if (this._ebean_get_senderComparator() == FilterComparator.Text.STARTS_WITH) {
                        senderExpressionUserId = Expr.istartsWith((String)"t0.user_id", (String)this._ebean_get_sender());
                        senderExpressionUserName = Expr.istartsWith((String)"user_name", (String)this._ebean_get_sender());
                    } else if (this._ebean_get_senderComparator() == FilterComparator.Text.ENDS_WITH) {
                        senderExpressionUserId = Expr.iendsWith((String)"t0.user_id", (String)this._ebean_get_sender());
                        senderExpressionUserName = Expr.iendsWith((String)"user_name", (String)this._ebean_get_sender());
                    } else {
                        String masked2 = "%" + this._ebean_get_sender() + "%";
                        senderExpressionUserId = Expr.ilike((String)"t0.user_id", (String)masked2);
                        senderExpressionUserName = Expr.ilike((String)"user_name", (String)masked2);
                        if (this._ebean_get_senderComparator() == FilterComparator.Text.CONTAINS_NOT) {
                            senderExpressionUserId = Expr.not((Expression)senderExpressionUserId);
                            senderExpressionUserName = Expr.not((Expression)senderExpressionUserName);
                        }
                    }
                    toReturn = this.addFilter(toReturn, Expr.or((Expression)Expr.and((Expression)Expr.isNull((String)"user_name"), (Expression)senderExpressionUserId), (Expression)senderExpressionUserName));
                }
            }
        }
        if (forType == SendFilterType.SENT_FILES && this._ebean_get_sendState() != null) {
            toReturn = this.addFilter(toReturn, this.getSendStateExpression(this._ebean_get_sendState()));
        }
        if ((forType == SendFilterType.DS_SIGNED || forType == SendFilterType.DS_CANCELLED) && this._ebean_get_dsState() != null) {
            toReturn = this.addFilter(toReturn, Expr.eq((String)"state", (Object)((Object)this._ebean_get_dsState())));
        }
        if (forType == SendFilterType.DS_OVERVIEW && (dsOverviewSigned = this.getDsOverviewSigned()) != null) {
            toReturn = this.addFilter(toReturn, Expr.eq((String)"signable", (Object)dsOverviewSigned));
        }
        Expression amount = null;
        if (this._ebean_get_amountComparator() != null && (this._ebean_get_fromAmount() != null || this._ebean_get_amountComparator() == FilterComparator.Amount.BETWEEN && this._ebean_get_toAmount() != null)) {
            switch (this._ebean_get_amountComparator()) {
                case EQUAL: {
                    amount = Expr.eq((String)"amount", (Object)this._ebean_get_fromAmount());
                    break;
                }
                case GREATER: {
                    amount = Expr.gt((String)"amount", (Object)this._ebean_get_fromAmount());
                    break;
                }
                case LESS: {
                    amount = Expr.lt((String)"amount", (Object)this._ebean_get_fromAmount());
                    break;
                }
                case BETWEEN: {
                    if (this._ebean_get_fromAmount() != null && this._ebean_get_toAmount() != null) {
                        if (this._ebean_get_fromAmount().compareTo(this._ebean_get_toAmount()) < 0) {
                            amount = Expr.between((String)"amount", (Object)this._ebean_get_fromAmount(), (Object)this._ebean_get_toAmount());
                            break;
                        }
                        amount = Expr.between((String)"amount", (Object)this._ebean_get_toAmount(), (Object)this._ebean_get_fromAmount());
                        break;
                    }
                    if (this._ebean_get_fromAmount() != null) {
                        amount = Expr.ge((String)"amount", (Object)this._ebean_get_fromAmount());
                        break;
                    }
                    amount = Expr.le((String)"amount", (Object)this._ebean_get_toAmount());
                    break;
                }
            }
            toReturn = this.addFilter(toReturn, amount);
        }
        return toReturn;
    }

    private Expression getSendStateExpression(State state) {
        if (state != null) {
            switch (state.ordinal()) {
                case 0: {
                    return Expr.in((String)"state", (Object[])new Send.State[]{Send.State.SENT, Send.State.CONFIRMED});
                }
                case 3: {
                    return Expr.in((String)"state", (Object[])new Send.State[]{Send.State.FINISHED_ERROR, Send.State.NOT_CONFIRMED});
                }
                case 2: {
                    Expression noExtendedState = Expr.and((Expression)Expr.isNull((String)"sts"), (Expression)Expr.isNull((String)"cnclSts"));
                    return Expr.and((Expression)Expr.eq((String)"state", (Object)((Object)Send.State.FINISHED_OK)), (Expression)noExtendedState);
                }
                case 1: {
                    return Expr.in((String)"state", (Object[])new Send.State[]{Send.State.WAITING_IN_DS, Send.State.SIGNATURE_STILL_MISSING});
                }
                case 4: {
                    return Expr.or((Expression)Expr.eq((String)"state", (Object)((Object)Send.State.CANCELED)), (Expression)Expr.eq((String)"cnclSts", (Object)"CNCL"));
                }
                case 6: {
                    Expression notCancelled = Expr.or((Expression)Expr.isNull((String)"cnclSts"), (Expression)Expr.ne((String)"cnclSts", (Object)"CNCL"));
                    return Expr.and((Expression)notCancelled, (Expression)this.getBookedExpression());
                }
                case 9: {
                    return Expr.eq((String)"sts", (Object)"PBK");
                }
                case 7: {
                    return Expr.or((Expression)Expr.and((Expression)Expr.isNotNull((String)"sts"), (Expression)Expr.not((Expression)this.getBookedExpression())), (Expression)Expr.isNotNull((String)"vopSts"));
                }
                case 5: {
                    Object[] rejectedStates = new String[]{"RJCT", "PRJ"};
                    return Expr.in((String)"sts", (Object[])rejectedStates);
                }
                case 8: {
                    Object[] finalStates = new String[]{"CNCL", "RJCR"};
                    Expression nonFinalState = Expr.or((Expression)Expr.isNull((String)"cnclSts"), (Expression)Expr.not((Expression)Expr.in((String)"cnclSts", (Object[])finalStates)));
                    return Expr.and((Expression)Expr.isNotNull((String)"callback"), (Expression)nonFinalState);
                }
            }
        }
        return null;
    }

    private Expression getBookedExpression() {
        return Expr.or((Expression)Expr.and((Expression)Expr.eq((String)"pmtType", (Object)((Object)PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER)), (Expression)Expr.eq((String)"sts", (Object)"ACCP")), (Expression)Expr.and((Expression)Expr.ne((String)"pmtType", (Object)((Object)PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER)), (Expression)Expr.eq((String)"sts", (Object)"ACSC")));
    }

    private Timestamp getMaximumTimestamp(Date date) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.set(11, c.getMaximum(11));
        c.set(12, c.getMaximum(12));
        c.set(13, c.getMaximum(13));
        return new Timestamp(c.getTimeInMillis());
    }

    private Expression addFilter(Expression main, Expression add) {
        if (main == null) {
            return add;
        }
        return Expr.and((Expression)main, (Expression)add);
    }

    static {
        _ebean_props = new String[]{"id", "user", "bank", "account", "sendActive", "dsSignedActive", "dsCancelledActive", "dsOverviewActive", "bankComparator", "dsOverviewSigned", "pmtType", "pmtTypeComparator", "orderType", "orderTypeComparator", "orderNumber", "orderNumberComparator", "sender", "senderComparator", "sendState", "dsState", "orderStateComparator", "fromDate", "toDate", "dateComparator", "fromAmount", "toAmount", "amountComparator"};
    }

    public /* synthetic */ SendFilter() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(1);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(2);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(3);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ boolean _ebean_get_sendActive() {
        this._ebean_intercept.preGetter(4);
        return this.sendActive;
    }

    protected /* synthetic */ void _ebean_set_sendActive(boolean newValue) {
        this._ebean_intercept.preSetter(true, 4, this._ebean_get_sendActive(), newValue);
        this.sendActive = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_sendActive() {
        return this.sendActive;
    }

    protected /* synthetic */ void _ebean_setni_sendActive(boolean _newValue) {
        this.sendActive = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ boolean _ebean_get_dsSignedActive() {
        this._ebean_intercept.preGetter(5);
        return this.dsSignedActive;
    }

    protected /* synthetic */ void _ebean_set_dsSignedActive(boolean newValue) {
        this._ebean_intercept.preSetter(true, 5, this._ebean_get_dsSignedActive(), newValue);
        this.dsSignedActive = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_dsSignedActive() {
        return this.dsSignedActive;
    }

    protected /* synthetic */ void _ebean_setni_dsSignedActive(boolean _newValue) {
        this.dsSignedActive = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ boolean _ebean_get_dsCancelledActive() {
        this._ebean_intercept.preGetter(6);
        return this.dsCancelledActive;
    }

    protected /* synthetic */ void _ebean_set_dsCancelledActive(boolean newValue) {
        this._ebean_intercept.preSetter(true, 6, this._ebean_get_dsCancelledActive(), newValue);
        this.dsCancelledActive = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_dsCancelledActive() {
        return this.dsCancelledActive;
    }

    protected /* synthetic */ void _ebean_setni_dsCancelledActive(boolean _newValue) {
        this.dsCancelledActive = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ boolean _ebean_get_dsOverviewActive() {
        this._ebean_intercept.preGetter(7);
        return this.dsOverviewActive;
    }

    protected /* synthetic */ void _ebean_set_dsOverviewActive(boolean newValue) {
        this._ebean_intercept.preSetter(true, 7, this._ebean_get_dsOverviewActive(), newValue);
        this.dsOverviewActive = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_dsOverviewActive() {
        return this.dsOverviewActive;
    }

    protected /* synthetic */ void _ebean_setni_dsOverviewActive(boolean _newValue) {
        this.dsOverviewActive = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ FilterComparator.Bank _ebean_get_bankComparator() {
        this._ebean_intercept.preGetter(8);
        return this.bankComparator;
    }

    protected /* synthetic */ void _ebean_set_bankComparator(FilterComparator.Bank newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_bankComparator(), (Object)newValue);
        this.bankComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Bank _ebean_getni_bankComparator() {
        return this.bankComparator;
    }

    protected /* synthetic */ void _ebean_setni_bankComparator(FilterComparator.Bank _newValue) {
        this.bankComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ Boolean _ebean_get_dsOverviewSigned() {
        this._ebean_intercept.preGetter(9);
        return this.dsOverviewSigned;
    }

    protected /* synthetic */ void _ebean_set_dsOverviewSigned(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_dsOverviewSigned(), (Object)newValue);
        this.dsOverviewSigned = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_dsOverviewSigned() {
        return this.dsOverviewSigned;
    }

    protected /* synthetic */ void _ebean_setni_dsOverviewSigned(Boolean _newValue) {
        this.dsOverviewSigned = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(10);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PaymentTransferType.PmtType newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PaymentTransferType.PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ FilterComparator.PaymentType _ebean_get_pmtTypeComparator() {
        this._ebean_intercept.preGetter(11);
        return this.pmtTypeComparator;
    }

    protected /* synthetic */ void _ebean_set_pmtTypeComparator(FilterComparator.PaymentType newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_pmtTypeComparator(), (Object)newValue);
        this.pmtTypeComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.PaymentType _ebean_getni_pmtTypeComparator() {
        return this.pmtTypeComparator;
    }

    protected /* synthetic */ void _ebean_setni_pmtTypeComparator(FilterComparator.PaymentType _newValue) {
        this.pmtTypeComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(12);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ FilterComparator.Text _ebean_get_orderTypeComparator() {
        this._ebean_intercept.preGetter(13);
        return this.orderTypeComparator;
    }

    protected /* synthetic */ void _ebean_set_orderTypeComparator(FilterComparator.Text newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_orderTypeComparator(), (Object)newValue);
        this.orderTypeComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Text _ebean_getni_orderTypeComparator() {
        return this.orderTypeComparator;
    }

    protected /* synthetic */ void _ebean_setni_orderTypeComparator(FilterComparator.Text _newValue) {
        this.orderTypeComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_orderNumber() {
        this._ebean_intercept.preGetter(14);
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_set_orderNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_orderNumber(), (Object)newValue);
        this.orderNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderNumber() {
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_setni_orderNumber(String _newValue) {
        this.orderNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ FilterComparator.Text _ebean_get_orderNumberComparator() {
        this._ebean_intercept.preGetter(15);
        return this.orderNumberComparator;
    }

    protected /* synthetic */ void _ebean_set_orderNumberComparator(FilterComparator.Text newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_orderNumberComparator(), (Object)newValue);
        this.orderNumberComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Text _ebean_getni_orderNumberComparator() {
        return this.orderNumberComparator;
    }

    protected /* synthetic */ void _ebean_setni_orderNumberComparator(FilterComparator.Text _newValue) {
        this.orderNumberComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_sender() {
        this._ebean_intercept.preGetter(16);
        return this.sender;
    }

    protected /* synthetic */ void _ebean_set_sender(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_sender(), (Object)newValue);
        this.sender = newValue;
    }

    protected /* synthetic */ String _ebean_getni_sender() {
        return this.sender;
    }

    protected /* synthetic */ void _ebean_setni_sender(String _newValue) {
        this.sender = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ FilterComparator.Text _ebean_get_senderComparator() {
        this._ebean_intercept.preGetter(17);
        return this.senderComparator;
    }

    protected /* synthetic */ void _ebean_set_senderComparator(FilterComparator.Text newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_senderComparator(), (Object)newValue);
        this.senderComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Text _ebean_getni_senderComparator() {
        return this.senderComparator;
    }

    protected /* synthetic */ void _ebean_setni_senderComparator(FilterComparator.Text _newValue) {
        this.senderComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ State _ebean_get_sendState() {
        this._ebean_intercept.preGetter(18);
        return this.sendState;
    }

    protected /* synthetic */ void _ebean_set_sendState(State newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_sendState(), (Object)newValue);
        this.sendState = newValue;
    }

    protected /* synthetic */ State _ebean_getni_sendState() {
        return this.sendState;
    }

    protected /* synthetic */ void _ebean_setni_sendState(State _newValue) {
        this.sendState = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ DsOrderDetails.State _ebean_get_dsState() {
        this._ebean_intercept.preGetter(19);
        return this.dsState;
    }

    protected /* synthetic */ void _ebean_set_dsState(DsOrderDetails.State newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_dsState(), (Object)newValue);
        this.dsState = newValue;
    }

    protected /* synthetic */ DsOrderDetails.State _ebean_getni_dsState() {
        return this.dsState;
    }

    protected /* synthetic */ void _ebean_setni_dsState(DsOrderDetails.State _newValue) {
        this.dsState = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ FilterComparator.SendState _ebean_get_orderStateComparator() {
        this._ebean_intercept.preGetter(20);
        return this.orderStateComparator;
    }

    protected /* synthetic */ void _ebean_set_orderStateComparator(FilterComparator.SendState newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_orderStateComparator(), (Object)newValue);
        this.orderStateComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.SendState _ebean_getni_orderStateComparator() {
        return this.orderStateComparator;
    }

    protected /* synthetic */ void _ebean_setni_orderStateComparator(FilterComparator.SendState _newValue) {
        this.orderStateComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ Date _ebean_get_fromDate() {
        this._ebean_intercept.preGetter(21);
        return this.fromDate;
    }

    protected /* synthetic */ void _ebean_set_fromDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_fromDate(), (Object)newValue);
        this.fromDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_fromDate() {
        return this.fromDate;
    }

    protected /* synthetic */ void _ebean_setni_fromDate(Date _newValue) {
        this.fromDate = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ Date _ebean_get_toDate() {
        this._ebean_intercept.preGetter(22);
        return this.toDate;
    }

    protected /* synthetic */ void _ebean_set_toDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_toDate(), (Object)newValue);
        this.toDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_toDate() {
        return this.toDate;
    }

    protected /* synthetic */ void _ebean_setni_toDate(Date _newValue) {
        this.toDate = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ FilterComparator.Date _ebean_get_dateComparator() {
        this._ebean_intercept.preGetter(23);
        return this.dateComparator;
    }

    protected /* synthetic */ void _ebean_set_dateComparator(FilterComparator.Date newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_dateComparator(), (Object)newValue);
        this.dateComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Date _ebean_getni_dateComparator() {
        return this.dateComparator;
    }

    protected /* synthetic */ void _ebean_setni_dateComparator(FilterComparator.Date _newValue) {
        this.dateComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ BigDecimal _ebean_get_fromAmount() {
        this._ebean_intercept.preGetter(24);
        return this.fromAmount;
    }

    protected /* synthetic */ void _ebean_set_fromAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_fromAmount(), (Object)newValue);
        this.fromAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_fromAmount() {
        return this.fromAmount;
    }

    protected /* synthetic */ void _ebean_setni_fromAmount(BigDecimal _newValue) {
        this.fromAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ BigDecimal _ebean_get_toAmount() {
        this._ebean_intercept.preGetter(25);
        return this.toAmount;
    }

    protected /* synthetic */ void _ebean_set_toAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_toAmount(), (Object)newValue);
        this.toAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_toAmount() {
        return this.toAmount;
    }

    protected /* synthetic */ void _ebean_setni_toAmount(BigDecimal _newValue) {
        this.toAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ FilterComparator.Amount _ebean_get_amountComparator() {
        this._ebean_intercept.preGetter(26);
        return this.amountComparator;
    }

    protected /* synthetic */ void _ebean_set_amountComparator(FilterComparator.Amount newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_amountComparator(), (Object)newValue);
        this.amountComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Amount _ebean_getni_amountComparator() {
        return this.amountComparator;
    }

    protected /* synthetic */ void _ebean_setni_amountComparator(FilterComparator.Amount _newValue) {
        this.amountComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.user;
            }
            case 2: {
                return this.bank;
            }
            case 3: {
                return this.account;
            }
            case 4: {
                return this.sendActive;
            }
            case 5: {
                return this.dsSignedActive;
            }
            case 6: {
                return this.dsCancelledActive;
            }
            case 7: {
                return this.dsOverviewActive;
            }
            case 8: {
                return this.bankComparator;
            }
            case 9: {
                return this.dsOverviewSigned;
            }
            case 10: {
                return this.pmtType;
            }
            case 11: {
                return this.pmtTypeComparator;
            }
            case 12: {
                return this.orderType;
            }
            case 13: {
                return this.orderTypeComparator;
            }
            case 14: {
                return this.orderNumber;
            }
            case 15: {
                return this.orderNumberComparator;
            }
            case 16: {
                return this.sender;
            }
            case 17: {
                return this.senderComparator;
            }
            case 18: {
                return this.sendState;
            }
            case 19: {
                return this.dsState;
            }
            case 20: {
                return this.orderStateComparator;
            }
            case 21: {
                return this.fromDate;
            }
            case 22: {
                return this.toDate;
            }
            case 23: {
                return this.dateComparator;
            }
            case 24: {
                return this.fromAmount;
            }
            case 25: {
                return this.toAmount;
            }
            case 26: {
                return this.amountComparator;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_bank();
            }
            case 3: {
                return this._ebean_get_account();
            }
            case 4: {
                return this._ebean_get_sendActive();
            }
            case 5: {
                return this._ebean_get_dsSignedActive();
            }
            case 6: {
                return this._ebean_get_dsCancelledActive();
            }
            case 7: {
                return this._ebean_get_dsOverviewActive();
            }
            case 8: {
                return this._ebean_get_bankComparator();
            }
            case 9: {
                return this._ebean_get_dsOverviewSigned();
            }
            case 10: {
                return this._ebean_get_pmtType();
            }
            case 11: {
                return this._ebean_get_pmtTypeComparator();
            }
            case 12: {
                return this._ebean_get_orderType();
            }
            case 13: {
                return this._ebean_get_orderTypeComparator();
            }
            case 14: {
                return this._ebean_get_orderNumber();
            }
            case 15: {
                return this._ebean_get_orderNumberComparator();
            }
            case 16: {
                return this._ebean_get_sender();
            }
            case 17: {
                return this._ebean_get_senderComparator();
            }
            case 18: {
                return this._ebean_get_sendState();
            }
            case 19: {
                return this._ebean_get_dsState();
            }
            case 20: {
                return this._ebean_get_orderStateComparator();
            }
            case 21: {
                return this._ebean_get_fromDate();
            }
            case 22: {
                return this._ebean_get_toDate();
            }
            case 23: {
                return this._ebean_get_dateComparator();
            }
            case 24: {
                return this._ebean_get_fromAmount();
            }
            case 25: {
                return this._ebean_get_toAmount();
            }
            case 26: {
                return this._ebean_get_amountComparator();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 3: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 4: {
                this._ebean_setni_sendActive((Boolean)o);
                return;
            }
            case 5: {
                this._ebean_setni_dsSignedActive((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_setni_dsCancelledActive((Boolean)o);
                return;
            }
            case 7: {
                this._ebean_setni_dsOverviewActive((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_setni_bankComparator((FilterComparator.Bank)((Object)o));
                return;
            }
            case 9: {
                this._ebean_setni_dsOverviewSigned((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 11: {
                this._ebean_setni_pmtTypeComparator((FilterComparator.PaymentType)((Object)o));
                return;
            }
            case 12: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_orderTypeComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 14: {
                this._ebean_setni_orderNumber((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_orderNumberComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 16: {
                this._ebean_setni_sender((String)o);
                return;
            }
            case 17: {
                this._ebean_setni_senderComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 18: {
                this._ebean_setni_sendState((State)((Object)o));
                return;
            }
            case 19: {
                this._ebean_setni_dsState((DsOrderDetails.State)((Object)o));
                return;
            }
            case 20: {
                this._ebean_setni_orderStateComparator((FilterComparator.SendState)((Object)o));
                return;
            }
            case 21: {
                this._ebean_setni_fromDate((Date)o);
                return;
            }
            case 22: {
                this._ebean_setni_toDate((Date)o);
                return;
            }
            case 23: {
                this._ebean_setni_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 24: {
                this._ebean_setni_fromAmount((BigDecimal)o);
                return;
            }
            case 25: {
                this._ebean_setni_toAmount((BigDecimal)o);
                return;
            }
            case 26: {
                this._ebean_setni_amountComparator((FilterComparator.Amount)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 3: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 4: {
                this._ebean_set_sendActive((Boolean)o);
                return;
            }
            case 5: {
                this._ebean_set_dsSignedActive((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_set_dsCancelledActive((Boolean)o);
                return;
            }
            case 7: {
                this._ebean_set_dsOverviewActive((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_set_bankComparator((FilterComparator.Bank)((Object)o));
                return;
            }
            case 9: {
                this._ebean_set_dsOverviewSigned((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 11: {
                this._ebean_set_pmtTypeComparator((FilterComparator.PaymentType)((Object)o));
                return;
            }
            case 12: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 13: {
                this._ebean_set_orderTypeComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 14: {
                this._ebean_set_orderNumber((String)o);
                return;
            }
            case 15: {
                this._ebean_set_orderNumberComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 16: {
                this._ebean_set_sender((String)o);
                return;
            }
            case 17: {
                this._ebean_set_senderComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 18: {
                this._ebean_set_sendState((State)((Object)o));
                return;
            }
            case 19: {
                this._ebean_set_dsState((DsOrderDetails.State)((Object)o));
                return;
            }
            case 20: {
                this._ebean_set_orderStateComparator((FilterComparator.SendState)((Object)o));
                return;
            }
            case 21: {
                this._ebean_set_fromDate((Date)o);
                return;
            }
            case 22: {
                this._ebean_set_toDate((Date)o);
                return;
            }
            case 23: {
                this._ebean_set_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 24: {
                this._ebean_set_fromAmount((BigDecimal)o);
                return;
            }
            case 25: {
                this._ebean_set_toAmount((BigDecimal)o);
                return;
            }
            case 26: {
                this._ebean_set_amountComparator((FilterComparator.Amount)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        SendFilter sendFilter = this;
        synchronized (sendFilter) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((SendFilter)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new SendFilter();
    }

    public static enum State {
        SENT,
        WAITING_IN_DS,
        FINISHED_OK,
        FINISHED_ERROR,
        CANCELED,
        RJCT,
        ACSC_ACCP,
        WITH_MESSAGES,
        CALLBACK_STARTED,
        PARTIAL_BOOKED;

    }

    public static enum SendFilterType {
        SENT_FILES,
        DS_SIGNED,
        DS_CANCELLED,
        DS_OVERVIEW;

    }
}

