/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Expr;
import io.ebean.Query;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.SqlUpdate;
import io.ebean.Update;
import io.ebean.annotation.Index;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="send_item")
@Index(name="ix_send_item_bank_msg_id", columnNames={"bank_id", "msg_id"})
public class Send
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private BankSettings bank;
    @Column(nullable=false)
    private Timestamp sent;
    @ManyToOne
    private WorkspaceFile file;
    @Column(length=250)
    private String origFileName;
    private State state;
    @Column(length=4)
    private String sts;
    @Column(length=4)
    private String cnclSts;
    @Column(length=4)
    private String vopSts;
    @Column(length=4)
    private String errorCode;
    @Column
    private String sender;
    private PaymentTransferType.PmtType pmtType;
    private String fileType;
    @Column(nullable=false, length=3)
    private String orderType;
    @Column(nullable=false, length=4)
    private String orderNumber;
    @Column(precision=38, scale=3)
    private BigDecimal amount;
    private Integer nbOfTxs;
    @Column(length=64)
    private String signatureHash;
    @Column(length=35)
    private String msgId;
    private String scheme;
    @Column
    private String additionalOrderInfo;
    @Column(length=3)
    private String currency;
    @Column(name="with_selaries")
    private Boolean withSalaries;
    private Boolean manualApproval;
    @ManyToOne
    private Send callback;
    private String ipAddress;
    @ManyToMany(fetch=FetchType.LAZY)
    private List<Account> accounts;
    private SignedPayments signedPayments;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public Send() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_signedPayments(SignedPayments.UNKNOWN);
    }

    public static int findCountByAccount(Account a) {
        return DB.find(Send.class).where().in("accounts", new Object[]{a}).findCount();
    }

    public static int countByBank(BankSettings bank) {
        return DB.find(Send.class).where().eq("bank", (Object)bank).findCount();
    }

    public static Send findNewestByHash(String hash) {
        return (Send)DB.find(Send.class).where().eq("file.md5Hash", (Object)hash).order("sent DESC").setMaxRows(1).findOne();
    }

    public static List<Send> find(BankSettings bank, String orderType, String orderNumber) {
        return DB.find(Send.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).findList();
    }

    public static List<Send> findByFileType(BankSettings bank, String fileType, String orderNumber) {
        return DB.find(Send.class).where().eq("bank", (Object)bank).eq("fileType", (Object)fileType).eq("orderNumber", (Object)orderNumber).findList();
    }

    public static List<Send> findByBTFStartsWith(BankSettings bank, String fileType, String orderNumber) {
        return DB.find(Send.class).where().eq("bank", (Object)bank).startsWith("fileType", fileType).eq("orderNumber", (Object)orderNumber).findList();
    }

    public static Send findByDsOrderDetails(DsOrderDetails orderDetails) {
        List sendList = null;
        Calendar start = Calendar.getInstance();
        start.setTime(orderDetails.getSubmissionDate());
        start.add(5, -30);
        Calendar end = Calendar.getInstance();
        end.setTime(orderDetails.getSubmissionDate());
        end.add(5, 1);
        String fileType = orderDetails.getFileType();
        sendList = fileType != null && RegularExpressions.ORDER_TYPE.matches(fileType) ? DB.find(Send.class).where().eq("bank", (Object)orderDetails.getBank()).eq("orderNumber", (Object)orderDetails.getOrderId()).eq("orderType", (Object)fileType).between("sent", (Object)start.getTime(), (Object)end.getTime()).findList() : DB.find(Send.class).where().eq("bank", (Object)orderDetails.getBank()).eq("orderNumber", (Object)orderDetails.getOrderId()).eq("fileType", (Object)fileType).between("sent", (Object)start.getTime(), (Object)end.getTime()).findList();
        if (sendList != null && sendList.size() == 1) {
            return (Send)sendList.get(0);
        }
        return null;
    }

    public static Query<Send> findSendByUser(User user, boolean hideSalaryPayments) {
        Query<Send> query = DB.find(Send.class);
        query.where().eq("bank.users.user", (Object)user);
        if (hideSalaryPayments) {
            query.where().add(Expr.eq((String)"withSalaries", (Object)false));
        }
        query.order("sent desc");
        return query;
    }

    public static List<Send> findByMessageId(BankSettings bank, String messageId) {
        return DB.find(Send.class).where().eq("bank", (Object)bank).eq("msgId", (Object)messageId).orderBy().desc("sent").findList();
    }

    public static List<Send> findByMessageId(BankSettings bank, String messageId, Timestamp oldestPossibleTime, Timestamp newestPossibleTime) {
        return DB.find(Send.class).where().eq("bank", (Object)bank).eq("msgId", (Object)messageId).ge("sent", (Object)oldestPossibleTime).lt("sent", (Object)newestPossibleTime).orderBy().desc("sent").findList();
    }

    public static Send findCalledBackOrder(Send send) {
        return (Send)DB.find(Send.class).where().eq("callback", (Object)send).setMaxRows(1).findOne();
    }

    public static int updateSendOrdersForEbics30(BankSettings bank, String orderType, String btf) {
        Update<Send> update = DB.createUpdate(Send.class, "UPDATE Send SET fileType=:param1 WHERE orderType=:param2 AND fileType is NULL AND bank_id=:param3");
        update.setParameter("param1", (Object)btf);
        update.setParameter("param2", (Object)orderType);
        update.setParameter("param3", (Object)bank.getBankId());
        return update.execute();
    }

    public static int updateFileTypeOfEbics25Orders(BankSettings bank, PaymentTransferType.PmtType pmtType, String fileType) {
        Update<Send> update = DB.createUpdate(Send.class, "UPDATE Send SET fileType =:p1 WHERE orderType <> 'BTU' AND pmtType =:p2 AND bank =:p3");
        update.setParameter("p1", (Object)fileType);
        update.setParameter("p2", (Object)pmtType);
        update.setParameter("p3", (Object)bank.getBankId());
        return update.execute();
    }

    public static List<PaymentTransferType.PmtType> findPmtTypesOfEbics30Orders(BankSettings bank) {
        SqlQuery query = DB.sqlQuery("SELECT DISTINCT pmt_type FROM send_item WHERE bank_id = :p1 AND order_type =:p2 AND pmt_type IS NOT NULL");
        query.setParameter("p1", (Object)bank.getBankId());
        query.setParameter("p2", (Object)"BTU");
        ArrayList<PaymentTransferType.PmtType> pmtTypes = new ArrayList<PaymentTransferType.PmtType>();
        for (SqlRow row : query.findList()) {
            pmtTypes.add(PaymentTransferType.PmtType.values()[row.getInteger("pmt_type")]);
        }
        return pmtTypes;
    }

    public static int updateOrderTypeOfEbics30Orders(BankSettings bank, PaymentTransferType.PmtType pmtType, String orderType) {
        Update<Send> update = DB.createUpdate(Send.class, "UPDATE Send SET orderType =:p1 WHERE orderType = 'BTU' AND pmtType =:p2 AND bank =:p3");
        update.setParameter("p1", (Object)orderType);
        update.setParameter("p2", (Object)pmtType);
        update.setParameter("p3", (Object)bank.getBankId());
        return update.execute();
    }

    public static int updateOrderTypeOfEbics30Orders(BankSettings bank, PaymentTransferType.PmtType pmtType, String btf, String orderType) {
        Update<Send> update = DB.createUpdate(Send.class, "UPDATE Send SET orderType =:p1 WHERE orderType = 'BTU' AND pmtType =:p2 AND bank =:p3 AND fileType =:p4");
        update.setParameter("p1", (Object)orderType);
        update.setParameter("p2", (Object)pmtType);
        update.setParameter("p3", (Object)bank.getBankId());
        update.setParameter("p4", (Object)btf);
        return update.execute();
    }

    public static Send findOldest(BankSettings bank, Timestamp maxOld) {
        return (Send)DB.find(Send.class).where().eq("bank", (Object)bank).not(Expr.in((String)"state", (Object[])new Object[]{State.FINISHED_ERROR, State.FINISHED_OK, State.CANCELED})).ge("sent", (Object)maxOld).orderBy("sent ASC").setMaxRows(1).findOne();
    }

    public static List<Send> findByOrderDetails(BankSettings bank, String orderOrFileType, String orderNumber, Timestamp submissionDate) {
        Calendar start = Calendar.getInstance();
        start.setTime(submissionDate);
        start.add(5, -1);
        Calendar end = Calendar.getInstance();
        end.setTime(submissionDate);
        end.add(5, 1);
        return DB.find(Send.class).where().isNotNull("pmtType").eq("bank", (Object)bank).eq("orderNumber", (Object)orderNumber).between("sent", (Object)start.getTime(), (Object)end.getTime()).or(Expr.eq((String)"orderType", (Object)orderOrFileType), Expr.eq((String)"fileType", (Object)orderOrFileType)).findList();
    }

    public static int deleteByBank(BankSettings bank) {
        AwzelEntry.removePaymentReferences(DB.find(SignedPayment.class).where().eq("send.bank", (Object)bank).findIds());
        Update<SignedPayment> deleteSigned = DB.createUpdate(SignedPayment.class, "DELETE FROM SignedPayment WHERE send IN (SELECT id FROM send_item WHERE bank_id=:bank)");
        deleteSigned.setParameter("bank", (Object)bank.getBankId());
        deleteSigned.execute();
        SqlUpdate deleteSendItemAccount = DB.sqlUpdate("DELETE from send_item_account where send_item_id IN (SELECT id FROM send_item WHERE bank_id=:bank)");
        deleteSendItemAccount.setParameter("bank", (Object)bank.getBankId());
        deleteSendItemAccount.execute();
        Update<Send> delete = DB.createUpdate(Send.class, "DELETE FROM Send WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public Timestamp getSent() {
        return this._ebean_get_sent();
    }

    public void setSent(Timestamp sent) {
        this._ebean_set_sent(sent);
    }

    public WorkspaceFile getFile() {
        return this._ebean_get_file();
    }

    public void setFile(WorkspaceFile file) {
        this._ebean_set_file(file);
    }

    public String getOrigFileName() {
        return this._ebean_get_origFileName();
    }

    public void setOrigFileName(String origFileName) {
        this._ebean_set_origFileName(origFileName);
    }

    public State getState() {
        return this._ebean_get_state();
    }

    public void setState(State state) {
        this._ebean_set_state(state);
    }

    public String getSts() {
        return this._ebean_get_sts();
    }

    public void setSts(String sts) {
        this._ebean_set_sts(sts);
    }

    public String getCancellationStatus() {
        return this._ebean_get_cnclSts();
    }

    public void setCancellationSatus(String cnclSts) {
        this._ebean_set_cnclSts(cnclSts);
    }

    public String getVopSts() {
        return this._ebean_get_vopSts();
    }

    public void setVopSts(String vopSts) {
        this._ebean_set_vopSts(vopSts);
    }

    public String getSender() {
        return this._ebean_get_sender();
    }

    public void setSender(String sender) {
        this._ebean_set_sender(sender);
    }

    public long getSize() {
        if (this.getFile() == null) {
            return 0L;
        }
        return this.getFile().getSize();
    }

    public String getMd5Hash() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().getMd5Hash();
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public String getFileType() {
        if (this._ebean_get_fileType() == null || !RegularExpressions.BTF_SERVICE_PATTERN.matches(this._ebean_get_fileType())) {
            return this._ebean_get_fileType();
        }
        return null;
    }

    public String getFileTypeOrBTF() {
        return this._ebean_get_fileType();
    }

    public String getBTF() {
        if (this._ebean_get_fileType() != null && RegularExpressions.BTF_SERVICE_PATTERN.matches(this._ebean_get_fileType())) {
            return this._ebean_get_fileType();
        }
        return null;
    }

    public void setFileType(String fileType) {
        this._ebean_set_fileType(fileType);
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(String orderType) {
        this._ebean_set_orderType(orderType);
    }

    public String getOrderNumber() {
        return this._ebean_get_orderNumber();
    }

    public void setOrderNumber(String orderNumber) {
        this._ebean_set_orderNumber(orderNumber);
    }

    public BigDecimal getAmount() {
        return this._ebean_get_amount();
    }

    public void setAmount(BigDecimal amount) {
        this._ebean_set_amount(amount);
    }

    public Integer getNbOfTxs() {
        return this._ebean_get_nbOfTxs();
    }

    public void setNbOfTxs(Integer nbOfTxs) {
        this._ebean_set_nbOfTxs(nbOfTxs);
    }

    public String getCurrency() {
        return this._ebean_get_currency();
    }

    public void setCurrency(String currency) {
        this._ebean_set_currency(currency);
    }

    public String getOriginalSendType() {
        String orderType = this.getOrderType();
        String fileType = this.getFileTypeOrBTF();
        if (("BTU".equals(orderType) || "FUL".equals(orderType)) && fileType != null) {
            return fileType;
        }
        return orderType;
    }

    public boolean hasManualApproval() {
        if (this._ebean_get_manualApproval() == null) {
            return false;
        }
        return this._ebean_get_manualApproval();
    }

    public void setManualApproval(boolean manualApproval) {
        this._ebean_set_manualApproval(manualApproval);
    }

    public boolean isWithSalaries() {
        if (this._ebean_get_withSalaries() == null) {
            return false;
        }
        return this._ebean_get_withSalaries();
    }

    public void setWithSelaries(boolean withSelaries) {
        this._ebean_set_withSalaries(withSelaries);
    }

    public String getSignatureHash() {
        return this._ebean_get_signatureHash();
    }

    public void setSignatureHash(String signatureHash) {
        this._ebean_set_signatureHash(signatureHash);
    }

    public String getErrorCode() {
        return this._ebean_get_errorCode();
    }

    public void setErrorCode(String errorCode) {
        this._ebean_set_errorCode(errorCode);
    }

    public Send getCallback() {
        return this._ebean_get_callback();
    }

    public void setCallback(Send callback) {
        this._ebean_set_callback(callback);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        SqlUpdate delete = DB.sqlUpdate("UPDATE notification_trx set send_id=null, signed_payment_id=null where send_id=:id");
        delete.setParameter("id", (Object)this.getId());
        delete.execute();
        if (SignedPayments.EXIST.equals((Object)this.getSignedPayments())) {
            AwzelEntry.removePaymentReferences(DB.find(SignedPayment.class).where().eq("send", (Object)this).findIds());
            delete = DB.sqlUpdate("DELETE from pmt_signed where send_id=:id");
            delete.setParameter("id", (Object)this.getId());
            delete.execute();
        }
        delete = DB.sqlUpdate("UPDATE pmt_signed set callback_id=null where callback_id=:id");
        delete.setParameter("id", (Object)this.getId());
        delete.execute();
        delete = DB.sqlUpdate("UPDATE notification set send_id=null where send_id=:id");
        delete.setParameter("id", (Object)this.getId());
        delete.execute();
        delete = DB.sqlUpdate("UPDATE send_item set callback_id=null where callback_id=:id");
        delete.setParameter("id", (Object)this.getId());
        delete.execute();
        delete = DB.sqlUpdate("DELETE from send_item_account where send_item_id=:id");
        delete.setParameter("id", (Object)this.getId());
        delete.execute();
        DB.delete(this);
    }

    public SignedPayments getSignedPayments() {
        return this._ebean_get_signedPayments();
    }

    public void setSignedPayments(SignedPayments signedPayments) {
        this._ebean_set_signedPayments(signedPayments);
    }

    public List<Account> getAccounts() {
        return this._ebean_get_accounts();
    }

    public void setAccounts(List<Account> accounts) {
        this._ebean_set_accounts(accounts);
    }

    public String getMsgId() {
        return this._ebean_get_msgId();
    }

    public void setMsgId(String msgId) {
        this._ebean_set_msgId(msgId);
    }

    public String getScheme() {
        return this._ebean_get_scheme();
    }

    public void setScheme(String scheme) {
        this._ebean_set_scheme(scheme);
    }

    public String getAdditionalOrderInfo() {
        return this._ebean_get_additionalOrderInfo();
    }

    public void setAdditionalOrderInfo(String additionalOrderInfo) {
        this._ebean_set_additionalOrderInfo(additionalOrderInfo);
    }

    public String getIpAddress() {
        return this._ebean_get_ipAddress();
    }

    public void setIpAddress(String ipAddress) {
        this._ebean_set_ipAddress(ipAddress);
    }

    static {
        _ebean_props = new String[]{"id", "bank", "sent", "file", "origFileName", "state", "sts", "cnclSts", "vopSts", "errorCode", "sender", "pmtType", "fileType", "orderType", "orderNumber", "amount", "nbOfTxs", "signatureHash", "msgId", "scheme", "additionalOrderInfo", "currency", "withSalaries", "manualApproval", "callback", "ipAddress", "accounts", "signedPayments"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Timestamp _ebean_get_sent() {
        this._ebean_intercept.preGetter(2);
        return this.sent;
    }

    protected /* synthetic */ void _ebean_set_sent(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_sent(), (Object)newValue);
        this.sent = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_sent() {
        return this.sent;
    }

    protected /* synthetic */ void _ebean_setni_sent(Timestamp _newValue) {
        this.sent = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_file() {
        this._ebean_intercept.preGetter(3);
        return this.file;
    }

    protected /* synthetic */ void _ebean_set_file(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_file(), (Object)newValue);
        this.file = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_file() {
        return this.file;
    }

    protected /* synthetic */ void _ebean_setni_file(WorkspaceFile _newValue) {
        this.file = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_origFileName() {
        this._ebean_intercept.preGetter(4);
        return this.origFileName;
    }

    protected /* synthetic */ void _ebean_set_origFileName(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_origFileName(), (Object)newValue);
        this.origFileName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_origFileName() {
        return this.origFileName;
    }

    protected /* synthetic */ void _ebean_setni_origFileName(String _newValue) {
        this.origFileName = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ State _ebean_get_state() {
        this._ebean_intercept.preGetter(5);
        return this.state;
    }

    protected /* synthetic */ void _ebean_set_state(State newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
    }

    protected /* synthetic */ State _ebean_getni_state() {
        return this.state;
    }

    protected /* synthetic */ void _ebean_setni_state(State _newValue) {
        this.state = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_sts() {
        this._ebean_intercept.preGetter(6);
        return this.sts;
    }

    protected /* synthetic */ void _ebean_set_sts(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_sts(), (Object)newValue);
        this.sts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_sts() {
        return this.sts;
    }

    protected /* synthetic */ void _ebean_setni_sts(String _newValue) {
        this.sts = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_cnclSts() {
        this._ebean_intercept.preGetter(7);
        return this.cnclSts;
    }

    protected /* synthetic */ void _ebean_set_cnclSts(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_cnclSts(), (Object)newValue);
        this.cnclSts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_cnclSts() {
        return this.cnclSts;
    }

    protected /* synthetic */ void _ebean_setni_cnclSts(String _newValue) {
        this.cnclSts = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_vopSts() {
        this._ebean_intercept.preGetter(8);
        return this.vopSts;
    }

    protected /* synthetic */ void _ebean_set_vopSts(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_vopSts(), (Object)newValue);
        this.vopSts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_vopSts() {
        return this.vopSts;
    }

    protected /* synthetic */ void _ebean_setni_vopSts(String _newValue) {
        this.vopSts = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_errorCode() {
        this._ebean_intercept.preGetter(9);
        return this.errorCode;
    }

    protected /* synthetic */ void _ebean_set_errorCode(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_errorCode(), (Object)newValue);
        this.errorCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_errorCode() {
        return this.errorCode;
    }

    protected /* synthetic */ void _ebean_setni_errorCode(String _newValue) {
        this.errorCode = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_sender() {
        this._ebean_intercept.preGetter(10);
        return this.sender;
    }

    protected /* synthetic */ void _ebean_set_sender(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_sender(), (Object)newValue);
        this.sender = newValue;
    }

    protected /* synthetic */ String _ebean_getni_sender() {
        return this.sender;
    }

    protected /* synthetic */ void _ebean_setni_sender(String _newValue) {
        this.sender = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(11);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PaymentTransferType.PmtType newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PaymentTransferType.PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_fileType() {
        this._ebean_intercept.preGetter(12);
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_set_fileType(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_fileType(), (Object)newValue);
        this.fileType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileType() {
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_setni_fileType(String _newValue) {
        this.fileType = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(13);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_orderNumber() {
        this._ebean_intercept.preGetter(14);
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_set_orderNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_orderNumber(), (Object)newValue);
        this.orderNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderNumber() {
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_setni_orderNumber(String _newValue) {
        this.orderNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amount() {
        this._ebean_intercept.preGetter(15);
        return this.amount;
    }

    protected /* synthetic */ void _ebean_set_amount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_amount(), (Object)newValue);
        this.amount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amount() {
        return this.amount;
    }

    protected /* synthetic */ void _ebean_setni_amount(BigDecimal _newValue) {
        this.amount = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ Integer _ebean_get_nbOfTxs() {
        this._ebean_intercept.preGetter(16);
        return this.nbOfTxs;
    }

    protected /* synthetic */ void _ebean_set_nbOfTxs(Integer newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_nbOfTxs(), (Object)newValue);
        this.nbOfTxs = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_nbOfTxs() {
        return this.nbOfTxs;
    }

    protected /* synthetic */ void _ebean_setni_nbOfTxs(Integer _newValue) {
        this.nbOfTxs = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ String _ebean_get_signatureHash() {
        this._ebean_intercept.preGetter(17);
        return this.signatureHash;
    }

    protected /* synthetic */ void _ebean_set_signatureHash(String newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_signatureHash(), (Object)newValue);
        this.signatureHash = newValue;
    }

    protected /* synthetic */ String _ebean_getni_signatureHash() {
        return this.signatureHash;
    }

    protected /* synthetic */ void _ebean_setni_signatureHash(String _newValue) {
        this.signatureHash = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ String _ebean_get_msgId() {
        this._ebean_intercept.preGetter(18);
        return this.msgId;
    }

    protected /* synthetic */ void _ebean_set_msgId(String newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_msgId(), (Object)newValue);
        this.msgId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_msgId() {
        return this.msgId;
    }

    protected /* synthetic */ void _ebean_setni_msgId(String _newValue) {
        this.msgId = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ String _ebean_get_scheme() {
        this._ebean_intercept.preGetter(19);
        return this.scheme;
    }

    protected /* synthetic */ void _ebean_set_scheme(String newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_scheme(), (Object)newValue);
        this.scheme = newValue;
    }

    protected /* synthetic */ String _ebean_getni_scheme() {
        return this.scheme;
    }

    protected /* synthetic */ void _ebean_setni_scheme(String _newValue) {
        this.scheme = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ String _ebean_get_additionalOrderInfo() {
        this._ebean_intercept.preGetter(20);
        return this.additionalOrderInfo;
    }

    protected /* synthetic */ void _ebean_set_additionalOrderInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_additionalOrderInfo(), (Object)newValue);
        this.additionalOrderInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_additionalOrderInfo() {
        return this.additionalOrderInfo;
    }

    protected /* synthetic */ void _ebean_setni_additionalOrderInfo(String _newValue) {
        this.additionalOrderInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ String _ebean_get_currency() {
        this._ebean_intercept.preGetter(21);
        return this.currency;
    }

    protected /* synthetic */ void _ebean_set_currency(String newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_currency(), (Object)newValue);
        this.currency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_currency() {
        return this.currency;
    }

    protected /* synthetic */ void _ebean_setni_currency(String _newValue) {
        this.currency = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ Boolean _ebean_get_withSalaries() {
        this._ebean_intercept.preGetter(22);
        return this.withSalaries;
    }

    protected /* synthetic */ void _ebean_set_withSalaries(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_withSalaries(), (Object)newValue);
        this.withSalaries = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_withSalaries() {
        return this.withSalaries;
    }

    protected /* synthetic */ void _ebean_setni_withSalaries(Boolean _newValue) {
        this.withSalaries = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ Boolean _ebean_get_manualApproval() {
        this._ebean_intercept.preGetter(23);
        return this.manualApproval;
    }

    protected /* synthetic */ void _ebean_set_manualApproval(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_manualApproval(), (Object)newValue);
        this.manualApproval = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_manualApproval() {
        return this.manualApproval;
    }

    protected /* synthetic */ void _ebean_setni_manualApproval(Boolean _newValue) {
        this.manualApproval = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ Send _ebean_get_callback() {
        this._ebean_intercept.preGetter(24);
        return this.callback;
    }

    protected /* synthetic */ void _ebean_set_callback(Send newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_callback(), (Object)newValue);
        this.callback = newValue;
    }

    protected /* synthetic */ Send _ebean_getni_callback() {
        return this.callback;
    }

    protected /* synthetic */ void _ebean_setni_callback(Send _newValue) {
        this.callback = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ String _ebean_get_ipAddress() {
        this._ebean_intercept.preGetter(25);
        return this.ipAddress;
    }

    protected /* synthetic */ void _ebean_set_ipAddress(String newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_ipAddress(), (Object)newValue);
        this.ipAddress = newValue;
    }

    protected /* synthetic */ String _ebean_getni_ipAddress() {
        return this.ipAddress;
    }

    protected /* synthetic */ void _ebean_setni_ipAddress(String _newValue) {
        this.ipAddress = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ List _ebean_get_accounts() {
        this._ebean_intercept.preGetter(26);
        if (this.accounts == null) {
            this.accounts = new BeanList();
            this._ebean_intercept.initialisedMany(26);
            ((BeanCollection)this.accounts).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_set_accounts(List newValue) {
        this._ebean_intercept.preSetterMany(false, 26, this.accounts, (Object)newValue);
        this.accounts = newValue;
    }

    protected /* synthetic */ List _ebean_getni_accounts() {
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_setni_accounts(List _newValue) {
        this.accounts = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    protected /* synthetic */ SignedPayments _ebean_get_signedPayments() {
        this._ebean_intercept.preGetter(27);
        return this.signedPayments;
    }

    protected /* synthetic */ void _ebean_set_signedPayments(SignedPayments newValue) {
        this._ebean_intercept.preSetter(true, 27, (Object)this._ebean_get_signedPayments(), (Object)newValue);
        this.signedPayments = newValue;
    }

    protected /* synthetic */ SignedPayments _ebean_getni_signedPayments() {
        return this.signedPayments;
    }

    protected /* synthetic */ void _ebean_setni_signedPayments(SignedPayments _newValue) {
        this.signedPayments = _newValue;
        this._ebean_intercept.setLoadedProperty(27);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.sent;
            }
            case 3: {
                return this.file;
            }
            case 4: {
                return this.origFileName;
            }
            case 5: {
                return this.state;
            }
            case 6: {
                return this.sts;
            }
            case 7: {
                return this.cnclSts;
            }
            case 8: {
                return this.vopSts;
            }
            case 9: {
                return this.errorCode;
            }
            case 10: {
                return this.sender;
            }
            case 11: {
                return this.pmtType;
            }
            case 12: {
                return this.fileType;
            }
            case 13: {
                return this.orderType;
            }
            case 14: {
                return this.orderNumber;
            }
            case 15: {
                return this.amount;
            }
            case 16: {
                return this.nbOfTxs;
            }
            case 17: {
                return this.signatureHash;
            }
            case 18: {
                return this.msgId;
            }
            case 19: {
                return this.scheme;
            }
            case 20: {
                return this.additionalOrderInfo;
            }
            case 21: {
                return this.currency;
            }
            case 22: {
                return this.withSalaries;
            }
            case 23: {
                return this.manualApproval;
            }
            case 24: {
                return this.callback;
            }
            case 25: {
                return this.ipAddress;
            }
            case 26: {
                return this.accounts;
            }
            case 27: {
                return this.signedPayments;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_sent();
            }
            case 3: {
                return this._ebean_get_file();
            }
            case 4: {
                return this._ebean_get_origFileName();
            }
            case 5: {
                return this._ebean_get_state();
            }
            case 6: {
                return this._ebean_get_sts();
            }
            case 7: {
                return this._ebean_get_cnclSts();
            }
            case 8: {
                return this._ebean_get_vopSts();
            }
            case 9: {
                return this._ebean_get_errorCode();
            }
            case 10: {
                return this._ebean_get_sender();
            }
            case 11: {
                return this._ebean_get_pmtType();
            }
            case 12: {
                return this._ebean_get_fileType();
            }
            case 13: {
                return this._ebean_get_orderType();
            }
            case 14: {
                return this._ebean_get_orderNumber();
            }
            case 15: {
                return this._ebean_get_amount();
            }
            case 16: {
                return this._ebean_get_nbOfTxs();
            }
            case 17: {
                return this._ebean_get_signatureHash();
            }
            case 18: {
                return this._ebean_get_msgId();
            }
            case 19: {
                return this._ebean_get_scheme();
            }
            case 20: {
                return this._ebean_get_additionalOrderInfo();
            }
            case 21: {
                return this._ebean_get_currency();
            }
            case 22: {
                return this._ebean_get_withSalaries();
            }
            case 23: {
                return this._ebean_get_manualApproval();
            }
            case 24: {
                return this._ebean_get_callback();
            }
            case 25: {
                return this._ebean_get_ipAddress();
            }
            case 26: {
                return this._ebean_get_accounts();
            }
            case 27: {
                return this._ebean_get_signedPayments();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_sent((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_setni_file((WorkspaceFile)o);
                return;
            }
            case 4: {
                this._ebean_setni_origFileName((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_state((State)((Object)o));
                return;
            }
            case 6: {
                this._ebean_setni_sts((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_cnclSts((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_vopSts((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_errorCode((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_sender((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 12: {
                this._ebean_setni_fileType((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_orderNumber((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_amount((BigDecimal)o);
                return;
            }
            case 16: {
                this._ebean_setni_nbOfTxs((Integer)o);
                return;
            }
            case 17: {
                this._ebean_setni_signatureHash((String)o);
                return;
            }
            case 18: {
                this._ebean_setni_msgId((String)o);
                return;
            }
            case 19: {
                this._ebean_setni_scheme((String)o);
                return;
            }
            case 20: {
                this._ebean_setni_additionalOrderInfo((String)o);
                return;
            }
            case 21: {
                this._ebean_setni_currency((String)o);
                return;
            }
            case 22: {
                this._ebean_setni_withSalaries((Boolean)o);
                return;
            }
            case 23: {
                this._ebean_setni_manualApproval((Boolean)o);
                return;
            }
            case 24: {
                this._ebean_setni_callback((Send)o);
                return;
            }
            case 25: {
                this._ebean_setni_ipAddress((String)o);
                return;
            }
            case 26: {
                this._ebean_setni_accounts((List)o);
                return;
            }
            case 27: {
                this._ebean_setni_signedPayments((SignedPayments)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_sent((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_set_file((WorkspaceFile)o);
                return;
            }
            case 4: {
                this._ebean_set_origFileName((String)o);
                return;
            }
            case 5: {
                this._ebean_set_state((State)((Object)o));
                return;
            }
            case 6: {
                this._ebean_set_sts((String)o);
                return;
            }
            case 7: {
                this._ebean_set_cnclSts((String)o);
                return;
            }
            case 8: {
                this._ebean_set_vopSts((String)o);
                return;
            }
            case 9: {
                this._ebean_set_errorCode((String)o);
                return;
            }
            case 10: {
                this._ebean_set_sender((String)o);
                return;
            }
            case 11: {
                this._ebean_set_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 12: {
                this._ebean_set_fileType((String)o);
                return;
            }
            case 13: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 14: {
                this._ebean_set_orderNumber((String)o);
                return;
            }
            case 15: {
                this._ebean_set_amount((BigDecimal)o);
                return;
            }
            case 16: {
                this._ebean_set_nbOfTxs((Integer)o);
                return;
            }
            case 17: {
                this._ebean_set_signatureHash((String)o);
                return;
            }
            case 18: {
                this._ebean_set_msgId((String)o);
                return;
            }
            case 19: {
                this._ebean_set_scheme((String)o);
                return;
            }
            case 20: {
                this._ebean_set_additionalOrderInfo((String)o);
                return;
            }
            case 21: {
                this._ebean_set_currency((String)o);
                return;
            }
            case 22: {
                this._ebean_set_withSalaries((Boolean)o);
                return;
            }
            case 23: {
                this._ebean_set_manualApproval((Boolean)o);
                return;
            }
            case 24: {
                this._ebean_set_callback((Send)o);
                return;
            }
            case 25: {
                this._ebean_set_ipAddress((String)o);
                return;
            }
            case 26: {
                this._ebean_set_accounts((List)o);
                return;
            }
            case 27: {
                this._ebean_set_signedPayments((SignedPayments)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        Send send = this;
        synchronized (send) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Send)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new Send();
    }

    public static enum SignedPayments {
        UNKNOWN,
        NEVER,
        EXIST;

    }

    public static enum State {
        SENT,
        CONFIRMED,
        WAITING_IN_DS,
        FINISHED_OK,
        FINISHED_ERROR,
        CANCELED,
        SIGNATURE_STILL_MISSING,
        NOT_CONFIRMED;

    }
}

