/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;

@Entity
public class Scheduler
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankSettings bank;
    @ManyToOne
    private User loginUser;
    private String orderOrFileType;
    private String days;
    private String month;
    private String hour;
    private String minute;
    private String year;
    private Timestamp lastFetch;
    private String parameter;
    @Column(name="s_interval")
    private Interval interval;
    @Lob
    private String error;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public Scheduler() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_days("");
        this._ebean_set_month("");
        this._ebean_set_hour("");
        this._ebean_set_minute("");
        this._ebean_set_year("-");
    }

    public static int deleteAll(BankSettings bank) {
        Update<Scheduler> delete = DB.createUpdate(Scheduler.class, "DELETE FROM Scheduler WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static List<Scheduler> findByBank(BankSettings bank) {
        return DB.find(Scheduler.class).where().eq("bank", (Object)bank).findList();
    }

    public static int deleteByBankUser(BankUser bankUser) {
        Update<Scheduler> setNull = DB.createUpdate(Scheduler.class, "UPDATE Scheduler set loginUser=null WHERE loginUser=:user and bank=:bank");
        setNull.setParameter("bank", (Object)bankUser.getBank().getBankId());
        setNull.setParameter("user", (Object)bankUser.getUser().getId());
        return setNull.execute();
    }

    public static int deleteByUser(User user) {
        Update<Scheduler> setNull = DB.createUpdate(Scheduler.class, "UPDATE Scheduler set loginUser=null WHERE loginUser=:user");
        setNull.setParameter("user", (Object)user.getId());
        return setNull.execute();
    }

    public static Query<Scheduler> findForBanksOfUser(User user) {
        return DB.find(Scheduler.class).where().in("bank.users.user", new Object[]{user}).query();
    }

    public static Query<Scheduler> findForManagedTenants(User user) {
        return DB.find(Scheduler.class).where().eq("bank.tenant.managingUsers", (Object)user).query();
    }

    public static Scheduler findById(int id) {
        return (Scheduler)DB.find(Scheduler.class).where().eq("id", (Object)id).findOne();
    }

    public static Query<Scheduler> queryAll() {
        return DB.find(Scheduler.class);
    }

    public static List<Scheduler> findAll() {
        return Scheduler.queryAll().findList();
    }

    public static Query<Scheduler> findByPeriodicParameters(String days, String month, String hour, String minute, String year, Interval interval) {
        ExpressionList expr = DB.find(Scheduler.class).where();
        if (days != null) {
            expr.eq("days", (Object)days);
        }
        if (month != null) {
            expr.eq("month", (Object)month);
        }
        if (hour != null) {
            expr.eq("hour", (Object)hour);
        }
        if (minute != null) {
            expr.eq("minute", (Object)minute);
        }
        if (year != null) {
            expr.eq("year", (Object)year);
        }
        if (interval != null) {
            expr.eq("interval", (Object)interval);
        }
        return expr.query();
    }

    public static Expression getFilterExpression(String filter) {
        Object f = filter;
        if (!filter.contains("%")) {
            f = "%" + filter + "%";
        }
        return Expr.or((Expression)Expr.ilike((String)"loginUser.name", (String)f), (Expression)Expr.or((Expression)Expr.ilike((String)"bank.customerId", (String)f), (Expression)Expr.or((Expression)Expr.ilike((String)"loginUser.tenants.name", (String)f), (Expression)Expr.ilike((String)"bank.displayName", (String)f))));
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public User getLoginUser() {
        return this._ebean_get_loginUser();
    }

    public void setLoginUser(User user) {
        this._ebean_set_loginUser(user);
    }

    public String getOrderOrFileType() {
        return this._ebean_get_orderOrFileType();
    }

    public void setOrderOrFileType(String orderOrFileType) {
        this._ebean_set_orderOrFileType(orderOrFileType);
    }

    public String getDays() {
        return this._ebean_get_days();
    }

    public void setDays(String days) {
        this._ebean_set_days(days);
    }

    public String getMonth() {
        return this._ebean_get_month();
    }

    public void setMonth(String month) {
        this._ebean_set_month(month);
    }

    public String getHour() {
        return this._ebean_get_hour();
    }

    public void setHour(String hour) {
        this._ebean_set_hour(hour);
    }

    public String getMinute() {
        return this._ebean_get_minute();
    }

    public void setMinute(String minute) {
        this._ebean_set_minute(minute);
    }

    public String getYear() {
        return this._ebean_get_year();
    }

    public void setYear(String year) {
        this._ebean_set_year(year);
    }

    public Timestamp getLastFetch() {
        return this._ebean_get_lastFetch();
    }

    public void setLastFetch(Timestamp lastFetch) {
        this._ebean_set_lastFetch(lastFetch);
    }

    public Interval getInterval() {
        return this._ebean_get_interval();
    }

    public void setInterval(Interval interval) {
        this._ebean_set_interval(interval);
    }

    public String getParameter() {
        return this._ebean_get_parameter();
    }

    public void setParameter(String parameter) {
        this._ebean_set_parameter(parameter);
    }

    public String getError() {
        return this._ebean_get_error();
    }

    public void setError(String error) {
        this._ebean_set_error(error);
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        if (this._ebean_get_id() != null) {
            DB.delete(this);
        }
    }

    public String getScheduleTimes(Locale l) {
        StringBuilder result = new StringBuilder();
        boolean append = false;
        if (this._ebean_get_year() != null && !this._ebean_get_year().equals("-") && this._ebean_get_year().trim().length() != 0) {
            result.append(this._ebean_get_year());
            append = true;
        }
        if (this._ebean_get_month() != null && this._ebean_get_month().trim().length() != 0) {
            if (append) {
                result.append(", ");
            }
            if (this._ebean_get_days() != null && this._ebean_get_days().trim().length() != 0) {
                if (append) {
                    result.append(", ");
                }
                result.append(this._ebean_get_days());
                result.append(", ");
            }
            c = Calendar.getInstance();
            String monthsWithNames = this._ebean_get_month();
            for (int i = 11; i >= 0; --i) {
                c.set(2, i);
                monthsWithNames = monthsWithNames.replaceAll(String.valueOf(i), c.getDisplayName(2, 1, l));
            }
            result.append(monthsWithNames);
            append = true;
        } else if (this._ebean_get_days() != null && this._ebean_get_days().trim().length() != 0) {
            if (append) {
                result.append(", ");
            }
            c = Calendar.getInstance();
            String daysWithNames = this._ebean_get_days();
            for (int i = 1; i <= 7; ++i) {
                c.set(7, i);
                daysWithNames = daysWithNames.replaceAll(String.valueOf(i), c.getDisplayName(7, 1, l));
            }
            result.append(daysWithNames);
            append = true;
        }
        if (this._ebean_get_hour() != null && this._ebean_get_hour().trim().length() != 0) {
            if (append) {
                result.append(", ");
            }
            if (this._ebean_get_interval() == Interval.NONE) {
                result.append(this._ebean_get_hour());
                if (this._ebean_get_minute() != null && this._ebean_get_minute().trim().length() != 0) {
                    result.append(":").append(this._ebean_get_minute());
                }
            } else {
                String hoursWithMinutes = "";
                switch (this._ebean_get_interval().ordinal()) {
                    case 1: {
                        hoursWithMinutes = this._ebean_get_hour().replaceAll("-", ":00-").concat(":55");
                        break;
                    }
                    case 2: {
                        hoursWithMinutes = this._ebean_get_hour().replaceAll("-", ":00-").concat(":45");
                        break;
                    }
                    case 3: {
                        hoursWithMinutes = this._ebean_get_hour().replaceAll("-", ":00-").concat(":30");
                        break;
                    }
                    case 4: {
                        hoursWithMinutes = this._ebean_get_hour().replaceAll("-", ":00-").concat(":00");
                        break;
                    }
                }
                result.append(hoursWithMinutes);
            }
        }
        return result.toString();
    }

    public BankUser getBankUser() {
        if (this._ebean_get_loginUser() == null) {
            return null;
        }
        return BankUser.findBankUser(this._ebean_get_bank(), this._ebean_get_loginUser());
    }

    public void setBankUser(BankUser bankUser) {
        if (bankUser == null) {
            this._ebean_set_loginUser(null);
        } else {
            this._ebean_set_loginUser(bankUser.getUser());
            this._ebean_set_bank(bankUser.getBank());
        }
    }

    public boolean canBeEditedBy(User user) {
        if (user == null) {
            return false;
        }
        if (user.isAdmin()) {
            return true;
        }
        if (user.isTenantAdmin() && (this._ebean_get_loginUser() == null || ((Object)this._ebean_get_loginUser()).equals(user) || user.getManagedTenants().contains(this._ebean_get_bank().getTenant()))) {
            return true;
        }
        if (BankUser.findBankUser(this._ebean_get_bank(), user) == null) {
            return false;
        }
        return this._ebean_get_loginUser() == null || ((Object)this._ebean_get_loginUser()).equals(user);
    }

    public boolean isUnique() {
        Query query = DB.find(Scheduler.class).where().eq("bank", (Object)this._ebean_get_bank()).query();
        query.where().eq("loginUser", (Object)this._ebean_get_loginUser());
        query.where().eq("orderOrFileType", (Object)this._ebean_get_orderOrFileType());
        query.where().eq("days", (Object)this._ebean_get_days());
        query.where().eq("month", (Object)this._ebean_get_month());
        query.where().eq("hour", (Object)this._ebean_get_hour());
        query.where().eq("minute", (Object)this._ebean_get_minute());
        query.where().eq("year", (Object)this._ebean_get_year());
        query.where().eq("parameter", (Object)this._ebean_get_parameter());
        query.where().eq("interval", (Object)this._ebean_get_interval());
        List list = query.findList();
        if (list.isEmpty()) {
            return true;
        }
        if (list.size() > 1) {
            return false;
        }
        Scheduler other = (Scheduler)list.get(0);
        return other == null || other.getId().equals(this.getId());
    }

    static {
        _ebean_props = new String[]{"id", "bank", "loginUser", "orderOrFileType", "days", "month", "hour", "minute", "year", "lastFetch", "parameter", "interval", "error"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ User _ebean_get_loginUser() {
        this._ebean_intercept.preGetter(2);
        return this.loginUser;
    }

    protected /* synthetic */ void _ebean_set_loginUser(User newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_loginUser(), (Object)newValue);
        this.loginUser = newValue;
    }

    protected /* synthetic */ User _ebean_getni_loginUser() {
        return this.loginUser;
    }

    protected /* synthetic */ void _ebean_setni_loginUser(User _newValue) {
        this.loginUser = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_orderOrFileType() {
        this._ebean_intercept.preGetter(3);
        return this.orderOrFileType;
    }

    protected /* synthetic */ void _ebean_set_orderOrFileType(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_orderOrFileType(), (Object)newValue);
        this.orderOrFileType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderOrFileType() {
        return this.orderOrFileType;
    }

    protected /* synthetic */ void _ebean_setni_orderOrFileType(String _newValue) {
        this.orderOrFileType = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_days() {
        this._ebean_intercept.preGetter(4);
        return this.days;
    }

    protected /* synthetic */ void _ebean_set_days(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_days(), (Object)newValue);
        this.days = newValue;
    }

    protected /* synthetic */ String _ebean_getni_days() {
        return this.days;
    }

    protected /* synthetic */ void _ebean_setni_days(String _newValue) {
        this.days = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_month() {
        this._ebean_intercept.preGetter(5);
        return this.month;
    }

    protected /* synthetic */ void _ebean_set_month(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_month(), (Object)newValue);
        this.month = newValue;
    }

    protected /* synthetic */ String _ebean_getni_month() {
        return this.month;
    }

    protected /* synthetic */ void _ebean_setni_month(String _newValue) {
        this.month = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_hour() {
        this._ebean_intercept.preGetter(6);
        return this.hour;
    }

    protected /* synthetic */ void _ebean_set_hour(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_hour(), (Object)newValue);
        this.hour = newValue;
    }

    protected /* synthetic */ String _ebean_getni_hour() {
        return this.hour;
    }

    protected /* synthetic */ void _ebean_setni_hour(String _newValue) {
        this.hour = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_minute() {
        this._ebean_intercept.preGetter(7);
        return this.minute;
    }

    protected /* synthetic */ void _ebean_set_minute(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_minute(), (Object)newValue);
        this.minute = newValue;
    }

    protected /* synthetic */ String _ebean_getni_minute() {
        return this.minute;
    }

    protected /* synthetic */ void _ebean_setni_minute(String _newValue) {
        this.minute = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_year() {
        this._ebean_intercept.preGetter(8);
        return this.year;
    }

    protected /* synthetic */ void _ebean_set_year(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_year(), (Object)newValue);
        this.year = newValue;
    }

    protected /* synthetic */ String _ebean_getni_year() {
        return this.year;
    }

    protected /* synthetic */ void _ebean_setni_year(String _newValue) {
        this.year = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ Timestamp _ebean_get_lastFetch() {
        this._ebean_intercept.preGetter(9);
        return this.lastFetch;
    }

    protected /* synthetic */ void _ebean_set_lastFetch(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_lastFetch(), (Object)newValue);
        this.lastFetch = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_lastFetch() {
        return this.lastFetch;
    }

    protected /* synthetic */ void _ebean_setni_lastFetch(Timestamp _newValue) {
        this.lastFetch = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_parameter() {
        this._ebean_intercept.preGetter(10);
        return this.parameter;
    }

    protected /* synthetic */ void _ebean_set_parameter(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_parameter(), (Object)newValue);
        this.parameter = newValue;
    }

    protected /* synthetic */ String _ebean_getni_parameter() {
        return this.parameter;
    }

    protected /* synthetic */ void _ebean_setni_parameter(String _newValue) {
        this.parameter = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Interval _ebean_get_interval() {
        this._ebean_intercept.preGetter(11);
        return this.interval;
    }

    protected /* synthetic */ void _ebean_set_interval(Interval newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_interval(), (Object)newValue);
        this.interval = newValue;
    }

    protected /* synthetic */ Interval _ebean_getni_interval() {
        return this.interval;
    }

    protected /* synthetic */ void _ebean_setni_interval(Interval _newValue) {
        this.interval = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_error() {
        this._ebean_intercept.preGetter(12);
        return this.error;
    }

    protected /* synthetic */ void _ebean_set_error(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_error(), (Object)newValue);
        this.error = newValue;
    }

    protected /* synthetic */ String _ebean_getni_error() {
        return this.error;
    }

    protected /* synthetic */ void _ebean_setni_error(String _newValue) {
        this.error = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.loginUser;
            }
            case 3: {
                return this.orderOrFileType;
            }
            case 4: {
                return this.days;
            }
            case 5: {
                return this.month;
            }
            case 6: {
                return this.hour;
            }
            case 7: {
                return this.minute;
            }
            case 8: {
                return this.year;
            }
            case 9: {
                return this.lastFetch;
            }
            case 10: {
                return this.parameter;
            }
            case 11: {
                return this.interval;
            }
            case 12: {
                return this.error;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_loginUser();
            }
            case 3: {
                return this._ebean_get_orderOrFileType();
            }
            case 4: {
                return this._ebean_get_days();
            }
            case 5: {
                return this._ebean_get_month();
            }
            case 6: {
                return this._ebean_get_hour();
            }
            case 7: {
                return this._ebean_get_minute();
            }
            case 8: {
                return this._ebean_get_year();
            }
            case 9: {
                return this._ebean_get_lastFetch();
            }
            case 10: {
                return this._ebean_get_parameter();
            }
            case 11: {
                return this._ebean_get_interval();
            }
            case 12: {
                return this._ebean_get_error();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_loginUser((User)o);
                return;
            }
            case 3: {
                this._ebean_setni_orderOrFileType((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_days((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_month((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_hour((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_minute((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_year((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_lastFetch((Timestamp)o);
                return;
            }
            case 10: {
                this._ebean_setni_parameter((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_interval((Interval)((Object)o));
                return;
            }
            case 12: {
                this._ebean_setni_error((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_loginUser((User)o);
                return;
            }
            case 3: {
                this._ebean_set_orderOrFileType((String)o);
                return;
            }
            case 4: {
                this._ebean_set_days((String)o);
                return;
            }
            case 5: {
                this._ebean_set_month((String)o);
                return;
            }
            case 6: {
                this._ebean_set_hour((String)o);
                return;
            }
            case 7: {
                this._ebean_set_minute((String)o);
                return;
            }
            case 8: {
                this._ebean_set_year((String)o);
                return;
            }
            case 9: {
                this._ebean_set_lastFetch((Timestamp)o);
                return;
            }
            case 10: {
                this._ebean_set_parameter((String)o);
                return;
            }
            case 11: {
                this._ebean_set_interval((Interval)((Object)o));
                return;
            }
            case 12: {
                this._ebean_set_error((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Scheduler)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new Scheduler();
    }

    public static enum Interval {
        NONE,
        FIVE_MINUTES,
        FIFTEEN_MINUTES,
        THIRTY_MINUTES,
        HOURLY;

    }
}

