/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;

@Entity
public class PtkEntry
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private BankSettings bank;
    @Column(nullable=false)
    private Timestamp ptkTime;
    @Column(name="axn", nullable=false)
    private Integer action;
    private Integer result;
    @Column(length=4)
    private String orderNumber;
    @Column(length=3)
    private String orderType;
    @Lob
    @Column(nullable=false)
    private String data;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public PtkEntry() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    @Deprecated
    public static List<PtkEntry> findByAction(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime, Integer ... actions) {
        return DB.find(PtkEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("ptkTime", (Object)oldestTime).in("action", (Object[])actions).orderBy("ptkTime DESC").findList();
    }

    public static List<PtkEntry> findByAction(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime, Timestamp newestTime, Integer ... actions) {
        return DB.find(PtkEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("ptkTime", (Object)oldestTime).le("ptkTime", (Object)newestTime).in("action", (Object[])actions).orderBy("ptkTime DESC").findList();
    }

    public static boolean exists(BankSettings bank, Timestamp ptkTime, Integer action, String orderType, String orderNumber) {
        int found;
        ExpressionList expr = DB.find(PtkEntry.class).where().eq("action", (Object)action).eq("ptkTime", (Object)ptkTime).eq("bank", (Object)bank);
        if (orderType != null) {
            expr.eq("orderType", (Object)orderType);
        }
        if (orderNumber != null) {
            expr.eq("orderNumber", (Object)orderNumber);
        }
        return (found = expr.findCount()) != 0;
    }

    @Deprecated
    public static int countByOrderType(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime) {
        return PtkEntry.queryByOrderType(bank, orderType, orderNumber, oldestTime).findCount();
    }

    public static int countByOrderType(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime, Timestamp newestTime) {
        return PtkEntry.queryByOrderType(bank, orderType, orderNumber, oldestTime, newestTime).findCount();
    }

    @Deprecated
    public static Query<PtkEntry> queryByOrderType(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime) {
        return DB.find(PtkEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("ptkTime", (Object)oldestTime).orderBy("ptkTime, id").query();
    }

    public static Query<PtkEntry> queryByOrderType(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime, Timestamp newestTime) {
        return DB.find(PtkEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("ptkTime", (Object)oldestTime).le("ptkTime", (Object)newestTime).orderBy("ptkTime, id").query();
    }

    public static Query<PtkEntry> queryByBank(BankSettings bank) {
        return DB.find(PtkEntry.class).where().eq("bank", (Object)bank).query();
    }

    public static List<PtkEntry> findByActionNoOrderNumber(BankSettings bank, int action) {
        return DB.find(PtkEntry.class).where().eq("bank", (Object)bank).eq("axn", (Object)action).isNull("orderNumber").findList();
    }

    public static void deleteAll(BankSettings bank) {
        Update<PtkEntry> delete = DB.createUpdate(PtkEntry.class, "DELETE FROM PtkEntry WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        delete.execute();
    }

    public static int findOlderThan(Timestamp older) {
        return DB.find(PtkEntry.class).where().lt("ptkTime", (Object)older).findCount();
    }

    public static int deleteOlderThan(Timestamp older) {
        Update<PtkEntry> update = DB.createUpdate(PtkEntry.class, "DELETE FROM PtkEntry WHERE ptkTime < :older");
        update.set("older", (Object)older);
        return update.execute();
    }

    public static int deleteByTimeAndAction(BankSettings bank, Timestamp timestamp, int action) {
        Update<PtkEntry> delete = DB.createUpdate(PtkEntry.class, "DELETE FROM PtkEntry WHERE bank =:param1 AND ptkTime=:param2 AND axn=:param3");
        delete.set("param1", (Object)bank.getBankId());
        delete.set("param2", (Object)timestamp);
        delete.set("param3", (Object)action);
        return delete.execute();
    }

    public static PtkEntry findById(int id) {
        return (PtkEntry)DB.find(PtkEntry.class).where().eq("id", (Object)id).findOne();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public Timestamp getPtkTime() {
        return this._ebean_get_ptkTime();
    }

    public void setPtkTime(Timestamp ptkTime) {
        this._ebean_set_ptkTime(ptkTime);
    }

    public Integer getAction() {
        return this._ebean_get_action();
    }

    public void setAction(Integer action) {
        this._ebean_set_action(action);
    }

    public Integer getResult() {
        return this._ebean_get_result();
    }

    public void setResult(Integer result) {
        this._ebean_set_result(result);
    }

    public String getData() {
        return this._ebean_get_data();
    }

    public void setData(String data) {
        this._ebean_set_data(data);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public String getOrderNumber() {
        return this._ebean_get_orderNumber();
    }

    public void setOrderNumber(String orderNumber) {
        this._ebean_set_orderNumber(orderNumber);
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(String orderType) {
        this._ebean_set_orderType(orderType);
    }

    public String toString() {
        return this.getData();
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        DB.delete(this);
    }

    static {
        _ebean_props = new String[]{"id", "bank", "ptkTime", "action", "result", "orderNumber", "orderType", "data"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Timestamp _ebean_get_ptkTime() {
        this._ebean_intercept.preGetter(2);
        return this.ptkTime;
    }

    protected /* synthetic */ void _ebean_set_ptkTime(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_ptkTime(), (Object)newValue);
        this.ptkTime = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_ptkTime() {
        return this.ptkTime;
    }

    protected /* synthetic */ void _ebean_setni_ptkTime(Timestamp _newValue) {
        this.ptkTime = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Integer _ebean_get_action() {
        this._ebean_intercept.preGetter(3);
        return this.action;
    }

    protected /* synthetic */ void _ebean_set_action(Integer newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_action(), (Object)newValue);
        this.action = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_action() {
        return this.action;
    }

    protected /* synthetic */ void _ebean_setni_action(Integer _newValue) {
        this.action = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Integer _ebean_get_result() {
        this._ebean_intercept.preGetter(4);
        return this.result;
    }

    protected /* synthetic */ void _ebean_set_result(Integer newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_result(), (Object)newValue);
        this.result = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_result() {
        return this.result;
    }

    protected /* synthetic */ void _ebean_setni_result(Integer _newValue) {
        this.result = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_orderNumber() {
        this._ebean_intercept.preGetter(5);
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_set_orderNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_orderNumber(), (Object)newValue);
        this.orderNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderNumber() {
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_setni_orderNumber(String _newValue) {
        this.orderNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(6);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_data() {
        this._ebean_intercept.preGetter(7);
        return this.data;
    }

    protected /* synthetic */ void _ebean_set_data(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_data(), (Object)newValue);
        this.data = newValue;
    }

    protected /* synthetic */ String _ebean_getni_data() {
        return this.data;
    }

    protected /* synthetic */ void _ebean_setni_data(String _newValue) {
        this.data = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.ptkTime;
            }
            case 3: {
                return this.action;
            }
            case 4: {
                return this.result;
            }
            case 5: {
                return this.orderNumber;
            }
            case 6: {
                return this.orderType;
            }
            case 7: {
                return this.data;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_ptkTime();
            }
            case 3: {
                return this._ebean_get_action();
            }
            case 4: {
                return this._ebean_get_result();
            }
            case 5: {
                return this._ebean_get_orderNumber();
            }
            case 6: {
                return this._ebean_get_orderType();
            }
            case 7: {
                return this._ebean_get_data();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_ptkTime((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_setni_action((Integer)o);
                return;
            }
            case 4: {
                this._ebean_setni_result((Integer)o);
                return;
            }
            case 5: {
                this._ebean_setni_orderNumber((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_data((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_ptkTime((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_set_action((Integer)o);
                return;
            }
            case 4: {
                this._ebean_set_result((Integer)o);
                return;
            }
            case 5: {
                this._ebean_set_orderNumber((String)o);
                return;
            }
            case 6: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 7: {
                this._ebean_set_data((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        PtkEntry ptkEntry = this;
        synchronized (ptkEntry) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PtkEntry)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new PtkEntry();
    }
}

