/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import io.ebean.Transaction;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyServer {
    private static final Logger LOGGER = Logger.getLogger(ProxyServer.class.getName());
    private static ProxyServer PROXY = null;
    private static final ArrayList<String> keyNames = new ArrayList();
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;

    public static void updateData() {
        List settings = DB.find(ApplicationInfo.class).where().in("propName", keyNames).findList();
        if (settings.isEmpty()) {
            PROXY = new ProxyServer();
            PROXY.save();
        } else {
            PROXY = new ProxyServer();
            for (ApplicationInfo i : settings) {
                ApplicationInfo.PropKey k = ApplicationInfo.PropKey.valueOf(i.getPropName());
                switch (k) {
                    case PROXY_HOST: {
                        PROXY.setProxyHost(i.getPropValue());
                        break;
                    }
                    case PROXY_PORT: {
                        if (i.getPropValue() == null || i.getPropValue().length() <= 0) break;
                        PROXY.setProxyPort(Integer.valueOf(i.getPropValue()));
                        break;
                    }
                    case PROXY_USER: {
                        PROXY.setProxyUser(i.getPropValue());
                        break;
                    }
                    case PROXY_PASSWORD: {
                        PROXY.setProxyPassword(i.getPropValue());
                        break;
                    }
                }
            }
        }
    }

    public static void setupProxy() {
        ProxyServer.updateData();
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                ArrayList<Proxy> PROXIES = new ArrayList<Proxy>();
                if (PROXY.getProxyHost() == null || PROXY.getProxyHost().length() == 0) {
                    LOGGER.log(Level.FINE, "No proxy configured");
                    PROXIES.add(Proxy.NO_PROXY);
                    return PROXIES;
                }
                int port = 8080;
                if (PROXY.getProxyPort() != null) {
                    port = PROXY.getProxyPort();
                }
                LOGGER.log(Level.FINE, "Proxy selected for uri {0}", uri);
                PROXIES.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PROXY.getProxyHost(), port)));
                return PROXIES;
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                LOGGER.log(Level.WARNING, "Proxy '" + PROXY.getProxyHost() + ":" + PROXY.getProxyPort() + "' failed for URL " + String.valueOf(uri), ioe);
            }
        });
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                char[] pwd = null;
                if (PROXY.getProxyPassword() != null) {
                    pwd = PROXY.getProxyPassword().toCharArray();
                }
                return new PasswordAuthentication(PROXY.getProxyUser(), pwd);
            }
        });
    }

    public static ProxyServer getProxyServer() {
        if (PROXY == null) {
            ProxyServer.setupProxy();
        }
        return PROXY;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void save() {
        ArrayList<ApplicationInfo> settings = new ArrayList<ApplicationInfo>();
        settings.add(ApplicationInfo.createInstance(ApplicationInfo.PropKey.PROXY_HOST, this.getProxyHost()));
        String port = "";
        if (this.getProxyPort() != null) {
            port = String.valueOf(this.getProxyPort());
        }
        settings.add(ApplicationInfo.createInstance(ApplicationInfo.PropKey.PROXY_PORT, port));
        settings.add(ApplicationInfo.createInstance(ApplicationInfo.PropKey.PROXY_USER, this.getProxyUser()));
        settings.add(ApplicationInfo.createInstance(ApplicationInfo.PropKey.PROXY_PASSWORD, this.getProxyPassword()));
        try (Transaction t = DB.beginTransaction();){
            List existing = DB.find(ApplicationInfo.class).where().in("propName", keyNames).findList();
            if (!existing.isEmpty()) {
                DB.delete(existing);
            }
            DB.save(settings);
            t.commit();
        }
    }

    static {
        keyNames.add(ApplicationInfo.PropKey.PROXY_HOST.name());
        keyNames.add(ApplicationInfo.PropKey.PROXY_PORT.name());
        keyNames.add(ApplicationInfo.PropKey.PROXY_USER.name());
        keyNames.add(ApplicationInfo.PropKey.PROXY_PASSWORD.name());
    }
}

