/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.UniqueConstraint;

@Entity
@UniqueConstraint(columnNames={"application_id", "pref_key", "user_id"})
public class Preference
implements EntityBean {
    @Id
    private Integer id;
    @Column(nullable=false)
    private ApplicationId applicationId;
    @Column(length=80, nullable=false, name="pref_key")
    private String key;
    @Column(length=255, name="pref_value")
    private String value;
    @ManyToOne(optional=true)
    private User user;
    @ManyToOne(optional=true)
    private Tenant tenant;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public Preference() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static List<Preference> getAllByUser(User user) {
        return DB.find(Preference.class).where().or(Expr.eq((String)"user", (Object)user), Expr.isNull((String)"user")).findList();
    }

    public static Preference getPreference(ApplicationId applicationId, String key) {
        return (Preference)DB.find(Preference.class).where().isNull("user").isNull("tenant").eq("applicationId", (Object)applicationId).eq("key", (Object)key).setMaxRows(1).findOne();
    }

    public static Preference getPreference(User user, ApplicationId applicationId, String key) {
        return (Preference)DB.find(Preference.class).where().eq("user", (Object)user).eq("applicationId", (Object)applicationId).eq("key", (Object)key).setMaxRows(1).findOne();
    }

    public static Preference getPreference(Tenant tenant, ApplicationId applicationId, String key) {
        return (Preference)DB.find(Preference.class).where().eq("tenant_id", (Object)tenant.getId()).eq("applicationId", (Object)applicationId).eq("key", (Object)key).setMaxRows(1).findOne();
    }

    public static void deleteByUser(User user) {
        Update<Preference> delete = DB.createUpdate(Preference.class, "DELETE FROM Preference WHERE user = :user");
        delete.setParameter("user", (Object)user.getId());
        delete.execute();
    }

    public static void deleteByTenant(Tenant tenant) {
        Update<Preference> delete = DB.createUpdate(Preference.class, "DELETE FROM Preference WHERE tenant=:tenant");
        delete.setParameter("tenant", (Object)tenant.getId());
        delete.execute();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public ApplicationId getApplicationId() {
        return this._ebean_get_applicationId();
    }

    public void setApplicationId(ApplicationId applicationId) {
        this._ebean_set_applicationId(applicationId);
    }

    public String getKey() {
        return this._ebean_get_key();
    }

    public void setKey(String key) {
        this._ebean_set_key(key);
    }

    public String getValue() {
        return this._ebean_get_value();
    }

    public void setValue(String value) {
        this._ebean_set_value(value);
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public void setUser(User user) {
        this._ebean_set_user(user);
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        if (this._ebean_get_id() != null) {
            DB.delete(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "applicationId", "key", "value", "user", "tenant"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ ApplicationId _ebean_get_applicationId() {
        this._ebean_intercept.preGetter(1);
        return this.applicationId;
    }

    protected /* synthetic */ void _ebean_set_applicationId(ApplicationId newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_applicationId(), (Object)newValue);
        this.applicationId = newValue;
    }

    protected /* synthetic */ ApplicationId _ebean_getni_applicationId() {
        return this.applicationId;
    }

    protected /* synthetic */ void _ebean_setni_applicationId(ApplicationId _newValue) {
        this.applicationId = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_key() {
        this._ebean_intercept.preGetter(2);
        return this.key;
    }

    protected /* synthetic */ void _ebean_set_key(String newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_key(), (Object)newValue);
        this.key = newValue;
    }

    protected /* synthetic */ String _ebean_getni_key() {
        return this.key;
    }

    protected /* synthetic */ void _ebean_setni_key(String _newValue) {
        this.key = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_value() {
        this._ebean_intercept.preGetter(3);
        return this.value;
    }

    protected /* synthetic */ void _ebean_set_value(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_value(), (Object)newValue);
        this.value = newValue;
    }

    protected /* synthetic */ String _ebean_getni_value() {
        return this.value;
    }

    protected /* synthetic */ void _ebean_setni_value(String _newValue) {
        this.value = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(4);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(5);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.applicationId;
            }
            case 2: {
                return this.key;
            }
            case 3: {
                return this.value;
            }
            case 4: {
                return this.user;
            }
            case 5: {
                return this.tenant;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_applicationId();
            }
            case 2: {
                return this._ebean_get_key();
            }
            case 3: {
                return this._ebean_get_value();
            }
            case 4: {
                return this._ebean_get_user();
            }
            case 5: {
                return this._ebean_get_tenant();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_applicationId((ApplicationId)((Object)o));
                return;
            }
            case 2: {
                this._ebean_setni_key((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_value((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 5: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_applicationId((ApplicationId)((Object)o));
                return;
            }
            case 2: {
                this._ebean_set_key((String)o);
                return;
            }
            case 3: {
                this._ebean_set_value((String)o);
                return;
            }
            case 4: {
                this._ebean_set_user((User)o);
                return;
            }
            case 5: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        Preference preference = this;
        synchronized (preference) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Preference)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new Preference();
    }

    public static enum ApplicationId {
        BANKING,
        AWZEL,
        BUNDESBANK,
        CM,
        PAYMENTS,
        SEPA,
        TRANSFER,
        UPDATE,
        BL_BANKING_WEB,
        YUBIKEY;

    }
}

