/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.EbeanHelper;
import de.businesslogics.banking.database.vo.HistoryLog;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.Transaction;
import io.ebean.Update;
import io.ebean.annotation.Index;
import io.ebean.bean.EntityBean;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="pmt_periodic")
public class PeriodicPayment
extends HistoryLog
implements EntityBean {
    @ManyToOne(optional=false)
    private BankSettings bank;
    @ManyToOne
    private Account account;
    private PaymentTransferType.PmtType pmtType;
    @Column(length=3)
    @Index(name="ix_pmt_periodic_order_type")
    private String orderType;
    @Column(length=50)
    @Index(name="ix_pmt_periodic_file_type")
    private String fileType;
    @Column(name="is_credit")
    private Boolean credit;
    @Column(name="is_urgent")
    private Boolean urgent;
    @Column(length=70)
    private String originator;
    @Column(length=70)
    private String recipient;
    @Column(precision=38, scale=3)
    private BigDecimal amount;
    @Column(length=3)
    private String amountCurrency;
    @Column(length=140)
    private String purpose;
    @Column(name="exec_ival", nullable=false)
    private ExecutionInterval executionInterval;
    private Date firstExecutionDate;
    private Date lastExecutionDate;
    private Date previousExecutionDate;
    private Date nextExecutionDate;
    @Lob
    private byte[] paymentData;
    @Column(length=150)
    private String genericPurpose;
    @ManyToOne
    private PaymentFolder folder;
    private Boolean salaryPayment;
    public static /* synthetic */ String[] _ebean_props;

    @Override
    public void confirm(User user, Integer id, Integer businessId) {
    }

    @Override
    public void discard(User user, Integer id, Integer businessId) {
    }

    @Override
    public HistoryLog findOriginalEntry() {
        if (this.getId() != null) {
            return DB.find(PeriodicPayment.class, this.getId());
        }
        return null;
    }

    @Override
    public HistoryLog findHistoricEntry() {
        return null;
    }

    public Query<PeriodicPayment> findHistoricEntries() {
        ExpressionList expr = this._ebean_get_businessId() != null ? DB.find(PeriodicPayment.class).where().eq("businessId", (Object)this._ebean_get_businessId()) : DB.find(PeriodicPayment.class).where().eq("id", (Object)this.getId());
        expr.where().gt("created", (Object)MIGRATION_DATE);
        expr.orderBy().desc("created");
        return expr.query();
    }

    public static PeriodicPayment findById(Integer id) {
        return (PeriodicPayment)DB.find(PeriodicPayment.class).where().eq("id", (Object)id).findOne();
    }

    public static int countByAccount(Account account) {
        return DB.find(PeriodicPayment.class).where().eq("account", (Object)account).findCount();
    }

    public static int getTotalPeriodicPaymentsCount(PaymentFolder folder) {
        return DB.find(PeriodicPayment.class).where().eq("folder", (Object)folder).where().ne("version", (Object)HistoryLog.Version.HISTORIC).findCount();
    }

    public static void changeHistoricPaymentsInFolder(PaymentFolder folder) {
        for (PeriodicPayment historicPayment : DB.find(PeriodicPayment.class).where().eq("folder", (Object)folder).where().eq("version", (Object)HistoryLog.Version.HISTORIC).findList()) {
            PeriodicPayment original = PeriodicPayment.findById(historicPayment.getBusinessId());
            if (original != null) {
                historicPayment.setFolder(original.getFolder());
            } else {
                historicPayment.setFolder(null);
            }
            DB.save(historicPayment);
        }
    }

    public static int deleteAll(Account account) {
        Update<PeriodicPayment> delete = DB.createUpdate(PeriodicPayment.class, "DELETE FROM PeriodicPayment WHERE account=:account");
        delete.setParameter("account", (Object)account.getId());
        return delete.execute();
    }

    public static int removeFolderReferences(PaymentFolder folder) {
        Update<PeriodicPayment> update = DB.createUpdate(PeriodicPayment.class, "UPDATE PeriodicPayment SET folder = null WHERE folder=:folder");
        update.setParameter("folder", (Object)folder.getId());
        return update.execute();
    }

    public static int getNumberOfPeriodicPayments(BankSettings bank) {
        return DB.find(PeriodicPayment.class).where().eq("bank", (Object)bank).findCount();
    }

    public static int deleteAll(BankSettings bank) {
        Update<PeriodicPayment> delete = DB.createUpdate(PeriodicPayment.class, "DELETE FROM PeriodicPayment WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static int updateFileTypeAndOrderType(BankSettings bank, PaymentTransferType.PmtType pmtType, String fileType, String orderType) {
        Update<PeriodicPayment> update = DB.createUpdate(PeriodicPayment.class, "UPDATE PeriodicPayment SET fileType =:p1, orderType =:p2 WHERE pmtType =:p3 AND bank =:p4");
        update.setParameter("p1", (Object)fileType);
        update.setParameter("p2", (Object)orderType);
        update.setParameter("p3", (Object)pmtType);
        update.setParameter("p4", (Object)bank.getBankId());
        return update.execute();
    }

    public static Query<PeriodicPayment> getDefaultQuery(User user, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PeriodicPayment.getDefaultQuery(user, null, onlyPaymentsWithPermission, excludeSalaries);
    }

    public static int getPeriodicPaymentsCount(User user, PaymentFolder folder, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PeriodicPayment.getDefaultQuery(user, folder, onlyPaymentsWithPermission, excludeSalaries).findCount();
    }

    public static Query<PeriodicPayment> getDefaultQuery(User user, PaymentFolder folder, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        Query query = DB.find(PeriodicPayment.class).orderBy("account");
        if (folder != null && folder.getId() != null) {
            query.where().eq("folder", (Object)folder);
        } else if (((Object)PaymentFolder.NULL_FOLDER).equals(folder)) {
            query.where().isNull("folder");
        }
        if (excludeSalaries) {
            query.where().or(Expr.isNull((String)"salaryPayment"), Expr.eq((String)"salaryPayment", (Object)false));
        }
        query.where().ne("version", (Object)HistoryLog.Version.HISTORIC);
        ArrayList<BankSettings> banksList = new ArrayList<BankSettings>();
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            banksList.add(bankUser.getBank());
        }
        if (onlyPaymentsWithPermission) {
            Expression orderTypeFilter = OrderType.buildExpressionForOrderTypePermissions(user, "bank", "orderType", "fileType", "account");
            if (orderTypeFilter == null) {
                return query.where(Expr.isNull((String)"bank"));
            }
            Expression accountFilter = Account.buildExpressionForAccountPermissions(user, "account");
            if (accountFilter == null) {
                return query.where(Expr.isNull((String)"bank"));
            }
            Expression manualAccounts = Account.buildExpressionForManualAccountPermissions(user, "account");
            query.where().or(manualAccounts, Expr.and((Expression)orderTypeFilter, (Expression)accountFilter));
        } else {
            if (banksList.size() == 0) {
                return query.where(Expr.isNull((String)"bank"));
            }
            if (banksList.size() == 1) {
                query.where().eq("bank", banksList.get(0));
            } else {
                query.where().in("bank", banksList);
            }
        }
        return query;
    }

    public static String getRecipientWithAccountNumber(PeriodicPayment payment, boolean showRecipientWithAccountNumber, boolean useMandates) {
        return PeriodicPayment.getRecipientWithAccountNumber(payment.getRecipient(), payment.isCredit(), payment.getAccount(), showRecipientWithAccountNumber, useMandates);
    }

    public static String getRecipientWithAccountNumber(String recipientName, boolean isCredit, Account originatorAccount, boolean showRecipientWithAccountNumber, boolean useMandates) {
        if (showRecipientWithAccountNumber) {
            String accNumber;
            int n;
            List<PaymentRecipient> paymentRecipients;
            Tenant tenant = originatorAccount.getBank().getTenant();
            ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
            paymentTypes.add(PaymentType.MANDATE);
            if (isCredit || !useMandates) {
                paymentTypes.add(PaymentType.SEPA);
            }
            if ((paymentRecipients = PaymentRecipient.findRecipientByName(paymentTypes, recipientName, tenant)) != null && (n = paymentRecipients.size()) == 1 && (accNumber = paymentRecipients.get(0).getAccountNumber()) != null) {
                return recipientName + " (" + IbanUtil.formatIfIBAN(accNumber) + ")";
            }
        }
        return recipientName;
    }

    public static void deletePayments(User user, Collection<PeriodicPayment> payments) {
        try (Transaction t = DB.beginTransaction();){
            for (PeriodicPayment payment : payments) {
                payment.delete(user);
            }
            t.commit();
        }
    }

    public static int countByCurrency(User user, String currency, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PeriodicPayment.getDefaultQuery(user, null, onlyPaymentsWithPermission, excludeSalaries).where(Expr.eq((String)"amountCurrency", (Object)currency)).findCount();
    }

    public static int countByCurrency(User user, PaymentFolder folder, String currency, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PeriodicPayment.getDefaultQuery(user, folder, onlyPaymentsWithPermission, excludeSalaries).where(Expr.eq((String)"amountCurrency", (Object)currency)).findCount();
    }

    public static BigDecimal sumAmount(User user, String currency, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PeriodicPayment.sumAmount(user, null, currency, onlyPaymentsWithPermission, excludeSalaries);
    }

    public static BigDecimal sumAmount(User user, PaymentFolder folder, String currency, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        SqlRow row;
        StringBuilder queryBuilder = new StringBuilder("select sum(amount) as total_amount from pmt_periodic where amount_currency = '").append(currency).append('\'');
        if (folder != null && folder.getId() != null) {
            queryBuilder.append(" and folder_id = ").append(folder.getId());
        } else if (((Object)PaymentFolder.NULL_FOLDER).equals(folder)) {
            queryBuilder.append(" and folder_id is null");
        }
        if (excludeSalaries) {
            queryBuilder.append(" and salary_payment = :param1");
        }
        if (onlyPaymentsWithPermission) {
            String whereClause = OrderType.buildRawExpressionForOrderTypePermissions(user, "bank_id", "order_type", "file_type", "account_id");
            if (whereClause == null) {
                return BigDecimal.ZERO;
            }
            queryBuilder.append(" and (").append(whereClause).append(')');
            whereClause = Account.buildRawExpressionForAccountPermission(user, "bank_id", "account_id");
            if (whereClause == null) {
                return BigDecimal.ZERO;
            }
            queryBuilder.append(" and ").append(whereClause);
        } else {
            List<BankUser> bankUsers = BankUser.findBanksForUser(user);
            if (bankUsers.size() != 0) {
                if (bankUsers.size() == 1) {
                    queryBuilder.append(" and bank_id = ").append(bankUsers.get(0).getBank().getBankId());
                } else {
                    queryBuilder.append(" and bank_id in (");
                    for (int i = 0; i < bankUsers.size(); ++i) {
                        if (i > 0) {
                            queryBuilder.append(", ");
                        }
                        queryBuilder.append(bankUsers.get(i).getBank().getBankId());
                    }
                    queryBuilder.append(')');
                }
            }
        }
        SqlQuery query = DB.createSqlQuery(queryBuilder.toString());
        if (excludeSalaries) {
            query.setParameter("param1", (Object)Boolean.FALSE);
        }
        if ((row = query.findOne()) == null) {
            return null;
        }
        return row.getBigDecimal("total_amount");
    }

    public static void deleteByFolder(User user, PaymentFolder folder, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        Query<PeriodicPayment> query = PeriodicPayment.getDefaultQuery(user, folder, onlyPaymentsWithPermission, excludeSalaries);
        ArrayList idsToDelete = new ArrayList();
        query.findEach(bean -> idsToDelete.add(bean.getId()));
        EbeanHelper.deleteById(PeriodicPayment.class, idsToDelete);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public String getOrderTypeOrFileType() {
        if (this.getFileType() != null && !RegularExpressions.BTF_SERVICE_PATTERN.matches(this.getFileType())) {
            return this.getFileType();
        }
        return this.getOrderType();
    }

    public void setOrderType(String orderType) {
        this._ebean_set_orderType(orderType);
    }

    public String getFileType() {
        if (this._ebean_get_fileType() == null || !RegularExpressions.BTF_SERVICE_PATTERN.matches(this._ebean_get_fileType())) {
            return this._ebean_get_fileType();
        }
        return null;
    }

    public String getFileTypeOrBTF() {
        return this._ebean_get_fileType();
    }

    public String getBTF() {
        if (this._ebean_get_fileType() != null && RegularExpressions.BTF_SERVICE_PATTERN.matches(this._ebean_get_fileType())) {
            return this._ebean_get_fileType();
        }
        return null;
    }

    public String getOrderTypeOrBtf() {
        try {
            int h00Version = Integer.parseInt(this._ebean_get_account().getBank().getProtocolVersion().substring(3, 4));
            if (h00Version >= 5) {
                return this.getBTF();
            }
            return this._ebean_get_orderType();
        }
        catch (NullPointerException | NumberFormatException e) {
            return this._ebean_get_orderType();
        }
    }

    public void setFileType(String fileType) {
        this._ebean_set_fileType(fileType);
    }

    public boolean isCredit() {
        if (this._ebean_get_credit() == null) {
            return false;
        }
        return this._ebean_get_credit();
    }

    public void setCredit(boolean isCredit) {
        this._ebean_set_credit(isCredit);
    }

    public Boolean isUrgent() {
        if (this._ebean_get_urgent() == null) {
            return false;
        }
        return this._ebean_get_urgent();
    }

    public void setUrgent(boolean isUrgent) {
        this._ebean_set_urgent(isUrgent);
    }

    public String getOriginator() {
        return this._ebean_get_originator();
    }

    public void setOriginator(String originator) {
        this._ebean_set_originator(originator);
    }

    public String getRecipient() {
        return this._ebean_get_recipient();
    }

    public void setRecipient(String recipient) {
        this._ebean_set_recipient(recipient);
    }

    public BigDecimal getAmount() {
        return this._ebean_get_amount();
    }

    public void setAmount(BigDecimal amount) {
        this._ebean_set_amount(amount);
    }

    public String getAmountCurrency() {
        return this._ebean_get_amountCurrency();
    }

    public void setAmountCurrency(String amountCurrency) {
        this._ebean_set_amountCurrency(amountCurrency);
    }

    public String getPurpose() {
        return this._ebean_get_purpose();
    }

    public void setPurpose(String purpose) {
        if (purpose != null && purpose.length() > 140) {
            this._ebean_set_purpose(purpose.substring(0, 140));
        } else {
            this._ebean_set_purpose(purpose);
        }
    }

    public ExecutionInterval getExecutionInterval() {
        return this._ebean_get_executionInterval();
    }

    public void setExecutionInterval(ExecutionInterval executionInterval) {
        this._ebean_set_executionInterval(executionInterval);
    }

    public Date getFirstExecutionDate() {
        return this._ebean_get_firstExecutionDate();
    }

    public void setFirstExecutionDate(Date firstExecutionDate) {
        this._ebean_set_firstExecutionDate(firstExecutionDate);
    }

    public Date getLastExecutionDate() {
        return this._ebean_get_lastExecutionDate();
    }

    public void setLastExecutionDate(Date lastExecutionDate) {
        this._ebean_set_lastExecutionDate(lastExecutionDate);
    }

    public Date getPreviousExecutionDate() {
        return this._ebean_get_previousExecutionDate();
    }

    public void setPreviousExecutionDate(Date previousExecutionDate) {
        this._ebean_set_previousExecutionDate(previousExecutionDate);
    }

    public Date getNextExecutionDate() {
        return this._ebean_get_nextExecutionDate();
    }

    public void setNextExecutionDate(Date nextExecutionDate) {
        this._ebean_set_nextExecutionDate(nextExecutionDate);
    }

    public byte[] getPaymentData() {
        return this._ebean_get_paymentData();
    }

    public void setPaymentData(byte[] paymentData) {
        this._ebean_set_paymentData(paymentData);
    }

    public String getGenericPurpose() {
        return this._ebean_get_genericPurpose();
    }

    public void setGenericPurpose(String genericPurpose) {
        this._ebean_set_genericPurpose(genericPurpose);
    }

    public PaymentFolder getFolder() {
        return this._ebean_get_folder();
    }

    public void setFolder(PaymentFolder folder) {
        this._ebean_set_folder(folder);
    }

    public Boolean getSalaryPayment() {
        return this._ebean_get_salaryPayment();
    }

    public void setSalaryPayment(Boolean salaryPayment) {
        this._ebean_set_salaryPayment(salaryPayment);
    }

    static {
        _ebean_props = new String[]{"id", "businessId", "createdUser", "created", "confirmedUser", "confirmed", "version", "lockingUser", "deleted", "hasFourEyesChange", "bank", "account", "pmtType", "orderType", "fileType", "credit", "urgent", "originator", "recipient", "amount", "amountCurrency", "purpose", "executionInterval", "firstExecutionDate", "lastExecutionDate", "previousExecutionDate", "nextExecutionDate", "paymentData", "genericPurpose", "folder", "salaryPayment"};
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(10);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(11);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(12);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PaymentTransferType.PmtType newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PaymentTransferType.PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(13);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_fileType() {
        this._ebean_intercept.preGetter(14);
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_set_fileType(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_fileType(), (Object)newValue);
        this.fileType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileType() {
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_setni_fileType(String _newValue) {
        this.fileType = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ Boolean _ebean_get_credit() {
        this._ebean_intercept.preGetter(15);
        return this.credit;
    }

    protected /* synthetic */ void _ebean_set_credit(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_credit(), (Object)newValue);
        this.credit = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_credit() {
        return this.credit;
    }

    protected /* synthetic */ void _ebean_setni_credit(Boolean _newValue) {
        this.credit = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ Boolean _ebean_get_urgent() {
        this._ebean_intercept.preGetter(16);
        return this.urgent;
    }

    protected /* synthetic */ void _ebean_set_urgent(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_urgent(), (Object)newValue);
        this.urgent = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_urgent() {
        return this.urgent;
    }

    protected /* synthetic */ void _ebean_setni_urgent(Boolean _newValue) {
        this.urgent = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ String _ebean_get_originator() {
        this._ebean_intercept.preGetter(17);
        return this.originator;
    }

    protected /* synthetic */ void _ebean_set_originator(String newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_originator(), (Object)newValue);
        this.originator = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originator() {
        return this.originator;
    }

    protected /* synthetic */ void _ebean_setni_originator(String _newValue) {
        this.originator = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ String _ebean_get_recipient() {
        this._ebean_intercept.preGetter(18);
        return this.recipient;
    }

    protected /* synthetic */ void _ebean_set_recipient(String newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_recipient(), (Object)newValue);
        this.recipient = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipient() {
        return this.recipient;
    }

    protected /* synthetic */ void _ebean_setni_recipient(String _newValue) {
        this.recipient = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amount() {
        this._ebean_intercept.preGetter(19);
        return this.amount;
    }

    protected /* synthetic */ void _ebean_set_amount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_amount(), (Object)newValue);
        this.amount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amount() {
        return this.amount;
    }

    protected /* synthetic */ void _ebean_setni_amount(BigDecimal _newValue) {
        this.amount = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ String _ebean_get_amountCurrency() {
        this._ebean_intercept.preGetter(20);
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_set_amountCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_amountCurrency(), (Object)newValue);
        this.amountCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_amountCurrency() {
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_setni_amountCurrency(String _newValue) {
        this.amountCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ String _ebean_get_purpose() {
        this._ebean_intercept.preGetter(21);
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_set_purpose(String newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_purpose(), (Object)newValue);
        this.purpose = newValue;
    }

    protected /* synthetic */ String _ebean_getni_purpose() {
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_setni_purpose(String _newValue) {
        this.purpose = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ ExecutionInterval _ebean_get_executionInterval() {
        this._ebean_intercept.preGetter(22);
        return this.executionInterval;
    }

    protected /* synthetic */ void _ebean_set_executionInterval(ExecutionInterval newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_executionInterval(), (Object)newValue);
        this.executionInterval = newValue;
    }

    protected /* synthetic */ ExecutionInterval _ebean_getni_executionInterval() {
        return this.executionInterval;
    }

    protected /* synthetic */ void _ebean_setni_executionInterval(ExecutionInterval _newValue) {
        this.executionInterval = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ Date _ebean_get_firstExecutionDate() {
        this._ebean_intercept.preGetter(23);
        return this.firstExecutionDate;
    }

    protected /* synthetic */ void _ebean_set_firstExecutionDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_firstExecutionDate(), (Object)newValue);
        this.firstExecutionDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_firstExecutionDate() {
        return this.firstExecutionDate;
    }

    protected /* synthetic */ void _ebean_setni_firstExecutionDate(Date _newValue) {
        this.firstExecutionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ Date _ebean_get_lastExecutionDate() {
        this._ebean_intercept.preGetter(24);
        return this.lastExecutionDate;
    }

    protected /* synthetic */ void _ebean_set_lastExecutionDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_lastExecutionDate(), (Object)newValue);
        this.lastExecutionDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_lastExecutionDate() {
        return this.lastExecutionDate;
    }

    protected /* synthetic */ void _ebean_setni_lastExecutionDate(Date _newValue) {
        this.lastExecutionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ Date _ebean_get_previousExecutionDate() {
        this._ebean_intercept.preGetter(25);
        return this.previousExecutionDate;
    }

    protected /* synthetic */ void _ebean_set_previousExecutionDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_previousExecutionDate(), (Object)newValue);
        this.previousExecutionDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_previousExecutionDate() {
        return this.previousExecutionDate;
    }

    protected /* synthetic */ void _ebean_setni_previousExecutionDate(Date _newValue) {
        this.previousExecutionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ Date _ebean_get_nextExecutionDate() {
        this._ebean_intercept.preGetter(26);
        return this.nextExecutionDate;
    }

    protected /* synthetic */ void _ebean_set_nextExecutionDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_nextExecutionDate(), (Object)newValue);
        this.nextExecutionDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_nextExecutionDate() {
        return this.nextExecutionDate;
    }

    protected /* synthetic */ void _ebean_setni_nextExecutionDate(Date _newValue) {
        this.nextExecutionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    protected /* synthetic */ byte[] _ebean_get_paymentData() {
        this._ebean_intercept.preGetter(27);
        return this.paymentData;
    }

    protected /* synthetic */ void _ebean_set_paymentData(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 27, this._ebean_get_paymentData(), newValue);
        this.paymentData = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_paymentData() {
        return this.paymentData;
    }

    protected /* synthetic */ void _ebean_setni_paymentData(byte[] _newValue) {
        this.paymentData = _newValue;
        this._ebean_intercept.setLoadedProperty(27);
    }

    protected /* synthetic */ String _ebean_get_genericPurpose() {
        this._ebean_intercept.preGetter(28);
        return this.genericPurpose;
    }

    protected /* synthetic */ void _ebean_set_genericPurpose(String newValue) {
        this._ebean_intercept.preSetter(true, 28, (Object)this._ebean_get_genericPurpose(), (Object)newValue);
        this.genericPurpose = newValue;
    }

    protected /* synthetic */ String _ebean_getni_genericPurpose() {
        return this.genericPurpose;
    }

    protected /* synthetic */ void _ebean_setni_genericPurpose(String _newValue) {
        this.genericPurpose = _newValue;
        this._ebean_intercept.setLoadedProperty(28);
    }

    protected /* synthetic */ PaymentFolder _ebean_get_folder() {
        this._ebean_intercept.preGetter(29);
        return this.folder;
    }

    protected /* synthetic */ void _ebean_set_folder(PaymentFolder newValue) {
        this._ebean_intercept.preSetter(true, 29, (Object)this._ebean_get_folder(), (Object)newValue);
        this.folder = newValue;
    }

    protected /* synthetic */ PaymentFolder _ebean_getni_folder() {
        return this.folder;
    }

    protected /* synthetic */ void _ebean_setni_folder(PaymentFolder _newValue) {
        this.folder = _newValue;
        this._ebean_intercept.setLoadedProperty(29);
    }

    protected /* synthetic */ Boolean _ebean_get_salaryPayment() {
        this._ebean_intercept.preGetter(30);
        return this.salaryPayment;
    }

    protected /* synthetic */ void _ebean_set_salaryPayment(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 30, (Object)this._ebean_get_salaryPayment(), (Object)newValue);
        this.salaryPayment = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_salaryPayment() {
        return this.salaryPayment;
    }

    protected /* synthetic */ void _ebean_setni_salaryPayment(Boolean _newValue) {
        this.salaryPayment = _newValue;
        this._ebean_intercept.setLoadedProperty(30);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this._ebean_getni_id();
            }
            case 1: {
                return this._ebean_getni_businessId();
            }
            case 2: {
                return this._ebean_getni_createdUser();
            }
            case 3: {
                return this._ebean_getni_created();
            }
            case 4: {
                return this._ebean_getni_confirmedUser();
            }
            case 5: {
                return this._ebean_getni_confirmed();
            }
            case 6: {
                return this._ebean_getni_version();
            }
            case 7: {
                return this._ebean_getni_lockingUser();
            }
            case 8: {
                return this._ebean_getni_deleted();
            }
            case 9: {
                return this._ebean_getni_hasFourEyesChange();
            }
            case 10: {
                return this.bank;
            }
            case 11: {
                return this.account;
            }
            case 12: {
                return this.pmtType;
            }
            case 13: {
                return this.orderType;
            }
            case 14: {
                return this.fileType;
            }
            case 15: {
                return this.credit;
            }
            case 16: {
                return this.urgent;
            }
            case 17: {
                return this.originator;
            }
            case 18: {
                return this.recipient;
            }
            case 19: {
                return this.amount;
            }
            case 20: {
                return this.amountCurrency;
            }
            case 21: {
                return this.purpose;
            }
            case 22: {
                return this.executionInterval;
            }
            case 23: {
                return this.firstExecutionDate;
            }
            case 24: {
                return this.lastExecutionDate;
            }
            case 25: {
                return this.previousExecutionDate;
            }
            case 26: {
                return this.nextExecutionDate;
            }
            case 27: {
                return this.paymentData;
            }
            case 28: {
                return this.genericPurpose;
            }
            case 29: {
                return this.folder;
            }
            case 30: {
                return this.salaryPayment;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_businessId();
            }
            case 2: {
                return this._ebean_get_createdUser();
            }
            case 3: {
                return this._ebean_get_created();
            }
            case 4: {
                return this._ebean_get_confirmedUser();
            }
            case 5: {
                return this._ebean_get_confirmed();
            }
            case 6: {
                return this._ebean_get_version();
            }
            case 7: {
                return this._ebean_get_lockingUser();
            }
            case 8: {
                return this._ebean_get_deleted();
            }
            case 9: {
                return this._ebean_get_hasFourEyesChange();
            }
            case 10: {
                return this._ebean_get_bank();
            }
            case 11: {
                return this._ebean_get_account();
            }
            case 12: {
                return this._ebean_get_pmtType();
            }
            case 13: {
                return this._ebean_get_orderType();
            }
            case 14: {
                return this._ebean_get_fileType();
            }
            case 15: {
                return this._ebean_get_credit();
            }
            case 16: {
                return this._ebean_get_urgent();
            }
            case 17: {
                return this._ebean_get_originator();
            }
            case 18: {
                return this._ebean_get_recipient();
            }
            case 19: {
                return this._ebean_get_amount();
            }
            case 20: {
                return this._ebean_get_amountCurrency();
            }
            case 21: {
                return this._ebean_get_purpose();
            }
            case 22: {
                return this._ebean_get_executionInterval();
            }
            case 23: {
                return this._ebean_get_firstExecutionDate();
            }
            case 24: {
                return this._ebean_get_lastExecutionDate();
            }
            case 25: {
                return this._ebean_get_previousExecutionDate();
            }
            case 26: {
                return this._ebean_get_nextExecutionDate();
            }
            case 27: {
                return this._ebean_get_paymentData();
            }
            case 28: {
                return this._ebean_get_genericPurpose();
            }
            case 29: {
                return this._ebean_get_folder();
            }
            case 30: {
                return this._ebean_get_salaryPayment();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_businessId((Integer)o);
                return;
            }
            case 2: {
                this._ebean_setni_createdUser((User)o);
                return;
            }
            case 3: {
                this._ebean_setni_created((java.util.Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_confirmedUser((User)o);
                return;
            }
            case 5: {
                this._ebean_setni_confirmed((java.util.Date)o);
                return;
            }
            case 6: {
                this._ebean_setni_version((HistoryLog.Version)((Object)o));
                return;
            }
            case 7: {
                this._ebean_setni_lockingUser((User)o);
                return;
            }
            case 8: {
                this._ebean_setni_deleted((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_setni_hasFourEyesChange((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 11: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 12: {
                this._ebean_setni_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 13: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_fileType((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_credit((Boolean)o);
                return;
            }
            case 16: {
                this._ebean_setni_urgent((Boolean)o);
                return;
            }
            case 17: {
                this._ebean_setni_originator((String)o);
                return;
            }
            case 18: {
                this._ebean_setni_recipient((String)o);
                return;
            }
            case 19: {
                this._ebean_setni_amount((BigDecimal)o);
                return;
            }
            case 20: {
                this._ebean_setni_amountCurrency((String)o);
                return;
            }
            case 21: {
                this._ebean_setni_purpose((String)o);
                return;
            }
            case 22: {
                this._ebean_setni_executionInterval((ExecutionInterval)((Object)o));
                return;
            }
            case 23: {
                this._ebean_setni_firstExecutionDate((Date)o);
                return;
            }
            case 24: {
                this._ebean_setni_lastExecutionDate((Date)o);
                return;
            }
            case 25: {
                this._ebean_setni_previousExecutionDate((Date)o);
                return;
            }
            case 26: {
                this._ebean_setni_nextExecutionDate((Date)o);
                return;
            }
            case 27: {
                this._ebean_setni_paymentData((byte[])o);
                return;
            }
            case 28: {
                this._ebean_setni_genericPurpose((String)o);
                return;
            }
            case 29: {
                this._ebean_setni_folder((PaymentFolder)o);
                return;
            }
            case 30: {
                this._ebean_setni_salaryPayment((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_businessId((Integer)o);
                return;
            }
            case 2: {
                this._ebean_set_createdUser((User)o);
                return;
            }
            case 3: {
                this._ebean_set_created((java.util.Date)o);
                return;
            }
            case 4: {
                this._ebean_set_confirmedUser((User)o);
                return;
            }
            case 5: {
                this._ebean_set_confirmed((java.util.Date)o);
                return;
            }
            case 6: {
                this._ebean_set_version((HistoryLog.Version)((Object)o));
                return;
            }
            case 7: {
                this._ebean_set_lockingUser((User)o);
                return;
            }
            case 8: {
                this._ebean_set_deleted((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_set_hasFourEyesChange((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 11: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 12: {
                this._ebean_set_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 13: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 14: {
                this._ebean_set_fileType((String)o);
                return;
            }
            case 15: {
                this._ebean_set_credit((Boolean)o);
                return;
            }
            case 16: {
                this._ebean_set_urgent((Boolean)o);
                return;
            }
            case 17: {
                this._ebean_set_originator((String)o);
                return;
            }
            case 18: {
                this._ebean_set_recipient((String)o);
                return;
            }
            case 19: {
                this._ebean_set_amount((BigDecimal)o);
                return;
            }
            case 20: {
                this._ebean_set_amountCurrency((String)o);
                return;
            }
            case 21: {
                this._ebean_set_purpose((String)o);
                return;
            }
            case 22: {
                this._ebean_set_executionInterval((ExecutionInterval)((Object)o));
                return;
            }
            case 23: {
                this._ebean_set_firstExecutionDate((Date)o);
                return;
            }
            case 24: {
                this._ebean_set_lastExecutionDate((Date)o);
                return;
            }
            case 25: {
                this._ebean_set_previousExecutionDate((Date)o);
                return;
            }
            case 26: {
                this._ebean_set_nextExecutionDate((Date)o);
                return;
            }
            case 27: {
                this._ebean_set_paymentData((byte[])o);
                return;
            }
            case 28: {
                this._ebean_set_genericPurpose((String)o);
                return;
            }
            case 29: {
                this._ebean_set_folder((PaymentFolder)o);
                return;
            }
            case 30: {
                this._ebean_set_salaryPayment((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new PeriodicPayment();
    }

    public static enum ExecutionInterval {
        MONTHLY("M1"),
        TWO_MONTHS("M2"),
        THREE_MONTHS("M3"),
        SIX_MONTHS("M6"),
        YEAR("M12"),
        MONTH_ULTIMO("U1"),
        QUARTER_ULTIMO("U3"),
        YEAR_ULTIMO("U12"),
        WEEKLY("W1"),
        TWO_WEEKS("W2");

        private final String code;

        private ExecutionInterval(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static ExecutionInterval valueByCode(String code) {
            for (ExecutionInterval e : ExecutionInterval.values()) {
                if (!e.getCode().equals(code)) continue;
                return e;
            }
            return null;
        }
    }
}

