/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BaseFilterWithOrderTypeBank;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import java.sql.Date;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="pdfstatements_filter")
public class PdfStatementsFilter
extends BaseFilterWithOrderTypeBank
implements EntityBean {
    private static final long serialVersionUID = 1L;
    private boolean statementActive;
    private Integer accountId;
    private CmPdfStatement.Type type;
    public static /* synthetic */ String[] _ebean_props;

    public static PdfStatementsFilter getFilter(User user) {
        PdfStatementsFilter f = (PdfStatementsFilter)DB.find(PdfStatementsFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            return new PdfStatementsFilter(user);
        }
        return f;
    }

    public static int deleteByUser(User user) {
        PdfStatementsFilter filter = (PdfStatementsFilter)DB.find(PdfStatementsFilter.class).where().eq("user", (Object)user).findOne();
        if (filter != null) {
            DB.delete(filter);
            return 1;
        }
        return 0;
    }

    public static int deleteByBank(BankSettings bank) {
        Update<PdfStatementsFilter> delete = DB.createUpdate(PdfStatementsFilter.class, "UPDATE PdfStatementsFilter SET bank=NULL WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public Integer getAccountId() {
        return this._ebean_get_accountId();
    }

    public void setAccountId(Integer accountId) {
        this._ebean_set_accountId(accountId);
    }

    private PdfStatementsFilter(User user) {
        super(user);
    }

    public final boolean isEmpty() {
        return this.isDateFilterEmpty() && this.getBank() == null && this.getAccountId() == null && this.getType() == null;
    }

    public boolean isStatementActive() {
        return this._ebean_get_statementActive();
    }

    public void setStatementActive(boolean statementActive) {
        this._ebean_set_statementActive(statementActive);
    }

    public CmPdfStatement.Type getType() {
        return this._ebean_get_type();
    }

    public void setType(CmPdfStatement.Type type) {
        this._ebean_set_type(type);
    }

    public Expression getExpression() {
        Expression toReturn = this.getDateExpression("statement_date");
        Expression bankExpression = this.getBankExpression("bank");
        if (bankExpression != null) {
            toReturn = this.addFilter(toReturn, bankExpression);
        }
        if (this._ebean_get_accountId() != null) {
            toReturn = this.addFilter(toReturn, Expr.eq((String)"account.id", (Object)this._ebean_get_accountId()));
        }
        if (this._ebean_get_type() != null) {
            toReturn = this.addFilter(toReturn, Expr.eq((String)"type", (Object)((Object)this._ebean_get_type())));
        }
        return toReturn;
    }

    static {
        _ebean_props = new String[]{"id", "user", "fromDate", "toDate", "dateComparator", "orderType", "orderTypeComparator", "bank", "bankComparator", "statementActive", "accountId", "type"};
    }

    public /* synthetic */ PdfStatementsFilter() {
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    protected /* synthetic */ boolean _ebean_get_statementActive() {
        this._ebean_intercept.preGetter(9);
        return this.statementActive;
    }

    protected /* synthetic */ void _ebean_set_statementActive(boolean newValue) {
        this._ebean_intercept.preSetter(true, 9, this._ebean_get_statementActive(), newValue);
        this.statementActive = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_statementActive() {
        return this.statementActive;
    }

    protected /* synthetic */ void _ebean_setni_statementActive(boolean _newValue) {
        this.statementActive = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ Integer _ebean_get_accountId() {
        this._ebean_intercept.preGetter(10);
        return this.accountId;
    }

    protected /* synthetic */ void _ebean_set_accountId(Integer newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_accountId(), (Object)newValue);
        this.accountId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_accountId() {
        return this.accountId;
    }

    protected /* synthetic */ void _ebean_setni_accountId(Integer _newValue) {
        this.accountId = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ CmPdfStatement.Type _ebean_get_type() {
        this._ebean_intercept.preGetter(11);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(CmPdfStatement.Type newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ CmPdfStatement.Type _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(CmPdfStatement.Type _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this._ebean_getni_id();
            }
            case 1: {
                return this._ebean_getni_user();
            }
            case 2: {
                return this._ebean_getni_fromDate();
            }
            case 3: {
                return this._ebean_getni_toDate();
            }
            case 4: {
                return this._ebean_getni_dateComparator();
            }
            case 5: {
                return this._ebean_getni_orderType();
            }
            case 6: {
                return this._ebean_getni_orderTypeComparator();
            }
            case 7: {
                return this._ebean_getni_bank();
            }
            case 8: {
                return this._ebean_getni_bankComparator();
            }
            case 9: {
                return this.statementActive;
            }
            case 10: {
                return this.accountId;
            }
            case 11: {
                return this.type;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_fromDate();
            }
            case 3: {
                return this._ebean_get_toDate();
            }
            case 4: {
                return this._ebean_get_dateComparator();
            }
            case 5: {
                return this._ebean_get_orderType();
            }
            case 6: {
                return this._ebean_get_orderTypeComparator();
            }
            case 7: {
                return this._ebean_get_bank();
            }
            case 8: {
                return this._ebean_get_bankComparator();
            }
            case 9: {
                return this._ebean_get_statementActive();
            }
            case 10: {
                return this._ebean_get_accountId();
            }
            case 11: {
                return this._ebean_get_type();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_setni_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 5: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_orderTypeComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 7: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 8: {
                this._ebean_setni_bankComparator((FilterComparator.Bank)((Object)o));
                return;
            }
            case 9: {
                this._ebean_setni_statementActive((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_accountId((Integer)o);
                return;
            }
            case 11: {
                this._ebean_setni_type((CmPdfStatement.Type)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_set_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_set_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 5: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 6: {
                this._ebean_set_orderTypeComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 7: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 8: {
                this._ebean_set_bankComparator((FilterComparator.Bank)((Object)o));
                return;
            }
            case 9: {
                this._ebean_set_statementActive((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_accountId((Integer)o);
                return;
            }
            case 11: {
                this._ebean_set_type((CmPdfStatement.Type)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new PdfStatementsFilter();
    }
}

